/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.declaration;

import spoon.SpoonException;
import spoon.experimental.CtUnresolvedImport;
import spoon.reflect.annotations.MetamodelPropertyField;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtImport;
import spoon.reflect.declaration.CtImportKind;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeMemberWildcardImportReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtImportVisitor;
import spoon.reflect.visitor.CtVisitor;
import spoon.support.reflect.declaration.CtElementImpl;
import spoon.support.reflect.reference.CtTypeMemberWildcardImportReferenceImpl;

public class CtImportImpl
extends CtElementImpl
implements CtImport {
    @MetamodelPropertyField(role={CtRole.IMPORT_REFERENCE})
    private CtReference localReference;

    @Override
    public CtImportKind getImportKind() {
        return this.getImportKindFor(this.localReference);
    }

    private CtImportKind getImportKindFor(CtReference ref) {
        if (ref == null) {
            return null;
        }
        if (ref instanceof CtFieldReference) {
            return CtImportKind.FIELD;
        }
        if (ref instanceof CtExecutableReference) {
            return CtImportKind.METHOD;
        }
        if (ref instanceof CtPackageReference) {
            return CtImportKind.ALL_TYPES;
        }
        if (ref instanceof CtTypeMemberWildcardImportReferenceImpl) {
            return CtImportKind.ALL_STATIC_MEMBERS;
        }
        if (ref instanceof CtTypeReference) {
            return CtImportKind.TYPE;
        }
        throw new SpoonException("Only CtFieldReference, CtExecutableReference, CtPackageReference and CtTypeReference are accepted reference types. Given " + ref.getClass());
    }

    @Override
    public <T extends CtImport> T setReference(CtReference reference) {
        if (reference != null) {
            reference.setParent(this);
        }
        this.getImportKindFor(reference);
        this.getFactory().getEnvironment().getModelChangeListener().onObjectUpdate((CtElement)this, CtRole.IMPORT_REFERENCE, reference, this.localReference);
        this.localReference = reference;
        return (T)this;
    }

    @Override
    public CtReference getReference() {
        return this.localReference;
    }

    @Override
    public void accept(CtVisitor visitor) {
        visitor.visitCtImport(this);
    }

    @Override
    public void accept(CtImportVisitor visitor) {
        switch (this.getImportKind()) {
            case TYPE: {
                visitor.visitTypeImport((CtTypeReference)this.localReference);
                break;
            }
            case METHOD: {
                visitor.visitMethodImport((CtExecutableReference)this.localReference);
                break;
            }
            case FIELD: {
                visitor.visitFieldImport((CtFieldReference)this.localReference);
                break;
            }
            case ALL_TYPES: {
                visitor.visitAllTypesImport((CtPackageReference)this.localReference);
                break;
            }
            case ALL_STATIC_MEMBERS: {
                visitor.visitAllStaticMembersImport((CtTypeMemberWildcardImportReference)this.localReference);
                break;
            }
            case UNRESOLVED: {
                visitor.visitUnresolvedImport((CtUnresolvedImport)((Object)this.localReference));
                break;
            }
            default: {
                throw new SpoonException("Unexpected import kind: " + this.getImportKind());
            }
        }
    }

    @Override
    public CtImportImpl clone() {
        return (CtImportImpl)super.clone();
    }
}

