/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.declaration;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import spoon.reflect.annotations.MetamodelPropertyField;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtBodyHolder;
import spoon.reflect.code.CtStatement;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtReceiverParameter;
import spoon.reflect.declaration.CtType;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.support.reflect.declaration.CtElementImpl;
import spoon.support.reflect.declaration.CtNamedElementImpl;
import spoon.support.util.QualifiedNameBasedSortedSet;
import spoon.support.visitor.SignaturePrinter;

public abstract class CtExecutableImpl<R>
extends CtNamedElementImpl
implements CtExecutable<R> {
    private static final long serialVersionUID = 1L;
    @MetamodelPropertyField(role={CtRole.BODY})
    CtBlock<?> body;
    @MetamodelPropertyField(role={CtRole.PARAMETER})
    List<CtParameter<?>> parameters = CtExecutableImpl.emptyList();
    @MetamodelPropertyField(role={CtRole.THROWN})
    Set<CtTypeReference<? extends Throwable>> thrownTypes = CtExecutableImpl.emptySet();
    @MetamodelPropertyField(role={CtRole.RECEIVER_PARAMETER})
    private CtReceiverParameter receiverParameter;

    public CtType<?> getDeclaringType() {
        return (CtType)this.parent;
    }

    public <T> CtType<T> getTopLevelType() {
        return this.getDeclaringType().getTopLevelType();
    }

    @Override
    public CtBlock<R> getBody() {
        return this.body;
    }

    @Override
    public <T extends CtBodyHolder> T setBody(CtStatement statement) {
        if (statement != null) {
            CtBlock<?> body = this.getFactory().Code().getOrCreateCtBlock(statement);
            this.getFactory().getEnvironment().getModelChangeListener().onObjectUpdate((CtElement)this, CtRole.BODY, body, this.body);
            if (body != null) {
                body.setParent(this);
            }
            this.body = body;
        } else {
            this.getFactory().getEnvironment().getModelChangeListener().onObjectDelete(this, CtRole.BODY, this.body);
            this.body = null;
        }
        return (T)this;
    }

    @Override
    public List<CtParameter<?>> getParameters() {
        return this.parameters;
    }

    @Override
    public <T extends CtExecutable<R>> T setParameters(List<CtParameter<?>> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            this.parameters = CtElementImpl.emptyList();
            return (T)this;
        }
        if (this.parameters == CtElementImpl.emptyList()) {
            this.parameters = new ArrayList(2);
        }
        this.getFactory().getEnvironment().getModelChangeListener().onListDeleteAll(this, CtRole.PARAMETER, this.parameters, new ArrayList(this.parameters));
        this.parameters.clear();
        for (CtParameter<?> p : parameters) {
            this.addParameter(p);
        }
        return (T)this;
    }

    @Override
    public <T extends CtExecutable<R>> T addParameter(CtParameter<?> parameter) {
        this.addParameterAt(this.parameters.size(), parameter);
        return (T)this;
    }

    @Override
    public <T extends CtExecutable<R>> T addParameterAt(int position, CtParameter<?> parameter) {
        if (parameter == null) {
            return (T)this;
        }
        if (this.parameters == CtElementImpl.emptyList()) {
            this.parameters = new ArrayList(2);
        }
        parameter.setParent(this);
        this.getFactory().getEnvironment().getModelChangeListener().onListAdd(this, CtRole.PARAMETER, this.parameters, parameter);
        this.parameters.add(position, parameter);
        return (T)this;
    }

    @Override
    public boolean removeParameter(CtParameter<?> parameter) {
        if (this.parameters == CtElementImpl.emptyList()) {
            return false;
        }
        this.getFactory().getEnvironment().getModelChangeListener().onListDelete(this, CtRole.PARAMETER, this.parameters, this.parameters.indexOf(parameter), parameter);
        return this.parameters.remove(parameter);
    }

    @Override
    public Set<CtTypeReference<? extends Throwable>> getThrownTypes() {
        return this.thrownTypes;
    }

    @Override
    public <T extends CtExecutable<R>> T setThrownTypes(Set<CtTypeReference<? extends Throwable>> thrownTypes) {
        if (thrownTypes == null || thrownTypes.isEmpty()) {
            this.thrownTypes = CtElementImpl.emptySet();
            return (T)this;
        }
        if (this.thrownTypes == CtElementImpl.emptySet()) {
            this.thrownTypes = new QualifiedNameBasedSortedSet<CtTypeReference<? extends Throwable>>();
        }
        this.getFactory().getEnvironment().getModelChangeListener().onSetDeleteAll(this, CtRole.THROWN, this.thrownTypes, new HashSet<CtTypeReference<? extends Throwable>>(this.thrownTypes));
        this.thrownTypes.clear();
        for (CtTypeReference<? extends Throwable> thrownType : thrownTypes) {
            this.addThrownType(thrownType);
        }
        return (T)this;
    }

    @Override
    public <T extends CtExecutable<R>> T addThrownType(CtTypeReference<? extends Throwable> throwType) {
        if (throwType == null) {
            return (T)this;
        }
        if (this.thrownTypes == CtElementImpl.emptySet()) {
            this.thrownTypes = new QualifiedNameBasedSortedSet<CtTypeReference<? extends Throwable>>();
        }
        throwType.setParent(this);
        this.getFactory().getEnvironment().getModelChangeListener().onSetAdd((CtElement)this, CtRole.THROWN, this.thrownTypes, throwType);
        this.thrownTypes.add(throwType);
        return (T)this;
    }

    @Override
    public boolean removeThrownType(CtTypeReference<? extends Throwable> throwType) {
        if (this.thrownTypes == CtElementImpl.emptySet()) {
            return false;
        }
        this.getFactory().getEnvironment().getModelChangeListener().onSetDelete((CtElement)this, CtRole.THROWN, this.thrownTypes, throwType);
        return this.thrownTypes.remove(throwType);
    }

    @Override
    public String getSignature() {
        SignaturePrinter pr = new SignaturePrinter();
        pr.scan(this);
        return pr.getSignature();
    }

    @Override
    public CtExecutableReference<R> getReference() {
        return this.getFactory().Executable().createReference(this);
    }

    @Override
    public CtExecutable<R> clone() {
        return (CtExecutable)super.clone();
    }

    @Override
    public CtExecutable<?> setReceiverParameter(CtReceiverParameter receiverParameter) {
        if (receiverParameter != null) {
            receiverParameter.setParent(this);
        }
        this.receiverParameter = receiverParameter;
        this.getFactory().getEnvironment().getModelChangeListener().onObjectUpdate((CtElement)this, CtRole.RECEIVER_PARAMETER, receiverParameter, this.receiverParameter);
        return this;
    }

    @Override
    public @Nullable CtReceiverParameter getReceiverParameter() {
        return this.receiverParameter;
    }
}

