/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import spoon.reflect.annotations.MetamodelPropertyField;
import spoon.reflect.code.CtNewClass;
import spoon.reflect.declaration.CtEnum;
import spoon.reflect.declaration.CtEnumValue;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtFormalTypeDeclarer;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeParameter;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtVisitor;
import spoon.support.DerivedProperty;
import spoon.support.UnsettableProperty;
import spoon.support.reflect.declaration.CtClassImpl;
import spoon.support.reflect.declaration.CtElementImpl;
import spoon.support.util.SignatureBasedSortedSet;

public class CtEnumImpl<T extends Enum<?>>
extends CtClassImpl<T>
implements CtEnum<T> {
    private static final long serialVersionUID = 1L;
    @MetamodelPropertyField(role={CtRole.VALUE})
    private List<CtEnumValue<?>> enumValues = CtElementImpl.emptyList();
    @MetamodelPropertyField(role={CtRole.VALUE})
    private CtMethod<T[]> valuesMethod;
    private CtMethod<T> valueOfMethod;

    @Override
    public void accept(CtVisitor visitor) {
        visitor.visitCtEnum(this);
    }

    @Override
    public Set<CtMethod<?>> getAllMethods() {
        SignatureBasedSortedSet allMethods = new SignatureBasedSortedSet();
        allMethods.addAll(this.getMethods());
        allMethods.addAll(this.getFactory().Type().get(Enum.class).getMethods());
        allMethods.add(this.valuesMethod());
        allMethods.add(this.valueOfMethod());
        return allMethods;
    }

    @Override
    public boolean isSubtypeOf(CtTypeReference<?> type) {
        return this.getReference().isSubtypeOf(type);
    }

    @Override
    public <C extends CtEnum<T>> C addEnumValue(CtEnumValue<?> enumValue) {
        if (enumValue == null) {
            return (C)this;
        }
        if (this.enumValues == CtElementImpl.emptyList()) {
            this.enumValues = new ArrayList();
        }
        if (!this.enumValues.contains(enumValue)) {
            enumValue.setParent(this);
            this.getFactory().getEnvironment().getModelChangeListener().onListAdd(this, CtRole.VALUE, this.enumValues, enumValue);
            this.enumValues.add(enumValue);
        }
        return (C)this;
    }

    @Override
    public boolean removeEnumValue(CtEnumValue<?> enumValue) {
        if (this.enumValues == CtElementImpl.emptyList()) {
            return false;
        }
        this.getFactory().getEnvironment().getModelChangeListener().onListDelete(this, CtRole.VALUE, this.enumValues, this.enumValues.indexOf(enumValue), enumValue);
        return this.enumValues.remove(enumValue);
    }

    @Override
    public CtEnumValue<?> getEnumValue(String name) {
        for (CtEnumValue<?> enumValue : this.enumValues) {
            if (!enumValue.getSimpleName().equals(name)) continue;
            return enumValue;
        }
        return null;
    }

    @Override
    public List<CtEnumValue<?>> getEnumValues() {
        return Collections.unmodifiableList(this.enumValues);
    }

    @Override
    public <C extends CtEnum<T>> C setEnumValues(List<CtEnumValue<?>> enumValues) {
        if (enumValues == null) {
            this.enumValues = CtEnumImpl.emptyList();
            return (C)this;
        }
        this.getFactory().getEnvironment().getModelChangeListener().onListDeleteAll(this, CtRole.VALUE, this.enumValues, new ArrayList(enumValues));
        if (enumValues.isEmpty()) {
            this.enumValues = CtEnumImpl.emptyList();
            return (C)this;
        }
        this.enumValues.clear();
        for (CtEnumValue<?> enumValue : enumValues) {
            this.addEnumValue(enumValue);
        }
        return (C)this;
    }

    @Override
    @DerivedProperty
    public List<CtField<?>> getFields() {
        ArrayList result = new ArrayList();
        result.addAll(this.getEnumValues());
        result.addAll(super.getFields());
        return Collections.unmodifiableList(result);
    }

    @Override
    public CtField<?> getField(String name) {
        CtField<?> field = super.getField(name);
        if (field == null) {
            return this.getEnumValue(name);
        }
        return field;
    }

    @Override
    public CtEnum<T> clone() {
        return (CtEnum)super.clone();
    }

    @Override
    @DerivedProperty
    public Set<CtTypeReference<?>> getPermittedTypes() {
        LinkedHashSet<CtReference> refs = new LinkedHashSet<CtReference>();
        for (CtEnumValue<?> value : this.enumValues) {
            if (!(value.getDefaultExpression() instanceof CtNewClass)) continue;
            refs.add(((CtNewClass)value.getDefaultExpression()).getAnonymousClass().getReference());
        }
        return Collections.unmodifiableSet(refs);
    }

    @Override
    @UnsettableProperty
    public CtEnum<T> setPermittedTypes(Collection<CtTypeReference<?>> permittedTypes) {
        return this;
    }

    @Override
    @UnsettableProperty
    public CtEnum<T> addPermittedType(CtTypeReference<?> type) {
        return this;
    }

    @Override
    @UnsettableProperty
    public CtEnum<T> removePermittedType(CtTypeReference<?> type) {
        return this;
    }

    @Override
    @DerivedProperty
    public CtTypeReference<?> getSuperclass() {
        return this.getFactory().Type().createReference(Enum.class);
    }

    @Override
    @UnsettableProperty
    public <C extends CtType<T>> C setSuperclass(CtTypeReference<?> superClass) {
        return (C)this;
    }

    private CtMethod valuesMethod() {
        if (this.valuesMethod == null) {
            this.valuesMethod = this.getFactory().Core().createMethod();
            this.valuesMethod.setParent(this);
            this.valuesMethod.addModifier(ModifierKind.PUBLIC);
            this.valuesMethod.addModifier(ModifierKind.STATIC);
            this.valuesMethod.setSimpleName("values");
            this.valuesMethod.setImplicit(true);
            this.valuesMethod.setType(this.factory.Type().createArrayReference(this.getReference()));
        }
        return this.valuesMethod;
    }

    private CtMethod valueOfMethod() {
        if (this.valueOfMethod == null) {
            this.valueOfMethod = this.getFactory().Core().createMethod();
            this.valueOfMethod.setParent(this);
            this.valueOfMethod.addModifier(ModifierKind.PUBLIC);
            this.valueOfMethod.addModifier(ModifierKind.STATIC);
            this.valueOfMethod.setSimpleName("valueOf");
            this.valueOfMethod.setImplicit(true);
            this.valueOfMethod.addThrownType(this.getFactory().Type().createReference(IllegalArgumentException.class));
            this.valueOfMethod.setType((CtTypeReference)this.getReference());
            this.factory.Method().createParameter(this.valueOfMethod, this.factory.Type().stringType(), "name");
        }
        return this.valueOfMethod;
    }

    @Override
    public <R> CtMethod<R> getMethod(String name, CtTypeReference<?> ... parameterTypes) {
        if ("values".equals(name) && parameterTypes.length == 0) {
            return this.valuesMethod();
        }
        if ("valueOf".equals(name) && parameterTypes.length == 1 && parameterTypes[0].equals(this.factory.Type().stringType())) {
            return this.valueOfMethod();
        }
        return super.getMethod(name, parameterTypes);
    }

    @Override
    public <R> CtMethod<R> getMethod(CtTypeReference<R> returnType, String name, CtTypeReference<?> ... parameterTypes) {
        if ("values".equals(name) && parameterTypes.length == 0 && returnType.equals(this.getReference())) {
            return this.valuesMethod();
        }
        if ("valueOf".equals(name) && parameterTypes.length == 1 && parameterTypes[0].equals(this.factory.Type().stringType()) && returnType.equals(this.factory.Type().createArrayReference(this.getReference()))) {
            return this.valueOfMethod();
        }
        return super.getMethod(returnType, name, parameterTypes);
    }

    @Override
    public boolean isClass() {
        return false;
    }

    @Override
    public boolean isEnum() {
        return true;
    }

    @Override
    @DerivedProperty
    public List<CtTypeParameter> getFormalCtTypeParameters() {
        return CtEnumImpl.emptyList();
    }

    @Override
    @UnsettableProperty
    public <C extends CtFormalTypeDeclarer> C setFormalCtTypeParameters(List<CtTypeParameter> formalTypeParameters) {
        return (C)this;
    }
}

