/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.declaration;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import spoon.SpoonException;
import spoon.reflect.annotations.MetamodelPropertyField;
import spoon.reflect.cu.CompilationUnit;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.declaration.CtCompilationUnit;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtImport;
import spoon.reflect.declaration.CtModule;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtPackageDeclaration;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.ParentNotInitializedException;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtModuleReference;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtVisitor;
import spoon.reflect.visitor.filter.TypeFilter;
import spoon.support.DerivedProperty;
import spoon.support.UnsettableProperty;
import spoon.support.reflect.cu.position.PartialSourcePositionImpl;
import spoon.support.reflect.declaration.CtElementImpl;
import spoon.support.sniper.internal.ElementSourceFragment;
import spoon.support.util.ModelList;

public class CtCompilationUnitImpl
extends CtElementImpl
implements CtCompilationUnit {
    private static final long serialVersionUID = 1L;
    @MetamodelPropertyField(role={CtRole.DECLARED_TYPE_REF})
    private final ModelList<CtTypeReference<?>> declaredTypeReferences = new ModelList<CtTypeReference<?>>(){

        @Override
        protected CtElement getOwner() {
            return CtCompilationUnitImpl.this;
        }

        @Override
        protected CtRole getRole() {
            return CtRole.DECLARED_TYPE_REF;
        }

        @Override
        protected int getDefaultCapacity() {
            return 1;
        }
    };
    @MetamodelPropertyField(role={CtRole.PACKAGE_DECLARATION})
    private CtPackageDeclaration packageDeclaration;
    @MetamodelPropertyField(role={CtRole.DECLARED_IMPORT})
    private final ModelList<CtImport> imports = new ModelList<CtImport>(){
        private static final long serialVersionUID = 1L;

        @Override
        protected CtElement getOwner() {
            return CtCompilationUnitImpl.this;
        }

        @Override
        protected CtRole getRole() {
            return CtRole.DECLARED_IMPORT;
        }

        @Override
        protected int getDefaultCapacity() {
            return 10;
        }
    };
    @MetamodelPropertyField(role={CtRole.DECLARED_MODULE_REF})
    private CtModuleReference moduleReference;
    private File file;
    private int[] lineSeparatorPositions;
    private ElementSourceFragment rootFragment;
    private String originalSourceCode;
    private PartialSourcePositionImpl myPartialSourcePosition;

    @Override
    public CtCompilationUnit.UNIT_TYPE getUnitType() {
        if (this.file != null) {
            if (this.file.getName().equals("module-info.java")) {
                return CtCompilationUnit.UNIT_TYPE.MODULE_DECLARATION;
            }
            if (this.file.getName().equals("package-info.java")) {
                return CtCompilationUnit.UNIT_TYPE.PACKAGE_DECLARATION;
            }
            return CtCompilationUnit.UNIT_TYPE.TYPE_DECLARATION;
        }
        if (this.getDeclaredTypes().isEmpty()) {
            if (this.getDeclaredModuleReference() != null) {
                return CtCompilationUnit.UNIT_TYPE.MODULE_DECLARATION;
            }
            if (this.packageDeclaration != null) {
                return CtCompilationUnit.UNIT_TYPE.PACKAGE_DECLARATION;
            }
            return CtCompilationUnit.UNIT_TYPE.UNKNOWN;
        }
        return CtCompilationUnit.UNIT_TYPE.TYPE_DECLARATION;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public CtType<?> getMainType() {
        if (this.getFile() == null || this.getDeclaredTypes().size() == 1) {
            return this.getDeclaredTypes().get(0);
        }
        for (CtType<?> t : this.getDeclaredTypes()) {
            String name = this.getFile().getName();
            name = name.substring(0, name.lastIndexOf(46));
            if (!t.getSimpleName().equals(name)) continue;
            return t;
        }
        throw new RuntimeException("inconsistent compilation unit: '" + this.file + "': declared types are " + this.getDeclaredTypes());
    }

    @Override
    public List<CtType<?>> getDeclaredTypes() {
        return Collections.unmodifiableList(this.declaredTypeReferences.stream().map((? super T ref) -> ref.getTypeDeclaration()).collect(Collectors.toList()));
    }

    @Override
    public List<CtTypeReference<?>> getDeclaredTypeReferences() {
        return this.declaredTypeReferences;
    }

    @Override
    public CtCompilationUnitImpl setDeclaredTypeReferences(List<CtTypeReference<?>> types) {
        this.declaredTypeReferences.set(types);
        return this;
    }

    @Override
    @DerivedProperty
    public CtCompilationUnit setDeclaredTypes(List<CtType<?>> types) {
        return this.setDeclaredTypeReferences(types.stream().map(CtType::getReference).collect(Collectors.toList()));
    }

    @Override
    @DerivedProperty
    public CtCompilationUnitImpl addDeclaredType(CtType<?> type) {
        if (type != null) {
            this.addDeclaredTypeReference((CtTypeReference)type.getReference());
        }
        return this;
    }

    @Override
    public CtCompilationUnitImpl addDeclaredTypeReference(CtTypeReference<?> type) {
        this.declaredTypeReferences.add(type);
        return this;
    }

    @Override
    @DerivedProperty
    public CtModule getDeclaredModule() {
        return this.moduleReference != null ? this.moduleReference.getDeclaration() : null;
    }

    @Override
    public CtModuleReference getDeclaredModuleReference() {
        return this.moduleReference;
    }

    @Override
    public CtCompilationUnitImpl setDeclaredModule(CtModule module) {
        this.setDeclaredModuleReference(module == null ? null : module.getReference());
        return this;
    }

    @Override
    public CtCompilationUnitImpl setDeclaredModuleReference(CtModuleReference module) {
        if (module != null) {
            module.setParent(this);
        }
        this.getFactory().getEnvironment().getModelChangeListener().onObjectUpdate((CtElement)this, CtRole.DECLARED_MODULE_REF, module, this.moduleReference);
        this.moduleReference = module;
        return this;
    }

    @Override
    @DerivedProperty
    public CtPackage getDeclaredPackage() {
        if (this.packageDeclaration != null) {
            return this.packageDeclaration.getReference().getDeclaration();
        }
        if (this.declaredTypeReferences.size() > 0) {
            return ((CtTypeReference)this.declaredTypeReferences.get(0)).getPackage().getDeclaration();
        }
        return this.getFactory().getModel().getRootPackage();
    }

    @Override
    public CtPackageDeclaration getPackageDeclaration() {
        if (this.packageDeclaration == null) {
            CtPackageReference packRef = this.declaredTypeReferences.size() > 0 ? ((CtTypeReference)this.declaredTypeReferences.get(0)).getPackage().clone() : this.getFactory().getModel().getRootPackage().getReference();
            this.packageDeclaration = this.getFactory().Package().createPackageDeclaration(packRef);
        }
        return this.packageDeclaration;
    }

    @Override
    public CtCompilationUnitImpl setDeclaredPackage(CtPackage ctPackage) {
        this.setPackageDeclaration(ctPackage == null ? null : this.getFactory().Package().createPackageDeclaration(ctPackage.getReference()));
        return this;
    }

    @Override
    public CtCompilationUnitImpl setPackageDeclaration(CtPackageDeclaration packageDeclaration) {
        if (packageDeclaration != null) {
            packageDeclaration.setParent(this);
        }
        this.getFactory().getEnvironment().getModelChangeListener().onObjectUpdate((CtElement)this, CtRole.PACKAGE_DECLARATION, packageDeclaration, this.packageDeclaration);
        this.packageDeclaration = packageDeclaration;
        return this;
    }

    @Override
    public CtCompilationUnitImpl setFile(File file) {
        this.file = file;
        this.position = SourcePosition.NOPOSITION;
        return this;
    }

    @Override
    public List<File> getBinaryFiles() {
        File base;
        ArrayList<File> binaries = new ArrayList<File>();
        String output = this.getFactory().getEnvironment().getBinaryOutputDirectory();
        if (output != null && (base = Paths.get(output, this.getDeclaredPackage().getQualifiedName().replace(".", File.separator)).toFile()).isDirectory()) {
            for (CtType<?> type : this.getDeclaredTypes()) {
                String nameOfType = type.getSimpleName();
                File fileOfType = new File(base, nameOfType + ".class");
                if (fileOfType.isFile()) {
                    binaries.add(fileOfType);
                }
                for (CtType inner : type.getElements(new TypeFilter<CtType>(CtType.class))) {
                    String nameOfInner;
                    File fileOfInnerType;
                    if (inner.equals(type) || !(fileOfInnerType = new File(base, (nameOfInner = nameOfType + "$" + inner.getSimpleName()) + ".class")).isFile()) continue;
                    binaries.add(fileOfInnerType);
                }
            }
        }
        return binaries;
    }

    @Override
    public String getOriginalSourceCode() {
        if (this.originalSourceCode == null && this.getFile() != null && this.getFile().exists()) {
            try {
                this.originalSourceCode = Files.readString(this.getFile().toPath(), this.getFactory().getEnvironment().getEncoding());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.originalSourceCode;
    }

    @Override
    public ModelList<CtImport> getImports() {
        return this.imports;
    }

    @Override
    public CtCompilationUnitImpl setImports(Collection<CtImport> imports) {
        this.imports.set(imports);
        return this;
    }

    @Override
    public ElementSourceFragment getOriginalSourceFragment() {
        if (this.rootFragment == null) {
            if (this.moduleReference != null) {
                throw new SpoonException("Root source fragment of compilation unit of module is not supported");
            }
            if (this.declaredTypeReferences.isEmpty()) {
                throw new SpoonException("Root source fragment of compilation unit of package is not supported");
            }
            this.rootFragment = ElementSourceFragment.createSourceFragmentsFrom(this);
        }
        return this.rootFragment;
    }

    @Override
    public int[] getLineSeparatorPositions() {
        return this.lineSeparatorPositions;
    }

    @Override
    public CtCompilationUnitImpl setLineSeparatorPositions(int[] lineSeparatorPositions) {
        this.lineSeparatorPositions = lineSeparatorPositions;
        return this;
    }

    @Override
    public SourcePosition getPosition() {
        if (this.position == SourcePosition.NOPOSITION) {
            String sourceCode = this.getOriginalSourceCode();
            this.position = sourceCode != null ? this.getFactory().Core().createSourcePosition((CompilationUnit)((Object)this), 0, sourceCode.length() - 1, this.getLineSeparatorPositions()) : this.getFactory().Core().createSourcePosition((CompilationUnit)((Object)this), 0, 0x7FFFFFFE, this.getLineSeparatorPositions());
        }
        return this.position;
    }

    @Override
    @UnsettableProperty
    public <E extends CtElement> E setPosition(SourcePosition position) {
        return (E)this;
    }

    public SourcePosition getOrCreatePartialSourcePosition() {
        if (this.myPartialSourcePosition == null) {
            this.myPartialSourcePosition = new PartialSourcePositionImpl((CompilationUnit)((Object)this));
        }
        return this.myPartialSourcePosition;
    }

    @Override
    public void accept(CtVisitor visitor) {
        visitor.visitCtCompilationUnit(this);
    }

    @Override
    public CtCompilationUnitImpl clone() {
        return (CtCompilationUnitImpl)super.clone();
    }

    @Override
    public CtElement getParent() throws ParentNotInitializedException {
        return null;
    }

    @Override
    @UnsettableProperty
    public <E extends CtElement> E setParent(CtElement parent) {
        return (E)this;
    }

    @Override
    public String toString() {
        if (this.file != null) {
            return this.file.getName();
        }
        return "CompilationUnit<unknown file>";
    }
}

