/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.cu.position;

import spoon.reflect.cu.CompilationUnit;
import spoon.reflect.cu.position.CompoundSourcePosition;
import spoon.support.reflect.cu.position.SourcePositionImpl;

public class CompoundSourcePositionImpl
extends SourcePositionImpl
implements CompoundSourcePosition {
    private static final long serialVersionUID = 1L;
    private int declarationSourceStart;
    private int declarationSourceEnd;

    public CompoundSourcePositionImpl(CompilationUnit compilationUnit, int nameStart, int nameEnd, int declarationSourceStart, int declarationSourceEnd, int[] lineSeparatorPositions) {
        super(compilationUnit, nameStart, nameEnd, lineSeparatorPositions);
        CompoundSourcePositionImpl.checkArgsAreAscending(declarationSourceStart, declarationSourceEnd);
        if (nameStart != 0) {
            CompoundSourcePositionImpl.checkArgsAreAscending(declarationSourceStart, nameStart, nameEnd + 1, declarationSourceEnd + 1);
        }
        this.declarationSourceStart = declarationSourceStart;
        this.declarationSourceEnd = declarationSourceEnd;
    }

    @Override
    public int getDeclarationEnd() {
        return this.declarationSourceEnd;
    }

    @Override
    public int getDeclarationStart() {
        return this.declarationSourceStart;
    }

    @Override
    public int getSourceEnd() {
        return this.declarationSourceEnd;
    }

    @Override
    public int getSourceStart() {
        return this.declarationSourceStart;
    }

    @Override
    public int getNameStart() {
        return super.getSourceStart();
    }

    @Override
    public int getNameEnd() {
        return super.getSourceEnd();
    }

    @Override
    public int getEndLine() {
        return this.searchLineNumber(this.declarationSourceEnd);
    }

    @Override
    public int getEndColumn() {
        return this.searchColumnNumber(this.declarationSourceEnd);
    }

    @Override
    public String getSourceDetails() {
        return super.getSourceDetails() + "\nname = " + this.getFragment(this.getNameStart(), this.getNameEnd());
    }
}

