/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.code;

import java.util.ArrayList;
import java.util.List;
import spoon.reflect.annotations.MetamodelPropertyField;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtStatementList;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtTypedElement;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtActualTypeContainer;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtVisitor;
import spoon.support.DerivedProperty;
import spoon.support.reflect.code.CtStatementImpl;
import spoon.support.reflect.code.CtTargetedExpressionImpl;
import spoon.support.reflect.declaration.CtElementImpl;

public class CtConstructorCallImpl<T>
extends CtTargetedExpressionImpl<T, CtExpression<?>>
implements CtConstructorCall<T> {
    private static final long serialVersionUID = 1L;
    @MetamodelPropertyField(role={CtRole.ARGUMENT})
    List<CtExpression<?>> arguments = CtConstructorCallImpl.emptyList();
    @MetamodelPropertyField(role={CtRole.EXECUTABLE_REF})
    CtExecutableReference<T> executable;
    @MetamodelPropertyField(role={CtRole.LABEL})
    String label;

    @Override
    public void accept(CtVisitor visitor) {
        visitor.visitCtConstructorCall(this);
    }

    @Override
    public List<CtExpression<?>> getArguments() {
        return this.arguments;
    }

    @Override
    public CtExecutableReference<T> getExecutable() {
        if (this.executable == null) {
            this.executable = this.getFactory().Core().createExecutableReference();
            this.executable.setParent(this);
        }
        return this.executable;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public <C extends CtStatement> C insertAfter(CtStatement statement) {
        CtStatementImpl.insertAfter((CtStatement)this, statement);
        return (C)this;
    }

    public <C extends CtStatement> C insertBefore(CtStatement statement) {
        CtStatementImpl.insertBefore((CtStatement)this, statement);
        return (C)this;
    }

    public <C extends CtStatement> C insertAfter(CtStatementList statements) {
        CtStatementImpl.insertAfter((CtStatement)this, statements);
        return (C)this;
    }

    public <C extends CtStatement> C insertBefore(CtStatementList statements) {
        CtStatementImpl.insertBefore((CtStatement)this, statements);
        return (C)this;
    }

    @Override
    public <C extends CtAbstractInvocation<T>> C setArguments(List<CtExpression<?>> arguments) {
        if (arguments == null || arguments.isEmpty()) {
            this.arguments = CtElementImpl.emptyList();
            return (C)this;
        }
        if (this.arguments == CtElementImpl.emptyList()) {
            this.arguments = new ArrayList(2);
        }
        this.getFactory().getEnvironment().getModelChangeListener().onListDeleteAll(this, CtRole.ARGUMENT, this.arguments, new ArrayList(this.arguments));
        this.arguments.clear();
        for (CtExpression<?> expr : arguments) {
            this.addArgument(expr);
        }
        return (C)this;
    }

    private <C extends CtAbstractInvocation<T>> C addArgument(int position, CtExpression<?> argument) {
        if (argument == null) {
            return (C)this;
        }
        if (this.arguments == CtElementImpl.emptyList()) {
            this.arguments = new ArrayList(2);
        }
        argument.setParent(this);
        this.getFactory().getEnvironment().getModelChangeListener().onListAdd(this, CtRole.ARGUMENT, this.arguments, position, argument);
        this.arguments.add(position, argument);
        return (C)this;
    }

    @Override
    public <C extends CtAbstractInvocation<T>> C addArgument(CtExpression<?> argument) {
        return this.addArgument(this.arguments.size(), argument);
    }

    @Override
    public <C extends CtAbstractInvocation<T>> C addArgumentAt(int position, CtExpression<?> argument) {
        return this.addArgument(position, argument);
    }

    @Override
    public void removeArgument(CtExpression<?> argument) {
        if (this.arguments == CtElementImpl.emptyList()) {
            return;
        }
        this.getFactory().getEnvironment().getModelChangeListener().onListDelete(this, CtRole.ARGUMENT, this.arguments, this.arguments.indexOf(argument), argument);
        this.arguments.remove(argument);
    }

    @Override
    public <C extends CtAbstractInvocation<T>> C setExecutable(CtExecutableReference<T> executable) {
        if (executable != null) {
            executable.setParent(this);
        }
        this.getFactory().getEnvironment().getModelChangeListener().onObjectUpdate((CtElement)this, CtRole.EXECUTABLE_REF, executable, this.executable);
        this.executable = executable;
        return (C)this;
    }

    public <C extends CtStatement> C setLabel(String label) {
        this.getFactory().getEnvironment().getModelChangeListener().onObjectUpdate((CtElement)this, CtRole.LABEL, label, this.label);
        this.label = label;
        return (C)this;
    }

    @Override
    @DerivedProperty
    public List<CtTypeReference<?>> getActualTypeArguments() {
        return this.getExecutable() == null ? CtElementImpl.emptyList() : this.getExecutable().getActualTypeArguments();
    }

    @Override
    @DerivedProperty
    public <T extends CtActualTypeContainer> T setActualTypeArguments(List<? extends CtTypeReference<?>> actualTypeArguments) {
        if (this.getExecutable() != null) {
            this.getExecutable().setActualTypeArguments(actualTypeArguments);
        }
        return (T)this;
    }

    @Override
    @DerivedProperty
    public <T extends CtActualTypeContainer> T addActualTypeArgument(CtTypeReference<?> actualTypeArgument) {
        if (this.getExecutable() != null) {
            this.getExecutable().addActualTypeArgument(actualTypeArgument);
        }
        return (T)this;
    }

    @Override
    @DerivedProperty
    public boolean removeActualTypeArgument(CtTypeReference<?> actualTypeArgument) {
        if (this.getExecutable() != null) {
            return this.getExecutable().removeActualTypeArgument(actualTypeArgument);
        }
        return false;
    }

    @Override
    @DerivedProperty
    public CtTypeReference<T> getType() {
        return this.getExecutable() == null ? null : this.getExecutable().getType();
    }

    @Override
    @DerivedProperty
    public <C extends CtTypedElement> C setType(CtTypeReference type) {
        if (type != null) {
            type.setParent(this);
        }
        if (this.getExecutable() != null) {
            this.getExecutable().setType(type);
        }
        return (C)this;
    }

    @Override
    public CtConstructorCall<T> clone() {
        return (CtConstructorCall)super.clone();
    }
}

