/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.code;

import java.util.Objects;
import spoon.reflect.annotations.MetamodelPropertyField;
import spoon.reflect.code.CtComment;
import spoon.reflect.code.CtJavaDoc;
import spoon.reflect.cu.CompilationUnit;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.path.CtRole;
import spoon.reflect.visitor.CtVisitor;
import spoon.support.compiler.jdt.JDTCommentBuilder;
import spoon.support.reflect.code.CtStatementImpl;

public class CtCommentImpl
extends CtStatementImpl
implements CtComment {
    private static final long serialVersionUID = 1L;
    @MetamodelPropertyField(role={CtRole.COMMENT_CONTENT})
    protected String content;
    @MetamodelPropertyField(role={CtRole.COMMENT_TYPE})
    private CtComment.CommentType type;

    public CtCommentImpl() {
    }

    protected CtCommentImpl(CtComment.CommentType type) {
        this.type = type;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public String getRawContent() {
        String source;
        SourcePosition pos = this.getPosition();
        CompilationUnit cu = pos.getCompilationUnit();
        if (cu != null && (source = cu.getOriginalSourceCode()) != null) {
            return source.substring(pos.getSourceStart(), pos.getSourceEnd() + 1);
        }
        return "";
    }

    @Override
    public <E extends CtComment> E setContent(String content) {
        this.getFactory().getEnvironment().getModelChangeListener().onObjectUpdate((CtElement)this, CtRole.COMMENT_CONTENT, content, this.content);
        this.content = JDTCommentBuilder.cleanComment(content);
        return (E)this;
    }

    public <E extends CtComment> E _setRawContent(String content) {
        this.content = content;
        return (E)this;
    }

    @Override
    public CtComment.CommentType getCommentType() {
        return this.type;
    }

    @Override
    public <E extends CtComment> E setCommentType(CtComment.CommentType commentType) {
        this.getFactory().getEnvironment().getModelChangeListener().onObjectUpdate((CtElement)this, CtRole.TYPE, (Object)commentType, (Object)this.type);
        this.type = commentType;
        return (E)this;
    }

    @Override
    public void accept(CtVisitor visitor) {
        visitor.visitCtComment(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CtCommentImpl ctComment = (CtCommentImpl)o;
        if (!Objects.equals(this.content, ctComment.content)) {
            return false;
        }
        return this.type == ctComment.type;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.content != null ? this.content.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    @Override
    public CtComment clone() {
        return (CtComment)super.clone();
    }

    @Override
    public CtJavaDoc asJavaDoc() {
        if (this instanceof CtJavaDoc) {
            return (CtJavaDoc)((Object)this);
        }
        throw new IllegalStateException("not a javadoc comment");
    }
}

