/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.modelobs;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import spoon.compiler.Environment;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.path.CtRole;
import spoon.reflect.visitor.EarlyTerminatingScanner;
import spoon.reflect.visitor.chain.CtScannerListener;
import spoon.reflect.visitor.chain.ScanningMode;
import spoon.support.modelobs.EmptyModelChangeListener;
import spoon.support.modelobs.FineModelChangeListener;

public class ChangeCollector {
    private final Map<CtElement, Set<CtRole>> elementToChangeRole = new IdentityHashMap<CtElement, Set<CtRole>>();
    private final ChangeListener changeListener = new ChangeListener();

    public static @Nullable ChangeCollector getChangeCollector(Environment env) {
        FineModelChangeListener mcl = env.getModelChangeListener();
        if (mcl instanceof ChangeListener) {
            return ((ChangeListener)mcl).getChangeCollector();
        }
        return null;
    }

    public static void runWithoutChangeListener(Environment env, Runnable runnable) {
        FineModelChangeListener mcl = env.getModelChangeListener();
        if (mcl instanceof ChangeListener) {
            env.setModelChangeListener(new EmptyModelChangeListener());
            try {
                runnable.run();
            }
            finally {
                env.setModelChangeListener(mcl);
            }
        }
    }

    public ChangeCollector attachTo(Environment env) {
        env.setModelChangeListener(this.changeListener);
        return this;
    }

    public Set<CtRole> getDirectChanges(CtElement currentElement) {
        Set<CtRole> changes = this.elementToChangeRole.get(currentElement);
        if (changes == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(changes);
    }

    public Set<CtRole> getChanges(CtElement currentElement) {
        final HashSet<CtRole> changes = new HashSet<CtRole>(this.getDirectChanges(currentElement));
        final Scanner scanner = new Scanner();
        scanner.setListener(new CtScannerListener(){
            int depth = 0;
            CtRole checkedRole;

            @Override
            public ScanningMode enter(CtElement element) {
                if (this.depth == 0) {
                    this.checkedRole = scanner.getScannedRole();
                }
                if (changes.contains((Object)this.checkedRole)) {
                    return ScanningMode.SKIP_ALL;
                }
                if (ChangeCollector.this.elementToChangeRole.containsKey(element) && !ChangeCollector.this.elementToChangeRole.get(element).contains((Object)CtRole.IS_IMPLICIT)) {
                    changes.add(this.checkedRole);
                    return ScanningMode.SKIP_ALL;
                }
                ++this.depth;
                return ScanningMode.NORMAL;
            }

            @Override
            public void exit(CtElement element) {
                --this.depth;
            }
        });
        currentElement.accept(scanner);
        return Collections.unmodifiableSet(changes);
    }

    protected void onChange(CtElement currentElement, CtRole role) {
        Set<CtRole> roles = this.elementToChangeRole.get(currentElement);
        if (roles == null) {
            roles = new HashSet<CtRole>();
            this.elementToChangeRole.put(currentElement, roles);
        }
        if (role.getSuperRole() != null) {
            role = role.getSuperRole();
        }
        roles.add(role);
    }

    private class ChangeListener
    implements FineModelChangeListener {
        private ChangeListener() {
        }

        private ChangeCollector getChangeCollector() {
            return ChangeCollector.this;
        }

        @Override
        public void onObjectUpdate(CtElement currentElement, CtRole role, CtElement newValue, CtElement oldValue) {
            ChangeCollector.this.onChange(currentElement, role);
        }

        @Override
        public void onObjectUpdate(CtElement currentElement, CtRole role, Object newValue, Object oldValue) {
            ChangeCollector.this.onChange(currentElement, role);
        }

        @Override
        public void onObjectDelete(CtElement currentElement, CtRole role, CtElement oldValue) {
            ChangeCollector.this.onChange(currentElement, role);
        }

        @Override
        public void onListAdd(CtElement currentElement, CtRole role, List field, CtElement newValue) {
            ChangeCollector.this.onChange(currentElement, role);
        }

        @Override
        public void onListAdd(CtElement currentElement, CtRole role, List field, int index, CtElement newValue) {
            ChangeCollector.this.onChange(currentElement, role);
        }

        @Override
        public void onListDelete(CtElement currentElement, CtRole role, List field, Collection<? extends CtElement> oldValue) {
            ChangeCollector.this.onChange(currentElement, role);
        }

        @Override
        public void onListDelete(CtElement currentElement, CtRole role, List field, int index, CtElement oldValue) {
            ChangeCollector.this.onChange(currentElement, role);
        }

        @Override
        public void onListDeleteAll(CtElement currentElement, CtRole role, List field, List oldValue) {
            ChangeCollector.this.onChange(currentElement, role);
        }

        @Override
        public <K, V> void onMapAdd(CtElement currentElement, CtRole role, Map<K, V> field, K key, CtElement newValue) {
            ChangeCollector.this.onChange(currentElement, role);
        }

        @Override
        public <K, V> void onMapDelete(CtElement currentElement, CtRole role, Map<K, V> field, K key, CtElement oldValue) {
            ChangeCollector.this.onChange(currentElement, role);
        }

        @Override
        public <K, V> void onMapDeleteAll(CtElement currentElement, CtRole role, Map<K, V> field, Map<K, V> oldValue) {
            ChangeCollector.this.onChange(currentElement, role);
        }

        @Override
        public void onSetAdd(CtElement currentElement, CtRole role, Set field, CtElement newValue) {
            ChangeCollector.this.onChange(currentElement, role);
        }

        @Override
        public <T extends Enum> void onSetAdd(CtElement currentElement, CtRole role, Set field, T newValue) {
            ChangeCollector.this.onChange(currentElement, role);
        }

        @Override
        public void onSetDelete(CtElement currentElement, CtRole role, Set field, CtElement oldValue) {
            ChangeCollector.this.onChange(currentElement, role);
        }

        @Override
        public void onSetDelete(CtElement currentElement, CtRole role, Set field, Collection<ModifierKind> oldValue) {
            ChangeCollector.this.onChange(currentElement, role);
        }

        @Override
        public void onSetDelete(CtElement currentElement, CtRole role, Set field, ModifierKind oldValue) {
            ChangeCollector.this.onChange(currentElement, role);
        }

        @Override
        public void onSetDeleteAll(CtElement currentElement, CtRole role, Set field, Set oldValue) {
            ChangeCollector.this.onChange(currentElement, role);
        }
    }

    private static class Scanner
    extends EarlyTerminatingScanner<Void> {
        Scanner() {
            this.setVisitCompilationUnitContent(true);
        }

        CtRole getScannedRole() {
            return this.scannedRole;
        }
    }
}

