/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.modelobs;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.path.CtRole;
import spoon.support.modelobs.ActionBasedChangeListener;
import spoon.support.modelobs.FineModelChangeListener;
import spoon.support.modelobs.action.Action;
import spoon.support.modelobs.action.AddAction;
import spoon.support.modelobs.action.DeleteAction;
import spoon.support.modelobs.action.DeleteAllAction;
import spoon.support.modelobs.action.UpdateAction;
import spoon.support.modelobs.context.Context;
import spoon.support.modelobs.context.ListContext;
import spoon.support.modelobs.context.MapContext;
import spoon.support.modelobs.context.ObjectContext;
import spoon.support.modelobs.context.SetContext;

public abstract class ActionBasedChangeListenerImpl
implements ActionBasedChangeListener,
FineModelChangeListener {
    private void propagateModelChange(Action action) {
        this.onAction(action);
        if (action instanceof DeleteAllAction) {
            this.onDeleteAll((DeleteAllAction)action);
        } else if (action instanceof DeleteAction) {
            this.onDelete((DeleteAction)action);
        } else if (action instanceof AddAction) {
            this.onAdd((AddAction)action);
        } else if (action instanceof UpdateAction) {
            this.onUpdate((UpdateAction)action);
        }
    }

    @Override
    public void onObjectUpdate(CtElement currentElement, CtRole role, CtElement newValue, CtElement oldValue) {
        this.propagateModelChange(new UpdateAction<CtElement>(new ObjectContext(currentElement, role), newValue, oldValue));
    }

    @Override
    public void onObjectUpdate(CtElement currentElement, CtRole role, Object newValue, Object oldValue) {
        this.propagateModelChange(new UpdateAction<Object>(new ObjectContext(currentElement, role), newValue, oldValue));
    }

    @Override
    public void onObjectDelete(CtElement currentElement, CtRole role, CtElement oldValue) {
        this.propagateModelChange(new DeleteAction<CtElement>(new ObjectContext(currentElement, role), oldValue));
    }

    @Override
    public void onListAdd(CtElement currentElement, CtRole role, List field, CtElement newValue) {
        this.propagateModelChange(new AddAction<CtElement>(new ListContext(currentElement, role, field), newValue));
    }

    @Override
    public void onListAdd(CtElement currentElement, CtRole role, List field, int index, CtElement newValue) {
        this.propagateModelChange(new AddAction<CtElement>(new ListContext(currentElement, role, field, index), newValue));
    }

    @Override
    public void onListDelete(CtElement currentElement, CtRole role, List field, Collection<? extends CtElement> oldValue) {
        for (CtElement ctElement : oldValue) {
            this.onListDelete(currentElement, role, field, field.indexOf(ctElement), ctElement);
        }
    }

    @Override
    public void onListDelete(CtElement currentElement, CtRole role, List field, int index, CtElement oldValue) {
        this.propagateModelChange(new DeleteAction<CtElement>(new ListContext(currentElement, role, field, index), oldValue));
    }

    @Override
    public void onListDeleteAll(CtElement currentElement, CtRole role, List field, List oldValue) {
        this.propagateModelChange(new DeleteAllAction((Context)new ListContext(currentElement, role, field), oldValue));
    }

    @Override
    public <K, V> void onMapAdd(CtElement currentElement, CtRole role, Map<K, V> field, K key, CtElement newValue) {
        this.propagateModelChange(new AddAction<CtElement>(new MapContext<K, V>(currentElement, role, field, key), newValue));
    }

    @Override
    public <K, V> void onMapDelete(CtElement currentElement, CtRole role, Map<K, V> field, K key, CtElement oldValue) {
        this.propagateModelChange(new DeleteAction<CtElement>(new MapContext<K, V>(currentElement, role, field, key), oldValue));
    }

    @Override
    public <K, V> void onMapDeleteAll(CtElement currentElement, CtRole role, Map<K, V> field, Map<K, V> oldValue) {
        this.propagateModelChange(new DeleteAllAction((Context)new MapContext<K, V>(currentElement, role, field), oldValue));
    }

    @Override
    public void onSetAdd(CtElement currentElement, CtRole role, Set field, CtElement newValue) {
        this.propagateModelChange(new AddAction<CtElement>(new SetContext(currentElement, role, field), newValue));
    }

    @Override
    public <T extends Enum> void onSetAdd(CtElement currentElement, CtRole role, Set field, T newValue) {
        this.propagateModelChange(new AddAction<T>(new SetContext(currentElement, role, field), newValue));
    }

    @Override
    public void onSetDelete(CtElement currentElement, CtRole role, Set field, CtElement oldValue) {
        this.propagateModelChange(new DeleteAction<CtElement>(new SetContext(currentElement, role, field), oldValue));
    }

    @Override
    public void onSetDelete(CtElement currentElement, CtRole role, Set field, Collection<ModifierKind> oldValue) {
        for (ModifierKind modifierKind : oldValue) {
            this.onSetDelete(currentElement, role, field, modifierKind);
        }
    }

    @Override
    public void onSetDelete(CtElement currentElement, CtRole role, Set field, ModifierKind oldValue) {
        this.propagateModelChange(new DeleteAction<ModifierKind>(new SetContext(currentElement, role, field), oldValue));
    }

    @Override
    public void onSetDeleteAll(CtElement currentElement, CtRole role, Set field, Set oldValue) {
        this.propagateModelChange(new DeleteAllAction((Context)new SetContext(currentElement, role, field), oldValue));
    }

    @Override
    public void onDelete(DeleteAction action) {
    }

    @Override
    public void onDeleteAll(DeleteAllAction action) {
    }

    @Override
    public void onAdd(AddAction action) {
    }

    @Override
    public void onUpdate(UpdateAction action) {
    }

    @Override
    public void onAction(Action action) {
    }
}

