/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.compiler.jdt;

import java.io.PrintWriter;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.CompilationProgress;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.util.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spoon.support.Level;
import spoon.support.compiler.jdt.JDTConstants;

class TreeBuilderCompiler
extends Compiler {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private boolean ignoreSyntaxErrors;
    private Level level;

    TreeBuilderCompiler(INameEnvironment environment, IErrorHandlingPolicy policy, CompilerOptions options, ICompilerRequestor requestor, IProblemFactory problemFactory, PrintWriter out, boolean ignoreSyntaxErrors, Level level, CompilationProgress progress) {
        super(environment, policy, options, requestor, problemFactory, out, progress);
        this.ignoreSyntaxErrors = ignoreSyntaxErrors;
        this.level = level;
    }

    private void sortModuleDeclarationsFirst(ICompilationUnit[] sourceUnits) {
        Arrays.sort(sourceUnits, (u1, u2) -> {
            boolean isMod2;
            char[] fn1 = u1.getFileName();
            char[] fn2 = u2.getFileName();
            boolean isMod1 = CharOperation.endsWith((char[])fn1, (char[])JDTConstants.MODULE_INFO_FILE_NAME) || CharOperation.endsWith((char[])fn1, (char[])JDTConstants.MODULE_INFO_CLASS_NAME);
            boolean bl = isMod2 = CharOperation.endsWith((char[])fn2, (char[])JDTConstants.MODULE_INFO_FILE_NAME) || CharOperation.endsWith((char[])fn2, (char[])JDTConstants.MODULE_INFO_CLASS_NAME);
            if (isMod1 == isMod2) {
                return 0;
            }
            return isMod1 ? -1 : 1;
        });
    }

    protected CompilationUnitDeclaration[] buildUnits(CompilationUnit[] sourceUnits) {
        this.reportProgress(Messages.compilation_beginningToCompile);
        this.sortModuleDeclarationsFirst((ICompilationUnit[])sourceUnits);
        CompilationUnit[] filteredSourceUnits = null;
        if (this.ignoreSyntaxErrors || this.level.toInt() > Level.ERROR.toInt()) {
            filteredSourceUnits = this.ignoreSyntaxErrors(sourceUnits);
        }
        if (this.ignoreSyntaxErrors) {
            this.beginToCompile((ICompilationUnit[])filteredSourceUnits);
        } else {
            this.beginToCompile((ICompilationUnit[])sourceUnits);
        }
        for (int i = 0; i < this.totalUnits; ++i) {
            CompilationUnitDeclaration unit = this.unitsToProcess[i];
            this.reportProgress(Messages.bind((String)Messages.compilation_processing, (Object)new String(unit.getFileName())));
            this.parser.getMethodBodies(unit);
            if (unit.scope != null) {
                unit.scope.faultInTypes();
            }
            if (unit.scope != null) {
                unit.scope.verifyMethods(this.lookupEnvironment.methodVerifier());
            }
            unit.resolve();
            unit.analyseCode();
            unit.ignoreFurtherInvestigation = false;
            this.requestor.acceptResult(unit.compilationResult);
            this.reportWorked(1, i);
        }
        ArrayList<CompilationUnitDeclaration> unitsToReturn = new ArrayList<CompilationUnitDeclaration>();
        for (CompilationUnitDeclaration cud : this.unitsToProcess) {
            if (cud == null) continue;
            unitsToReturn.add(cud);
        }
        return unitsToReturn.toArray(new CompilationUnitDeclaration[0]);
    }

    private CompilationUnit[] ignoreSyntaxErrors(CompilationUnit[] sourceUnits) {
        ArrayList<CompilationUnit> sourceUnitList = new ArrayList<CompilationUnit>();
        int maxUnits = sourceUnits.length;
        for (int i = 0; i < maxUnits; ++i) {
            CompilationResult unitResult = new CompilationResult((ICompilationUnit)sourceUnits[i], i, maxUnits, this.options.maxProblemsPerUnit);
            CompilationUnitDeclaration parsedUnit = this.parser.parse((ICompilationUnit)sourceUnits[i], unitResult);
            if (parsedUnit.hasErrors()) {
                LOGGER.warn("Syntax error detected in: " + String.valueOf(sourceUnits[i].getFileName()));
                continue;
            }
            sourceUnitList.add(sourceUnits[i]);
        }
        this.initializeParser();
        return sourceUnitList.toArray(new CompilationUnit[0]);
    }
}

