/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.compiler.jdt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.ModuleReference;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ReferenceExpression;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.Wildcard;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.CaptureBinding;
import org.eclipse.jdt.internal.compiler.lookup.CatchParameterBinding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.IntersectionTypeBinding18;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.MissingTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.PlainPackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.PolyTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemPackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticFactoryMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.VoidTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;
import org.jspecify.annotations.Nullable;
import spoon.NoClasspathWorkaround;
import spoon.reflect.code.CtLambda;
import spoon.reflect.declaration.CtModule;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.factory.PackageFactory;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtCatchVariableReference;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtLocalVariableReference;
import spoon.reflect.reference.CtModuleReference;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtParameterReference;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtVariableReference;
import spoon.reflect.reference.CtWildcardReference;
import spoon.support.Level;
import spoon.support.compiler.jdt.ASTPair;
import spoon.support.compiler.jdt.ContextBuilder;
import spoon.support.compiler.jdt.JDTTreeBuilder;
import spoon.support.compiler.jdt.JDTTreeBuilderHelper;
import spoon.support.compiler.jdt.JDTTreeBuilderQuery;
import spoon.support.compiler.jdt.ModifierTarget;
import spoon.support.reflect.CtExtendedModifier;

public class ReferenceBuilder {
    private static final Set<CtExtendedModifier> PUBLIC_PROTECTED = Set.of(CtExtendedModifier.explicit(ModifierKind.PUBLIC), CtExtendedModifier.explicit(ModifierKind.PROTECTED));
    private Map<TypeBinding, CtTypeReference> exploringParameterizedBindings = new HashMap<TypeBinding, CtTypeReference>();
    private final JDTTreeBuilder jdtTreeBuilder;
    final Map<TypeBinding, CtTypeReference> bindingCache = new HashMap<TypeBinding, CtTypeReference>();

    ReferenceBuilder(JDTTreeBuilder jdtTreeBuilder) {
        this.jdtTreeBuilder = jdtTreeBuilder;
    }

    <T> CtTypeReference<T> buildTypeReference(TypeReference type, Scope scope) {
        return this.buildTypeReference(type, scope, false);
    }

    <T> CtTypeReference<T> buildTypeReference(TypeReference type, Scope scope, boolean isTypeCast) {
        if (type == null) {
            return null;
        }
        CtTypeReference<T> typeReference = this.getTypeReference(type.resolvedType, type);
        return this.buildTypeReferenceInternal(typeReference, type, scope, isTypeCast);
    }

    <T> CtTypeReference<T> buildTypeReference(QualifiedTypeReference type, Scope scope) {
        CtTypeReference<T> ref;
        TypeBinding receiverType;
        CtTypeReference<T> accessedType = this.buildTypeReference((TypeReference)type, scope);
        TypeBinding typeBinding = receiverType = type != null ? type.resolvedType : null;
        if (receiverType != null && (ref = this.getQualifiedTypeReference(type.tokens, receiverType, receiverType.enclosingType(), new JDTTreeBuilder.OnAccessListener(){

            @Override
            public boolean onAccess(char[][] tokens, int index) {
                return true;
            }
        })) != null && !ref.equals(accessedType)) {
            JDTTreeBuilderHelper.handleImplicit(type, ref);
            accessedType = ref;
        }
        return accessedType;
    }

    private CtTypeParameterReference buildTypeParameterReference(TypeReference type, Scope scope) {
        if (type == null) {
            return null;
        }
        return (CtTypeParameterReference)this.buildTypeReferenceInternal(this.getTypeParameterReference(type.resolvedType, type), type, scope, false);
    }

    private <T> CtTypeReference<T> buildTypeReferenceInternal(CtTypeReference<T> typeReference, TypeReference type, Scope scope, boolean isTypeCast) {
        if (type == null) {
            return null;
        }
        CtTypeReference<Object> currentReference = typeReference;
        for (int position = type.getTypeName().length - 1; position >= 0 && currentReference != null; currentReference = currentReference.getDeclaringType(), --position) {
            this.jdtTreeBuilder.getContextBuilder().isBuildTypeCast = isTypeCast;
            this.jdtTreeBuilder.getContextBuilder().enter(currentReference, (ASTNode)type);
            this.jdtTreeBuilder.getContextBuilder().isBuildTypeCast = false;
            if (type.annotations != null && type.annotations.length - 1 <= position && type.annotations[position] != null && type.annotations[position].length > 0) {
                for (Annotation annotation : type.annotations[position]) {
                    if (scope instanceof ClassScope) {
                        annotation.traverse((ASTVisitor)this.jdtTreeBuilder, (ClassScope)scope);
                        continue;
                    }
                    if (scope instanceof BlockScope) {
                        annotation.traverse((ASTVisitor)this.jdtTreeBuilder, (BlockScope)scope);
                        continue;
                    }
                    annotation.traverse((ASTVisitor)this.jdtTreeBuilder, (BlockScope)null);
                }
            }
            if (type.getTypeArguments() != null && type.getTypeArguments().length - 1 <= position && type.getTypeArguments()[position] != null && type.getTypeArguments()[position].length > 0) {
                CtTypeReference<Object> componentReference = this.getTypeReferenceOfArrayComponent(currentReference);
                componentReference.getActualTypeArguments().clear();
                for (TypeReference typeArgument : type.getTypeArguments()[position]) {
                    if (typeArgument instanceof Wildcard || typeArgument.resolvedType instanceof WildcardBinding || typeArgument.resolvedType instanceof TypeVariableBinding) {
                        componentReference.addActualTypeArgument(this.buildTypeParameterReference(typeArgument, scope));
                        continue;
                    }
                    componentReference.addActualTypeArgument(this.buildTypeReference(typeArgument, scope));
                }
            } else if ((type instanceof ParameterizedSingleTypeReference || type instanceof ParameterizedQualifiedTypeReference) && !this.isTypeArgumentExplicit(type.getTypeArguments())) {
                for (CtTypeReference<?> actualTypeArgument : currentReference.getActualTypeArguments()) {
                    actualTypeArgument.setImplicit(true);
                    if (!(actualTypeArgument instanceof CtArrayTypeReference)) continue;
                    ((CtArrayTypeReference)actualTypeArgument).getComponentType().setImplicit(true);
                }
            }
            if (type instanceof Wildcard && typeReference instanceof CtWildcardReference) {
                ((CtWildcardReference)typeReference).setBoundingType(this.buildTypeReference(((Wildcard)type).bound, scope));
            }
            this.jdtTreeBuilder.getContextBuilder().exit((ASTNode)type);
        }
        if (type instanceof SingleTypeReference) {
            typeReference.setSimplyQualified(true);
        } else if (type instanceof QualifiedTypeReference) {
            this.jdtTreeBuilder.getHelper();
            JDTTreeBuilderHelper.handleImplicit((QualifiedTypeReference)type, typeReference);
        }
        return typeReference;
    }

    private CtTypeReference<?> getTypeReferenceOfArrayComponent(CtTypeReference<?> currentReference) {
        while (currentReference instanceof CtArrayTypeReference) {
            currentReference = ((CtArrayTypeReference)currentReference).getComponentType();
        }
        return currentReference;
    }

    private boolean isTypeArgumentExplicit(TypeReference[][] typeArguments) {
        if (typeArguments == null) {
            return true;
        }
        boolean isGenericTypeExplicit = true;
        for (TypeReference[] typeArgument : typeArguments) {
            boolean bl = isGenericTypeExplicit = typeArgument != null && typeArgument.length > 0;
            if (isGenericTypeExplicit) break;
        }
        return isGenericTypeExplicit;
    }

    <T> CtTypeReference<T> getQualifiedTypeReference(char[][] tokens, TypeBinding receiverType, ReferenceBinding enclosingType, JDTTreeBuilder.OnAccessListener listener) {
        if (enclosingType != null && Collections.disjoint(PUBLIC_PROTECTED, JDTTreeBuilderQuery.getModifiers(enclosingType.modifiers, false, ModifierTarget.NONE))) {
            TypeBinding accessBinding;
            int i;
            String access = "";
            CompilationUnitDeclaration[] units = ((Compiler)this.jdtTreeBuilder.getContextBuilder().compilationunitdeclaration.scope.environment.typeRequestor).unitsToProcess;
            for (i = 0; i < tokens.length; ++i) {
                char[][] qualified = (char[][])Arrays.copyOfRange(tokens, 0, i + 1);
                if (JDTTreeBuilderQuery.searchPackage(qualified, units) != null) continue;
                access = CharOperation.toString((char[][])qualified);
                break;
            }
            if (!access.contains(".")) {
                access = JDTTreeBuilderQuery.searchType(access, this.jdtTreeBuilder.getContextBuilder().compilationunitdeclaration.imports);
            }
            if ((accessBinding = JDTTreeBuilderQuery.searchTypeBinding(access, units)) != null && listener.onAccess(tokens, i)) {
                TypeBinding superClassBinding = JDTTreeBuilderQuery.searchTypeBinding(accessBinding.superclass(), CharOperation.charToString((char[])tokens[i + 1]));
                if (superClassBinding != null) {
                    return this.getTypeReference(superClassBinding.clone(accessBinding));
                }
                return this.getTypeReference(receiverType);
            }
            return this.getTypeReference(receiverType);
        }
        return null;
    }

    @Nullable CtReference getDeclaringReferenceFromImports(char[] expectedName) {
        CompilationUnitDeclaration cuDeclaration = this.jdtTreeBuilder.getContextBuilder().compilationunitdeclaration;
        if (cuDeclaration == null) {
            return null;
        }
        LookupEnvironment environment = cuDeclaration.scope.environment;
        if (cuDeclaration.imports != null) {
            for (ImportReference anImport : cuDeclaration.imports) {
                if (!CharOperation.equals((char[])anImport.getImportName()[anImport.getImportName().length - 1], (char[])expectedName)) continue;
                if (anImport.isStatic()) {
                    int indexDeclaring = 2;
                    if ((anImport.bits & 0x20000) != 0) {
                        indexDeclaring = 1;
                    }
                    char[][] packageName = CharOperation.subarray((char[][])anImport.getImportName(), (int)0, (int)(anImport.getImportName().length - indexDeclaring));
                    char[][] className = CharOperation.subarray((char[][])anImport.getImportName(), (int)(anImport.getImportName().length - indexDeclaring), (int)(anImport.getImportName().length - (indexDeclaring - 1)));
                    try {
                        PackageBinding aPackage = packageName.length != 0 ? environment.createPackage(packageName) : null;
                        MissingTypeBinding declaringType = environment.createMissingType(aPackage, className);
                        this.jdtTreeBuilder.getContextBuilder().ignoreComputeImports = true;
                        CtTypeReference typeReference = this.getTypeReference((TypeBinding)declaringType);
                        this.jdtTreeBuilder.getContextBuilder().ignoreComputeImports = false;
                        return typeReference;
                    }
                    catch (NullPointerException e) {
                        return null;
                    }
                }
                PackageBinding packageBinding = null;
                char[][] chars = CharOperation.subarray((char[][])anImport.getImportName(), (int)0, (int)(anImport.getImportName().length - 1));
                if (chars.length > 0) {
                    Binding someBinding = cuDeclaration.scope.findImport(chars, false, false);
                    if (someBinding != null && someBinding.isValidBinding() && someBinding instanceof PackageBinding) {
                        packageBinding = (PackageBinding)someBinding;
                    } else {
                        try {
                            packageBinding = environment.createPackage(chars);
                        }
                        catch (NullPointerException e) {
                            packageBinding = null;
                        }
                    }
                }
                if (packageBinding == null || packageBinding instanceof ProblemPackageBinding) {
                    packageBinding = new PackageBinding(chars, null, environment, environment.module){

                        public PlainPackageBinding getIncarnation(ModuleBinding arg0) {
                            return null;
                        }
                    };
                }
                return this.getPackageReference(packageBinding);
            }
        }
        return null;
    }

    <T> CtExecutableReference<T> getExecutableReference(ReferenceExpression referenceExpression) {
        return this.getExecutableReference(referenceExpression.binding, ReferenceBuilder.getExecutableRefSourceStart(referenceExpression.typeArguments, referenceExpression.nameSourceStart), referenceExpression.nameSourceEnd());
    }

    <T> CtExecutableReference<T> getExecutableReference(ExplicitConstructorCall explicitConstructor) {
        CtExecutableReference<T> ref = this.getExecutableReference(explicitConstructor.binding);
        if (ref != null) {
            ref.setImplicit(true);
        }
        return ref;
    }

    private <T> CtExecutableReference<T> getExecutableReference(MethodBinding exec) {
        return this.getExecutableReference(exec, -1, -1);
    }

    <T> CtExecutableReference<T> getExecutableReference(MethodBinding exec, int sourceStart, int sourceEnd) {
        ArrayList parameters;
        if (exec == null) {
            return null;
        }
        CtExecutableReference ref = this.jdtTreeBuilder.getFactory().Core().createExecutableReference();
        if (sourceStart >= 0 && sourceEnd >= 0) {
            ref.setPosition(this.jdtTreeBuilder.getPositionBuilder().buildPosition(sourceStart, sourceEnd));
        }
        if (exec.isConstructor() || exec.original() instanceof SyntheticFactoryMethodBinding) {
            ref.setSimpleName("<init>");
            if (exec.returnType instanceof VoidTypeBinding) {
                ref.setType(this.getTypeReference((TypeBinding)exec.declaringClass, true));
            } else {
                ref.setType(this.getTypeReference(exec.returnType, true));
            }
        } else {
            ref.setSimpleName(new String(exec.selector));
            ref.setType(this.getTypeReference(exec.returnType, true));
        }
        if (exec instanceof ProblemMethodBinding) {
            if (exec.declaringClass != null && Arrays.asList(exec.declaringClass.methods()).contains(exec)) {
                ref.setDeclaringType(this.getTypeReference((TypeBinding)exec.declaringClass));
            } else {
                CtReference declaringType = this.getDeclaringReferenceFromImports(exec.constantPoolName());
                if (declaringType instanceof CtTypeReference) {
                    ref.setDeclaringType((CtTypeReference)declaringType);
                }
            }
            if (exec.isConstructor()) {
                ref.setDeclaringType(this.getTypeReference((TypeBinding)exec.declaringClass));
            }
            ref.setStatic(true);
        } else {
            if (exec.isConstructor() && !(exec.returnType instanceof VoidTypeBinding)) {
                ref.setDeclaringType(this.getTypeReference(exec.returnType));
            } else {
                ref.setDeclaringType(this.getTypeReference((TypeBinding)exec.declaringClass));
            }
            ref.setStatic(exec.isStatic());
        }
        if (exec.declaringClass instanceof ParameterizedTypeBinding) {
            ref.setDeclaringType(this.getTypeReference((TypeBinding)exec.declaringClass.actualType()));
        }
        if (exec.original() != null) {
            if (exec.isPolymorphic()) {
                ref.setType(this.getTypeReference(exec.original().returnType));
            }
            parameters = new ArrayList(exec.original().parameters.length);
            for (TypeBinding b : exec.original().parameters) {
                parameters.add(this.getTypeReference(b, true));
            }
            ref.setParameters(parameters);
        } else if (exec.parameters != null) {
            parameters = new ArrayList();
            for (TypeBinding b : exec.parameters) {
                parameters.add(this.getTypeReference(b, true));
            }
            ref.setParameters(parameters);
        }
        return ref;
    }

    <T> CtExecutableReference<T> getExecutableReference(AllocationExpression allocationExpression) {
        CtExecutableReference<T> ref;
        if (allocationExpression.binding != null) {
            ref = this.getExecutableReference(allocationExpression.binding);
            if (this.isIncorrectlyBoundExecutableInNoClasspath(ref, allocationExpression)) {
                this.adjustExecutableAccordingToResolvedType(ref, allocationExpression);
            }
        } else {
            ref = this.jdtTreeBuilder.getFactory().Core().createExecutableReference();
            ref.setSimpleName("<init>");
            ref.setDeclaringType(this.getTypeReference(null, allocationExpression.type));
            ArrayList parameters = new ArrayList(allocationExpression.argumentTypes.length);
            for (TypeBinding b : allocationExpression.argumentTypes) {
                parameters.add(this.getTypeReference(b, true));
            }
            ref.setParameters(parameters);
        }
        if (allocationExpression.type == null) {
            ref.setType(this.getTypeReference(allocationExpression.expectedType(), true));
        }
        ref.setImplicit(true);
        return ref;
    }

    @NoClasspathWorkaround(reason="https://github.com/INRIA/spoon/issues/4643")
    private boolean isIncorrectlyBoundExecutableInNoClasspath(CtExecutableReference<?> ref, AllocationExpression allocationExpression) {
        boolean noClasspath = ref.getFactory().getEnvironment().getNoClasspath();
        return noClasspath && ref.getType() != null && ref.getType().equals(ref.getFactory().Type().objectType()) && allocationExpression.resolvedType != null;
    }

    @NoClasspathWorkaround(reason="https://github.com/INRIA/spoon/issues/4643")
    private void adjustExecutableAccordingToResolvedType(CtExecutableReference ref, AllocationExpression allocationExpression) {
        CtTypeReference resolvedTypeRef = this.getTypeReference(allocationExpression.resolvedType);
        ref.setType(resolvedTypeRef);
        ref.getExecutableDeclaration().setType(resolvedTypeRef);
        ref.setDeclaringType(resolvedTypeRef);
    }

    private static int getExecutableRefSourceStart(TypeReference[] typeArguments, int start) {
        int sourceStart = start;
        if (typeArguments != null) {
            for (TypeReference typeArgument : typeArguments) {
                sourceStart = Math.min(typeArgument.sourceStart() - 1, sourceStart);
            }
        }
        return sourceStart;
    }

    <T> CtExecutableReference<T> getExecutableReference(MessageSend messageSend) {
        if (messageSend.binding != null) {
            return this.getExecutableReference(messageSend.binding, ReferenceBuilder.getExecutableRefSourceStart(messageSend.typeArguments, messageSend.nameSourceStart()), messageSend.nameSourceEnd());
        }
        CtExecutableReference ref = this.jdtTreeBuilder.getFactory().Core().createExecutableReference();
        ref.setSimpleName(CharOperation.charToString((char[])messageSend.selector));
        ref.setType(this.getTypeReference(messageSend.expectedType(), true));
        ref.setPosition(this.jdtTreeBuilder.getPositionBuilder().buildPosition(ReferenceBuilder.getExecutableRefSourceStart(messageSend.typeArguments, messageSend.nameSourceStart()), messageSend.nameSourceEnd()));
        if (messageSend.receiver.resolvedType == null) {
            ref.setStatic(true);
            if (messageSend.receiver instanceof SingleNameReference) {
                ref.setDeclaringType(this.jdtTreeBuilder.getHelper().createTypeAccessNoClasspath((SingleNameReference)messageSend.receiver).getAccessedType());
            } else if (messageSend.receiver instanceof QualifiedNameReference) {
                ref.setDeclaringType(this.jdtTreeBuilder.getHelper().createTypeAccessNoClasspath((QualifiedNameReference)messageSend.receiver).getAccessedType());
            }
        } else {
            ref.setDeclaringType(this.getTypeReference(messageSend.receiver.resolvedType));
        }
        if (messageSend.arguments != null) {
            ArrayList parameters = new ArrayList();
            for (Expression expression : messageSend.arguments) {
                parameters.add(this.getTypeReference(expression.resolvedType, true));
            }
            ref.setParameters(parameters);
        }
        return ref;
    }

    private CtPackageReference getPackageReference(PackageBinding reference) {
        return this.getPackageReference(new String(reference.shortReadableName()));
    }

    public CtPackageReference getPackageReference(String name) {
        if (name.isEmpty()) {
            return this.jdtTreeBuilder.getFactory().Package().topLevel();
        }
        CtPackageReference ref = this.jdtTreeBuilder.getFactory().Core().createPackageReference();
        ref.setSimpleName(name);
        return ref;
    }

    <T> CtTypeReference<T> getTypeReference(TypeBinding binding, TypeReference ref) {
        CtTypeReference<T> ctRef = this.getTypeReference(binding);
        if (ctRef != null && this.isCorrectTypeReference(ref)) {
            this.insertGenericTypesInNoClasspathFromJDTInSpoon(ref, ctRef);
        } else {
            ctRef = this.getTypeReference(ref);
        }
        if (ref instanceof SingleTypeReference) {
            ctRef.setSimplyQualified(true);
        } else if (ref instanceof QualifiedTypeReference) {
            this.jdtTreeBuilder.getHelper();
            JDTTreeBuilderHelper.handleImplicit((QualifiedTypeReference)ref, ctRef);
        }
        return ctRef;
    }

    CtTypeReference<Object> getTypeParameterReference(TypeBinding binding, TypeReference ref) {
        CtTypeParameterReference ctRef = this.getTypeReference(binding);
        if (ctRef != null && this.isCorrectTypeReference(ref)) {
            if (!(ctRef instanceof CtTypeParameterReference)) {
                CtTypeParameterReference typeParameterRef = this.jdtTreeBuilder.getFactory().Core().createTypeParameterReference();
                typeParameterRef.setSimpleName(ctRef.getSimpleName());
                typeParameterRef.setDeclaringType(ctRef.getDeclaringType());
                typeParameterRef.setPackage(ctRef.getPackage());
                ctRef = typeParameterRef;
            }
            this.insertGenericTypesInNoClasspathFromJDTInSpoon(ref, ctRef);
            return ctRef;
        }
        return this.getTypeParameterReference(CharOperation.toString((char[][])ref.getParameterizedTypeName()));
    }

    private boolean isCorrectTypeReference(TypeReference ref) {
        if (ref.resolvedType == null) {
            return false;
        }
        if (!(ref.resolvedType instanceof ProblemReferenceBinding)) {
            return true;
        }
        String[] compoundName = CharOperation.charArrayToStringArray((char[][])((ProblemReferenceBinding)ref.resolvedType).compoundName);
        String[] typeName = CharOperation.charArrayToStringArray((char[][])ref.getTypeName());
        if (compoundName.length == 0 || typeName.length == 0) {
            return false;
        }
        return compoundName[compoundName.length - 1].equals(typeName[typeName.length - 1]);
    }

    private <T> void insertGenericTypesInNoClasspathFromJDTInSpoon(TypeReference original, CtTypeReference<T> type) {
        if (original.resolvedType instanceof ProblemReferenceBinding && original.getTypeArguments() != null) {
            for (TypeReference[] typeReferences : original.getTypeArguments()) {
                if (typeReferences == null) continue;
                for (TypeReference typeReference : typeReferences) {
                    type.addActualTypeArgument(this.getTypeReference(typeReference.resolvedType));
                }
            }
        }
        if (original.isParameterizedTypeReference() && !type.isParameterized()) {
            this.tryRecoverTypeArguments(type);
        }
    }

    private void tryRecoverTypeArguments(CtTypeReference<?> type) {
        ContextBuilder contextBuilder = this.jdtTreeBuilder.getContextBuilder();
        if (!contextBuilder.hasCurrentContext() || !(contextBuilder.getCurrentNode() instanceof AllocationExpression)) {
            return;
        }
        AllocationExpression alloc = (AllocationExpression)contextBuilder.getCurrentNode();
        if (alloc.expectedType() instanceof ParameterizedTypeBinding) {
            ParameterizedTypeBinding expectedType = (ParameterizedTypeBinding)alloc.expectedType();
            if (expectedType.typeArguments() != null) {
                for (TypeBinding binding : expectedType.typeArguments()) {
                    CtTypeReference typeArgRef = this.getTypeReference(binding);
                    typeArgRef.setImplicit(true);
                    type.addActualTypeArgument(typeArgRef);
                }
            }
            return;
        }
        type.addActualTypeArgument(this.jdtTreeBuilder.getFactory().Type().createReference("<omitted>"));
    }

    <T> CtTypeReference<T> getTypeReference(TypeReference ref) {
        CtTypeReference<T> main;
        int index;
        if (ref == null) {
            return null;
        }
        CtTypeReference<T> res = null;
        CtTypeReference<T> inner = null;
        String[] namesParameterized = CharOperation.charArrayToStringArray((char[][])ref.getParameterizedTypeName());
        String nameParameterized = CharOperation.toString((char[][])ref.getParameterizedTypeName());
        String typeName = CharOperation.toString((char[][])ref.getTypeName());
        for (index = namesParameterized.length - 1; index >= 0 && (main = this.getTypeReference(namesParameterized[index])) != null; --index) {
            if (res == null) {
                res = main;
            } else {
                inner.setDeclaringType(main);
            }
            inner = main;
        }
        if (res == null) {
            return this.jdtTreeBuilder.getFactory().Type().createReference(nameParameterized);
        }
        if (inner.getPackage() == null) {
            PackageFactory packageFactory = this.jdtTreeBuilder.getFactory().Package();
            CtPackageReference packageReference = index >= 0 ? packageFactory.getOrCreate(this.concatSubArray(namesParameterized, index)).getReference() : packageFactory.topLevel();
            inner.setPackage(packageReference);
        }
        if (!res.toStringDebug().replace(", ", ",").endsWith(nameParameterized)) {
            return this.jdtTreeBuilder.getFactory().Type().createReference(typeName);
        }
        return res;
    }

    private String concatSubArray(String[] a, int endIndex) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < endIndex; ++i) {
            sb.append(a[i]).append('.');
        }
        sb.append(a[endIndex]);
        return sb.toString();
    }

    public <T> CtTypeReference<T> getTypeReference(String name) {
        CtTypeReference main = null;
        if (name.matches(".*(<.+>)")) {
            Pattern pattern = Pattern.compile("([^<]+)<(.+)>");
            Matcher m = pattern.matcher(name);
            main = name.startsWith("?") ? this.jdtTreeBuilder.getFactory().Core().createWildcardReference() : this.jdtTreeBuilder.getFactory().Core().createTypeReference();
            if (m.find()) {
                String[] split;
                main.setSimpleName(m.group(1));
                for (String parameter : split = this.getStringTypeParameters(m.group(2)).toArray(new String[0])) {
                    main.addActualTypeArgument(this.getTypeParameterReference(parameter.trim()));
                }
            }
        } else if (Character.isUpperCase(name.charAt(0))) {
            if (name.endsWith("[]")) {
                main = this.jdtTreeBuilder.getFactory().Core().createArrayTypeReference();
                name = name.substring(0, name.length() - 2);
                ((CtArrayTypeReference)main).setComponentType(this.getTypeReference(name));
            } else {
                main = this.jdtTreeBuilder.getFactory().Core().createTypeReference();
            }
            main.setSimpleName(name);
            CtReference declaring = this.getDeclaringReferenceFromImports(name.toCharArray());
            this.setPackageOrDeclaringType(main, declaring);
        } else if (name.startsWith("?")) {
            return this.jdtTreeBuilder.getFactory().Core().createWildcardReference();
        }
        return main;
    }

    private List<String> getStringTypeParameters(String typeParamString) {
        if (!typeParamString.contains("<")) {
            return List.of(typeParamString.split(","));
        }
        ArrayList<String> typeParams = new ArrayList<String>();
        int bracketsEncountered = 0;
        StringBuilder paramAccumulator = new StringBuilder();
        for (int idx = 0; idx < typeParamString.length(); ++idx) {
            char currChar = typeParamString.charAt(idx);
            if (currChar == ',' && bracketsEncountered == 0) {
                typeParams.add(paramAccumulator.toString());
                paramAccumulator.setLength(0);
                continue;
            }
            if (currChar == '<') {
                ++bracketsEncountered;
                paramAccumulator.append('<');
                continue;
            }
            if (currChar == '>') {
                --bracketsEncountered;
                paramAccumulator.append('>');
                continue;
            }
            paramAccumulator.append(currChar);
        }
        typeParams.add(paramAccumulator.toString());
        return typeParams;
    }

    private CtTypeReference<Object> getTypeParameterReference(String name) {
        CtTypeReference<Object> param = null;
        if (name.contains("extends") || name.contains("super")) {
            String[] split = name.contains("extends") ? name.split("extends") : name.split("super");
            param = this.getTypeParameterReference(split[0].trim());
            if (param instanceof CtWildcardReference) {
                param.setBoundingType(this.getTypeReference(split[split.length - 1].trim()));
            }
        } else if (name.matches(".*(<.+>)")) {
            Pattern pattern = Pattern.compile("([^<]+)<(.+)>");
            Matcher m = pattern.matcher(name);
            if (m.find()) {
                String[] split;
                param = this.jdtTreeBuilder.getFactory().Core().createTypeReference();
                param.setSimpleName(m.group(1));
                for (String parameter : split = m.group(2).split(",")) {
                    param.addActualTypeArgument(this.getTypeParameterReference(parameter.trim()));
                }
            }
        } else if (name.contains("?")) {
            param = this.jdtTreeBuilder.getFactory().Core().createWildcardReference();
        } else {
            param = this.jdtTreeBuilder.getFactory().Core().createTypeParameterReference();
            param.setSimpleName(name);
        }
        return param;
    }

    <T> CtTypeReference<T> getTypeReference(TypeBinding binding) {
        return this.getTypeReference(binding, false);
    }

    <T> CtTypeReference<T> getTypeReference(TypeBinding binding, boolean resolveGeneric) {
        CtTypeReference<Object> ref;
        if (binding == null) {
            return null;
        }
        if (binding instanceof RawTypeBinding) {
            ref = this.getTypeReference((TypeBinding)((ParameterizedTypeBinding)binding).genericType());
        } else if (binding instanceof ParameterizedTypeBinding) {
            ref = this.getParameterizedTypeReference((ParameterizedTypeBinding)binding);
        } else if (binding instanceof MissingTypeBinding) {
            ref = this.getTypeReferenceFromMissingTypeBinding((MissingTypeBinding)binding);
        } else if (binding instanceof BinaryTypeBinding) {
            ref = this.getTypeReferenceFromBinaryTypeBinding((BinaryTypeBinding)binding);
        } else if (binding instanceof TypeVariableBinding) {
            ref = this.getTypeReferenceFromTypeVariableBinding((TypeVariableBinding)binding, resolveGeneric);
        } else if (binding instanceof BaseTypeBinding) {
            ref = this.getTypeReferenceFromBaseTypeBinding((BaseTypeBinding)binding);
        } else if (binding instanceof WildcardBinding) {
            ref = this.getTypeReferenceFromWildcardBinding((WildcardBinding)binding);
        } else if (binding instanceof LocalTypeBinding) {
            ref = this.getTypeReferenceFromLocalTypeBinding((LocalTypeBinding)binding);
        } else if (binding instanceof SourceTypeBinding) {
            ref = this.getTypeReferenceFromSourceTypeBinding((SourceTypeBinding)binding);
        } else if (binding instanceof ArrayBinding) {
            ref = this.getTypeReferenceFromArrayBinding((ArrayBinding)binding, resolveGeneric);
        } else if (binding instanceof PolyTypeBinding) {
            ref = this.jdtTreeBuilder.getFactory().Type().objectType();
        } else if (binding instanceof ProblemReferenceBinding) {
            ref = this.getTypeReferenceFromProblemReferenceBinding((ProblemReferenceBinding)binding);
        } else if (binding instanceof IntersectionTypeBinding18) {
            ref = this.getTypeReferenceFromIntersectionTypeBinding((IntersectionTypeBinding18)binding);
        } else if (binding instanceof UnresolvedReferenceBinding) {
            ref = this.getTypeReferenceFromUnresolvedReferenceBinding((UnresolvedReferenceBinding)binding);
        } else {
            throw new RuntimeException("Unknown TypeBinding: " + binding.getClass() + " " + binding);
        }
        this.bindingCache.remove(binding);
        this.exploringParameterizedBindings.remove(binding);
        return ref;
    }

    private @Nullable CtTypeReference<?> getTypeReferenceFromUnresolvedReferenceBinding(UnresolvedReferenceBinding binding) {
        TypeBinding closestMatch = binding.closestMatch();
        if (closestMatch != null) {
            CtTypeReference ref = this.jdtTreeBuilder.getFactory().Core().createTypeReference();
            ref.setSimpleName(new String(binding.sourceName()));
            ref.setPackage(this.getPackageReference(binding.getPackage()));
            return ref;
        }
        return null;
    }

    private static boolean isParameterizedProblemReferenceBinding(TypeBinding binding) {
        String sourceName = String.valueOf(binding.sourceName());
        return binding instanceof ProblemReferenceBinding && ReferenceBuilder.typeRefContainsTypeArgs(sourceName);
    }

    private static boolean typeRefContainsTypeArgs(String typeRef) {
        return !typeRef.startsWith("<") && typeRef.endsWith(">");
    }

    private CtTypeReference<?> getParameterizedTypeReference(ParameterizedTypeBinding binding) {
        CtTypeReference ref;
        if (binding.actualType() instanceof LocalTypeBinding) {
            ref = this.getTypeReference((TypeBinding)binding.actualType());
        } else {
            ref = this.jdtTreeBuilder.getFactory().Core().createTypeReference();
            this.exploringParameterizedBindings.put((TypeBinding)binding, ref);
            if (binding.isAnonymousType()) {
                ref.setSimpleName("");
            } else {
                ref.setSimpleName(String.valueOf(binding.sourceName()));
                if (binding.enclosingType() != null) {
                    ref.setDeclaringType(this.getTypeReference((TypeBinding)binding.enclosingType()));
                } else {
                    ref.setPackage(this.getPackageReference(binding.getPackage()));
                }
            }
        }
        if (binding.actualType() instanceof MissingTypeBinding) {
            ref = this.getTypeReference((TypeBinding)binding.actualType());
        }
        this.getTypeArguments(binding).forEach(ref::addActualTypeArgument);
        return ref;
    }

    private List<CtTypeReference<?>> getTypeArguments(ParameterizedTypeBinding binding) {
        return binding.arguments == null ? Collections.emptyList() : Arrays.stream(binding.arguments).map(this::getTypeReferenceFromTypeArgument).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private CtTypeReference<?> getTypeReferenceFromTypeArgument(TypeBinding typeArgBinding) {
        if (this.bindingCache.containsKey(typeArgBinding)) {
            return this.getCtCircularTypeReference(typeArgBinding);
        }
        if (this.exploringParameterizedBindings.containsKey(typeArgBinding)) {
            CtTypeReference typeRefBeingExplored = this.exploringParameterizedBindings.get(typeArgBinding);
            return typeRefBeingExplored == null ? null : typeRefBeingExplored.clone();
        }
        this.exploringParameterizedBindings.put(typeArgBinding, null);
        CtTypeReference typeRefB = this.getTypeReference(typeArgBinding);
        this.exploringParameterizedBindings.put(typeArgBinding, typeRefB);
        return typeRefB;
    }

    private CtTypeReference<?> getTypeReferenceFromMissingTypeBinding(MissingTypeBinding binding) {
        CtTypeReference ref = this.jdtTreeBuilder.getFactory().Core().createTypeReference();
        ref.setSimpleName(new String(binding.sourceName()));
        ref.setPackage(this.getPackageReference(binding.getPackage()));
        if (!this.jdtTreeBuilder.getContextBuilder().ignoreComputeImports) {
            CtReference declaring = this.getDeclaringReferenceFromImports(binding.sourceName());
            if (declaring instanceof CtPackageReference) {
                ref.setPackage((CtPackageReference)declaring);
            } else if (declaring instanceof CtTypeReference) {
                ref.setDeclaringType((CtTypeReference)declaring);
            }
        }
        return ref;
    }

    private CtTypeReference<?> getTypeReferenceFromBinaryTypeBinding(BinaryTypeBinding binding) {
        CtTypeReference ref = this.jdtTreeBuilder.getFactory().Core().createTypeReference();
        if (binding.enclosingType() != null) {
            ref.setDeclaringType(this.getTypeReference((TypeBinding)binding.enclosingType()));
        } else {
            CtPackageReference packageReference = this.getPackageReference(binding.getPackage());
            ref.setPackage(packageReference);
        }
        ref.setSimpleName(new String(binding.sourceName()));
        return ref;
    }

    private CtTypeReference<?> getTypeReferenceFromTypeVariableBinding(TypeVariableBinding binding, boolean resolveGeneric) {
        if (binding instanceof CaptureBinding && ((CaptureBinding)binding).wildcard != null) {
            return this.getTypeReference((TypeBinding)((CaptureBinding)binding).wildcard, resolveGeneric);
        }
        if (binding instanceof CaptureBinding) {
            CtWildcardReference wildcard = this.jdtTreeBuilder.getFactory().Core().createWildcardReference();
            this.setBoundingTypeOnWildcardIfExists(wildcard, binding, resolveGeneric);
            return wildcard;
        }
        if (resolveGeneric) {
            return this.getTypeReferenceOfBoundingType(binding).clone();
        }
        CtTypeParameterReference ref = this.jdtTreeBuilder.getFactory().Core().createTypeParameterReference();
        String name = new String(binding.sourceName());
        if (binding.declaringElement instanceof SyntheticFactoryMethodBinding) {
            name = name.replace("'", "");
        }
        ref.setSimpleName(name);
        return ref;
    }

    private CtTypeReference<?> getTypeReferenceOfBoundingType(TypeVariableBinding binding) {
        boolean resolveGeneric = true;
        ReferenceBinding superClass = binding.superclass;
        ReferenceBinding[] superInterfaces = binding.superInterfaces();
        if (this.isViableAsBoundingType(superClass)) {
            return this.getTypeReference((TypeBinding)superClass, true);
        }
        if (superInterfaces != null && superInterfaces.length == 1) {
            return this.getTypeReference((TypeBinding)superInterfaces[0], true);
        }
        return this.jdtTreeBuilder.getFactory().Type().getDefaultBoundingType();
    }

    private boolean isViableAsBoundingType(ReferenceBinding binding) {
        return binding != null && !"java.lang.Object".equals(CharOperation.toString((char[][])binding.compoundName)) && !this.isParameterizedBindingCurrentlyBeingExplored(binding);
    }

    private boolean isParameterizedBindingCurrentlyBeingExplored(ReferenceBinding binding) {
        return binding instanceof ParameterizedTypeBinding && this.exploringParameterizedBindings.containsKey(binding);
    }

    private void setBoundingTypeOnWildcardIfExists(CtWildcardReference wildcard, TypeVariableBinding binding, boolean resolveGeneric) {
        this.bindingCache.put((TypeBinding)binding, wildcard);
        if (binding.superclass != null && binding.firstBound == binding.superclass) {
            CtTypeReference boundingType = this.getTypeReference((TypeBinding)binding.superclass, resolveGeneric);
            wildcard.setBoundingType(boundingType);
        } else if (binding.superInterfaces != null && binding.superInterfaces != Binding.NO_SUPERINTERFACES) {
            this.setSuperInterfaceDerivedBoundingTypeOnWildcard(wildcard, binding, resolveGeneric);
        }
    }

    private void setSuperInterfaceDerivedBoundingTypeOnWildcard(CtWildcardReference wildcard, TypeVariableBinding binding, boolean resolveGeneric) {
        ArrayList boundingTypes = new ArrayList();
        if (!wildcard.isDefaultBoundingType()) {
            boundingTypes.add(wildcard.getBoundingType());
        }
        for (ReferenceBinding superInterface : binding.superInterfaces) {
            boundingTypes.add(this.getTypeReference((TypeBinding)superInterface, resolveGeneric));
        }
        wildcard.setBoundingType(this.jdtTreeBuilder.getFactory().Type().createIntersectionTypeReferenceWithBounds(boundingTypes));
    }

    private CtTypeReference<?> getTypeReferenceFromBaseTypeBinding(BaseTypeBinding binding) {
        String name = new String(binding.sourceName());
        CtTypeReference ref = this.jdtTreeBuilder.getFactory().Core().createTypeReference();
        ref.setSimpleName(name);
        return ref;
    }

    private CtTypeReference<?> getTypeReferenceFromWildcardBinding(WildcardBinding binding) {
        CtWildcardReference wref = this.jdtTreeBuilder.getFactory().Core().createWildcardReference();
        if (binding.boundKind == 2) {
            wref.setUpper(false);
        }
        if (binding.bound != null) {
            if (this.bindingCache.containsKey(binding.bound)) {
                wref.setBoundingType(this.getCtCircularTypeReference(binding.bound));
            } else {
                wref.setBoundingType(this.getTypeReference(binding.bound));
            }
        }
        return wref;
    }

    private CtTypeReference<?> getTypeReferenceFromLocalTypeBinding(LocalTypeBinding binding) {
        CtTypeReference ref = this.jdtTreeBuilder.getFactory().Core().createTypeReference();
        if (binding.isAnonymousType()) {
            ref.setSimpleName(JDTTreeBuilderHelper.computeAnonymousName(binding.constantPoolName()));
            ref.setDeclaringType(this.getTypeReference((TypeBinding)binding.enclosingType()));
        } else {
            ref.setSimpleName(new String(binding.sourceName()));
            if (binding.enclosingMethod == null && binding.enclosingType() != null && binding.enclosingType() instanceof LocalTypeBinding) {
                ref.setDeclaringType(this.getTypeReference((TypeBinding)binding.enclosingType()));
            } else if (binding.enclosingMethod() != null) {
                ref.setSimpleName(JDTTreeBuilderHelper.computeAnonymousName(binding.constantPoolName()));
                ref.setDeclaringType(this.getTypeReference((TypeBinding)binding.enclosingType()));
            }
        }
        return ref;
    }

    private CtTypeReference<?> getTypeReferenceFromSourceTypeBinding(SourceTypeBinding binding) {
        CtTypeReference ref = this.jdtTreeBuilder.getFactory().Core().createTypeReference();
        if (binding.isAnonymousType()) {
            ref.setSimpleName(JDTTreeBuilderHelper.computeAnonymousName(binding.constantPoolName()));
            ref.setDeclaringType(this.getTypeReference((TypeBinding)binding.enclosingType()));
        } else {
            ref.setSimpleName(new String(binding.sourceName()));
            if (binding.enclosingType() != null) {
                ref.setDeclaringType(this.getTypeReference((TypeBinding)binding.enclosingType()));
            } else {
                ref.setPackage(this.getPackageReference(binding.getPackage()));
            }
        }
        return ref;
    }

    private CtTypeReference<?> getTypeReferenceFromArrayBinding(ArrayBinding binding, boolean resolveGeneric) {
        CtArrayTypeReference ref;
        CtArrayTypeReference outermostRef = ref = this.jdtTreeBuilder.getFactory().Core().createArrayTypeReference();
        for (int i = 1; i < binding.dimensions(); ++i) {
            CtArrayTypeReference tmp = this.jdtTreeBuilder.getFactory().Core().createArrayTypeReference();
            ref.setComponentType(tmp);
            ref = tmp;
        }
        ref.setComponentType(this.getTypeReference(binding.leafComponentType(), resolveGeneric));
        return outermostRef;
    }

    private CtTypeReference<?> getTypeReferenceFromProblemReferenceBinding(ProblemReferenceBinding binding) {
        String readableName = String.valueOf(binding.readableName());
        if (ReferenceBuilder.isParameterizedProblemReferenceBinding((TypeBinding)binding)) {
            readableName = readableName.substring(0, readableName.indexOf(60));
            this.jdtTreeBuilder.getFactory().getEnvironment().report(null, Level.WARN, "Ignoring type parameters for problem binding: " + binding);
        }
        CtTypeReference ref = this.jdtTreeBuilder.getFactory().Core().createTypeReference();
        ref.setSimpleName(ReferenceBuilder.stripPackageName(readableName));
        CtReference declaring = this.getDeclaringReferenceFromImports(binding.sourceName());
        Optional<String> packageName = ReferenceBuilder.getPackageName(readableName);
        if (declaring == null && packageName.isPresent()) {
            declaring = this.jdtTreeBuilder.getFactory().Package().createReference(packageName.get());
        }
        this.setPackageOrDeclaringType(ref, declaring);
        return ref;
    }

    private static String stripPackageName(String fullyQualifiedName) {
        int idx;
        int s = 0;
        while (Character.isLowerCase(fullyQualifiedName.charAt(s)) && (idx = fullyQualifiedName.indexOf(46, s)) >= 0) {
            s = idx + 1;
        }
        return fullyQualifiedName.substring(s);
    }

    private static Optional<String> getPackageName(String fullyQualifiedName) {
        if (!fullyQualifiedName.contains(".")) {
            return Optional.empty();
        }
        String className = ReferenceBuilder.stripPackageName(fullyQualifiedName);
        if (fullyQualifiedName.equals(className)) {
            return Optional.empty();
        }
        return Optional.of(fullyQualifiedName.substring(0, fullyQualifiedName.length() - className.length()));
    }

    private CtTypeReference<?> getTypeReferenceFromIntersectionTypeBinding(IntersectionTypeBinding18 binding) {
        ArrayList boundingTypes = new ArrayList();
        for (ReferenceBinding superInterface : binding.getIntersectingTypes()) {
            boundingTypes.add(this.getTypeReference((TypeBinding)superInterface));
        }
        return this.jdtTreeBuilder.getFactory().Type().createIntersectionTypeReferenceWithBounds(boundingTypes);
    }

    private CtTypeReference<?> getCtCircularTypeReference(TypeBinding b) {
        return this.bindingCache.get(b).clone();
    }

    <T> CtFieldReference<T> getVariableReference(@Nullable TypeBinding type, FieldBinding varbin) {
        CtFieldReference ref = this.jdtTreeBuilder.getFactory().Core().createFieldReference();
        if (varbin == null) {
            return ref;
        }
        ref.setSimpleName(new String(varbin.name));
        ref.setType(this.getTypeReference(varbin.type));
        if (type != null && type.isArrayType()) {
            ref.setDeclaringType(this.getTypeReference(type));
        } else {
            ref.setDeclaringType(this.getTypeReference((TypeBinding)varbin.declaringClass));
        }
        ref.setFinal(varbin.isFinal());
        ref.setStatic((varbin.modifiers & 8) != 0);
        return ref;
    }

    <T> CtFieldReference<T> getVariableReference(@Nullable TypeBinding type, FieldBinding fieldBinding, char[] tokens) {
        CtFieldReference<T> ref = this.getVariableReference(type, fieldBinding);
        if (fieldBinding != null) {
            return ref;
        }
        ref.setSimpleName(CharOperation.charToString((char[])tokens));
        return ref;
    }

    <T> CtVariableReference<T> getVariableReference(VariableBinding varbin) {
        if (varbin instanceof FieldBinding) {
            return this.getVariableReference((TypeBinding)((FieldBinding)varbin).declaringClass, (FieldBinding)varbin);
        }
        if (varbin instanceof LocalVariableBinding) {
            LocalVariableBinding localVariableBinding = (LocalVariableBinding)varbin;
            if (localVariableBinding.declaration instanceof Argument && localVariableBinding.declaringScope instanceof MethodScope) {
                CtParameterReference ref = this.jdtTreeBuilder.getFactory().Core().createParameterReference();
                ref.setSimpleName(new String(varbin.name));
                ref.setType(this.getTypeReference(varbin.type));
                return ref;
            }
            if (localVariableBinding.declaration.binding instanceof CatchParameterBinding) {
                CtCatchVariableReference ref = this.jdtTreeBuilder.getFactory().Core().createCatchVariableReference();
                ref.setSimpleName(new String(varbin.name));
                CtTypeReference<T> ref2 = this.getTypeReference(varbin.type);
                ref.setType(ref2);
                return ref;
            }
            CtLocalVariableReference ref = this.jdtTreeBuilder.getFactory().Core().createLocalVariableReference();
            ref.setSimpleName(new String(varbin.name));
            CtTypeReference<T> ref2 = this.getTypeReference(varbin.type);
            ref.setType(ref2);
            return ref;
        }
        return null;
    }

    <T> CtVariableReference<T> getVariableReference(ProblemBinding binding) {
        CtFieldReference ref = this.jdtTreeBuilder.getFactory().Core().createFieldReference();
        if (binding == null) {
            return ref;
        }
        ref.setSimpleName(new String(binding.name));
        ref.setType(this.getTypeReference((TypeBinding)binding.searchType));
        return ref;
    }

    void setPackageOrDeclaringType(CtTypeReference<?> ref, CtReference declaring) {
        block10: {
            if (declaring instanceof CtPackageReference) {
                ref.setPackage((CtPackageReference)declaring);
            } else if (declaring instanceof CtTypeReference) {
                ref.setDeclaringType((CtTypeReference)declaring);
            } else if (declaring == null) {
                try {
                    Class.forName("java.lang." + ref.getSimpleName());
                    CtPackageReference javaLangPackageReference = this.jdtTreeBuilder.getFactory().Core().createPackageReference();
                    javaLangPackageReference.setSimpleName("java.lang");
                    ref.setPackage(javaLangPackageReference);
                }
                catch (ClassNotFoundException | NoClassDefFoundError e) {
                    assert (this.jdtTreeBuilder.getFactory().getEnvironment().getNoClasspath());
                    ContextBuilder ctx = this.jdtTreeBuilder.getContextBuilder();
                    if (ReferenceBuilder.containsStarImport(ctx.compilationunitdeclaration.imports)) {
                        CtPackageReference pkgRef = this.jdtTreeBuilder.getFactory().Core().createPackageReference();
                        pkgRef.setImplicit(true);
                        ref.setPackage(pkgRef);
                        break block10;
                    }
                    ref.setPackage(ctx.compilationUnitSpoon.getDeclaredPackage().getReference());
                }
            } else {
                throw new AssertionError((Object)("unexpected declaring type: " + declaring.getClass() + " of " + declaring));
            }
        }
    }

    void setImplicitPackageOrDeclaringType(CtTypeReference<?> ref, CtReference declaring) {
        CtTypeReference<?> oldDeclaring = ref.getDeclaringType();
        CtPackageReference oldPackage = ref.getPackage();
        this.setPackageOrDeclaringType(ref, declaring);
        CtTypeReference<?> currentDeclaring = ref.getDeclaringType();
        CtPackageReference currentPackage = ref.getPackage();
        if (currentDeclaring != oldDeclaring) {
            currentDeclaring.setImplicit(true);
        }
        if (currentPackage != oldPackage) {
            currentPackage.setImplicit(true);
        }
    }

    private static boolean containsStarImport(ImportReference[] imports) {
        return imports != null && Arrays.stream(imports).anyMatch(imp -> imp.toString().endsWith("*"));
    }

    public CtExecutableReference<?> getLambdaExecutableReference(SingleNameReference singleNameReference) {
        ASTPair potentialLambda = null;
        for (ASTPair astPair : this.jdtTreeBuilder.getContextBuilder().getAllContexts()) {
            if (!(astPair.node() instanceof LambdaExpression)) continue;
            potentialLambda = astPair;
            break;
        }
        if (potentialLambda == null) {
            return null;
        }
        LambdaExpression lambdaJDT = (LambdaExpression)potentialLambda.node();
        for (Argument argument : lambdaJDT.arguments()) {
            if (!CharOperation.equals((char[])argument.name, (char[])singleNameReference.token)) continue;
            CtTypeReference declaringType = null;
            if (lambdaJDT.enclosingScope instanceof MethodScope) {
                declaringType = this.jdtTreeBuilder.getReferencesBuilder().getTypeReference((TypeBinding)((MethodScope)lambdaJDT.enclosingScope).parent.enclosingSourceType());
            }
            CtLambda ctLambda = (CtLambda)potentialLambda.element();
            ArrayList parametersType = new ArrayList();
            List<CtParameter<?>> parameters = ctLambda.getParameters();
            for (CtParameter<?> parameter : parameters) {
                parametersType.add(this.getMethodParameterType(parameter));
            }
            return this.jdtTreeBuilder.getFactory().Executable().createReference(declaringType, ctLambda.getType(), ctLambda.getSimpleName(), parametersType);
        }
        return null;
    }

    private CtTypeReference<?> getMethodParameterType(CtParameter<?> param) {
        CtTypeReference<Object> paramType = param.getType();
        if (paramType instanceof CtTypeParameterReference) {
            paramType = ((CtTypeParameterReference)paramType).getBoundingType();
        }
        if (paramType == null) {
            return param.getFactory().Type().objectType();
        }
        return paramType.clone();
    }

    public CtModuleReference getModuleReference(ModuleReference moduleReference) {
        String moduleName = new String(moduleReference.moduleName);
        CtModule module = this.jdtTreeBuilder.getFactory().Module().getModule(moduleName);
        if (module == null) {
            CtModuleReference ctModuleReference = this.jdtTreeBuilder.getFactory().Core().createModuleReference();
            ctModuleReference.setSimpleName(moduleName);
            return ctModuleReference;
        }
        return module.getReference();
    }
}

