/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.compiler.jdt;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.AnnotationMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.AssertStatement;
import org.eclipse.jdt.internal.compiler.ast.CaseStatement;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Initializer;
import org.eclipse.jdt.internal.compiler.ast.Javadoc;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.SuperReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.Wildcard;
import spoon.SpoonException;
import spoon.reflect.code.CtCase;
import spoon.reflect.code.CtCatch;
import spoon.reflect.code.CtCatchVariable;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtForEach;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtStatementList;
import spoon.reflect.code.CtTry;
import spoon.reflect.cu.CompilationUnit;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.cu.position.DeclarationSourcePosition;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtModifiable;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.factory.CoreFactory;
import spoon.reflect.reference.CtTypeReference;
import spoon.support.compiler.jdt.ASTPair;
import spoon.support.compiler.jdt.ContextBuilder;
import spoon.support.compiler.jdt.JDTTreeBuilder;
import spoon.support.compiler.jdt.JDTTreeBuilderQuery;
import spoon.support.compiler.jdt.ModifierTarget;
import spoon.support.reflect.CtExtendedModifier;

public class PositionBuilder {
    private final JDTTreeBuilder jdtTreeBuilder;
    private static final String CATCH = "catch";

    public PositionBuilder(JDTTreeBuilder jdtTreeBuilder) {
        this.jdtTreeBuilder = jdtTreeBuilder;
    }

    SourcePosition buildPosition(int sourceStart, int sourceEnd) {
        CompilationUnit cu = this.jdtTreeBuilder.getContextBuilder().compilationUnitSpoon;
        int[] lineSeparatorPositions = this.jdtTreeBuilder.getContextBuilder().getCompilationUnitLineSeparatorPositions();
        return this.jdtTreeBuilder.getFactory().Core().createSourcePosition(cu, sourceStart, sourceEnd, lineSeparatorPositions);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    SourcePosition buildPositionCtElement(CtElement e, ASTNode node) {
        if (e instanceof CtCatch) {
            return SourcePosition.NOPOSITION;
        }
        CoreFactory cf = this.jdtTreeBuilder.getFactory().Core();
        CompilationUnit cu = this.jdtTreeBuilder.getContextBuilder().compilationUnitSpoon;
        int[] lineSeparatorPositions = this.jdtTreeBuilder.getContextBuilder().getCompilationUnitLineSeparatorPositions();
        char[] contents = this.jdtTreeBuilder.getContextBuilder().getCompilationUnitContents();
        int sourceStart = node.sourceStart;
        int sourceEnd = node.sourceEnd;
        if (node instanceof Annotation) {
            Annotation ann = (Annotation)node;
            int declEnd = ann.declarationSourceEnd;
            if (declEnd > 0) {
                sourceEnd = declEnd;
            }
        } else if (node instanceof Expression) {
            Expression expression = (Expression)node;
            int statementEnd = expression.statementEnd;
            if (statementEnd > 0) {
                sourceEnd = statementEnd;
            }
            if (this.jdtTreeBuilder.getContextBuilder().isBuildTypeCast && e instanceof CtTypeReference) {
                int declarationSourceStart = sourceStart;
                int declarationSourceEnd = sourceEnd;
                declarationSourceStart = PositionBuilder.findPrevNonWhitespace(contents, this.getParentsSourceStart(), declarationSourceStart - 1);
                if (contents[declarationSourceStart] != '(') {
                    return this.handlePositionProblem("Unexpected character '" + contents[declarationSourceStart] + "' at start of cast expression on offset: " + declarationSourceStart);
                }
                if (contents[declarationSourceEnd = PositionBuilder.findNextNonWhitespace(contents, contents.length - 1, declarationSourceEnd + 1)] == ')') return cf.createCompoundSourcePosition(cu, sourceStart, sourceEnd, declarationSourceStart, declarationSourceEnd, lineSeparatorPositions);
                return this.handlePositionProblem("Unexpected character '" + contents[declarationSourceStart] + "' at end of cast expression on offset: " + declarationSourceEnd);
            }
            List<ContextBuilder.CastInfo> casts = this.jdtTreeBuilder.getContextBuilder().casts;
            if (!casts.isEmpty() && e instanceof CtExpression) {
                int nrOfBrackets;
                int declarationSourceStart = sourceStart;
                int declarationSourceEnd = sourceEnd;
                SourcePosition pos = casts.get((int)0).typeRef.getPosition();
                if (!pos.isValidPosition()) return cf.createCompoundSourcePosition(cu, sourceStart, sourceEnd, declarationSourceStart, declarationSourceEnd, lineSeparatorPositions);
                declarationSourceStart = pos.getSourceStart();
                for (nrOfBrackets = this.getNrOfFirstCastExpressionBrackets(); nrOfBrackets > 0; --nrOfBrackets) {
                    declarationSourceStart = PositionBuilder.findPrevNonWhitespace(contents, this.getParentsSourceStart(), declarationSourceStart - 1);
                    if (declarationSourceStart < 0) {
                        return this.handlePositionProblem("Cannot found beginning of cast expression until offset: " + this.getParentsSourceStart());
                    }
                    if (contents[declarationSourceStart] == '(') continue;
                    return this.handlePositionProblem("Unexpected character '" + contents[declarationSourceStart] + "' at start of expression on offset: " + declarationSourceStart);
                }
                nrOfBrackets = this.getNrOfCastExpressionBrackets();
                while (nrOfBrackets > 0) {
                    if (contents[declarationSourceEnd = PositionBuilder.findNextNonWhitespace(contents, contents.length - 1, declarationSourceEnd + 1)] != ')') {
                        return this.handlePositionProblem("Unexpected character '" + contents[declarationSourceStart] + "' at end of expression on offset: " + declarationSourceEnd);
                    }
                    --nrOfBrackets;
                }
                return cf.createCompoundSourcePosition(cu, sourceStart, sourceEnd, declarationSourceStart, declarationSourceEnd, lineSeparatorPositions);
            }
        }
        if (node instanceof TypeParameter) {
            TypeParameter typeParameter = (TypeParameter)node;
            sourceStart = typeParameter.declarationSourceStart;
            sourceEnd = typeParameter.declarationSourceEnd;
            if (typeParameter.type != null) {
                sourceEnd = this.getSourceEndOfTypeReference(contents, typeParameter.type, sourceEnd);
            }
        } else {
            if (node instanceof AbstractVariableDeclaration) {
                int modifiersSourceEnd;
                ArrayTypeReference arrTypeRef;
                int dimensions;
                CtElement parent;
                AbstractVariableDeclaration variableDeclaration = (AbstractVariableDeclaration)node;
                int modifiersSourceStart = variableDeclaration.modifiersSourceStart;
                int declarationSourceStart = variableDeclaration.declarationSourceStart;
                int declarationSourceEnd = variableDeclaration.declarationSourceEnd;
                if (declarationSourceStart == 0 && declarationSourceEnd == 0) {
                    return SourcePosition.NOPOSITION;
                }
                if (e instanceof CtCatchVariable) {
                    int lastBracket;
                    CtTry tryStatement = this.jdtTreeBuilder.getContextBuilder().getParentElementOfType(CtTry.class);
                    int endOfTry = tryStatement.getPosition().getSourceEnd();
                    int catchStart = PositionBuilder.findNextNonWhitespace(contents, endOfTry, (lastBracket = this.getEndOfLastTryBlock(tryStatement, 0)) + 1);
                    if (!CATCH.equals(new String(contents, catchStart, CATCH.length()))) {
                        return this.handlePositionProblem("Unexpected beginning of catch statement on offset: " + catchStart);
                    }
                    int bracketStart = PositionBuilder.findNextNonWhitespace(contents, endOfTry, catchStart + CATCH.length());
                    if (bracketStart < 0) {
                        return this.handlePositionProblem("Unexpected end of file instead of '(' after catch statement on offset: " + catchStart);
                    }
                    if (contents[bracketStart] != '(') {
                        return this.handlePositionProblem("Unexpected character " + contents[bracketStart] + " instead of '(' after catch statement on offset: " + bracketStart);
                    }
                    declarationSourceStart = bracketStart + 1;
                }
                if ((parent = this.jdtTreeBuilder.getContextBuilder().getContextElementOnLevel(1)) instanceof CtForEach) {
                    CtForEach forEach = (CtForEach)parent;
                    int parentStart = parent.getPosition().getSourceStart();
                    if (contents[parentStart] != 'f') return this.handlePositionProblem("Expected keyword for at offset: " + parentStart);
                    if (contents[parentStart + 1] != 'o') return this.handlePositionProblem("Expected keyword for at offset: " + parentStart);
                    if (contents[parentStart + 2] != 'r') {
                        return this.handlePositionProblem("Expected keyword for at offset: " + parentStart);
                    }
                    int bracketOff = PositionBuilder.findNextNonWhitespace(contents, forEach.getPosition().getSourceEnd(), parentStart + 3);
                    if (bracketOff < 0) return this.handlePositionProblem("Expected character after 'for' instead of '(' at offset: " + (parentStart + 3));
                    if (contents[bracketOff] != '(') {
                        return this.handlePositionProblem("Expected character after 'for' instead of '(' at offset: " + (parentStart + 3));
                    }
                    declarationSourceStart = bracketOff + 1;
                    declarationSourceEnd = sourceEnd;
                }
                if (variableDeclaration instanceof Argument && variableDeclaration.type instanceof ArrayTypeReference && (dimensions = (arrTypeRef = (ArrayTypeReference)variableDeclaration.type).dimensions()) > 0) {
                    for (int foundDimensions = this.getNrOfDimensions(contents, declarationSourceStart, declarationSourceEnd); dimensions > foundDimensions; ++foundDimensions) {
                        if ((declarationSourceEnd = PositionBuilder.findNextChar(contents, contents.length, declarationSourceEnd + 1, ']')) >= 0) continue;
                        return this.handlePositionProblem("Unexpected array type declaration on offset: " + declarationSourceStart);
                    }
                }
                if (variableDeclaration instanceof Argument && variableDeclaration.type == null) {
                    declarationSourceStart = PositionBuilder.findPrevNonWhitespace(contents, 0, declarationSourceStart);
                    declarationSourceEnd = PositionBuilder.findNextNonWhitespace(contents, contents.length - 1, declarationSourceEnd);
                }
                if (modifiersSourceStart <= 0) {
                    modifiersSourceStart = PositionBuilder.findNextNonWhitespace(contents, contents.length - 1, declarationSourceStart);
                }
                if (modifiersSourceStart > (modifiersSourceEnd = variableDeclaration.type != null ? PositionBuilder.findPrevNonWhitespace(contents, declarationSourceStart, variableDeclaration.type.sourceStart() - 1) : (variableDeclaration instanceof Initializer ? ((Initializer)variableDeclaration).block.sourceStart - 1 : declarationSourceStart - 1))) {
                    modifiersSourceEnd = modifiersSourceStart - 1;
                } else if (e instanceof CtModifiable) {
                    this.setModifiersPosition((CtModifiable)e, modifiersSourceStart, modifiersSourceEnd);
                }
                if (variableDeclaration instanceof FieldDeclaration && !(variableDeclaration instanceof Initializer)) {
                    declarationSourceEnd = variableDeclaration.declarationEnd;
                }
                DeclarationSourcePosition declarationSourcePosition = cf.createDeclarationSourcePosition(cu, sourceStart, sourceEnd, modifiersSourceStart, modifiersSourceEnd, declarationSourceStart, declarationSourceEnd, lineSeparatorPositions);
                if (!(variableDeclaration instanceof FieldDeclaration)) return declarationSourcePosition;
                return declarationSourcePosition.addDefaultValueEnd(((FieldDeclaration)variableDeclaration).endPart2Position);
            }
            if (node instanceof TypeDeclaration && e instanceof CtPackage) {
                return cf.createSourcePosition(cu, 0, contents.length - 1, lineSeparatorPositions);
            }
            if (node instanceof TypeDeclaration) {
                int modifiersSourceEnd;
                TypeDeclaration typeDeclaration = (TypeDeclaration)node;
                int declarationSourceStart = typeDeclaration.declarationSourceStart;
                int declarationSourceEnd = typeDeclaration.declarationSourceEnd;
                int modifiersSourceStart = typeDeclaration.modifiersSourceStart;
                int bodyStart = typeDeclaration.bodyStart;
                int bodyEnd = typeDeclaration.bodyEnd;
                if (typeDeclaration.name.length == 0) {
                    if (contents[bodyStart] != '{') {
                        if (bodyStart < 1) throw new SpoonException("Cannot found body start at offset " + bodyStart + " of annonymous class with sources:\n" + new String(contents));
                        if (contents[bodyStart - 1] != '{') {
                            throw new SpoonException("Cannot found body start at offset " + bodyStart + " of annonymous class with sources:\n" + new String(contents));
                        }
                        --bodyStart;
                    }
                    modifiersSourceStart = sourceStart = bodyStart;
                    declarationSourceStart = sourceStart;
                    if (contents[bodyEnd] != '}') {
                        if (contents[bodyEnd + 1] != '}') {
                            throw new SpoonException("Cannot found body end at offset " + bodyEnd + " of annonymous class with sources:\n" + new String(contents));
                        }
                        ++bodyEnd;
                    }
                    declarationSourceEnd = bodyEnd;
                    sourceEnd = sourceStart - 1;
                    modifiersSourceEnd = modifiersSourceStart - 1;
                    ++bodyStart;
                    return cf.createBodyHolderSourcePosition(cu, sourceStart, sourceEnd, modifiersSourceStart, modifiersSourceEnd, declarationSourceStart, declarationSourceEnd, bodyStart - 1, bodyEnd, lineSeparatorPositions);
                } else {
                    if (modifiersSourceStart <= 0) {
                        modifiersSourceStart = declarationSourceStart;
                    }
                    modifiersSourceEnd = PositionBuilder.findPrevNonWhitespace(contents, modifiersSourceStart - 1, PositionBuilder.findPrevWhitespace(contents, modifiersSourceStart - 1, PositionBuilder.findPrevNonWhitespace(contents, modifiersSourceStart - 1, sourceStart - 1)));
                    if (e instanceof CtModifiable) {
                        this.setModifiersPosition((CtModifiable)e, modifiersSourceStart, modifiersSourceEnd);
                    }
                    if (modifiersSourceEnd >= modifiersSourceStart) return cf.createBodyHolderSourcePosition(cu, sourceStart, sourceEnd, modifiersSourceStart, modifiersSourceEnd, declarationSourceStart, declarationSourceEnd, bodyStart - 1, bodyEnd, lineSeparatorPositions);
                    modifiersSourceEnd = modifiersSourceStart - 1;
                }
                return cf.createBodyHolderSourcePosition(cu, sourceStart, sourceEnd, modifiersSourceStart, modifiersSourceEnd, declarationSourceStart, declarationSourceEnd, bodyStart - 1, bodyEnd, lineSeparatorPositions);
            }
            if (node instanceof AbstractMethodDeclaration) {
                TypeParameter[] typeParameters;
                Javadoc javadoc;
                AbstractMethodDeclaration methodDeclaration = (AbstractMethodDeclaration)node;
                int bodyStart = methodDeclaration.bodyStart;
                int bodyEnd = methodDeclaration.bodyEnd;
                int declarationSourceStart = methodDeclaration.declarationSourceStart;
                int declarationSourceEnd = methodDeclaration.declarationSourceEnd;
                int modifiersSourceStart = methodDeclaration.modifiersSourceStart;
                if (modifiersSourceStart <= 0) {
                    modifiersSourceStart = declarationSourceStart;
                }
                if (node instanceof AnnotationMethodDeclaration && bodyStart == bodyEnd) {
                    --bodyEnd;
                }
                if ((javadoc = methodDeclaration.javadoc) != null && javadoc.sourceEnd() > declarationSourceStart) {
                    modifiersSourceStart = javadoc.sourceEnd() + 1;
                }
                int modifiersSourceEnd = sourceStart - 1;
                if (e instanceof CtModifiable) {
                    this.setModifiersPosition((CtModifiable)e, modifiersSourceStart, declarationSourceEnd);
                }
                if (methodDeclaration instanceof MethodDeclaration && ((MethodDeclaration)methodDeclaration).returnType != null) {
                    modifiersSourceEnd = ((MethodDeclaration)methodDeclaration).returnType.sourceStart() - 2;
                }
                if ((typeParameters = methodDeclaration.typeParameters()) != null && typeParameters.length > 0) {
                    modifiersSourceEnd = contents[typeParameters[0].declarationSourceStart - 2] != ' ' ? typeParameters[0].declarationSourceStart - 2 : typeParameters[0].declarationSourceStart - 3;
                }
                if (JDTTreeBuilderQuery.getModifiers(methodDeclaration.modifiers, false, ModifierTarget.METHOD).isEmpty()) {
                    modifiersSourceEnd = modifiersSourceStart - 1;
                }
                sourceEnd = sourceStart + methodDeclaration.selector.length - 1;
                if (bodyStart == 0) {
                    return cf.createPartialSourcePosition(cu);
                }
                if (e instanceof CtStatementList) {
                    return cf.createSourcePosition(cu, bodyStart - 1, bodyEnd + 1, lineSeparatorPositions);
                }
                if (contents[bodyStart - 1] != '{') return cf.createBodyHolderSourcePosition(cu, sourceStart, sourceEnd, modifiersSourceStart, modifiersSourceEnd, declarationSourceStart, declarationSourceEnd, bodyStart, bodyEnd, lineSeparatorPositions);
                --bodyStart;
                if (contents[bodyEnd + 1] == '}') {
                    ++bodyEnd;
                    return cf.createBodyHolderSourcePosition(cu, sourceStart, sourceEnd, modifiersSourceStart, modifiersSourceEnd, declarationSourceStart, declarationSourceEnd, bodyStart, bodyEnd, lineSeparatorPositions);
                } else {
                    if (bodyStart >= bodyEnd) return cf.createBodyHolderSourcePosition(cu, sourceStart, sourceEnd, modifiersSourceStart, modifiersSourceEnd, declarationSourceStart, declarationSourceEnd, bodyStart, bodyEnd, lineSeparatorPositions);
                    return this.handlePositionProblem("Missing body end in\n" + new String(contents, sourceStart, sourceEnd - sourceStart));
                }
            }
            if (e instanceof CtCatchVariable) {
                ASTPair pair = this.jdtTreeBuilder.getContextBuilder().getParentContextOfType(CtCatch.class);
                if (pair != null) return this.buildPositionCtElement(e, (ASTNode)((Argument)pair.node()));
                return this.handlePositionProblem("There is no CtCatch parent for CtCatchVariable");
            }
            if (node instanceof TypeReference) {
                sourceEnd = this.getSourceEndOfTypeReference(contents, (TypeReference)node, sourceEnd);
            } else if (node instanceof AllocationExpression) {
                AllocationExpression allocationExpression = (AllocationExpression)node;
                if (allocationExpression.enumConstant != null) {
                    FieldDeclaration fieldDeclaration = allocationExpression.enumConstant;
                    Annotation[] annotations = allocationExpression.enumConstant.annotations;
                    if (annotations != null && annotations.length > 0) {
                        Annotation lastAnnotation = annotations[annotations.length - 1];
                        sourceStart = PositionBuilder.findNextNonWhitespace(contents, sourceEnd, lastAnnotation.sourceEnd);
                    }
                    sourceStart = PositionBuilder.findNextNonWhitespace(contents, sourceEnd, sourceStart);
                    sourceStart += fieldDeclaration.name.length;
                }
            } else if (node instanceof CaseStatement) {
                if ((sourceEnd = PositionBuilder.findNextNonWhitespace(contents, contents.length - 1, sourceEnd + 1)) < 0) {
                    return this.handlePositionProblem("Unexpected end of file in CtCase on: " + sourceStart);
                }
                if (contents[sourceEnd] != ':') {
                    if (contents[sourceEnd] != '-') return this.handlePositionProblem("Unexpected character " + contents[sourceEnd] + " instead of ':' or '->' in CtCase on: " + sourceEnd);
                    if (contents.length <= sourceEnd + 1) return this.handlePositionProblem("Unexpected character " + contents[sourceEnd] + " instead of ':' or '->' in CtCase on: " + sourceEnd);
                    if (contents[sourceEnd + 1] != '>') return this.handlePositionProblem("Unexpected character " + contents[sourceEnd] + " instead of ':' or '->' in CtCase on: " + sourceEnd);
                    ++sourceEnd;
                }
            } else if (node instanceof AssertStatement) {
                AssertStatement assert_ = (AssertStatement)node;
                sourceEnd = PositionBuilder.findNextChar(contents, contents.length, sourceEnd, ';');
            } else if (node instanceof SuperReference) {
                sourceEnd = sourceStart + "super".length() - 1;
            }
        }
        if (e instanceof CtModifiable) {
            this.setModifiersPosition((CtModifiable)e, sourceStart, sourceEnd);
        }
        if (sourceStart != 0) return cf.createSourcePosition(cu, sourceStart, sourceEnd, lineSeparatorPositions);
        if (sourceEnd != 0) return cf.createSourcePosition(cu, sourceStart, sourceEnd, lineSeparatorPositions);
        return SourcePosition.NOPOSITION;
    }

    private int getParentsSourceStart() {
        Iterator<ASTPair> iter = this.jdtTreeBuilder.getContextBuilder().getAllContexts().iterator();
        if (iter.hasNext()) {
            ASTPair pair;
            SourcePosition pos;
            iter.next();
            if (iter.hasNext() && (pos = (pair = iter.next()).element().getPosition()).isValidPosition()) {
                return pos.getSourceStart();
            }
        }
        return 0;
    }

    private int getNrOfDimensions(char[] contents, int start, int end) {
        int nrDims = 0;
        while ((start = PositionBuilder.findNextNonWhitespace(contents, end, start)) >= 0) {
            if (contents[start] == ']') {
                ++nrDims;
            }
            if (contents[start] == '.' && start + 2 <= end && contents[start + 1] == '.' && contents[start + 2] == '.') {
                start += 2;
                ++nrDims;
            }
            ++start;
        }
        return nrDims;
    }

    SourcePosition buildPosition(CtCatch catcher) {
        int[] lineSeparatorPositions = this.jdtTreeBuilder.getContextBuilder().getCompilationUnitLineSeparatorPositions();
        CtTry tryElement = catcher.getParent(CtTry.class);
        int declarationStart = this.getEndOfLastTryBlock(tryElement, 1) + 1;
        DeclarationSourcePosition paramPos = (DeclarationSourcePosition)catcher.getParameter().getPosition();
        int bodyStart = catcher.getBody().getPosition().getSourceStart();
        int bodyEnd = catcher.getBody().getPosition().getSourceEnd();
        return catcher.getFactory().Core().createBodyHolderSourcePosition(tryElement.getPosition().getCompilationUnit(), paramPos.getSourceStart(), paramPos.getSourceEnd(), declarationStart, declarationStart - 1, declarationStart, bodyEnd, bodyStart, bodyEnd, lineSeparatorPositions);
    }

    SourcePosition buildPosition(CtCase<?> child) {
        List<CtStatement> statements = child.getStatements();
        SourcePosition oldPosition = child.getPosition();
        if (statements.isEmpty()) {
            return oldPosition;
        }
        int[] lineSeparatorPositions = this.jdtTreeBuilder.getContextBuilder().getCompilationUnitLineSeparatorPositions();
        int bodyStart = child.getPosition().getSourceEnd() + 1;
        int bodyEnd = statements.get(statements.size() - 1).getPosition().getSourceEnd();
        return child.getFactory().Core().createBodyHolderSourcePosition(oldPosition.getCompilationUnit(), oldPosition.getSourceStart(), oldPosition.getSourceEnd(), oldPosition.getSourceStart(), oldPosition.getSourceStart() - 1, oldPosition.getSourceStart(), bodyEnd, bodyStart, bodyEnd, lineSeparatorPositions);
    }

    private int getEndOfLastTryBlock(CtTry tryElement, int negIdx) {
        int endOfLastBlock = tryElement.getBody().getPosition().getSourceEnd();
        if (tryElement.getCatchers().size() > negIdx) {
            CtCatch prevCatcher = tryElement.getCatchers().get(tryElement.getCatchers().size() - 1 - negIdx);
            endOfLastBlock = prevCatcher.getPosition().getSourceEnd();
        }
        return endOfLastBlock;
    }

    private int getNrOfFirstCastExpressionBrackets() {
        return this.jdtTreeBuilder.getContextBuilder().casts.get((int)0).nrOfBrackets;
    }

    private int getNrOfCastExpressionBrackets() {
        int nr = 0;
        for (ContextBuilder.CastInfo castInfo : this.jdtTreeBuilder.getContextBuilder().casts) {
            nr += castInfo.nrOfBrackets;
        }
        return nr;
    }

    private void setModifiersPosition(CtModifiable e, int start, int end) {
        int o1;
        CoreFactory cf = this.jdtTreeBuilder.getFactory().Core();
        CompilationUnit cu = this.jdtTreeBuilder.getContextBuilder().compilationUnitSpoon;
        char[] contents = this.jdtTreeBuilder.getContextBuilder().getCompilationUnitContents();
        Set<CtExtendedModifier> modifiers = e.getExtendedModifiers();
        HashMap<String, CtExtendedModifier> explicitModifiersByName = new HashMap<String, CtExtendedModifier>();
        for (CtExtendedModifier modifier : modifiers) {
            if (modifier.isImplicit()) {
                modifier.setPosition(cf.createPartialSourcePosition(cu));
                continue;
            }
            if (explicitModifiersByName.put(modifier.getKind().toString(), modifier) == null) continue;
            throw new SpoonException("The modifier " + modifier.getKind().toString() + " found twice");
        }
        ++end;
        while (start < end && explicitModifiersByName.size() > 0 && (o1 = PositionBuilder.findNextNonWhitespace(contents, end - 1, start)) != -1) {
            String modifierName;
            CtExtendedModifier modifier;
            int chevronIndex;
            int o2 = PositionBuilder.findNextWhitespace(contents, end - 1, o1);
            if (o2 == -1) {
                o2 = end;
            }
            if ((chevronIndex = ArrayUtils.indexOf((char[])Arrays.copyOfRange(contents, o1, o2), (char)'<')) > 0) {
                o2 = o1 + chevronIndex;
            }
            if ((modifier = (CtExtendedModifier)explicitModifiersByName.remove(modifierName = String.valueOf(contents, o1, o2 - o1))) != null) {
                modifier.setPosition(cf.createSourcePosition(cu, o1, o2 - 1, this.jdtTreeBuilder.getContextBuilder().getCompilationUnitLineSeparatorPositions()));
            }
            start = o2;
        }
        if (explicitModifiersByName.size() > 0) {
            throw new SpoonException("Position of CtExtendedModifiers: [" + String.join((CharSequence)", ", explicitModifiersByName.keySet()) + "] not found in " + String.valueOf(contents, start, end - start));
        }
    }

    private int getSourceEndOfTypeReference(char[] contents, TypeReference node, int sourceEnd) {
        TypeReference[][] typeArgs = node.getTypeArguments();
        if (typeArgs != null && typeArgs.length > 0) {
            TypeReference[] trs = typeArgs[typeArgs.length - 1];
            if (trs != null && trs.length > 0) {
                TypeReference tr = trs[trs.length - 1];
                if (sourceEnd < tr.sourceEnd) {
                    sourceEnd = PositionBuilder.findNextNonWhitespace(contents, contents.length - 1, this.getSourceEndOfTypeReference(contents, tr, tr.sourceEnd) + 1);
                }
                if (contents[sourceEnd] == '.' && contents[sourceEnd - 1] == '.' && contents[sourceEnd - 2] == '.') {
                    sourceEnd -= 3;
                }
            } else {
                int endIdx;
                int startIdx = PositionBuilder.findNextNonWhitespace(contents, contents.length - 1, sourceEnd + 1);
                if (startIdx != -1 && contents[startIdx] == '<' && (endIdx = PositionBuilder.findNextNonWhitespace(contents, contents.length - 1, startIdx + 1)) != -1 && contents[endIdx] == '>') {
                    sourceEnd = endIdx;
                }
            }
        }
        if (node instanceof Wildcard) {
            Wildcard wildcard = (Wildcard)node;
            if (wildcard.bound != null) {
                sourceEnd = this.getSourceEndOfTypeReference(contents, wildcard.bound, sourceEnd);
            }
        }
        return sourceEnd;
    }

    static int findNextChar(char[] contents, int maxOff, int off, char expectedChar) {
        while ((off = PositionBuilder.findNextNonWhitespace(contents, maxOff, off)) >= 0) {
            if (contents[off] == expectedChar) {
                return off;
            }
            ++off;
        }
        return -1;
    }

    public static int findNextNonWhitespace(char[] content, int maxOff, int off) {
        return PositionBuilder.findNextNonWhitespace(true, content, maxOff, off);
    }

    static int findNextNonWhitespace(boolean commentIsWhiteSpace, char[] content, int maxOff, int off) {
        maxOff = Math.min(maxOff, content.length - 1);
        while (off >= 0 && off <= maxOff) {
            char c = content[off];
            if (!Character.isWhitespace(c)) {
                int endOfCommentOff;
                int n = endOfCommentOff = commentIsWhiteSpace ? PositionBuilder.getEndOfComment(content, maxOff, off) : -1;
                if (endOfCommentOff == -1) {
                    return off;
                }
                off = endOfCommentOff;
            }
            ++off;
        }
        return -1;
    }

    static int findNextWhitespace(char[] content, int maxOff, int off) {
        boolean inString = false;
        maxOff = Math.min(maxOff, content.length - 1);
        while (off >= 0 && off <= maxOff) {
            char c = content[off];
            if (c == '\"' && !inString) {
                inString = true;
            } else if (c == '\"' && inString) {
                inString = false;
            }
            if (Character.isWhitespace(c) || !inString && PositionBuilder.getEndOfComment(content, maxOff, off) >= 0) {
                return off;
            }
            ++off;
        }
        return -1;
    }

    static int findPrevNonWhitespace(char[] content, int minOff, int off) {
        minOff = Math.max(0, minOff);
        while (off >= minOff) {
            char c = content[off];
            int startOfCommentOff = PositionBuilder.getStartOfComment(content, minOff, off);
            if (startOfCommentOff >= 0) {
                off = startOfCommentOff;
            } else if (!Character.isWhitespace(c)) {
                return off;
            }
            --off;
        }
        return -1;
    }

    static int findPrevAnnotations(char[] content, int minOff, int off) {
        minOff = Math.max(0, minOff);
        while (off >= minOff) {
            char c = content[off];
            int startOfCommentOff = PositionBuilder.getStartOfComment(content, minOff, off);
            if (startOfCommentOff >= 0) {
                off = startOfCommentOff;
            } else if (c == '@') {
                return off;
            }
            --off;
        }
        return -1;
    }

    static int findPrevWhitespace(char[] content, int minOff, int off) {
        minOff = Math.max(0, minOff);
        while (off >= minOff) {
            char c = content[off];
            if (Character.isWhitespace(c) || PositionBuilder.getStartOfComment(content, minOff, off) >= 0) {
                return off;
            }
            --off;
        }
        return -1;
    }

    public static int getEndOfComment(char[] content, int maxOff, int off) {
        if (off + 1 <= (maxOff = Math.min(maxOff, content.length - 1))) {
            if (content[off] == '/' && content[off + 1] == '*') {
                off += 3;
                while (off <= maxOff) {
                    if (content[off] == '/' && content[off - 1] == '*') {
                        return off;
                    }
                    ++off;
                }
                return off;
            }
            if (content[off] == '/' && content[off + 1] == '/') {
                while (off <= maxOff) {
                    if (content[off] == '\n') {
                        return off;
                    }
                    if (content[off] == '\r') {
                        if (off < maxOff && content[off + 1] == '\n') {
                            ++off;
                        }
                        return off;
                    }
                    ++off;
                }
            }
        }
        return -1;
    }

    static int getStartOfComment(char[] content, int minOff, int off) {
        if (off < 2) {
            return -1;
        }
        if (content[off] == '/' && content[off - 1] == '*' || content[off] == '\n' || content[off] == '\r') {
            int maxOff = off;
            for (off = minOff; off <= maxOff; ++off) {
                int endOfComment = PositionBuilder.getEndOfComment(content, maxOff, off);
                if (endOfComment < 0) continue;
                if (endOfComment == maxOff) {
                    return off;
                }
                off = endOfComment;
            }
        }
        return -1;
    }

    private SourcePosition handlePositionProblem(String errorMessage) {
        if (this.jdtTreeBuilder.getFactory().getEnvironment().checksAreSkipped()) {
            this.jdtTreeBuilder.getFactory().getEnvironment().debugMessage("Source position detection failed: " + errorMessage);
            return SourcePosition.NOPOSITION;
        }
        throw new SpoonException("Source position detection failed: " + errorMessage);
    }
}

