/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.compiler.jdt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.AnnotationMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ArrayAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.CaseStatement;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.EitherOrMultiPattern;
import org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ForStatement;
import org.eclipse.jdt.internal.compiler.ast.IfStatement;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.StringLiteralConcatenation;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.UnionTypeReference;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.jspecify.annotations.Nullable;
import spoon.SpoonException;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CaseKind;
import spoon.reflect.code.CtArrayAccess;
import spoon.reflect.code.CtArrayRead;
import spoon.reflect.code.CtArrayWrite;
import spoon.reflect.code.CtAssert;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtBreak;
import spoon.reflect.code.CtCase;
import spoon.reflect.code.CtCasePattern;
import spoon.reflect.code.CtCatch;
import spoon.reflect.code.CtCatchVariable;
import spoon.reflect.code.CtConditional;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtDo;
import spoon.reflect.code.CtExecutableReferenceExpression;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtForEach;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLambda;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtLoop;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.code.CtNewClass;
import spoon.reflect.code.CtPattern;
import spoon.reflect.code.CtRecordPattern;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtSuperAccess;
import spoon.reflect.code.CtSwitch;
import spoon.reflect.code.CtSwitchExpression;
import spoon.reflect.code.CtSynchronized;
import spoon.reflect.code.CtTargetedExpression;
import spoon.reflect.code.CtThisAccess;
import spoon.reflect.code.CtThrow;
import spoon.reflect.code.CtTry;
import spoon.reflect.code.CtTryWithResource;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.code.CtTypePattern;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.code.CtWhile;
import spoon.reflect.code.CtYieldStatement;
import spoon.reflect.cu.CompilationUnit;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.declaration.CtAnnotatedElementType;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtAnnotationMethod;
import spoon.reflect.declaration.CtAnonymousExecutable;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtEnum;
import spoon.reflect.declaration.CtEnumValue;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtFormalTypeDeclarer;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtReceiverParameter;
import spoon.reflect.declaration.CtRecord;
import spoon.reflect.declaration.CtRecordComponent;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeParameter;
import spoon.reflect.declaration.CtTypedElement;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.reference.CtIntersectionTypeReference;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtWildcardReference;
import spoon.reflect.visitor.CtInheritanceScanner;
import spoon.reflect.visitor.CtScanner;
import spoon.support.compiler.jdt.ASTPair;
import spoon.support.compiler.jdt.JDTTreeBuilder;
import spoon.support.compiler.jdt.JDTTreeBuilderQuery;
import spoon.support.compiler.jdt.ReferenceBuilder;

public class ParentExiter
extends CtInheritanceScanner {
    private final JDTTreeBuilder jdtTreeBuilder;
    private CtElement child;
    private ASTNode childJDT;
    private ASTPair parentPair;
    private Map<CtTypedElement<?>, List<CtAnnotation>> annotationsMap = new HashMap();

    ParentExiter(JDTTreeBuilder jdtTreeBuilder) {
        this.jdtTreeBuilder = jdtTreeBuilder;
    }

    public void exitParent(ASTPair pair) {
        this.parentPair = pair;
        this.scan(pair.element());
    }

    public void setChild(CtElement child) {
        this.child = child;
    }

    public void setChild(ASTNode child) {
        this.childJDT = child;
    }

    @Override
    public void scanCtElement(CtElement e) {
        if (this.child instanceof CtAnnotation && this.jdtTreeBuilder.getContextBuilder().annotationValueName.isEmpty()) {
            CtAnnotatedElementType annotatedElementType = CtAnnotation.getAnnotatedElementTypeForCtElement(e);
            CtAnnotatedElementType ctAnnotatedElementType = annotatedElementType = e instanceof CtTypeParameter || e instanceof CtTypeParameterReference ? CtAnnotatedElementType.TYPE_USE : annotatedElementType;
            if (this.jdtTreeBuilder.getFactory().getEnvironment().getNoClasspath() || annotatedElementType != null && JDTTreeBuilderQuery.hasAnnotationWithType((Annotation)this.childJDT, annotatedElementType)) {
                e.addAnnotation((CtAnnotation)this.child);
            }
            if (e instanceof CtTypedElement && JDTTreeBuilderQuery.hasAnnotationWithType((Annotation)this.childJDT, CtAnnotatedElementType.TYPE_USE)) {
                List<Object> annotations = new ArrayList();
                if (!this.annotationsMap.containsKey(e)) {
                    this.annotationsMap.put((CtTypedElement)e, annotations);
                } else {
                    annotations = this.annotationsMap.get(e);
                }
                annotations.add((CtAnnotation)this.child.clone());
                this.annotationsMap.put((CtTypedElement)e, annotations);
            }
        }
    }

    private void substituteAnnotation(CtTypedElement ele) {
        if (this.annotationsMap.containsKey(ele)) {
            List<CtAnnotation> annotations = this.annotationsMap.get(ele);
            for (CtAnnotation annotation : annotations) {
                if (this.jdtTreeBuilder.getFactory().getEnvironment().getNoClasspath() && annotation.isParentInitialized()) {
                    CtElement parent = annotation.getParent();
                    parent.removeAnnotation(annotation);
                }
                if (ele.getType().getAnnotations().contains(annotation)) continue;
                ele.getType().addAnnotation((CtAnnotation<? extends java.lang.annotation.Annotation>)annotation.clone());
            }
            this.annotationsMap.remove(ele);
        }
    }

    @Override
    public <R> void scanCtExecutable(CtExecutable<R> e) {
        if (this.child instanceof CtTypeAccess) {
            e.addThrownType(((CtTypeAccess)this.child).getAccessedType());
            return;
        }
        if (this.child instanceof CtParameter) {
            e.addParameter((CtParameter)this.child);
            return;
        }
        if (this.child instanceof CtBlock && !(e instanceof CtMethod) && !(e instanceof CtConstructor)) {
            e.setBody((CtBlock)this.child);
            return;
        }
        if (this.child instanceof CtReceiverParameter) {
            CtReceiverParameter ctReceiverParameter = (CtReceiverParameter)this.child;
            e.setReceiverParameter(ctReceiverParameter);
        }
        super.scanCtExecutable(e);
    }

    @Override
    public void scanCtFormalTypeDeclarer(CtFormalTypeDeclarer e) {
        if (this.childJDT instanceof TypeParameter && this.child instanceof CtTypeParameter) {
            e.addFormalCtTypeParameter((CtTypeParameter)this.child);
        }
    }

    @Override
    public void scanCtLoop(CtLoop loop) {
        if (loop.getBody() == null && this.child instanceof CtStatement) {
            CtBlock<?> child = (CtBlock<?>)this.child;
            if (!(this.child instanceof CtBlock)) {
                child = this.jdtTreeBuilder.getFactory().Code().createCtBlock(child);
                child.setImplicit(true);
                child.setPosition(this.child.getPosition());
            }
            loop.setBody(child);
        }
        super.scanCtLoop(loop);
    }

    @Override
    public <T, E extends CtExpression<?>> void scanCtTargetedExpression(CtTargetedExpression<T, E> targetedExpression) {
        if (this.child instanceof CtExpression) {
            targetedExpression.setTarget((CtExpression)this.child);
            return;
        }
        super.scanCtTargetedExpression(targetedExpression);
    }

    @Override
    public <T> void scanCtType(CtType<T> type) {
        if (this.child instanceof CtType && !(this.child instanceof CtTypeParameter)) {
            if (type.getTypeMembers().contains(this.child)) {
                type.removeTypeMember((CtType)this.child);
            }
            type.addNestedType((CtType)this.child);
            return;
        }
        if (this.child instanceof CtEnumValue && type instanceof CtEnum) {
            ((CtEnum)type).addEnumValue((CtEnumValue)this.child);
        } else {
            if (this.child instanceof CtField) {
                CtRecord record;
                CtField<?> existing;
                CtField field = (CtField)this.child;
                if (type instanceof CtRecord && !field.isStatic() && (existing = (record = (CtRecord)type).getField(field.getSimpleName())) != null) {
                    record.removeField(existing);
                }
                type.addField(field);
                return;
            }
            if (this.child instanceof CtConstructor) {
                return;
            }
        }
        if (this.child instanceof CtMethod) {
            type.addMethod((CtMethod)this.child);
            return;
        }
        super.scanCtType(type);
    }

    @Override
    public <T> void scanCtVariable(CtVariable<T> v) {
        if (this.childJDT instanceof TypeReference && this.child instanceof CtTypeAccess) {
            v.setType(((CtTypeAccess)this.child).getAccessedType());
            this.substituteAnnotation(v);
            return;
        }
        if (this.child instanceof CtExpression && this.hasChildEqualsToDefaultValue(v)) {
            v.setDefaultExpression((CtExpression)this.child);
            return;
        }
        super.scanCtVariable(v);
    }

    private <T> boolean hasChildEqualsToDefaultValue(CtVariable<T> ctVariable) {
        if (this.jdtTreeBuilder.getContextBuilder().getCurrentNode() instanceof AnnotationMethodDeclaration) {
            AnnotationMethodDeclaration parent = (AnnotationMethodDeclaration)this.jdtTreeBuilder.getContextBuilder().getCurrentNode();
            return parent.defaultValue != null && this.getFinalExpressionFromCast(parent.defaultValue).equals(this.childJDT) && !this.child.equals(ctVariable.getDefaultExpression());
        }
        AbstractVariableDeclaration parent = (AbstractVariableDeclaration)this.jdtTreeBuilder.getContextBuilder().getCurrentNode();
        return parent.initialization != null && this.getFinalExpressionFromCast(parent.initialization).equals(this.childJDT) && !this.child.equals(ctVariable.getDefaultExpression());
    }

    @Override
    public <A extends java.lang.annotation.Annotation> void visitCtAnnotation(CtAnnotation<A> annotation) {
        if (this.child instanceof CtExpression) {
            annotation.addValue(this.jdtTreeBuilder.getContextBuilder().annotationValueName.peek(), this.child);
        }
        super.visitCtAnnotation(annotation);
    }

    @Override
    public <T> void visitCtConstructor(CtConstructor<T> e) {
        if (e.getBody() == null && this.child instanceof CtBlock) {
            e.setBody((CtBlock)this.child);
            return;
        }
        if (this.child instanceof CtStatement) {
            this.visitCtBlock((CtBlock)e.getBody());
            return;
        }
        super.visitCtConstructor(e);
    }

    @Override
    public <T> void visitCtMethod(CtMethod<T> e) {
        if (e.getBody() == null && this.child instanceof CtBlock) {
            e.setBody((CtBlock)this.child);
            return;
        }
        if (this.child instanceof CtStatement) {
            this.visitCtBlock((CtBlock)e.getBody());
            return;
        }
        if (this.child instanceof CtTypeAccess && this.hasChildEqualsToType(e)) {
            e.setType(((CtTypeAccess)this.child).getAccessedType());
            this.substituteAnnotation(e);
            return;
        }
        super.visitCtMethod(e);
    }

    private <T> boolean hasChildEqualsToType(CtMethod<T> ctMethod) {
        MethodDeclaration parent = (MethodDeclaration)this.jdtTreeBuilder.getContextBuilder().getCurrentNode();
        return parent.returnType != null && parent.returnType.equals(this.childJDT) && !this.child.equals(ctMethod.getType());
    }

    @Override
    public <T> void visitCtAnnotationMethod(CtAnnotationMethod<T> annotationMethod) {
        if (this.child instanceof CtExpression && this.hasChildEqualsToDefaultValue(annotationMethod)) {
            annotationMethod.setDefaultExpression((CtExpression)this.child);
            return;
        }
        super.visitCtAnnotationMethod(annotationMethod);
    }

    private <T> boolean hasChildEqualsToDefaultValue(CtAnnotationMethod<T> ctAnnotationMethod) {
        AnnotationMethodDeclaration parent = (AnnotationMethodDeclaration)this.jdtTreeBuilder.getContextBuilder().getCurrentNode();
        return parent.defaultValue != null && parent.defaultValue.equals(this.childJDT) && !this.child.equals(ctAnnotationMethod.getDefaultExpression());
    }

    @Override
    public void visitCtAnonymousExecutable(CtAnonymousExecutable e) {
        if (this.child instanceof CtBlock) {
            e.setBody((CtBlock)this.child);
            return;
        }
        super.visitCtAnonymousExecutable(e);
    }

    @Override
    public <T> void visitCtArrayRead(CtArrayRead<T> arrayRead) {
        if (this.visitArrayAccess(arrayRead)) {
            super.visitCtArrayRead(arrayRead);
        }
    }

    @Override
    public <T> void visitCtArrayWrite(CtArrayWrite<T> arrayWrite) {
        if (this.visitArrayAccess(arrayWrite)) {
            super.visitCtArrayWrite(arrayWrite);
        }
    }

    private <T, E extends CtExpression<?>> boolean visitArrayAccess(CtArrayAccess<T, E> arrayAccess) {
        if (this.child instanceof CtExpression) {
            if (arrayAccess.getTarget() == null) {
                arrayAccess.setTarget((CtExpression)this.child);
                return false;
            }
            arrayAccess.setIndexExpression((CtExpression)this.child);
            return false;
        }
        return true;
    }

    @Override
    public <T> void visitCtAssert(CtAssert<T> asserted) {
        if (this.child instanceof CtExpression) {
            if (asserted.getAssertExpression() == null) {
                asserted.setAssertExpression((CtExpression)this.child);
                return;
            }
            asserted.setExpression((CtExpression)this.child);
            return;
        }
        super.visitCtAssert(asserted);
    }

    @Override
    public <T, A extends T> void visitCtAssignment(CtAssignment<T, A> assignement) {
        if (this.child instanceof CtExpression) {
            if (assignement.getAssigned() == null) {
                assignement.setAssigned((CtExpression)this.child);
                return;
            }
            if (assignement.getAssignment() == null) {
                assignement.setAssignment((CtExpression)this.child);
                return;
            }
        }
        super.visitCtAssignment(assignement);
    }

    @Override
    public <T> void visitCtBinaryOperator(CtBinaryOperator<T> operator) {
        CtElement child;
        CtElement ctElement = child = operator.getKind() == BinaryOperatorKind.INSTANCEOF && operator.getLeftHandOperand() != null ? this.adjustIfLocalVariableToTypePattern(this.child) : this.child;
        if (child instanceof CtExpression) {
            if (operator.getLeftHandOperand() == null) {
                operator.setLeftHandOperand((CtExpression)child);
                return;
            }
            if (operator.getRightHandOperand() == null) {
                if (child.getPosition().isValidPosition()) {
                    int childEnd = child.getPosition().getSourceEnd();
                    SourcePosition oldPos = operator.getPosition();
                    if (oldPos.isValidPosition() && oldPos.getSourceEnd() < childEnd) {
                        int[] lineSeparatorPositions = this.jdtTreeBuilder.getContextBuilder().getCompilationUnitLineSeparatorPositions();
                        operator.setPosition(operator.getFactory().Core().createSourcePosition(oldPos.getCompilationUnit(), oldPos.getSourceStart(), childEnd, lineSeparatorPositions));
                    }
                }
                operator.setRightHandOperand((CtExpression)child);
                return;
            }
            if (this.jdtTreeBuilder.getContextBuilder().getCurrentNode() instanceof StringLiteralConcatenation) {
                CtBinaryOperator op = operator.getFactory().Core().createBinaryOperator();
                op.setKind(BinaryOperatorKind.PLUS);
                op.setLeftHandOperand(operator.getLeftHandOperand());
                op.setRightHandOperand(operator.getRightHandOperand());
                op.setType(operator.getFactory().Type().stringType());
                operator.setLeftHandOperand(op);
                operator.setRightHandOperand((CtExpression)child);
                int[] lineSeparatorPositions = this.jdtTreeBuilder.getContextBuilder().getCompilationUnitLineSeparatorPositions();
                SourcePosition leftPosition = op.getLeftHandOperand().getPosition();
                SourcePosition rightPosition = op.getRightHandOperand().getPosition();
                op.setPosition(op.getFactory().createSourcePosition(leftPosition.getCompilationUnit(), leftPosition.getSourceStart(), rightPosition.getSourceEnd(), lineSeparatorPositions));
                return;
            }
        }
        super.visitCtBinaryOperator(operator);
    }

    private CtElement adjustIfLocalVariableToTypePattern(CtElement original) {
        CtElement child = original;
        if (child instanceof CtLocalVariable) {
            CtTypePattern typePattern = child.getFactory().Core().createTypePattern();
            typePattern.setVariable((CtLocalVariable)child);
            typePattern.setPosition(child.getPosition());
            child = typePattern;
        }
        return child;
    }

    @Override
    public <R> void visitCtBlock(CtBlock<R> block) {
        if (this.child instanceof CtStatement) {
            block.addStatement((CtStatement)this.child);
            return;
        }
        super.visitCtBlock(block);
    }

    @Override
    public void visitCtBreak(CtBreak b) {
        super.visitCtBreak(b);
    }

    @Override
    public <E> void visitCtCase(CtCase<E> caseStatement) {
        ASTNode node = this.jdtTreeBuilder.getContextBuilder().getCurrentNode();
        if (node instanceof CaseStatement) {
            CaseStatement cs = (CaseStatement)node;
            caseStatement.setCaseKind(cs.isSwitchRule ? CaseKind.ARROW : CaseKind.COLON);
        }
        if (this.shouldAddAsCaseExpression(caseStatement, node)) {
            if (this.child instanceof CtPattern) {
                CtPattern pattern = (CtPattern)this.child;
                caseStatement.addCaseExpression(this.jdtTreeBuilder.getFactory().Core().createCasePattern().setPattern(pattern));
            } else {
                caseStatement.addCaseExpression((CtExpression)this.child);
            }
            return;
        }
        if (this.child instanceof CtStatement) {
            caseStatement.addStatement((CtStatement)this.child);
            return;
        }
        if (this.child instanceof CtExpression) {
            CtExpression guard = (CtExpression)this.child;
            caseStatement.setGuard(guard);
        }
        super.visitCtCase(caseStatement);
    }

    private <E> boolean shouldAddAsCaseExpression(CtCase<E> caseStatement, ASTNode node) {
        if (!(node instanceof CaseStatement)) {
            return false;
        }
        CaseStatement cs = (CaseStatement)node;
        if (cs.constantExpressions == null) {
            return false;
        }
        if (this.child instanceof CtExpression && caseStatement.getCaseExpressions().size() < cs.constantExpressions.length) {
            return true;
        }
        if (cs.constantExpressions.length == 1 && cs.constantExpressions[0] instanceof EitherOrMultiPattern) {
            EitherOrMultiPattern eomp = (EitherOrMultiPattern)cs.constantExpressions[0];
            return caseStatement.getCaseExpressions().size() < eomp.getAlternatives().length;
        }
        return false;
    }

    @Override
    public void visitCtCatch(CtCatch catchBlock) {
        if (this.child instanceof CtBlock) {
            catchBlock.setBody((CtBlock)this.child);
            return;
        }
        if (this.child instanceof CtCatchVariable) {
            catchBlock.setParameter((CtCatchVariable)this.child);
            catchBlock.getAnnotations().forEach(a -> {
                a.setParent(this.child);
                this.child.addAnnotation((CtAnnotation<? extends java.lang.annotation.Annotation>)a);
            });
            catchBlock.setAnnotations(List.of());
            return;
        }
        super.visitCtCatch(catchBlock);
    }

    @Override
    public <T> void visitCtCatchVariable(CtCatchVariable<T> e) {
        if (this.jdtTreeBuilder.getContextBuilder().getCurrentNode() instanceof UnionTypeReference) {
            e.addMultiType((CtTypeReference)this.child);
            return;
        }
        super.visitCtCatchVariable(e);
    }

    @Override
    public void visitCtCasePattern(CtCasePattern casePattern) {
        if (this.child instanceof CtPattern) {
            CtPattern pattern = (CtPattern)this.child;
            casePattern.setPattern(pattern);
        }
        super.visitCtCasePattern(casePattern);
    }

    @Override
    public <T> void visitCtClass(CtClass<T> ctClass) {
        if (this.child instanceof CtConstructor) {
            CtConstructor constructor = (CtConstructor)this.child;
            ctClass.addConstructor(constructor);
            this.fixJdtEnumConstructorSuperCall(ctClass, constructor);
        }
        if (this.child instanceof CtAnonymousExecutable) {
            ctClass.addAnonymousExecutable((CtAnonymousExecutable)this.child);
        }
        super.visitCtClass(ctClass);
    }

    private <T> void fixJdtEnumConstructorSuperCall(CtClass<T> ctClass, CtConstructor<T> constructor) {
        if (!(this.child.isImplicit() && ctClass.isEnum() && constructor.getParameters().isEmpty())) {
            return;
        }
        if (constructor.getBody().getStatements().isEmpty()) {
            return;
        }
        if (!(constructor.getBody().getStatement(0) instanceof CtInvocation)) {
            return;
        }
        CtInvocation superCall = (CtInvocation)constructor.getBody().getStatement(0);
        if (superCall.getExecutable().getSimpleName().equals("<init>")) {
            constructor.getBody().removeStatement(superCall);
        }
    }

    @Override
    public void visitCtTypeParameter(CtTypeParameter typeParameter) {
        if (this.childJDT instanceof TypeReference && this.child instanceof CtTypeAccess) {
            if (typeParameter.getSuperclass() == null) {
                typeParameter.setSuperclass(((CtTypeAccess)this.child).getAccessedType());
            } else if (typeParameter.getSuperclass() instanceof CtIntersectionTypeReference) {
                typeParameter.getSuperclass().asCtIntersectionTypeReference().addBound(((CtTypeAccess)this.child).getAccessedType());
            } else {
                ArrayList refs = new ArrayList();
                refs.add(typeParameter.getSuperclass());
                refs.add(((CtTypeAccess)this.child).getAccessedType());
                typeParameter.setSuperclass(this.jdtTreeBuilder.getFactory().Type().createIntersectionTypeReferenceWithBounds(refs));
            }
            return;
        }
        super.visitCtTypeParameter(typeParameter);
    }

    @Override
    public <T> void visitCtConditional(CtConditional<T> conditional) {
        if (this.child instanceof CtExpression) {
            if (conditional.getCondition() == null) {
                conditional.setCondition((CtExpression)this.child);
            } else if (conditional.getThenExpression() == null) {
                conditional.setThenExpression((CtExpression)this.child);
            } else if (conditional.getElseExpression() == null) {
                conditional.setElseExpression((CtExpression)this.child);
            }
        }
        super.visitCtConditional(conditional);
    }

    @Override
    public void visitCtDo(CtDo doLoop) {
        if (doLoop.getBody() != null && this.child instanceof CtExpression && doLoop.getLoopingExpression() == null) {
            doLoop.setLoopingExpression((CtExpression)this.child);
            return;
        }
        super.visitCtDo(doLoop);
    }

    @Override
    public void visitCtFor(CtFor forLoop) {
        if (this.isContainedInForInit() && this.child instanceof CtStatement) {
            forLoop.addForInit((CtStatement)this.child);
            return;
        }
        if (this.isContainedInForUpdate() && this.child instanceof CtStatement) {
            forLoop.addForUpdate((CtStatement)this.child);
            return;
        }
        if (this.isContainedInForCondition() && this.child instanceof CtExpression) {
            forLoop.setExpression((CtExpression)this.child);
            return;
        }
        super.visitCtFor(forLoop);
    }

    private boolean isContainedInForInit() {
        if (!(this.jdtTreeBuilder.getContextBuilder().getCurrentNode() instanceof ForStatement)) {
            return false;
        }
        ForStatement parent = (ForStatement)this.jdtTreeBuilder.getContextBuilder().getCurrentNode();
        if (parent.initializations == null) {
            return false;
        }
        for (Statement initialization : parent.initializations) {
            if (initialization == null || !initialization.equals(this.childJDT)) continue;
            return true;
        }
        return false;
    }

    private boolean isContainedInForUpdate() {
        if (!(this.jdtTreeBuilder.getContextBuilder().getCurrentNode() instanceof ForStatement)) {
            return false;
        }
        ForStatement parent = (ForStatement)this.jdtTreeBuilder.getContextBuilder().getCurrentNode();
        if (parent.increments == null) {
            return false;
        }
        for (Statement increment : parent.increments) {
            if (increment == null || !increment.equals(this.childJDT)) continue;
            return true;
        }
        return false;
    }

    private boolean isContainedInForCondition() {
        if (!(this.jdtTreeBuilder.getContextBuilder().getCurrentNode() instanceof ForStatement)) {
            return false;
        }
        ForStatement parent = (ForStatement)this.jdtTreeBuilder.getContextBuilder().getCurrentNode();
        return parent.condition != null && parent.condition.equals(this.childJDT);
    }

    @Override
    public void visitCtForEach(CtForEach foreach) {
        if (foreach.getVariable() == null && this.child instanceof CtLocalVariable) {
            foreach.setVariable((CtLocalVariable)this.child);
        } else if (foreach.getExpression() == null && this.child instanceof CtExpression) {
            foreach.setExpression((CtExpression)this.child);
        } else {
            super.visitCtForEach(foreach);
        }
    }

    @Override
    public void visitCtWhile(CtWhile whileLoop) {
        if (whileLoop.getLoopingExpression() == null && this.child instanceof CtExpression) {
            whileLoop.setLoopingExpression((CtExpression)this.child);
            return;
        }
        super.visitCtWhile(whileLoop);
    }

    @Override
    public void visitCtIf(CtIf ifElement) {
        if (ifElement.getCondition() == null && this.child instanceof CtExpression) {
            ifElement.setCondition((CtExpression)this.child);
            return;
        }
        if (this.child instanceof CtStatement) {
            CtBlock<?> child = (CtBlock<?>)this.child;
            if (!(this.child instanceof CtBlock)) {
                child = this.jdtTreeBuilder.getFactory().Code().createCtBlock(child);
                child.setImplicit(true);
                child.setPosition(this.child.getPosition());
            }
            IfStatement ifJDT = (IfStatement)this.parentPair.node();
            if (ifJDT.thenStatement == this.childJDT) {
                ifElement.setThenStatement(child);
                return;
            }
            if (ifJDT.elseStatement == this.childJDT) {
                ifElement.setElseStatement(child);
                return;
            }
            throw new SpoonException("Unexpected call of ParentExiter on CtIf");
        }
        super.visitCtIf(ifElement);
    }

    @Override
    public <T> void visitCtSuperAccess(CtSuperAccess<T> superAccess) {
        if (this.child instanceof CtTypeAccess) {
            superAccess.setTarget((CtTypeAccess)this.child);
            return;
        }
        super.visitCtSuperAccess(superAccess);
    }

    @Override
    public <T> void visitCtInvocation(CtInvocation<T> invocation) {
        if (this.childJDT instanceof TypeReference && this.child instanceof CtTypeAccess) {
            invocation.getExecutable().addActualTypeArgument(((CtTypeAccess)this.child).getAccessedType());
            return;
        }
        if (this.child instanceof CtExpression) {
            if (this.hasChildEqualsToReceiver(invocation) || this.hasChildEqualsToQualification(invocation)) {
                if (this.child instanceof CtThisAccess) {
                    if (!this.setTargetFromUnqualifiedAccess(invocation)) {
                        CtTypeReference<?> declaringType = invocation.getExecutable().getDeclaringType();
                        if (declaringType != null && invocation.getExecutable().isStatic() && this.child.isImplicit()) {
                            invocation.setTarget(this.jdtTreeBuilder.getFactory().Code().createTypeAccess(declaringType, true));
                        } else {
                            invocation.setTarget((CtThisAccess)this.child);
                        }
                    }
                } else {
                    invocation.setTarget((CtExpression)this.child);
                }
            } else {
                invocation.addArgument((CtExpression)this.child);
            }
            return;
        }
        super.visitCtInvocation(invocation);
    }

    private <T> boolean setTargetFromUnqualifiedAccess(CtInvocation<T> invocation) {
        CtTypeReference<Object> resolvedReceiverType;
        if (!(this.parentPair.node() instanceof MessageSend)) {
            return false;
        }
        MessageSend messageSend = (MessageSend)this.parentPair.node();
        if (messageSend.actualReceiverType == null || messageSend.receiver.resolvedType == null) {
            return false;
        }
        ReferenceBuilder referenceBuilder = this.jdtTreeBuilder.getReferencesBuilder();
        CtTypeReference actualReceiverType = referenceBuilder.getTypeReference(messageSend.actualReceiverType);
        if (actualReceiverType.equals(resolvedReceiverType = referenceBuilder.getTypeReference(messageSend.receiver.resolvedType))) {
            return false;
        }
        if (messageSend.binding() == null || !messageSend.binding().isStatic()) {
            while (resolvedReceiverType != null) {
                if (!actualReceiverType.equals(resolvedReceiverType = resolvedReceiverType.getDeclaringType())) continue;
                invocation.setTarget(this.jdtTreeBuilder.getFactory().Code().createThisAccess(actualReceiverType, true));
                return true;
            }
            return false;
        }
        invocation.setTarget(this.jdtTreeBuilder.getFactory().Code().createTypeAccess(actualReceiverType, true));
        return true;
    }

    private <T> boolean hasChildEqualsToQualification(CtInvocation<T> ctInvocation) {
        if (!(this.jdtTreeBuilder.getContextBuilder().getCurrentNode() instanceof ExplicitConstructorCall)) {
            return false;
        }
        ExplicitConstructorCall parent = (ExplicitConstructorCall)this.jdtTreeBuilder.getContextBuilder().getCurrentNode();
        return parent.qualification != null && this.getFinalExpressionFromCast(parent.qualification).equals(this.childJDT) && !this.child.equals(ctInvocation.getTarget());
    }

    private <T> boolean hasChildEqualsToReceiver(CtInvocation<T> ctInvocation) {
        if (!(this.jdtTreeBuilder.getContextBuilder().getCurrentNode() instanceof MessageSend)) {
            return false;
        }
        MessageSend parent = (MessageSend)this.jdtTreeBuilder.getContextBuilder().getCurrentNode();
        return parent.receiver != null && this.getFinalExpressionFromCast(parent.receiver).equals(this.childJDT) && !this.child.equals(ctInvocation.getTarget());
    }

    private Expression getFinalExpressionFromCast(Expression potentialCase) {
        if (!(potentialCase instanceof CastExpression)) {
            return potentialCase;
        }
        return this.getFinalExpressionFromCast(((CastExpression)potentialCase).expression);
    }

    @Override
    public <T> void visitCtNewArray(CtNewArray<T> newArray) {
        if (this.childJDT instanceof TypeReference && this.child instanceof CtTypeAccess) {
            ArrayAllocationExpression arrayAlloc = (ArrayAllocationExpression)this.jdtTreeBuilder.getContextBuilder().getCurrentNode();
            newArray.setType(this.jdtTreeBuilder.getFactory().Type().createArrayReference(((CtTypeAccess)this.child).getAccessedType(), arrayAlloc.dimensions.length));
        } else if (this.child instanceof CtExpression) {
            if (this.isContainedInDimensionExpression()) {
                newArray.addDimensionExpression((CtExpression)this.child);
            } else if (this.child instanceof CtNewArray && this.childJDT instanceof ArrayInitializer && this.jdtTreeBuilder.getContextBuilder().getCurrentNode() instanceof ArrayAllocationExpression) {
                newArray.setElements(((CtNewArray)this.child).getElements());
            } else {
                newArray.addElement((CtExpression)this.child);
            }
        }
    }

    private boolean isContainedInDimensionExpression() {
        if (!(this.jdtTreeBuilder.getContextBuilder().getCurrentNode() instanceof ArrayAllocationExpression)) {
            return false;
        }
        ArrayAllocationExpression parent = (ArrayAllocationExpression)this.jdtTreeBuilder.getContextBuilder().getCurrentNode();
        if (parent.dimensions == null) {
            return false;
        }
        for (Expression dimension : parent.dimensions) {
            if (dimension == null || !this.getFinalExpressionFromCast(dimension).equals(this.childJDT)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T> void visitCtConstructorCall(CtConstructorCall<T> ctConstructorCall) {
        if (this.child instanceof CtTypeAccess) {
            if (this.hasChildEqualsToType(ctConstructorCall)) {
                ctConstructorCall.getExecutable().setType(((CtTypeAccess)this.child).getAccessedType());
            } else {
                ctConstructorCall.addActualTypeArgument(((CtTypeAccess)this.child).getAccessedType());
            }
            return;
        }
        if (this.child instanceof CtExpression) {
            if (this.hasChildEqualsToEnclosingInstance(ctConstructorCall)) {
                ctConstructorCall.setTarget((CtExpression)this.child);
            } else {
                ctConstructorCall.addArgument((CtExpression)this.child);
            }
            return;
        }
        super.visitCtConstructorCall(ctConstructorCall);
    }

    private <T> boolean hasChildEqualsToEnclosingInstance(CtConstructorCall<T> ctConstructorCall) {
        if (!(this.jdtTreeBuilder.getContextBuilder().getCurrentNode() instanceof QualifiedAllocationExpression)) {
            return false;
        }
        QualifiedAllocationExpression parent = (QualifiedAllocationExpression)this.jdtTreeBuilder.getContextBuilder().getCurrentNode();
        return parent.enclosingInstance != null && this.getFinalExpressionFromCast(parent.enclosingInstance).equals(this.childJDT) && !this.child.equals(ctConstructorCall.getTarget());
    }

    private <T> boolean hasChildEqualsToType(CtConstructorCall<T> ctConstructorCall) {
        AllocationExpression parent = (AllocationExpression)this.jdtTreeBuilder.getContextBuilder().getCurrentNode();
        return parent.type != null && parent.type.equals(this.childJDT);
    }

    @Override
    public <T> void visitCtNewClass(CtNewClass<T> newClass) {
        if (this.child instanceof CtClass) {
            ReferenceBinding[] referenceBindings;
            newClass.setAnonymousClass((CtClass)this.child);
            QualifiedAllocationExpression node = (QualifiedAllocationExpression)this.jdtTreeBuilder.getContextBuilder().getCurrentNode();
            ReferenceBinding[] referenceBindingArray = referenceBindings = node.resolvedType == null ? null : node.resolvedType.superInterfaces();
            if (referenceBindings != null && referenceBindings.length > 0) {
                ((CtClass)this.child).setSuperInterfaces(Collections.singleton(this.cloneAsImplicit(newClass.getType())));
            } else if (newClass.getType() != null) {
                ((CtClass)this.child).setSuperclass(this.cloneAsImplicit(newClass.getType()));
            }
            return;
        }
        super.visitCtNewClass(newClass);
    }

    private <T extends CtElement> T cloneAsImplicit(T ele) {
        ele = ele.clone();
        ele.accept(new CtScanner(){

            @Override
            protected void enter(CtElement e) {
                e.setPosition(SourcePosition.NOPOSITION);
            }
        });
        ele.setImplicit(true);
        return (T)ele;
    }

    @Override
    public <T> void visitCtLambda(CtLambda<T> lambda) {
        if (this.child instanceof CtParameter) {
            lambda.addParameter((CtParameter)this.child);
            return;
        }
        if (this.child instanceof CtBlock) {
            lambda.setBody((CtBlock)this.child);
            return;
        }
        if (this.child instanceof CtExpression) {
            lambda.setExpression((CtExpression)this.child);
        }
        super.visitCtLambda(lambda);
    }

    @Override
    public <T, E extends CtExpression<?>> void visitCtExecutableReferenceExpression(CtExecutableReferenceExpression<T, E> expression) {
        if (this.child instanceof CtExpression) {
            expression.setTarget((CtExpression)this.child);
        } else if (this.child instanceof CtTypeParameterReference) {
            expression.getExecutable().addActualTypeArgument((CtTypeReference)this.child);
        }
        super.visitCtExecutableReferenceExpression(expression);
    }

    @Override
    public void visitCtPackage(CtPackage ctPackage) {
        if (this.child instanceof CtType) {
            CtType type = (CtType)this.child;
            if (ctPackage.getTypes().contains(type)) {
                ctPackage.removeType(type);
            }
            ctPackage.addType(type);
            CompilationUnit cu = type.getPosition().getCompilationUnit();
            if (cu != null) {
                cu.addDeclaredType(type);
            }
            return;
        }
        super.visitCtPackage(ctPackage);
    }

    @Override
    public <R> void visitCtReturn(CtReturn<R> returnStatement) {
        if (this.child instanceof CtExpression) {
            returnStatement.setReturnedExpression((CtExpression)this.child);
            return;
        }
        super.visitCtReturn(returnStatement);
    }

    @Override
    public <E> void visitCtSwitch(CtSwitch<E> switchStatement) {
        if (switchStatement.getSelector() == null && this.child instanceof CtExpression) {
            switchStatement.setSelector((CtExpression)this.child);
            return;
        }
        if (this.child instanceof CtCase) {
            switchStatement.addCase((CtCase)this.child);
            this.child.setPosition(this.jdtTreeBuilder.getPositionBuilder().buildPosition((CtCase)this.child));
            return;
        }
        super.visitCtSwitch(switchStatement);
    }

    @Override
    public <T, S> void visitCtSwitchExpression(CtSwitchExpression<T, S> switchExpression) {
        if (switchExpression.getSelector() == null && this.child instanceof CtExpression) {
            switchExpression.setSelector((CtExpression)this.child);
            return;
        }
        if (this.child instanceof CtCase) {
            switchExpression.addCase((CtCase)this.child);
            this.child.setPosition(this.jdtTreeBuilder.getPositionBuilder().buildPosition((CtCase)this.child));
            return;
        }
        super.visitCtSwitchExpression(switchExpression);
    }

    @Override
    public void visitCtSynchronized(CtSynchronized synchro) {
        if (synchro.getExpression() == null && this.child instanceof CtExpression) {
            synchro.setExpression((CtExpression)this.child);
            return;
        }
        if (synchro.getBlock() == null && this.child instanceof CtBlock) {
            synchro.setBlock((CtBlock)this.child);
            return;
        }
        super.visitCtSynchronized(synchro);
    }

    @Override
    public void visitCtThrow(CtThrow throwStatement) {
        if (throwStatement.getThrownExpression() == null && this.child instanceof CtExpression) {
            throwStatement.setThrownExpression((CtExpression)this.child);
            return;
        }
        super.visitCtThrow(throwStatement);
    }

    @Override
    public void visitCtTry(CtTry tryBlock) {
        if (this.child instanceof CtBlock) {
            CtBlock childBlock = (CtBlock)this.child;
            CtCatch lastCatcher = this.getLastCatcher(tryBlock);
            if (lastCatcher != null && lastCatcher.getBody() == null) {
                lastCatcher.setBody(childBlock);
                lastCatcher.setPosition(this.jdtTreeBuilder.getPositionBuilder().buildPosition(lastCatcher));
            } else if (tryBlock.getBody() != null && tryBlock.getFinalizer() == null) {
                tryBlock.setFinalizer(childBlock);
            } else {
                tryBlock.setBody(childBlock);
            }
            return;
        }
        if (this.child instanceof CtCatch) {
            tryBlock.addCatcher((CtCatch)this.child);
            return;
        }
        super.visitCtTry(tryBlock);
    }

    private @Nullable CtCatch getLastCatcher(CtTry tryBlock) {
        List<CtCatch> catchers = tryBlock.getCatchers();
        int nrCatchers = catchers.size();
        if (nrCatchers > 0) {
            return catchers.get(nrCatchers - 1);
        }
        return null;
    }

    @Override
    public void visitCtTryWithResource(CtTryWithResource tryWithResource) {
        if (this.child instanceof CtLocalVariable) {
            CtLocalVariable var = (CtLocalVariable)this.child;
            tryWithResource.addResource(var);
        } else if (this.child instanceof CtVariableRead) {
            CtVariableRead read = (CtVariableRead)this.child;
            tryWithResource.addResource(read);
        }
        super.visitCtTryWithResource(tryWithResource);
    }

    @Override
    public <T> void visitCtUnaryOperator(CtUnaryOperator<T> operator) {
        if (operator.getOperand() == null && this.child instanceof CtExpression) {
            operator.setOperand((CtExpression)this.child);
            return;
        }
        super.visitCtUnaryOperator(operator);
    }

    @Override
    public void visitCtWildcardReference(CtWildcardReference e) {
        if (this.childJDT instanceof TypeReference && this.child instanceof CtTypeAccess) {
            e.setBoundingType(((CtTypeAccess)this.child).getAccessedType());
        }
        super.visitCtWildcardReference(e);
    }

    @Override
    public void visitCtYieldStatement(CtYieldStatement e) {
        if (this.child instanceof CtExpression) {
            e.setExpression((CtExpression)this.child);
            if (e.isImplicit()) {
                e.setPosition(this.child.getPosition());
            }
            return;
        }
        super.visitCtYieldStatement(e);
    }

    @Override
    public void visitCtTypePattern(CtTypePattern pattern) {
        if (this.child instanceof CtLocalVariable) {
            pattern.setVariable((CtLocalVariable)this.child);
        }
        super.visitCtTypePattern(pattern);
    }

    @Override
    public void visitCtRecord(CtRecord recordType) {
        if (this.child instanceof CtConstructor) {
            CtConstructor newConstructor = (CtConstructor)this.child;
            ParentExiter.adjustConstructors(recordType, newConstructor);
        }
        if (this.child instanceof CtAnonymousExecutable) {
            recordType.addAnonymousExecutable((CtAnonymousExecutable)this.child);
        }
        if (this.child instanceof CtRecordComponent) {
            recordType.addRecordComponent((CtRecordComponent)this.child);
        }
        super.visitCtRecord(recordType);
    }

    @Override
    public void visitCtRecordPattern(CtRecordPattern pattern) {
        CtElement child = this.adjustIfLocalVariableToTypePattern(this.child);
        if (child instanceof CtTypeReference) {
            CtTypeReference typeReference = (CtTypeReference)child;
            pattern.setRecordType((CtTypeReference<?>)typeReference.clone());
        } else if (child instanceof CtPattern) {
            CtPattern innerPattern = (CtPattern)child;
            pattern.addPattern(innerPattern);
        }
    }

    private static void adjustConstructors(CtRecord recordType, CtConstructor<Object> newConstructor) {
        if (newConstructor.isImplicit()) {
            for (CtConstructor<Object> ctConstructor : recordType.getConstructors()) {
                if (!ParentExiter.hasSameParameters(newConstructor, ctConstructor)) continue;
                return;
            }
        } else {
            for (CtConstructor<Object> ctConstructor : recordType.getConstructors()) {
                if (!ctConstructor.isImplicit() || !ParentExiter.hasSameParameters(newConstructor, ctConstructor)) continue;
                recordType.removeConstructor(ctConstructor);
            }
        }
        recordType.addConstructor(newConstructor);
    }

    private static boolean hasSameParameters(CtConstructor<Object> newConstructor, CtConstructor<Object> constructor) {
        return constructor.getSignature().endsWith(newConstructor.getSignature());
    }

    @Override
    public void visitCtRecordComponent(CtRecordComponent recordComponent) {
        if (this.childJDT instanceof TypeReference && this.child instanceof CtTypeAccess) {
            recordComponent.setType(((CtTypeAccess)this.child).getAccessedType());
            this.substituteAnnotation(recordComponent);
            return;
        }
        this.scanCtElement(recordComponent);
    }
}

