/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.compiler.jdt;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import spoon.reflect.declaration.ModifierKind;

enum ModifierTarget {
    FIELD(ModifierKind.PUBLIC, ModifierKind.PROTECTED, ModifierKind.PRIVATE, ModifierKind.STRICTFP, ModifierKind.FINAL, ModifierKind.TRANSIENT, ModifierKind.VOLATILE),
    LOCAL_VARIABLE(ModifierKind.FINAL, new ModifierKind[0]),
    METHOD(ModifierKind.PUBLIC, ModifierKind.PROTECTED, ModifierKind.PRIVATE, ModifierKind.ABSTRACT, ModifierKind.STATIC, ModifierKind.FINAL, ModifierKind.SYNCHRONIZED, ModifierKind.NATIVE, ModifierKind.STRICTFP),
    CONSTRUCTOR(ModifierKind.PUBLIC, ModifierKind.PROTECTED, ModifierKind.PRIVATE),
    CLASS(ModifierKind.PUBLIC, ModifierKind.PROTECTED, ModifierKind.PRIVATE, ModifierKind.ABSTRACT, ModifierKind.STATIC, ModifierKind.SEALED, ModifierKind.NON_SEALED, ModifierKind.FINAL, ModifierKind.STRICTFP),
    INTERFACE(ModifierKind.PUBLIC, ModifierKind.PROTECTED, ModifierKind.PRIVATE, ModifierKind.ABSTRACT, ModifierKind.STATIC, ModifierKind.SEALED, ModifierKind.NON_SEALED, ModifierKind.STRICTFP),
    PARAMETER(ModifierKind.FINAL, new ModifierKind[0]);

    private Set<ModifierTarget> singleton;
    private final Set<ModifierKind> allowedKinds;
    public static final Set<ModifierTarget> NONE;
    public static final Set<ModifierTarget> VARIABLE;
    public static final Set<ModifierTarget> EXECUTABLE;
    public static final Set<ModifierTarget> TYPE;

    private ModifierTarget(ModifierKind firstAllowed, ModifierKind ... allowedKinds) {
        this.allowedKinds = Collections.unmodifiableSet(EnumSet.of(firstAllowed, allowedKinds));
    }

    public Set<ModifierTarget> asSingleton() {
        if (this.singleton == null) {
            this.singleton = Collections.singleton(this);
        }
        return this.singleton;
    }

    public Set<ModifierKind> getAllowedKinds() {
        return this.allowedKinds;
    }

    static {
        NONE = Collections.emptySet();
        VARIABLE = Collections.unmodifiableSet(EnumSet.of(FIELD, LOCAL_VARIABLE));
        EXECUTABLE = Collections.unmodifiableSet(EnumSet.of(METHOD, CONSTRUCTOR));
        TYPE = Collections.unmodifiableSet(EnumSet.of(CLASS, INTERFACE));
    }
}

