/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.compiler.jdt;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemFieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.UnaryOperatorKind;
import spoon.reflect.declaration.CtAnnotatedElementType;
import spoon.reflect.declaration.ModifierKind;
import spoon.support.compiler.jdt.ContextBuilder;
import spoon.support.compiler.jdt.ModifierTarget;
import spoon.support.reflect.CtExtendedModifier;

class JDTTreeBuilderQuery {
    private JDTTreeBuilderQuery() {
    }

    static TypeBinding searchTypeBinding(ReferenceBinding type, String simpleName) {
        if (simpleName == null || type == null) {
            return null;
        }
        if (type.memberTypes() != null) {
            for (ReferenceBinding memberType : type.memberTypes()) {
                if (!simpleName.equals(CharOperation.charToString((char[])memberType.sourceName()))) continue;
                return memberType;
            }
        }
        return JDTTreeBuilderQuery.searchTypeBinding(type.superclass(), simpleName);
    }

    static TypeBinding searchTypeBinding(String qualifiedName, CompilationUnitDeclaration[] unitsToProcess) {
        if (qualifiedName == null) {
            return null;
        }
        for (CompilationUnitDeclaration unitToProcess : unitsToProcess) {
            if (unitToProcess.types == null) continue;
            for (TypeDeclaration type : unitToProcess.types) {
                if (JDTTreeBuilderQuery.qualifiedNameEqualsBindingCompoundName(qualifiedName, type)) {
                    return type.binding;
                }
                if (type.memberTypes == null) continue;
                for (TypeDeclaration memberType : type.memberTypes) {
                    if (!JDTTreeBuilderQuery.qualifiedNameEqualsBindingCompoundName(qualifiedName, memberType)) continue;
                    return type.binding;
                }
            }
        }
        return null;
    }

    private static boolean qualifiedNameEqualsBindingCompoundName(String qualifiedName, TypeDeclaration type) {
        return type.binding != null && qualifiedName.equals(CharOperation.toString((char[][])type.binding.compoundName));
    }

    static String searchType(String typeName, ImportReference[] imports) {
        if (typeName == null || imports == null) {
            return null;
        }
        for (ImportReference anImport : imports) {
            String importType = CharOperation.charToString((char[])anImport.getImportName()[anImport.getImportName().length - 1]);
            if (!typeName.equals(importType)) continue;
            return CharOperation.toString((char[][])anImport.getImportName());
        }
        return null;
    }

    static ImportReference searchPackage(char[][] packageName, CompilationUnitDeclaration[] unitsToProcess) {
        for (CompilationUnitDeclaration unit : unitsToProcess) {
            char[][] tokens;
            ImportReference currentPackage = unit.currentPackage;
            if (currentPackage == null || packageName.length > (tokens = currentPackage.tokens).length) continue;
            boolean isFound = true;
            for (int i = 0; i < packageName.length; ++i) {
                char[] chars = packageName[i];
                if (CharOperation.equals((char[])chars, (char[])tokens[i])) continue;
                isFound = false;
                break;
            }
            if (!isFound) continue;
            return currentPackage;
        }
        return null;
    }

    static boolean hasAnnotationWithType(Annotation a, CtAnnotatedElementType elementType) {
        if (a.resolvedType == null) {
            return false;
        }
        boolean shouldTargetAnnotationExists = elementType == CtAnnotatedElementType.TYPE_USE || elementType == CtAnnotatedElementType.TYPE_PARAMETER;
        boolean targetAnnotationExists = false;
        for (AnnotationBinding annotation : a.resolvedType.getAnnotations()) {
            Object[] fields;
            if (annotation == null || !"Target".equals(CharOperation.charToString((char[])annotation.getAnnotationType().sourceName()))) continue;
            targetAnnotationExists = true;
            Object value = annotation.getElementValuePairs()[0].value;
            if (value == null) continue;
            if (value instanceof FieldBinding && elementType.name().equals(CharOperation.charToString((char[])((FieldBinding)value).name))) {
                return true;
            }
            if (!value.getClass().isArray()) continue;
            for (Object field : fields = (Object[])value) {
                if (!(field instanceof FieldBinding) || !elementType.name().equals(CharOperation.charToString((char[])((FieldBinding)field).name))) continue;
                return true;
            }
        }
        return !shouldTargetAnnotationExists && !targetAnnotationExists;
    }

    static boolean isValidProblemBindingField(QualifiedNameReference qualifiedNameReference) {
        return qualifiedNameReference.binding instanceof ProblemFieldBinding && !((FieldBinding)qualifiedNameReference.binding).declaringClass.isAnonymousType() && qualifiedNameReference.tokens.length - 1 == ((FieldBinding)qualifiedNameReference.binding).declaringClass.compoundName.length && CharOperation.equals((char[][])CharOperation.subarray((char[][])qualifiedNameReference.tokens, (int)0, (int)(qualifiedNameReference.tokens.length - 1)), (char[][])((FieldBinding)qualifiedNameReference.binding).declaringClass.compoundName);
    }

    static boolean isFieldReference(QualifiedNameReference qualifiedNameReference) {
        return qualifiedNameReference.binding instanceof FieldBinding;
    }

    static boolean isLhsAssignment(ContextBuilder context, Expression lhs) {
        return context.getCurrentNode() instanceof Assignment && ((Assignment)context.getCurrentNode()).lhs.equals(lhs);
    }

    static UnaryOperatorKind getUnaryOperator(int operator) {
        switch (operator) {
            case 14: {
                return UnaryOperatorKind.POS;
            }
            case 13: {
                return UnaryOperatorKind.NEG;
            }
            case 11: {
                return UnaryOperatorKind.NOT;
            }
            case 12: {
                return UnaryOperatorKind.COMPL;
            }
        }
        return null;
    }

    static BinaryOperatorKind getBinaryOperatorKind(int operator) {
        switch (operator) {
            case 18: {
                return BinaryOperatorKind.EQ;
            }
            case 5: {
                return BinaryOperatorKind.LE;
            }
            case 7: {
                return BinaryOperatorKind.GE;
            }
            case 20: {
                return BinaryOperatorKind.NE;
            }
            case 10: {
                return BinaryOperatorKind.SL;
            }
            case 17: {
                return BinaryOperatorKind.SR;
            }
            case 19: {
                return BinaryOperatorKind.USR;
            }
            case 1: {
                return BinaryOperatorKind.OR;
            }
            case 0: {
                return BinaryOperatorKind.AND;
            }
            case 14: {
                return BinaryOperatorKind.PLUS;
            }
            case 13: {
                return BinaryOperatorKind.MINUS;
            }
            case 11: {
                return BinaryOperatorKind.NE;
            }
            case 16: {
                return BinaryOperatorKind.MOD;
            }
            case 8: {
                return BinaryOperatorKind.BITXOR;
            }
            case 2: {
                return BinaryOperatorKind.BITAND;
            }
            case 15: {
                return BinaryOperatorKind.MUL;
            }
            case 3: {
                return BinaryOperatorKind.BITOR;
            }
            case 9: {
                return BinaryOperatorKind.DIV;
            }
            case 6: {
                return BinaryOperatorKind.GT;
            }
            case 4: {
                return BinaryOperatorKind.LT;
            }
            case 22: {
                throw new RuntimeException("Unknown operator");
            }
            case 21: {
                return BinaryOperatorKind.EQ;
            }
        }
        return null;
    }

    static Set<CtExtendedModifier> getModifiers(int modifier, boolean implicit, Set<ModifierTarget> target) {
        HashSet<CtExtendedModifier> modifiers = new HashSet<CtExtendedModifier>();
        if ((modifier & 1) != 0) {
            modifiers.add(new CtExtendedModifier(ModifierKind.PUBLIC, implicit));
        }
        if ((modifier & 2) != 0) {
            modifiers.add(new CtExtendedModifier(ModifierKind.PRIVATE, implicit));
        }
        if ((modifier & 4) != 0) {
            modifiers.add(new CtExtendedModifier(ModifierKind.PROTECTED, implicit));
        }
        if ((modifier & 8) != 0) {
            modifiers.add(new CtExtendedModifier(ModifierKind.STATIC, implicit));
        }
        if ((modifier & 0x10) != 0) {
            modifiers.add(new CtExtendedModifier(ModifierKind.FINAL, implicit));
        }
        if ((modifier & 0x20) != 0) {
            modifiers.add(new CtExtendedModifier(ModifierKind.SYNCHRONIZED, implicit));
        }
        if ((modifier & 0x40) != 0) {
            modifiers.add(new CtExtendedModifier(ModifierKind.VOLATILE, implicit));
        }
        if ((modifier & 0x80) != 0 && target.contains((Object)ModifierTarget.FIELD)) {
            modifiers.add(new CtExtendedModifier(ModifierKind.TRANSIENT, implicit));
        }
        if ((modifier & 0x400) != 0) {
            modifiers.add(new CtExtendedModifier(ModifierKind.ABSTRACT, implicit));
        }
        if ((modifier & 0x800) != 0) {
            modifiers.add(new CtExtendedModifier(ModifierKind.STRICTFP, implicit));
        }
        if ((modifier & 0x100) != 0) {
            modifiers.add(new CtExtendedModifier(ModifierKind.NATIVE, implicit));
        }
        if ((modifier & 0x10000000) != 0 && JDTTreeBuilderQuery.intersect(target, ModifierTarget.TYPE)) {
            modifiers.add(new CtExtendedModifier(ModifierKind.SEALED, implicit));
        } else if ((modifier & 0x4000000) != 0 && JDTTreeBuilderQuery.intersect(target, ModifierTarget.TYPE)) {
            modifiers.add(new CtExtendedModifier(ModifierKind.NON_SEALED, implicit));
        }
        return modifiers;
    }

    static Set<CtExtendedModifier> getModifiers(int modifier, boolean implicit, ModifierTarget target) {
        return JDTTreeBuilderQuery.getModifiers(modifier, implicit, target.asSingleton());
    }

    private static <E> boolean intersect(Set<E> first, Set<E> second) {
        return !Collections.disjoint(first, second);
    }
}

