/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.compiler.jdt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Consumer;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.ModuleDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ModuleReference;
import org.eclipse.jdt.internal.compiler.ast.PackageVisibilityStatement;
import org.eclipse.jdt.internal.compiler.ast.ProvidesStatement;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Receiver;
import org.eclipse.jdt.internal.compiler.ast.ReferenceExpression;
import org.eclipse.jdt.internal.compiler.ast.RequiresStatement;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.UnionTypeReference;
import org.eclipse.jdt.internal.compiler.ast.UsesStatement;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MissingTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;
import org.jspecify.annotations.Nullable;
import spoon.SpoonException;
import spoon.reflect.code.CtCatchVariable;
import spoon.reflect.code.CtExecutableReferenceExpression;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtLambda;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtModule;
import spoon.reflect.declaration.CtModuleRequirement;
import spoon.reflect.declaration.CtPackageExport;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtProvidedService;
import spoon.reflect.declaration.CtReceiverParameter;
import spoon.reflect.declaration.CtSealable;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtUsedService;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.factory.CoreFactory;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtModuleReference;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtParameterReference;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtVariableReference;
import spoon.support.compiler.jdt.ASTPair;
import spoon.support.compiler.jdt.ContextBuilder;
import spoon.support.compiler.jdt.JDTTreeBuilder;
import spoon.support.compiler.jdt.JDTTreeBuilderQuery;
import spoon.support.compiler.jdt.ModifierTarget;
import spoon.support.compiler.jdt.PositionBuilder;
import spoon.support.compiler.jdt.ReferenceBuilder;
import spoon.support.reflect.CtExtendedModifier;

public class JDTTreeBuilderHelper {
    private final JDTTreeBuilder jdtTreeBuilder;

    JDTTreeBuilderHelper(JDTTreeBuilder jdtTreeBuilder) {
        this.jdtTreeBuilder = jdtTreeBuilder;
    }

    static String computeAnonymousName(char[] anonymousQualifiedName) {
        String poolName = CharOperation.charToString((char[])anonymousQualifiedName);
        return poolName.substring(poolName.lastIndexOf("$") + 1);
    }

    static String createQualifiedTypeName(char[][] typeName) {
        StringJoiner joiner = new StringJoiner(".");
        for (char[] typeNamePart : typeName) {
            joiner.add(CharOperation.charToString((char[])typeNamePart));
        }
        return joiner.toString();
    }

    CtCatchVariable<Throwable> createCatchVariable(TypeReference typeReference, Scope scope) {
        Argument jdtCatch = (Argument)this.jdtTreeBuilder.getContextBuilder().getCurrentNode();
        Set<CtExtendedModifier> modifiers = JDTTreeBuilderQuery.getModifiers(jdtCatch.modifiers, false, ModifierTarget.LOCAL_VARIABLE);
        CtCatchVariable<Throwable> result = this.jdtTreeBuilder.getFactory().Core().createCatchVariable();
        ((CtCatchVariable)result.setSimpleName(CharOperation.charToString((char[])jdtCatch.name))).setExtendedModifiers(modifiers);
        if (typeReference instanceof UnionTypeReference) {
            return result;
        }
        CtTypeReference ctTypeReference = this.jdtTreeBuilder.getReferencesBuilder().buildTypeReference(typeReference, scope);
        return (CtCatchVariable)result.setType(ctTypeReference);
    }

    public <T> CtVariableAccess<T> createVariableAccess(CtVariableReference<T> variableReference, boolean isReadAccess) {
        CtVariableAccess<T> variableAccess = isReadAccess ? this.jdtTreeBuilder.getFactory().Core().createVariableWrite() : this.jdtTreeBuilder.getFactory().Core().createVariableRead();
        return variableAccess.setVariable(variableReference);
    }

    <T> CtVariableAccess<T> createVariableAccess(SingleNameReference singleNameReference) {
        CtVariableAccess va = JDTTreeBuilderQuery.isLhsAssignment(this.jdtTreeBuilder.getContextBuilder(), (Expression)singleNameReference) ? this.jdtTreeBuilder.getFactory().Core().createVariableWrite() : this.jdtTreeBuilder.getFactory().Core().createVariableRead();
        va.setVariable(this.jdtTreeBuilder.getReferencesBuilder().getVariableReference((VariableBinding)singleNameReference.binding));
        return va;
    }

    <T> CtVariableAccess<T> createVariableAccessNoClasspath(SingleNameReference singleNameReference) {
        CtVariableAccess variableAccess;
        CtParameterReference variableReference;
        CoreFactory coreFactory = this.jdtTreeBuilder.getFactory().Core();
        ContextBuilder contextBuilder = this.jdtTreeBuilder.getContextBuilder();
        ReferenceBuilder referenceBuilder = this.jdtTreeBuilder.getReferencesBuilder();
        PositionBuilder positionBuilder = this.jdtTreeBuilder.getPositionBuilder();
        String name = CharOperation.charToString((char[])singleNameReference.token);
        CtVariable variable = contextBuilder.getVariableDeclaration(name);
        if (variable == null) {
            return null;
        }
        if (variable instanceof CtParameter) {
            CtParameterReference parameterReference = coreFactory.createParameterReference();
            if (!(variable.getParent() instanceof CtLambda)) {
                CtExecutable executable = (CtExecutable)variable.getParent();
                AbstractMethodDeclaration executableJDT = null;
                for (ASTPair astPair : contextBuilder.getAllContexts()) {
                    if (astPair.element() != executable) continue;
                    executableJDT = (AbstractMethodDeclaration)astPair.node();
                }
                assert (executableJDT != null);
                CtTypeReference ctTypeReference = executableJDT.binding == null ? coreFactory.createTypeReference() : referenceBuilder.getTypeReference((TypeBinding)executableJDT.binding.declaringClass);
            }
            variableReference = parameterReference;
            variableAccess = JDTTreeBuilderQuery.isLhsAssignment(contextBuilder, (Expression)singleNameReference) ? coreFactory.createVariableWrite() : coreFactory.createVariableRead();
        } else if (variable instanceof CtField) {
            variableReference = variable.getReference();
            variableAccess = JDTTreeBuilderQuery.isLhsAssignment(contextBuilder, (Expression)singleNameReference) ? coreFactory.createFieldWrite() : coreFactory.createFieldRead();
        } else {
            variableReference = variable.getReference();
            variableAccess = JDTTreeBuilderQuery.isLhsAssignment(contextBuilder, (Expression)singleNameReference) ? coreFactory.createVariableWrite() : coreFactory.createVariableRead();
        }
        variableReference.setSimpleName(name);
        variableReference.setPosition(positionBuilder.buildPosition(singleNameReference.sourceStart(), singleNameReference.sourceEnd()));
        variableAccess.setVariable(variableReference);
        return variableAccess;
    }

    <T> CtVariableAccess<T> createVariableAccess(QualifiedNameReference qualifiedNameReference) {
        CtVariableAccess va;
        CtVariableReference ref;
        boolean isOtherBinding;
        long[] positions = qualifiedNameReference.sourcePositions;
        int sourceStart = qualifiedNameReference.sourceStart();
        int sourceEnd = qualifiedNameReference.sourceEnd();
        if (qualifiedNameReference.indexOfFirstFieldBinding < positions.length) {
            sourceEnd = (int)(positions[qualifiedNameReference.indexOfFirstFieldBinding] >>> 32) - 2;
        }
        boolean fromAssignment = JDTTreeBuilderQuery.isLhsAssignment(this.jdtTreeBuilder.getContextBuilder(), (Expression)qualifiedNameReference);
        boolean bl = isOtherBinding = qualifiedNameReference.otherBindings == null || qualifiedNameReference.otherBindings.length == 0;
        if (qualifiedNameReference.binding instanceof FieldBinding) {
            ref = this.jdtTreeBuilder.getReferencesBuilder().getVariableReference((VariableBinding)qualifiedNameReference.fieldBinding());
            ref.setPosition(this.jdtTreeBuilder.getPositionBuilder().buildPosition(this.getVariableReferenceSourceStart(sourceStart, sourceEnd), sourceEnd));
            va = this.createFieldAccess(ref, this.createTargetFieldAccess(qualifiedNameReference, (CtFieldReference)ref), isOtherBinding && fromAssignment);
        } else {
            ref = this.jdtTreeBuilder.getReferencesBuilder().getVariableReference((VariableBinding)qualifiedNameReference.binding);
            ref.setPosition(this.jdtTreeBuilder.getPositionBuilder().buildPosition(this.getVariableReferenceSourceStart(sourceStart, sourceEnd), sourceEnd));
            va = this.createVariableAccess(ref, isOtherBinding && fromAssignment);
        }
        if (qualifiedNameReference.otherBindings != null) {
            int i = 0;
            va.setPosition(this.jdtTreeBuilder.getPositionBuilder().buildPosition(sourceStart, sourceEnd));
            sourceStart = (int)(positions[qualifiedNameReference.indexOfFirstFieldBinding - 1] >>> 32);
            @Nullable TypeBinding declaringType = ((VariableBinding)qualifiedNameReference.binding).type;
            for (FieldBinding b : qualifiedNameReference.otherBindings) {
                isOtherBinding = qualifiedNameReference.otherBindings.length == i + 1;
                CtFieldAccess other = this.createFieldAccess(this.jdtTreeBuilder.getReferencesBuilder().getVariableReference(declaringType, b, qualifiedNameReference.tokens[i + 1]), va, isOtherBinding && fromAssignment);
                sourceEnd = i + qualifiedNameReference.indexOfFirstFieldBinding >= qualifiedNameReference.otherBindings.length ? qualifiedNameReference.sourceEnd() : (int)(positions[qualifiedNameReference.indexOfFirstFieldBinding + i + 1] >>> 32) - 2;
                other.setPosition(this.jdtTreeBuilder.getPositionBuilder().buildPosition(sourceStart, sourceEnd));
                va = other;
                declaringType = b != null ? b.type : null;
                ++i;
            }
        } else if (!(qualifiedNameReference.binding instanceof FieldBinding) && qualifiedNameReference.tokens.length > 1) {
            sourceStart = (int)(positions[0] >>> 32);
            for (int i = 1; i < qualifiedNameReference.tokens.length; ++i) {
                isOtherBinding = qualifiedNameReference.tokens.length == i + 1;
                TypeBinding type = ((VariableBinding)qualifiedNameReference.binding).type;
                CtFieldAccess other = this.createFieldAccess(this.jdtTreeBuilder.getReferencesBuilder().getVariableReference(type, null, qualifiedNameReference.tokens[i]), va, isOtherBinding && fromAssignment);
                sourceEnd = (int)positions[i];
                va.setPosition(this.jdtTreeBuilder.getPositionBuilder().buildPosition(sourceStart, sourceEnd));
                va = other;
            }
        }
        va.setPosition(this.jdtTreeBuilder.getPositionBuilder().buildPosition(qualifiedNameReference.sourceStart(), qualifiedNameReference.sourceEnd()));
        return va;
    }

    private int getVariableReferenceSourceStart(int sourceStart, int sourceEnd) {
        char[] contents = this.jdtTreeBuilder.getContextBuilder().getCompilationUnitContents();
        int lastIdentifierStart = sourceStart;
        int dotIdx;
        while ((dotIdx = PositionBuilder.findNextChar(contents, sourceEnd, lastIdentifierStart, '.')) >= 0) {
            lastIdentifierStart = dotIdx + 1;
        }
        return lastIdentifierStart;
    }

    public <T> CtFieldAccess<T> createFieldAccess(CtVariableReference<T> variableReference, CtExpression<?> target, boolean isReadAccess) {
        CtFieldAccess<T> fieldAccess = isReadAccess ? this.jdtTreeBuilder.getFactory().Core().createFieldWrite() : this.jdtTreeBuilder.getFactory().Core().createFieldRead();
        fieldAccess.setVariable(variableReference);
        fieldAccess.setTarget(target);
        return fieldAccess;
    }

    <T> CtFieldAccess<T> createFieldAccess(SingleNameReference singleNameReference) {
        CtFieldAccess va = JDTTreeBuilderQuery.isLhsAssignment(this.jdtTreeBuilder.getContextBuilder(), (Expression)singleNameReference) ? this.jdtTreeBuilder.getFactory().Core().createFieldWrite() : this.jdtTreeBuilder.getFactory().Core().createFieldRead();
        va.setVariable(this.jdtTreeBuilder.getReferencesBuilder().getVariableReference((VariableBinding)singleNameReference.fieldBinding().original()));
        if (va.getVariable() != null) {
            CtVariableReference ref = va.getVariable();
            if (ref.isStatic() && !ref.getDeclaringType().isAnonymous()) {
                va.setTarget(this.jdtTreeBuilder.getFactory().Code().createTypeAccess(ref.getDeclaringType(), true));
            } else if (!ref.isStatic()) {
                ReferenceBinding fieldDeclarerType = singleNameReference.fieldBinding().declaringClass;
                TypeBinding actualReceiverType = singleNameReference.actualReceiverType;
                CtTypeReference owningType = this.jdtTreeBuilder.getReferencesBuilder().getTypeReference((TypeBinding)fieldDeclarerType);
                if (Arrays.equals(fieldDeclarerType.qualifiedSourceName(), actualReceiverType.qualifiedSourceName())) {
                    va.setTarget(this.jdtTreeBuilder.getFactory().Code().createThisAccess(owningType, true));
                } else {
                    va.setTarget((CtExpression)this.jdtTreeBuilder.getFactory().createSuperAccess().setType(owningType).setImplicit(true));
                }
            }
        }
        return va;
    }

    <T> CtFieldAccess<T> createFieldAccessNoClasspath(SingleNameReference singleNameReference) {
        CtFieldAccess va = JDTTreeBuilderQuery.isLhsAssignment(this.jdtTreeBuilder.getContextBuilder(), (Expression)singleNameReference) ? this.jdtTreeBuilder.getFactory().Core().createFieldWrite() : this.jdtTreeBuilder.getFactory().Core().createFieldRead();
        va.setVariable(this.jdtTreeBuilder.getReferencesBuilder().getVariableReference((ProblemBinding)singleNameReference.binding));
        CtReference declaring = this.jdtTreeBuilder.getReferencesBuilder().getDeclaringReferenceFromImports(singleNameReference.token);
        if (declaring instanceof CtTypeReference && va.getVariable() != null) {
            CtTypeReference declaringRef = (CtTypeReference)declaring;
            va.setTarget(this.jdtTreeBuilder.getFactory().Code().createTypeAccess(declaringRef, true));
            va.getVariable().setDeclaringType(declaringRef);
            va.getVariable().setStatic(true);
        }
        return va;
    }

    boolean isProblemNameRefProbablyTypeRef(QualifiedNameReference qualifiedNameReference) {
        ContextBuilder contextBuilder = this.jdtTreeBuilder.getContextBuilder();
        if (contextBuilder.compilationunitdeclaration == null) {
            return false;
        }
        if (contextBuilder.compilationunitdeclaration.imports == null) {
            return false;
        }
        char[][] ourName = qualifiedNameReference.tokens;
        for (ImportReference anImport : contextBuilder.compilationunitdeclaration.imports) {
            char[][] importName = anImport.getImportName();
            int i = JDTTreeBuilderHelper.indexOfSubList(importName, ourName);
            if (i <= 0) continue;
            boolean extendsToEndOfImport = i + ourName.length == importName.length;
            boolean isStaticImport = anImport.isStatic();
            if (!isStaticImport) {
                return true;
            }
            char[] simpleName = qualifiedNameReference.tokens[qualifiedNameReference.tokens.length - 1];
            return !extendsToEndOfImport || !Character.isLowerCase(simpleName[0]);
        }
        return false;
    }

    private static int indexOfSubList(char[][] haystack, char[][] needle) {
        block0: for (int i = 0; i < haystack.length - needle.length; ++i) {
            for (int j = 0; j < needle.length; ++j) {
                if (!Arrays.equals(haystack[i + j], needle[j])) continue block0;
            }
            return i;
        }
        return -1;
    }

    <T> CtFieldAccess<T> createFieldAccessNoClasspath(QualifiedNameReference qualifiedNameReference) {
        boolean fromAssignment = JDTTreeBuilderQuery.isLhsAssignment(this.jdtTreeBuilder.getContextBuilder(), (Expression)qualifiedNameReference);
        CtFieldAccess fieldAccess = this.createFieldAccess(this.jdtTreeBuilder.getReferencesBuilder().getVariableReference((ProblemBinding)qualifiedNameReference.binding), null, fromAssignment);
        char[][] declaringClass = CharOperation.subarray((char[][])qualifiedNameReference.tokens, (int)0, (int)(qualifiedNameReference.tokens.length - 1));
        MissingTypeBinding declaringType = this.jdtTreeBuilder.getContextBuilder().compilationunitdeclaration.scope.environment.createMissingType(null, declaringClass);
        CtTypeReference declaringRef = this.jdtTreeBuilder.getReferencesBuilder().getTypeReference((TypeBinding)declaringType);
        fieldAccess.getVariable().setDeclaringType(declaringRef);
        fieldAccess.getVariable().setStatic(true);
        fieldAccess.setTarget(this.jdtTreeBuilder.getFactory().Code().createTypeAccess(declaringRef));
        fieldAccess.getVariable().setSimpleName(JDTTreeBuilderHelper.createQualifiedTypeName(CharOperation.subarray((char[][])qualifiedNameReference.tokens, (int)(qualifiedNameReference.tokens.length - 1), (int)qualifiedNameReference.tokens.length)));
        return fieldAccess;
    }

    <T> CtFieldAccess<T> createFieldAccess(FieldReference fieldReference) {
        CtFieldAccess fieldAccess = JDTTreeBuilderQuery.isLhsAssignment(this.jdtTreeBuilder.getContextBuilder(), (Expression)fieldReference) ? this.jdtTreeBuilder.getFactory().Core().createFieldWrite() : this.jdtTreeBuilder.getFactory().Core().createFieldRead();
        fieldAccess.setVariable(this.jdtTreeBuilder.getReferencesBuilder().getVariableReference(fieldReference.actualReceiverType, fieldReference.binding, fieldReference.token));
        fieldAccess.setType(this.jdtTreeBuilder.getReferencesBuilder().getTypeReference(fieldReference.resolvedType));
        return fieldAccess;
    }

    CtTypeAccess<?> createTypeAccess(QualifiedNameReference qualifiedNameReference, CtFieldReference<?> fieldReference) {
        TypeBinding receiverType = qualifiedNameReference.actualReceiverType;
        if (receiverType != null) {
            CtTypeReference qualifiedRef = this.jdtTreeBuilder.getReferencesBuilder().getQualifiedTypeReference(qualifiedNameReference.tokens, receiverType, qualifiedNameReference.fieldBinding().declaringClass.enclosingType(), new JDTTreeBuilder.OnAccessListener(){

                @Override
                public boolean onAccess(char[][] tokens, int index) {
                    return !CharOperation.equals((char[])tokens[index + 1], (char[])tokens[tokens.length - 1]);
                }
            });
            if (qualifiedRef != null) {
                fieldReference.setDeclaringType(qualifiedRef);
            } else {
                fieldReference.setDeclaringType(this.jdtTreeBuilder.getReferencesBuilder().getTypeReference(receiverType));
            }
        }
        CtTypeAccess<?> typeAccess = this.jdtTreeBuilder.getFactory().Code().createTypeAccess(fieldReference.getDeclaringType());
        if (qualifiedNameReference.indexOfFirstFieldBinding > 1) {
            long[] positions = qualifiedNameReference.sourcePositions;
            typeAccess.setPosition(this.jdtTreeBuilder.getPositionBuilder().buildPosition(qualifiedNameReference.sourceStart(), (int)(positions[qualifiedNameReference.indexOfFirstFieldBinding - 1] >>> 32) - 2));
            JDTTreeBuilderHelper.handleImplicit(qualifiedNameReference.actualReceiverType.getPackage(), qualifiedNameReference, fieldReference.getSimpleName(), typeAccess.getAccessedType());
        } else {
            boolean isStaticallyImportedConstantFieldAccess;
            boolean bl = isStaticallyImportedConstantFieldAccess = receiverType != null && receiverType.isStatic() && qualifiedNameReference.tokens.length == 2;
            if (qualifiedNameReference.isImplicitThis() || isStaticallyImportedConstantFieldAccess) {
                typeAccess.setImplicit(true);
            }
        }
        return typeAccess;
    }

    static void handleImplicit(PackageBinding packageBinding, QualifiedNameReference qualifiedNameReference, String simpleName, CtTypeReference<?> typeRef) {
        JDTTreeBuilderHelper.handleImplicit(packageBinding, qualifiedNameReference.tokens, qualifiedNameReference.otherBindings == null ? 0 : qualifiedNameReference.otherBindings.length, qualifiedNameReference, simpleName, typeRef);
    }

    static void handleImplicit(QualifiedTypeReference qualifiedTypeReference, CtTypeReference<?> typeRef) {
        if (qualifiedTypeReference.resolvedType instanceof ProblemReferenceBinding || qualifiedTypeReference.resolvedType == null) {
            return;
        }
        JDTTreeBuilderHelper.handleImplicit(qualifiedTypeReference.resolvedType.getPackage(), qualifiedTypeReference.tokens, 0, qualifiedTypeReference, null, typeRef);
    }

    private static void handleImplicit(PackageBinding packageBinding, char[][] tokens, int countOfOtherBindings, Object qualifiedNameReference, String simpleName, CtTypeReference<?> typeRef) {
        char[][] packageNames = null;
        if (packageBinding != null) {
            packageNames = packageBinding.compoundName;
        }
        CtTypeReference<?> originTypeRef = typeRef;
        while (typeRef instanceof CtArrayTypeReference) {
            typeRef = ((CtArrayTypeReference)typeRef).getComponentType();
        }
        int off = tokens.length - 1;
        if ((off -= countOfOtherBindings) > 0) {
            if (simpleName != null) {
                if (!simpleName.equals(new String(tokens[off]))) {
                    throw new SpoonException("Unexpected field reference simple name: \"" + new String(tokens[off]) + "\" expected: \"" + simpleName + "\"");
                }
                --off;
            }
            while (off >= 0) {
                String token = new String(tokens[off]);
                if (!typeRef.getSimpleName().equals(token)) {
                    return;
                }
                if (typeRef instanceof CtTypeParameterReference) {
                    return;
                }
                CtTypeReference<?> declTypeRef = typeRef.getDeclaringType();
                if (declTypeRef != null) {
                    typeRef = declTypeRef;
                    --off;
                    continue;
                }
                CtPackageReference packageRef = typeRef.getPackage();
                if (packageRef == null) continue;
                if (packageNames != null && packageNames.length == off) {
                    return;
                }
                if (off == 0) {
                    packageRef.setImplicit(true);
                    return;
                }
                if (packageBinding == null || (packageBinding.tagBits & 0x80L) != 0L) {
                    return;
                }
                throw new SpoonException("Unexpected QualifiedNameReference tokens " + qualifiedNameReference + " for typeRef: " + originTypeRef);
            }
            typeRef.setImplicit(true);
        }
    }

    <T> CtTypeAccess<T> createTypeAccessNoClasspath(QualifiedNameReference qualifiedNameReference) {
        CtTypeReference typeReference;
        if (qualifiedNameReference.binding instanceof ProblemBinding) {
            typeReference = this.jdtTreeBuilder.getFactory().Type().createReference(CharOperation.toString((char[][])qualifiedNameReference.tokens));
        } else if (qualifiedNameReference.binding instanceof FieldBinding) {
            ReferenceBinding declaringClass = ((FieldBinding)qualifiedNameReference.binding).declaringClass;
            typeReference = this.jdtTreeBuilder.getReferencesBuilder().getTypeReference((TypeBinding)declaringClass);
        } else {
            char[][] packageName = CharOperation.subarray((char[][])qualifiedNameReference.tokens, (int)0, (int)(qualifiedNameReference.tokens.length - 1));
            char[][] className = CharOperation.subarray((char[][])qualifiedNameReference.tokens, (int)(qualifiedNameReference.tokens.length - 1), (int)qualifiedNameReference.tokens.length);
            if (packageName.length > 0) {
                try {
                    PackageBinding aPackage = this.jdtTreeBuilder.getContextBuilder().compilationunitdeclaration.scope.environment.createPackage(packageName);
                    MissingTypeBinding declaringType = this.jdtTreeBuilder.getContextBuilder().compilationunitdeclaration.scope.environment.createMissingType(aPackage, className);
                    typeReference = this.jdtTreeBuilder.getReferencesBuilder().getTypeReference((TypeBinding)declaringType);
                }
                catch (NullPointerException e) {
                    typeReference = this.jdtTreeBuilder.getFactory().Type().createReference(qualifiedNameReference.toString());
                }
            } else {
                typeReference = this.jdtTreeBuilder.getFactory().Type().createReference(qualifiedNameReference.toString());
            }
        }
        CtTypeAccess typeAccess = this.jdtTreeBuilder.getFactory().Code().createTypeAccess(typeReference);
        int sourceStart = qualifiedNameReference.sourceStart();
        int sourceEnd = qualifiedNameReference.sourceEnd();
        typeAccess.setPosition(this.jdtTreeBuilder.getPositionBuilder().buildPosition(sourceStart, sourceEnd));
        return typeAccess;
    }

    <T> CtTypeAccess<T> createTypeAccessNoClasspath(SingleNameReference singleNameReference) {
        CtTypeReference typeReference = this.jdtTreeBuilder.getFactory().Core().createTypeReference();
        if (singleNameReference.binding == null) {
            typeReference.setSimpleName(CharOperation.charToString((char[])singleNameReference.token));
        } else {
            typeReference.setSimpleName(CharOperation.charToString((char[])singleNameReference.binding.readableName()));
        }
        CtReference packageOrDeclaringType = this.jdtTreeBuilder.getReferencesBuilder().getDeclaringReferenceFromImports(singleNameReference.token);
        this.jdtTreeBuilder.getReferencesBuilder().setImplicitPackageOrDeclaringType(typeReference, packageOrDeclaringType);
        return this.jdtTreeBuilder.getFactory().Code().createTypeAccess(typeReference);
    }

    CtExpression<?> createTargetFieldAccess(QualifiedNameReference qualifiedNameReference, CtFieldReference<Object> ref) {
        CtExpression<Void> target = null;
        if (JDTTreeBuilderQuery.isValidProblemBindingField(qualifiedNameReference)) {
            target = this.createTypeAccessNoClasspath(qualifiedNameReference);
        } else if (ref.isStatic()) {
            target = this.createTypeAccess(qualifiedNameReference, ref);
        } else if (!ref.isStatic() && !ref.getDeclaringType().isAnonymous()) {
            target = !JDTTreeBuilderQuery.isFieldReference(qualifiedNameReference) ? this.createTypeAccessNoClasspath(qualifiedNameReference) : this.jdtTreeBuilder.getFactory().Code().createThisAccess(this.jdtTreeBuilder.getReferencesBuilder().getTypeReference(qualifiedNameReference.actualReceiverType), true);
        }
        return target;
    }

    <T> CtParameter<T> createParameter(Argument argument) {
        CtParameter p = this.jdtTreeBuilder.getFactory().Core().createParameter();
        p.setSimpleName(CharOperation.charToString((char[])argument.name));
        p.setVarArgs(argument.isVarArgs());
        p.setExtendedModifiers(JDTTreeBuilderQuery.getModifiers(argument.modifiers, false, ModifierTarget.PARAMETER));
        if (argument.binding != null && argument.binding.type != null && argument.type == null) {
            p.setType(this.jdtTreeBuilder.getReferencesBuilder().getTypeReference(argument.binding.type));
            p.getType().setImplicit(argument.type == null);
            if (p.getType() instanceof CtArrayTypeReference) {
                ((CtArrayTypeReference)p.getType()).getComponentType().setImplicit(argument.type == null);
            }
        }
        return p;
    }

    CtReceiverParameter createReceiverParameter(Receiver argument) {
        CtReceiverParameter p = this.jdtTreeBuilder.getFactory().Core().createReceiverParameter();
        if (argument.type != null) {
            p.setType(this.jdtTreeBuilder.getReferencesBuilder().getTypeReference(argument.type));
        }
        return p;
    }

    <T, E extends CtExpression<?>> CtExecutableReferenceExpression<T, E> createExecutableReferenceExpression(ReferenceExpression referenceExpression) {
        CtTypeReference returnType;
        CtExecutableReferenceExpression executableRef = this.jdtTreeBuilder.getFactory().Core().createExecutableReferenceExpression();
        CtExecutableReference executableReference = this.jdtTreeBuilder.getReferencesBuilder().getExecutableReference(referenceExpression);
        if (executableReference == null) {
            executableReference = this.jdtTreeBuilder.getFactory().Core().createExecutableReference();
            executableReference.setSimpleName(CharOperation.charToString((char[])referenceExpression.selector));
            executableReference.setDeclaringType(this.jdtTreeBuilder.getReferencesBuilder().getTypeReference(referenceExpression.lhs.resolvedType));
        }
        executableReference.setType((CtTypeReference)((returnType = executableReference.getType()) == null ? null : returnType.clone()));
        executableRef.setExecutable(executableReference);
        return executableRef;
    }

    CtType<?> createType(TypeDeclaration typeDeclaration) {
        CtElement type = (typeDeclaration.modifiers & 0x2000) != 0 ? this.jdtTreeBuilder.getFactory().Core().createAnnotationType() : ((typeDeclaration.modifiers & 0x4000) != 0 ? this.jdtTreeBuilder.getFactory().Core().createEnum() : ((typeDeclaration.modifiers & 0x200) != 0 ? this.jdtTreeBuilder.getFactory().Core().createInterface() : (typeDeclaration.isRecord() ? this.jdtTreeBuilder.getFactory().Core().createRecord() : this.jdtTreeBuilder.getFactory().Core().createClass())));
        if (typeDeclaration.binding != null) {
            type.setExtendedModifiers(JDTTreeBuilderQuery.getModifiers(typeDeclaration.binding.modifiers, true, ModifierTarget.TYPE));
        }
        for (CtExtendedModifier modifier : JDTTreeBuilderQuery.getModifiers(typeDeclaration.modifiers, false, ModifierTarget.TYPE)) {
            type.addModifier(modifier.getKind());
        }
        this.jdtTreeBuilder.getContextBuilder().enter(type, (ASTNode)typeDeclaration);
        if (typeDeclaration.superInterfaces != null) {
            for (TypeReference ref2 : typeDeclaration.superInterfaces) {
                CtTypeReference ctTypeReference = this.jdtTreeBuilder.references.buildTypeReference(ref2, null);
                type.addSuperInterface(ctTypeReference);
            }
        }
        Consumer<CtTypeReference> addPermittedType = type instanceof CtSealable ? ((CtSealable)((Object)type))::addPermittedType : ref -> {
            throw new SpoonException("Tried to add permitted type to " + type);
        };
        if (typeDeclaration.permittedTypes != null) {
            for (TypeReference typeReference : typeDeclaration.permittedTypes) {
                CtTypeReference reference = this.jdtTreeBuilder.references.buildTypeReference(typeReference, (Scope)typeDeclaration.scope);
                addPermittedType.accept(reference);
            }
        } else if (typeDeclaration.binding != null && typeDeclaration.binding.permittedTypes != null) {
            for (ReferenceBinding referenceBinding : typeDeclaration.binding.permittedTypes) {
                CtTypeReference reference = this.jdtTreeBuilder.references.getTypeReference((TypeBinding)referenceBinding);
                reference.setImplicit(true);
                addPermittedType.accept(reference);
            }
        }
        if (type instanceof CtClass && typeDeclaration.superclass != null) {
            ((CtClass)type).setSuperclass(this.jdtTreeBuilder.references.buildTypeReference(typeDeclaration.superclass, (Scope)typeDeclaration.scope));
        }
        if ((type instanceof CtClass || type instanceof CtInterface) && typeDeclaration.binding != null && (typeDeclaration.binding.isAnonymousType() || typeDeclaration.binding instanceof LocalTypeBinding && typeDeclaration.binding.enclosingMethod() != null)) {
            type.setSimpleName(JDTTreeBuilderHelper.computeAnonymousName(typeDeclaration.binding.constantPoolName()));
        } else {
            type.setSimpleName(new String(typeDeclaration.name));
        }
        return type;
    }

    CtModule createModule(ModuleDeclaration moduleDeclaration) {
        CtModule module = this.jdtTreeBuilder.getFactory().Module().getOrCreate(new String(moduleDeclaration.moduleName));
        module.setIsOpenModule(moduleDeclaration.isOpen());
        this.jdtTreeBuilder.getContextBuilder().enter(module, (ASTNode)moduleDeclaration);
        if (moduleDeclaration.requires != null && moduleDeclaration.requires.length > 0) {
            ArrayList<CtModuleRequirement> moduleRequirements = new ArrayList<CtModuleRequirement>();
            for (RequiresStatement requiresStatement : moduleDeclaration.requires) {
                moduleRequirements.add(this.createModuleRequirement(requiresStatement));
            }
            module.setRequiredModules(moduleRequirements);
        }
        if (moduleDeclaration.exports != null && moduleDeclaration.exports.length > 0) {
            ArrayList<CtPackageExport> moduleExports = new ArrayList<CtPackageExport>();
            for (RequiresStatement requiresStatement : moduleDeclaration.exports) {
                moduleExports.add(this.createModuleExport((PackageVisibilityStatement)requiresStatement));
            }
            module.setExportedPackages(moduleExports);
        }
        if (moduleDeclaration.opens != null && moduleDeclaration.opens.length > 0) {
            ArrayList<CtPackageExport> moduleOpens = new ArrayList<CtPackageExport>();
            for (RequiresStatement requiresStatement : moduleDeclaration.opens) {
                moduleOpens.add(this.createModuleExport((PackageVisibilityStatement)requiresStatement));
            }
            module.setOpenedPackages(moduleOpens);
        }
        if (moduleDeclaration.uses != null && moduleDeclaration.uses.length > 0) {
            ArrayList<CtUsedService> consumedServices = new ArrayList<CtUsedService>();
            for (RequiresStatement requiresStatement : moduleDeclaration.uses) {
                consumedServices.add(this.createUsedService((UsesStatement)requiresStatement));
            }
            module.setUsedServices(consumedServices);
        }
        if (moduleDeclaration.services != null && moduleDeclaration.services.length > 0) {
            ArrayList<CtProvidedService> moduleProvidedServices = new ArrayList<CtProvidedService>();
            for (RequiresStatement requiresStatement : moduleDeclaration.services) {
                moduleProvidedServices.add(this.createModuleProvidedService((ProvidesStatement)requiresStatement));
            }
            module.setProvidedServices(moduleProvidedServices);
        }
        module.setPosition(this.jdtTreeBuilder.getPositionBuilder().buildPosition(moduleDeclaration.declarationSourceStart, moduleDeclaration.declarationSourceEnd));
        return module;
    }

    CtUsedService createUsedService(UsesStatement usesStatement) {
        CtTypeReference typeReference = this.jdtTreeBuilder.references.getTypeReference(usesStatement.serviceInterface);
        CtUsedService usedService = this.jdtTreeBuilder.getFactory().Module().createUsedService(typeReference);
        usedService.setPosition(this.jdtTreeBuilder.getPositionBuilder().buildPosition(usesStatement.sourceStart, usesStatement.sourceEnd));
        return usedService;
    }

    CtModuleRequirement createModuleRequirement(RequiresStatement requiresStatement) {
        int sourceStart = requiresStatement.sourceStart;
        int sourceEnd = requiresStatement.sourceEnd;
        CtModuleReference ctModuleReference = this.jdtTreeBuilder.references.getModuleReference(requiresStatement.module);
        CtModuleRequirement moduleRequirement = this.jdtTreeBuilder.getFactory().Module().createModuleRequirement(ctModuleReference);
        HashSet<CtModuleRequirement.RequiresModifier> modifiers = new HashSet<CtModuleRequirement.RequiresModifier>();
        if (requiresStatement.isStatic()) {
            modifiers.add(CtModuleRequirement.RequiresModifier.STATIC);
        }
        if (requiresStatement.isTransitive()) {
            modifiers.add(CtModuleRequirement.RequiresModifier.TRANSITIVE);
        }
        moduleRequirement.setRequiresModifiers(modifiers);
        moduleRequirement.setPosition(this.jdtTreeBuilder.getPositionBuilder().buildPosition(sourceStart, sourceEnd));
        return moduleRequirement;
    }

    CtPackageExport createModuleExport(PackageVisibilityStatement statement) {
        String packageName = new String(statement.pkgName);
        int sourceStart = statement.sourceStart;
        int sourceEnd = statement.sourceEnd;
        CtPackageReference ctPackageReference = this.jdtTreeBuilder.references.getPackageReference(packageName);
        CtPackageExport moduleExport = this.jdtTreeBuilder.getFactory().Module().createPackageExport(ctPackageReference);
        if (statement.targets != null && statement.targets.length > 0) {
            ArrayList<CtModuleReference> moduleReferences = new ArrayList<CtModuleReference>();
            for (ModuleReference moduleReference : statement.targets) {
                moduleReferences.add(this.jdtTreeBuilder.references.getModuleReference(moduleReference));
            }
            moduleExport.setTargetExport(moduleReferences);
        }
        moduleExport.setPosition(this.jdtTreeBuilder.getPositionBuilder().buildPosition(sourceStart, sourceEnd));
        return moduleExport;
    }

    CtProvidedService createModuleProvidedService(ProvidesStatement providesStatement) {
        int sourceStart = providesStatement.sourceStart;
        int sourceEnd = providesStatement.sourceEnd;
        CtTypeReference provideService = this.jdtTreeBuilder.references.getTypeReference(providesStatement.serviceInterface);
        ArrayList<CtTypeReference> implementations = new ArrayList<CtTypeReference>();
        for (TypeReference typeReference : providesStatement.implementations) {
            implementations.add(this.jdtTreeBuilder.references.getTypeReference(typeReference));
        }
        CtProvidedService providedService = this.jdtTreeBuilder.getFactory().Module().createProvidedService(provideService);
        providedService.setImplementationTypes(implementations);
        providedService.setPosition(this.jdtTreeBuilder.getPositionBuilder().buildPosition(sourceStart, sourceEnd));
        return providedService;
    }
}

