/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.compiler.jdt;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.CompilationProgress;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.batch.Main;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.core.util.CommentRecorderParser;
import spoon.SpoonException;
import spoon.support.compiler.SpoonProgress;
import spoon.support.compiler.jdt.JDTBasedSpoonCompiler;
import spoon.support.compiler.jdt.JDTConstants;
import spoon.support.compiler.jdt.PositionBuilder;
import spoon.support.compiler.jdt.TreeBuilderCompiler;

public class JDTBatchCompiler
extends Main {
    protected final JDTBasedSpoonCompiler jdtCompiler;
    protected CompilationUnit[] compilationUnits;
    protected Set<String> filesToBeIgnored = new HashSet<String>();

    public JDTBatchCompiler(JDTBasedSpoonCompiler jdtCompiler) {
        this(jdtCompiler, OutputStream.nullOutputStream(), OutputStream.nullOutputStream());
    }

    JDTBatchCompiler(JDTBasedSpoonCompiler jdtCompiler, OutputStream outWriter, OutputStream errWriter) {
        super(new PrintWriter(outWriter), new PrintWriter(errWriter), false, null, null);
        this.jdtCompiler = jdtCompiler;
        if (jdtCompiler != null) {
            this.jdtCompiler.probs.clear();
        }
    }

    public CompilationUnit[] getCompilationUnits() {
        HashMap<String, char[]> pathToModName = new HashMap<String, char[]>();
        for (int round = 0; round < 2; ++round) {
            block1: for (CompilationUnit compilationUnit : this.compilationUnits) {
                char[] charName = compilationUnit.getFileName();
                boolean isModuleInfo = CharOperation.endsWith((char[])charName, (char[])JDTConstants.MODULE_INFO_FILE_NAME);
                if (isModuleInfo != (round == 0)) continue;
                String fileName = new String(charName);
                if (isModuleInfo) {
                    int lastSlash = CharOperation.lastIndexOf((char)File.separatorChar, (char[])charName);
                    if (lastSlash == -1) continue;
                    char[] modulePath = CharOperation.subarray((char[])charName, (int)0, (int)lastSlash);
                    lastSlash = (lastSlash = CharOperation.lastIndexOf((char)File.separatorChar, (char[])modulePath)) == -1 ? 0 : ++lastSlash;
                    compilationUnit.module = this.module == null ? CharOperation.subarray((char[])modulePath, (int)lastSlash, (int)modulePath.length) : this.getModuleName(compilationUnit).toCharArray();
                    pathToModName.put(String.valueOf(modulePath), compilationUnit.module);
                    continue;
                }
                for (Map.Entry entry : pathToModName.entrySet()) {
                    if (!fileName.startsWith((String)entry.getKey())) continue;
                    compilationUnit.module = (char[])entry.getValue();
                    continue block1;
                }
            }
        }
        return this.compilationUnits;
    }

    private String getModuleName(CompilationUnit compilationUnit) {
        StringBuilder sb = new StringBuilder();
        int index = 0;
        while (!sb.toString().equals("module") && index != -1) {
            sb.setLength(0);
            index = this.nextToken(compilationUnit, index, sb);
        }
        sb.setLength(0);
        this.nextToken(compilationUnit, index, sb);
        return sb.toString();
    }

    private int nextToken(CompilationUnit cu, int start, StringBuilder sb) {
        int index = PositionBuilder.findNextNonWhitespace(cu.contents, cu.contents.length, start);
        if (index == -1) {
            return -1;
        }
        for (int i = index; i < cu.contents.length; ++i) {
            if (Character.isWhitespace(cu.contents[i]) || cu.contents[i] == '{') {
                return i + 1;
            }
            sb.append(cu.contents[i]);
        }
        return -1;
    }

    public void setCompilationUnits(CompilationUnit[] compilationUnits) {
        this.compilationUnits = compilationUnits;
    }

    public ICompilerRequestor getBatchRequestor() {
        final ICompilerRequestor r = super.getBatchRequestor();
        return new ICompilerRequestor(){

            public void acceptResult(CompilationResult compilationResult) {
                if (compilationResult.hasErrors()) {
                    for (CategorizedProblem problem : compilationResult.problems) {
                        if (JDTBatchCompiler.this.jdtCompiler == null) {
                            throw new SpoonException(problem.toString());
                        }
                        JDTBatchCompiler.this.jdtCompiler.reportProblem(problem);
                    }
                }
                r.acceptResult(compilationResult);
            }
        };
    }

    public void ignoreFile(String filePath) {
        this.filesToBeIgnored.add(filePath);
    }

    public CompilationUnitDeclaration[] getUnits() {
        this.startTime = System.currentTimeMillis();
        INameEnvironment environment = this.jdtCompiler.environment;
        if (environment == null) {
            environment = this.getLibraryAccess();
        }
        CompilerOptions compilerOptions = new CompilerOptions(this.options);
        compilerOptions.parseLiteralExpressionsAsConstants = false;
        Object errorHandlingPolicy = this.jdtCompiler.getEnvironment().getNoClasspath() ? new IErrorHandlingPolicy(){

            public boolean proceedOnErrors() {
                return true;
            }

            public boolean stopOnFirstError() {
                return false;
            }

            public boolean ignoreAllErrors() {
                return false;
            }
        } : new IErrorHandlingPolicy(){

            public boolean proceedOnErrors() {
                return false;
            }

            public boolean stopOnFirstError() {
                return false;
            }

            public boolean ignoreAllErrors() {
                return false;
            }
        };
        IProblemFactory problemFactory = this.getProblemFactory();
        TreeBuilderCompiler treeBuilderCompiler = new TreeBuilderCompiler(environment, (IErrorHandlingPolicy)errorHandlingPolicy, compilerOptions, this.jdtCompiler.requestor, problemFactory, this.out, this.jdtCompiler.getEnvironment().getIgnoreSyntaxErrors(), this.jdtCompiler.getEnvironment().getLevel(), new CompilationProgress(){
            private String currentElement = null;
            private int totalTask = -1;

            public void begin(int i) {
            }

            public void done() {
            }

            public boolean isCanceled() {
                return false;
            }

            public void setTaskName(String s) {
                String strToFind = "Processing ";
                int processingPosition = s.indexOf(strToFind);
                if (processingPosition != -1) {
                    this.currentElement = s.substring(processingPosition + strToFind.length());
                }
            }

            public void worked(int increment, int remaining) {
                if (this.totalTask == -1) {
                    this.totalTask = remaining + 1;
                }
                JDTBatchCompiler.this.jdtCompiler.getEnvironment().getSpoonProgress().step(SpoonProgress.Process.COMPILE, this.currentElement, this.totalTask - remaining, this.totalTask);
            }
        });
        if (this.jdtCompiler.getEnvironment().getNoClasspath()) {
            treeBuilderCompiler.lookupEnvironment.problemReporter = new ProblemReporter((IErrorHandlingPolicy)errorHandlingPolicy, compilerOptions, problemFactory){

                public int computeSeverity(int problemID) {
                    return 256;
                }
            };
            treeBuilderCompiler.lookupEnvironment.mayTolerateMissingType = true;
        }
        this.jdtCompiler.getEnvironment().getSpoonProgress().start(SpoonProgress.Process.COMPILE);
        CompilationUnitDeclaration[] result = treeBuilderCompiler.buildUnits(this.getCompilationUnits());
        this.jdtCompiler.getEnvironment().getSpoonProgress().end(SpoonProgress.Process.COMPILE);
        if (this.jdtCompiler.getEnvironment().isCommentsEnabled()) {
            this.jdtCompiler.getEnvironment().getSpoonProgress().start(SpoonProgress.Process.COMMENT);
            for (int i = 0; i < result.length; ++i) {
                CompilationUnitDeclaration unit = result[i];
                CommentRecorderParser parser = new CommentRecorderParser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), compilerOptions, (IProblemFactory)new DefaultProblemFactory(Locale.getDefault())), false);
                ICompilationUnit sourceUnit = unit.compilationResult.compilationUnit;
                CompilationResult compilationResult = new CompilationResult(sourceUnit, 0, 0, compilerOptions.maxProblemsPerUnit);
                CompilationUnitDeclaration tmpDeclForComment = parser.dietParse(sourceUnit, compilationResult);
                unit.comments = tmpDeclForComment.comments;
                this.jdtCompiler.getEnvironment().getSpoonProgress().step(SpoonProgress.Process.COMMENT, new String(unit.getFileName()), i + 1, result.length);
            }
            this.jdtCompiler.getEnvironment().getSpoonProgress().end(SpoonProgress.Process.COMMENT);
        }
        return result;
    }

    public JDTBasedSpoonCompiler getJdtCompiler() {
        return this.jdtCompiler;
    }
}

