/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.compiler.jdt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import spoon.SpoonModelBuilder;
import spoon.compiler.Environment;
import spoon.compiler.SpoonFile;
import spoon.support.compiler.jdt.JDTBasedSpoonCompiler;
import spoon.support.compiler.jdt.JDTBatchCompiler;

public class FileCompilerConfig
implements SpoonModelBuilder.InputType {
    public static final SpoonModelBuilder.InputType INSTANCE = new FileCompilerConfig((List)null){

        @Override
        public List<SpoonFile> getFiles(JDTBatchCompiler compiler) {
            JDTBasedSpoonCompiler jdtCompiler = compiler.getJdtCompiler();
            ArrayList<SpoonFile> files = new ArrayList<SpoonFile>();
            files.addAll(jdtCompiler.sources.getAllJavaFiles());
            files.addAll(jdtCompiler.templates.getAllJavaFiles());
            return files;
        }
    };
    private final List<SpoonFile> files;

    public FileCompilerConfig(List<SpoonFile> files) {
        this.files = files;
    }

    @Override
    public void initializeCompiler(JDTBatchCompiler compiler) {
        JDTBasedSpoonCompiler jdtCompiler = compiler.getJdtCompiler();
        ArrayList<CompilationUnit> cuList = new ArrayList<CompilationUnit>();
        Environment env = jdtCompiler.getEnvironment();
        for (SpoonFile f : this.getFiles(compiler)) {
            if (compiler.filesToBeIgnored.contains(f.getPath())) continue;
            String fName = f.isActualFile() ? f.getPath() : f.getName();
            cuList.add(new CompilationUnit(f.getContentChars(env), fName, env.getEncoding().displayName()));
        }
        compiler.setCompilationUnits(cuList.toArray(new CompilationUnit[0]));
    }

    protected List<SpoonFile> getFiles(JDTBatchCompiler compiler) {
        return this.files;
    }
}

