/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.compiler.jdt;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import spoon.compiler.Environment;
import spoon.reflect.code.CtCatchVariable;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.cu.CompilationUnit;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypedElement;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.factory.ClassFactory;
import spoon.reflect.factory.CoreFactory;
import spoon.reflect.factory.FieldFactory;
import spoon.reflect.factory.InterfaceFactory;
import spoon.reflect.factory.TypeFactory;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.EarlyTerminatingScanner;
import spoon.support.Internal;
import spoon.support.SpoonClassNotFoundException;
import spoon.support.compiler.jdt.ASTPair;
import spoon.support.compiler.jdt.JDTTreeBuilder;
import spoon.support.compiler.jdt.JDTTreeBuilderQuery;
import spoon.support.compiler.jdt.ModifierTarget;
import spoon.support.compiler.jdt.ReferenceBuilder;

@Internal
public class ContextBuilder {
    Deque<String> annotationValueName = new ArrayDeque<String>();
    List<CastInfo> casts = new ArrayList<CastInfo>(1);
    CompilationUnitDeclaration compilationunitdeclaration;
    CompilationUnit compilationUnitSpoon;
    boolean isBuildLambda;
    boolean isBuildTypeCast;
    boolean ignoreComputeImports;
    private final Deque<ASTPair> stack = new ArrayDeque<ASTPair>();
    private final JDTTreeBuilder jdtTreeBuilder;

    ContextBuilder(JDTTreeBuilder jdtTreeBuilder) {
        this.jdtTreeBuilder = jdtTreeBuilder;
    }

    void enter(CtElement e, ASTNode node) {
        ASTPair pair;
        CtElement current;
        this.stack.push(new ASTPair(e, node));
        if ((!(e instanceof CtPackage) || this.compilationUnitSpoon.getFile() != null && this.compilationUnitSpoon.getFile().getName().equals("package-info.java")) && this.compilationunitdeclaration != null && !e.isImplicit()) {
            try {
                e.setPosition(this.jdtTreeBuilder.getPositionBuilder().buildPositionCtElement(e, node));
            }
            catch (Exception ex) {
                e.setPosition(SourcePosition.NOPOSITION);
            }
        }
        if ((current = (pair = this.stack.peek()).element()) instanceof CtExpression) {
            while (!this.casts.isEmpty()) {
                ((CtExpression)current).addTypeCast(this.casts.remove((int)0).typeRef);
            }
        }
        try {
            if (e instanceof CtTypedElement && !(e instanceof CtConstructorCall) && !(e instanceof CtCatchVariable) && node instanceof Expression && ((CtTypedElement)e).getType() == null) {
                ((CtTypedElement)e).setType(this.jdtTreeBuilder.getReferencesBuilder().getTypeReference(((Expression)node).resolvedType));
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    void exit(ASTNode node) {
        ASTPair pair = this.stack.pop();
        if (pair.node() != node) {
            throw new RuntimeException("Inconsistent Stack " + node + "\n" + pair.node());
        }
        CtElement current = pair.element();
        if (!this.stack.isEmpty()) {
            this.jdtTreeBuilder.getExiter().setChild(current);
            this.jdtTreeBuilder.getExiter().setChild(pair.node());
            ASTPair parentPair = this.stack.peek();
            this.jdtTreeBuilder.getExiter().exitParent(parentPair);
        }
    }

    Iterable<ASTPair> getAllContexts() {
        return this.stack;
    }

    boolean hasCurrentContext() {
        return !this.stack.isEmpty();
    }

    CtElement getCurrentElement() {
        return this.stack.peek().element();
    }

    ASTNode getCurrentNode() {
        return this.stack.peek().node();
    }

    CtElement getContextElementOnLevel(int level) {
        for (ASTPair pair : this.stack) {
            if (level == 0) {
                return pair.element();
            }
            --level;
        }
        return null;
    }

    <T extends CtElement> T getParentElementOfType(Class<T> clazz) {
        for (ASTPair pair : this.stack) {
            if (!clazz.isInstance(pair.element())) continue;
            return (T)pair.element();
        }
        return null;
    }

    ASTPair getParentContextOfType(Class<? extends CtElement> clazz) {
        for (ASTPair pair : this.stack) {
            if (!clazz.isInstance(pair.element())) continue;
            return pair;
        }
        return null;
    }

    <T> CtLocalVariable<T> getLocalVariableDeclaration(String name) {
        Class<?> clazz = this.jdtTreeBuilder.getFactory().Core().createLocalVariable().getClass();
        CtLocalVariable localVariable = (CtLocalVariable)this.getVariableDeclaration(name, clazz);
        if (localVariable == null) {
            ContextBuilder contextBuilder = this;
            contextBuilder.jdtTreeBuilder.getLogger().error(String.format("Could not find declaration for local variable %s at %s", name, this.getCurrentElement().getPosition()));
        }
        return localVariable;
    }

    <T> CtCatchVariable<T> getCatchVariableDeclaration(String name) {
        Class<?> clazz = this.jdtTreeBuilder.getFactory().Core().createCatchVariable().getClass();
        CtCatchVariable catchVariable = (CtCatchVariable)this.getVariableDeclaration(name, clazz);
        if (catchVariable == null) {
            ContextBuilder contextBuilder = this;
            contextBuilder.jdtTreeBuilder.getLogger().error(String.format("Could not find declaration for catch variable %s at %s", name, this.getCurrentElement().getPosition()));
        }
        return catchVariable;
    }

    <T> CtVariable<T> getVariableDeclaration(String name) {
        Object variable = this.getVariableDeclaration(name, null);
        if (variable == null) {
            ContextBuilder contextBuilder = this;
            contextBuilder.jdtTreeBuilder.getLogger().debug(String.format("Could not find declaration for variable %s at %s.", name, this.getCurrentElement().getPosition()));
        }
        return variable;
    }

    private static String getNormalQualifiedName(ReferenceBinding referenceBinding) {
        String pkg = new String(referenceBinding.getPackage().readableName()).replaceAll("\\.", "\\.");
        String name = new String(referenceBinding.qualifiedSourceName()).replaceAll("\\.", "\\$");
        return pkg.isEmpty() ? name : pkg + "." + name;
    }

    private <T, U extends CtVariable<T>> U getVariableDeclaration(String name, Class<U> clazz) {
        block14: {
            CtReference potentialReferenceToField;
            CoreFactory coreFactory = this.jdtTreeBuilder.getFactory().Core();
            TypeFactory typeFactory = this.jdtTreeBuilder.getFactory().Type();
            ClassFactory classFactory = this.jdtTreeBuilder.getFactory().Class();
            InterfaceFactory interfaceFactory = this.jdtTreeBuilder.getFactory().Interface();
            FieldFactory fieldFactory = this.jdtTreeBuilder.getFactory().Field();
            ReferenceBuilder referenceBuilder = this.jdtTreeBuilder.getReferencesBuilder();
            Environment environment = this.jdtTreeBuilder.getFactory().getEnvironment();
            boolean lookingForFields = clazz == null || coreFactory.createField().getClass().isAssignableFrom(clazz);
            for (ASTPair astPair : this.stack) {
                ScopeRespectingVariableScanner<U> scanner = new ScopeRespectingVariableScanner<U>(name, clazz);
                astPair.element().accept(scanner);
                if (scanner.getResult() != null) {
                    return (U)((CtVariable)scanner.getResult());
                }
                if (!lookingForFields || !(astPair.node() instanceof TypeDeclaration)) continue;
                TypeDeclaration nodeDeclaration = (TypeDeclaration)astPair.node();
                ArrayDeque<ReferenceBinding> referenceBindings = new ArrayDeque<ReferenceBinding>();
                if (nodeDeclaration.superclass != null && nodeDeclaration.superclass.resolvedType instanceof ReferenceBinding) {
                    referenceBindings.push((ReferenceBinding)nodeDeclaration.superclass.resolvedType);
                }
                if (nodeDeclaration.superInterfaces != null) {
                    for (TypeReference tr : nodeDeclaration.superInterfaces) {
                        if (!(tr.resolvedType instanceof ReferenceBinding)) continue;
                        referenceBindings.push((ReferenceBinding)tr.resolvedType);
                    }
                }
                while (!referenceBindings.isEmpty()) {
                    ReferenceBinding[] interfaces;
                    ReferenceBinding referenceBinding = (ReferenceBinding)referenceBindings.pop();
                    for (FieldBinding fieldBinding : referenceBinding.fields()) {
                        if (!name.equals(new String(fieldBinding.readableName()))) continue;
                        String qualifiedNameOfParent = ContextBuilder.getNormalQualifiedName(referenceBinding);
                        CtType parentOfField = typeFactory.get(qualifiedNameOfParent);
                        if (parentOfField != null) {
                            return (U)parentOfField.getField(name);
                        }
                        parentOfField = referenceBinding.isClass() ? classFactory.create(qualifiedNameOfParent) : interfaceFactory.create(qualifiedNameOfParent);
                        CtField field = fieldFactory.create(parentOfField, EnumSet.noneOf(ModifierKind.class), referenceBuilder.getTypeReference(fieldBinding.type), name);
                        return (U)((CtVariable)field.setExtendedModifiers(JDTTreeBuilderQuery.getModifiers(fieldBinding.modifiers, true, ModifierTarget.FIELD)));
                    }
                    ReferenceBinding superclass = referenceBinding.superclass();
                    if (superclass != null) {
                        referenceBindings.push(superclass);
                    }
                    if ((interfaces = referenceBinding.superInterfaces()) == null) continue;
                    for (ReferenceBinding rb : interfaces) {
                        referenceBindings.push(rb);
                    }
                }
            }
            if (lookingForFields && (potentialReferenceToField = referenceBuilder.getDeclaringReferenceFromImports(name.toCharArray())) instanceof CtTypeReference) {
                CtField<Object> field;
                CtTypeReference typeReference = (CtTypeReference)potentialReferenceToField;
                try {
                    CtType declaringTypeOfField;
                    Class classOfType = typeReference.getActualClass();
                    if (classOfType != null && (field = (declaringTypeOfField = typeReference.isInterface() ? interfaceFactory.get(classOfType) : classFactory.get(classOfType)).getField(name)) != null) {
                        return (U)field;
                    }
                }
                catch (SpoonClassNotFoundException scnfe) {
                    if (!environment.getNoClasspath() || !name.toUpperCase().equals(name)) break block14;
                    CtClass parentOfField = classFactory.create(typeReference.getQualifiedName());
                    field = coreFactory.createField();
                    field.setParent(parentOfField);
                    field.setSimpleName(name);
                    field.setType(typeFactory.nullType());
                    return (U)field;
                }
            }
        }
        return null;
    }

    public int[] getCompilationUnitLineSeparatorPositions() {
        return this.compilationunitdeclaration.compilationResult.lineSeparatorPositions;
    }

    public char[] getCompilationUnitContents() {
        return this.compilationunitdeclaration.compilationResult.compilationUnit.getContents();
    }

    private class ScopeRespectingVariableScanner<T extends CtVariable>
    extends EarlyTerminatingScanner<T> {
        private final Class<T> clazz;
        final String name;

        ScopeRespectingVariableScanner(String pName, Class<T> pType) {
            this.clazz = pType == null ? CtVariable.class : pType;
            this.name = pName;
        }

        @Override
        public void scan(CtElement element) {
            CtVariable potentialVariable;
            if (element != null && this.clazz.isAssignableFrom(element.getClass()) && this.name.equals((potentialVariable = (CtVariable)element).getSimpleName())) {
                CtElement parentOfPotentialVariable = potentialVariable.getParent();
                for (ASTPair astPair : ContextBuilder.this.stack) {
                    CtExecutable executable;
                    if (astPair.element() == parentOfPotentialVariable) {
                        this.finish(potentialVariable);
                        return;
                    }
                    if (!(astPair.element() instanceof CtExecutable) || (executable = (CtExecutable)astPair.element()).getBody() != parentOfPotentialVariable) continue;
                    this.finish(potentialVariable);
                    return;
                }
            }
            super.scan(element);
        }

        private void finish(T element) {
            this.setResult(element);
            this.terminate();
        }
    }

    public static class CastInfo {
        int nrOfBrackets;
        CtTypeReference<?> typeRef;
    }
}

