/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.compiler;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import spoon.Launcher;
import spoon.SpoonException;
import spoon.compiler.SpoonFile;
import spoon.compiler.SpoonFolder;
import spoon.compiler.SpoonResourceHelper;
import spoon.support.compiler.ZipFile;

public class ZipFolder
implements SpoonFolder {
    File file;
    List<SpoonFile> files;

    public ZipFolder(File file) throws IOException {
        if (!file.isFile()) {
            throw new IOException(file.getName() + " is not a valid zip file");
        }
        this.file = file;
    }

    @Override
    public List<SpoonFile> getAllFiles() {
        return this.getFiles();
    }

    @Override
    public List<SpoonFile> getAllJavaFiles() {
        return this.getFiles().stream().filter(SpoonFile::isJava).collect(Collectors.toList());
    }

    @Override
    public List<SpoonFile> getFiles() {
        if (this.files == null) {
            this.files = new ArrayList<SpoonFile>();
            try (FileSystem zip = FileSystems.newFileSystem(URI.create("jar:" + this.file.toURI()), Map.of());){
                Path tempFolder = Files.createTempDirectory("spoon-zip-file-proxy", new FileAttribute[0]);
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    try {
                        FileUtils.deleteDirectory((File)tempFolder.toFile());
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }));
                for (Path directory : zip.getRootDirectories()) {
                    this.copyFolder(directory, tempFolder);
                }
            }
            catch (Exception e) {
                Launcher.LOGGER.error("Error copying zip file contents", (Throwable)e);
            }
        }
        return this.files;
    }

    private void copyFolder(Path source, Path target) throws IOException {
        try (Stream<Path> stream = Files.walk(source, new FileVisitOption[0]);){
            for (Path path : stream::iterator) {
                String relativePath = source.relativize(path).toString();
                Path targetFile = target.resolve(relativePath);
                if (Files.isDirectory(path, new LinkOption[0])) {
                    Files.createDirectories(targetFile, new FileAttribute[0]);
                    continue;
                }
                Files.copy(path, targetFile, new CopyOption[0]);
                this.files.add(new ZipFile(this, relativePath, targetFile));
            }
        }
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public SpoonFolder getParent() {
        try {
            return SpoonResourceHelper.createFolder(this.file.getParentFile());
        }
        catch (FileNotFoundException e) {
            Launcher.LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public List<SpoonFolder> getSubFolders() {
        return new ArrayList<SpoonFolder>(0);
    }

    @Override
    public boolean isFile() {
        return false;
    }

    public String toString() {
        return this.getPath();
    }

    @Override
    public String getPath() {
        try {
            return this.file.getCanonicalPath();
        }
        catch (Exception e) {
            Launcher.LOGGER.error(e.getMessage(), (Throwable)e);
            return this.file.getPath();
        }
    }

    @Override
    public boolean isArchive() {
        return true;
    }

    @Override
    public File getFileSystemParent() {
        return this.file.getParentFile();
    }

    @Override
    public File toFile() {
        return this.file;
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ZipFolder)) {
            return false;
        }
        ZipFolder other = (ZipFolder)obj;
        return Objects.equals(this.file, other.file);
    }

    @Override
    public void addFile(SpoonFile source) {
        throw new UnsupportedOperationException("not possible a real folder");
    }

    @Override
    public void addFolder(SpoonFolder source) {
        throw new UnsupportedOperationException("not possible a real folder");
    }

    public void extract(File destDir) {
        try (ZipInputStream zipInput = new ZipInputStream(new BufferedInputStream(new FileInputStream(this.file)));){
            ZipEntry entry;
            while ((entry = zipInput.getNextEntry()) != null) {
                File f = new File(destDir + File.separator + entry.getName());
                if (!f.toPath().normalize().startsWith(destDir.toPath())) {
                    throw new SpoonException("Entry is outside of the target dir: " + entry.getName());
                }
                if (entry.isDirectory()) {
                    f.mkdir();
                    continue;
                }
                f.getParentFile().mkdirs();
                try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(f));){
                    zipInput.transferTo(output);
                }
            }
        }
        catch (Exception e) {
            Launcher.LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }
}

