/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.compiler;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Objects;
import spoon.SpoonException;
import spoon.compiler.SpoonFile;
import spoon.compiler.SpoonFolder;
import spoon.support.Internal;
import spoon.support.compiler.ZipFolder;

public class ZipFile
implements SpoonFile {
    private final String name;
    private final ZipFolder parent;
    private final Path tempFile;
    private final byte[] content;

    @Deprecated
    public ZipFile(ZipFolder parent, String name, byte[] content) {
        this.content = content;
        this.name = name;
        this.parent = parent;
        this.tempFile = null;
    }

    @Internal
    public ZipFile(ZipFolder parent, String name, Path tempFile) {
        this.parent = parent;
        this.name = name;
        this.tempFile = tempFile;
        this.content = null;
    }

    @Override
    public InputStream getContent() {
        if (this.content != null) {
            return new ByteArrayInputStream(this.content);
        }
        try {
            return Files.newInputStream(Objects.requireNonNull(this.tempFile), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new SpoonException(e);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public SpoonFolder getParent() {
        return this.parent;
    }

    @Override
    public File getFileSystemParent() {
        return this.getParent().getFileSystemParent();
    }

    @Override
    public boolean isFile() {
        return true;
    }

    @Override
    public boolean isJava() {
        return this.getName().endsWith(".java");
    }

    @Override
    public String getPath() {
        if (this.tempFile != null) {
            return this.tempFile.toAbsolutePath().toString();
        }
        return this.toString();
    }

    public String toString() {
        return this.parent + "!" + this.getName();
    }

    @Override
    public boolean isArchive() {
        return true;
    }

    @Override
    public File toFile() {
        return null;
    }

    @Override
    public boolean isActualFile() {
        return this.tempFile != null;
    }

    public int hashCode() {
        int result = Objects.hash(this.name, this.parent, this.tempFile);
        result = 31 * result + Arrays.hashCode(this.content);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ZipFile)) {
            return false;
        }
        ZipFile zipFile = (ZipFile)obj;
        return Objects.equals(this.name, zipFile.name) && Objects.equals(this.parent, zipFile.parent) && Objects.equals(this.tempFile, zipFile.tempFile) && Arrays.equals(this.content, zipFile.content);
    }
}

