/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.compiler;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Profile;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import spoon.Launcher;
import spoon.MavenLauncher;
import spoon.SpoonException;
import spoon.compiler.Environment;
import spoon.compiler.SpoonFolder;
import spoon.compiler.SpoonResource;
import spoon.compiler.SpoonResourceHelper;
import spoon.support.Internal;

public class SpoonPom
implements SpoonResource {
    static String mavenVersionParsing = "Maven home: ";
    static String spoonClasspathTmpFileName = "spoon.classpath.tmp";
    static String spoonClasspathTmpFileNameApp = "spoon.classpath-app.tmp";
    static String spoonClasspathTmpFileNameTest = "spoon.classpath-test.tmp";
    static long classpathTmpFilesTTL = 3600000L;
    List<SpoonPom> modules = new ArrayList<SpoonPom>();
    Model model;
    SpoonPom parent;
    File pomFile;
    File directory;
    MavenLauncher.SOURCE_TYPE sourceType;
    Environment environment;
    private static final Pattern MAVEN_PROPERTY = Pattern.compile("\\$\\{.*?}");

    public SpoonPom(String path, MavenLauncher.SOURCE_TYPE sourceType, Environment environment) throws IOException, XmlPullParserException {
        this(path, null, sourceType, environment);
    }

    public SpoonPom(String path, MavenLauncher.SOURCE_TYPE sourceType, Environment environment, Pattern profileFilter) throws IOException, XmlPullParserException {
        this(path, null, sourceType, environment, profileFilter);
    }

    public SpoonPom(String path, SpoonPom parent, MavenLauncher.SOURCE_TYPE sourceType, Environment environment) throws IOException, XmlPullParserException {
        this(path, parent, sourceType, environment, Pattern.compile("^$"));
    }

    public SpoonPom(String path, SpoonPom parent, MavenLauncher.SOURCE_TYPE sourceType, Environment environment, Pattern profileFilter) throws IOException, XmlPullParserException {
        this.parent = parent;
        this.sourceType = sourceType;
        this.environment = environment;
        if (!path.endsWith(".xml") && !path.endsWith(".pom") || Paths.get(path, new String[0]).toFile().isDirectory()) {
            path = Paths.get(path, "pom.xml").toString();
        }
        this.pomFile = new File(path).getCanonicalFile();
        if (!this.pomFile.exists()) {
            throw new IOException("Pom does not exists.");
        }
        this.directory = this.pomFile.getParentFile();
        MavenXpp3Reader pomReader = new MavenXpp3Reader();
        try (FileReader reader = new FileReader(this.pomFile);){
            this.model = pomReader.read((Reader)reader);
            HashSet<String> allModules = new HashSet<String>();
            for (Profile profile : this.model.getProfiles()) {
                if (!profileFilter.matcher(profile.getId()).matches()) continue;
                for (String module : profile.getModules()) {
                    allModules.add(module);
                    this.addModule(new SpoonPom(Paths.get(this.pomFile.getParent(), module).toString(), this, sourceType, environment));
                }
            }
            for (String module : this.model.getModules()) {
                if (allModules.contains(module)) continue;
                this.addModule(new SpoonPom(Paths.get(this.pomFile.getParent(), module).toString(), this, sourceType, environment));
            }
        }
        catch (FileNotFoundException e) {
            throw new IOException("Pom does not exists.");
        }
    }

    private void addModule(SpoonPom module) {
        this.modules.add(module);
    }

    public List<SpoonPom> getModules() {
        return Collections.unmodifiableList(this.modules);
    }

    public Model getModel() {
        return this.model;
    }

    public List<File> getSourceDirectories() {
        File generatedSource;
        Path path;
        String absoluteSourcePath;
        File source;
        ArrayList<File> output = new ArrayList<File>();
        String sourcePath = null;
        Build build = this.model.getBuild();
        if (build != null) {
            sourcePath = build.getSourceDirectory();
        }
        if (sourcePath == null && (sourcePath = this.getSourceDirectoryFromParent(this.getParentPom())) == null) {
            sourcePath = Paths.get("src/main/java", new String[0]).toString();
        }
        if ((source = new File(absoluteSourcePath = (path = Paths.get(sourcePath = this.extractVariable(sourcePath), new String[0])).isAbsolute() ? path.toString() : Paths.get(this.directory.getAbsolutePath(), sourcePath).toString())).exists()) {
            output.add(source);
        }
        if ((generatedSource = Paths.get(this.directory.getAbsolutePath(), "target", "generated-sources").toFile()).exists()) {
            output.add(generatedSource);
        }
        for (SpoonPom module : this.modules) {
            output.addAll(module.getSourceDirectories());
        }
        return output;
    }

    private String getSourceDirectoryFromParent(SpoonPom parent) {
        if (parent == null) {
            return null;
        }
        String sourcePath = null;
        Build build = parent.model.getBuild();
        if (build != null ? (sourcePath = build.getSourceDirectory()) == null && parent.getParentPom() != null : parent.getParentPom() != null) {
            return this.getSourceDirectoryFromParent(parent.getParentPom());
        }
        return sourcePath;
    }

    public List<File> getTestDirectories() {
        File generatedSource;
        Path path;
        String absoluteSourcePath;
        File source;
        ArrayList<File> output = new ArrayList<File>();
        String sourcePath = null;
        Build build = this.model.getBuild();
        if (build != null) {
            sourcePath = build.getTestSourceDirectory();
        }
        if (sourcePath == null && (sourcePath = this.getTestSourceDirectoryFromParent(this.getParentPom())) == null) {
            sourcePath = Paths.get("src/test/java", new String[0]).toString();
        }
        if ((source = new File(absoluteSourcePath = (path = Paths.get(sourcePath = this.extractVariable(sourcePath), new String[0])).isAbsolute() ? path.toString() : Paths.get(this.directory.getAbsolutePath(), sourcePath).toString())).exists()) {
            output.add(source);
        }
        if ((generatedSource = Paths.get(this.directory.getAbsolutePath(), "target", "generated-test-sources").toFile()).exists()) {
            output.add(generatedSource);
        }
        for (SpoonPom module : this.modules) {
            output.addAll(module.getTestDirectories());
        }
        return output;
    }

    private String getTestSourceDirectoryFromParent(SpoonPom parent) {
        if (parent == null) {
            return null;
        }
        String sourcePath = null;
        Build build = parent.model.getBuild();
        if (build != null ? (sourcePath = build.getTestSourceDirectory()) == null && parent.getParentPom() != null : parent.getParentPom() != null) {
            return this.getTestSourceDirectoryFromParent(parent.getParentPom());
        }
        return sourcePath;
    }

    public List<File> getClasspathTmpFiles(String fileName) {
        ArrayList<File> output = new ArrayList<File>();
        File tmp = new File(this.directory, fileName);
        if (tmp.exists() && tmp.isFile()) {
            output.add(tmp);
        }
        for (SpoonPom module : this.modules) {
            output.addAll(module.getClasspathTmpFiles(fileName));
        }
        return output;
    }

    private String extractVariable(String value) {
        String val = value;
        if (value != null && value.contains("$")) {
            Matcher matcher = MAVEN_PROPERTY.matcher(value);
            while (matcher.find()) {
                String var = matcher.group();
                val = val.replace(var, this.getProperty(var.substring(2, var.length() - 1)));
            }
        }
        return val;
    }

    private @Nullable String getProperty(String key) {
        String value;
        if ("project.version".equals(key) || "pom.version".equals(key) || "version".equals(key)) {
            if (this.model.getVersion() != null) {
                return this.model.getVersion();
            }
            if (this.model.getParent() != null) {
                return this.model.getParent().getVersion();
            }
        } else if ("project.groupId".equals(key) || "pom.groupId".equals(key) || "groupId".equals(key)) {
            if (this.model.getGroupId() != null) {
                return this.model.getGroupId();
            }
            if (this.model.getParent() != null) {
                return this.model.getParent().getGroupId();
            }
        } else if ("project.artifactId".equals(key) || "pom.artifactId".equals(key) || "artifactId".equals(key)) {
            if (this.model.getArtifactId() != null) {
                return this.model.getArtifactId();
            }
            if (this.model.getParent() != null) {
                return this.model.getParent().getArtifactId();
            }
        } else {
            if ("project.basedir".equals(key) || "pom.basedir".equals(key) || "basedir".equals(key)) {
                return this.pomFile.getParent();
            }
            if ("file.separator".equals(key)) {
                return File.separator;
            }
        }
        if ((value = this.extractVariable(this.model.getProperties().getProperty(key))) == null) {
            if (this.parent == null) {
                return null;
            }
            return this.parent.getProperty(key);
        }
        return value;
    }

    public int getSourceVersion() {
        String javaVersion = null;
        if (this.model.getBuild() != null) {
            javaVersion = this.getSourceVersion((BuildBase)this.model.getBuild());
        }
        if (javaVersion != null) {
            return this.correctJavaVersion(javaVersion);
        }
        for (Profile profile : this.model.getProfiles()) {
            if (profile.getActivation() == null || !profile.getActivation().isActiveByDefault() || profile.getBuild() == null) continue;
            javaVersion = this.getSourceVersion(profile.getBuild());
        }
        if (javaVersion != null) {
            return this.correctJavaVersion(javaVersion);
        }
        javaVersion = this.getProperty("java.version");
        if (javaVersion != null) {
            return this.correctJavaVersion(javaVersion);
        }
        javaVersion = this.getProperty("java.src.version");
        if (javaVersion != null) {
            return this.correctJavaVersion(javaVersion);
        }
        javaVersion = this.getProperty("maven.compiler.source");
        if (javaVersion != null) {
            return this.correctJavaVersion(javaVersion);
        }
        javaVersion = this.getProperty("maven.compile.source");
        if (javaVersion != null) {
            return this.correctJavaVersion(javaVersion);
        }
        return this.environment.getComplianceLevel();
    }

    private int correctJavaVersion(String javaVersion) {
        String version = this.extractVariable(javaVersion);
        return Integer.parseInt(version.contains(".") ? version.substring(2) : version);
    }

    private String getSourceVersion(BuildBase build) {
        for (Plugin plugin : build.getPlugins()) {
            Xpp3Dom source;
            if (!"maven-compiler-plugin".equals(plugin.getArtifactId())) continue;
            Xpp3Dom configuration = (Xpp3Dom)plugin.getConfiguration();
            if (configuration == null || (source = configuration.getChild("source")) == null) break;
            return source.getValue();
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.model.getGroupId());
        sb.append(":");
        sb.append(this.model.getArtifactId());
        sb.append(":");
        sb.append(this.model.getVersion());
        if (this.modules.isEmpty()) {
            return sb.toString();
        }
        sb.append(" {\n");
        for (SpoonPom spoonPom : this.modules) {
            String child = spoonPom.toString();
            for (String s : child.split("\n")) {
                sb.append("\t");
                sb.append(s);
                sb.append("\n");
            }
        }
        sb.append("}");
        return sb.toString();
    }

    private void generateClassPathFile(File mvnHome, MavenLauncher.SOURCE_TYPE sourceType, Logger LOGGER, boolean forceRefresh, Map<String, String> environmentVariables) {
        File classpathFile = new File(this.directory, SpoonPom.getSpoonClasspathTmpFileName(sourceType));
        Date date = new Date();
        long time = date.getTime();
        if (forceRefresh || !classpathFile.exists() || time - classpathFile.lastModified() > classpathTmpFilesTTL) {
            DefaultInvocationRequest request = new DefaultInvocationRequest();
            request.setBatchMode(true);
            request.setPomFile(this.pomFile);
            request.addArg("dependency:build-classpath");
            Properties properties = new Properties();
            if (sourceType == MavenLauncher.SOURCE_TYPE.APP_SOURCE) {
                properties.setProperty("includeScope", "runtime");
            }
            properties.setProperty("mdep.outputFile", SpoonPom.getSpoonClasspathTmpFileName(sourceType));
            request.setProperties(properties);
            request.setReactorFailureBehavior(InvocationRequest.ReactorFailureBehavior.FailNever);
            for (Map.Entry<String, String> entry : environmentVariables.entrySet()) {
                request.addShellEnvironment(entry.getKey(), entry.getValue());
            }
            request.setBaseDirectory(this.directory);
            if (LOGGER != null) {
                request.setOutputHandler(arg_0 -> ((Logger)LOGGER).debug(arg_0));
                request.setErrorHandler(arg_0 -> ((Logger)LOGGER).debug(arg_0));
            }
            DefaultInvoker invoker = new DefaultInvoker();
            invoker.setMavenHome(mvnHome);
            try {
                invoker.execute((InvocationRequest)request);
            }
            catch (MavenInvocationException e) {
                throw new SpoonException("Maven invocation failed to build a classpath.");
            }
            classpathFile.setLastModified(time);
        }
    }

    private static String[] readClassPath(File ... classPathFiles) throws IOException {
        ArrayList<String> classpathElements = new ArrayList<String>();
        for (File classPathFile : classPathFiles) {
            try (BufferedReader br = new BufferedReader(new FileReader(classPathFile));){
                String[] classpath;
                StringBuilder sb = new StringBuilder();
                String line = br.readLine();
                while (line != null) {
                    sb.append(line);
                    line = br.readLine();
                }
                if (sb.toString().isEmpty()) continue;
                for (String cpe : classpath = sb.toString().split(File.pathSeparator)) {
                    if (classpathElements.contains(cpe)) continue;
                    classpathElements.add(cpe);
                }
            }
        }
        return classpathElements.toArray(new String[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String guessMavenHome() {
        try {
            String[] cmd = new String[]{SpoonPom.getPathToMavenExecutable(), "-version"};
            Process p = Runtime.getRuntime().exec(cmd);
            try (BufferedReader output = new BufferedReader(new InputStreamReader(p.getInputStream()));){
                String line;
                while ((line = output.readLine()) != null) {
                    if (!line.contains(mavenVersionParsing)) continue;
                    String string = line.replace(mavenVersionParsing, "");
                    return string;
                }
            }
            p.waitFor();
            throw new SpoonException("Couldn't find path to maven home.");
        }
        catch (IOException e) {
            throw new SpoonException("Maven home detection has failed.");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SpoonException("Maven home detection was interrupted.");
        }
    }

    private static String getPathToMavenExecutable() {
        String executableName = System.getProperty("os.name").contains("Windows") ? "mvn.cmd" : "mvn";
        for (String dirname : System.getenv("PATH").split(File.pathSeparator)) {
            File file = new File(dirname, executableName);
            if (!file.isFile() || !file.canExecute()) continue;
            return file.getAbsolutePath();
        }
        throw new SpoonException("Maven executable does not exist on PATH.");
    }

    public String[] buildClassPath(String mvnHome, MavenLauncher.SOURCE_TYPE sourceType, Logger LOGGER, boolean forceRefresh) {
        return this.buildClassPath(mvnHome, sourceType, LOGGER, forceRefresh, MavenOptions.empty());
    }

    public String[] buildClassPath(String mvnHome, MavenLauncher.SOURCE_TYPE sourceType, Logger LOGGER, boolean forceRefresh, MavenOptions mavenOptions) {
        String[] classpath;
        if (mvnHome == null) {
            mvnHome = SpoonPom.guessMavenHome();
        }
        this.generateClassPathFile(new File(mvnHome), sourceType, LOGGER, forceRefresh, mavenOptions.getEnvironmentVariables());
        try {
            List<File> classPathPrints = this.getClasspathTmpFiles(SpoonPom.getSpoonClasspathTmpFileName(sourceType));
            File[] classPathPrintFiles = new File[classPathPrints.size()];
            classPathPrintFiles = classPathPrints.toArray(classPathPrintFiles);
            classpath = SpoonPom.readClassPath(classPathPrintFiles);
        }
        catch (IOException e) {
            throw new SpoonException("Failed to generate class path for " + this.pomFile.getAbsolutePath() + ".");
        }
        return classpath;
    }

    private static String getSpoonClasspathTmpFileName(MavenLauncher.SOURCE_TYPE sourceType) {
        if (MavenLauncher.SOURCE_TYPE.TEST_SOURCE == sourceType) {
            return spoonClasspathTmpFileNameTest;
        }
        if (MavenLauncher.SOURCE_TYPE.APP_SOURCE == sourceType) {
            return spoonClasspathTmpFileNameApp;
        }
        return spoonClasspathTmpFileName;
    }

    public SpoonPom getParentPom() {
        return this.parent;
    }

    @Override
    public SpoonFolder getParent() {
        try {
            return SpoonResourceHelper.createFolder(this.directory);
        }
        catch (FileNotFoundException e) {
            Launcher.LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public File getFileSystemParent() {
        return this.directory;
    }

    @Override
    public String getName() {
        return this.model.getName();
    }

    @Override
    public boolean isFile() {
        return true;
    }

    @Override
    public boolean isArchive() {
        return false;
    }

    @Override
    public String getPath() {
        return this.pomFile.getPath();
    }

    @Override
    public File toFile() {
        return this.pomFile;
    }

    @Internal
    public static class MavenOptions {
        private final Map<String, String> environmentVariables = new HashMap<String, String>();

        private MavenOptions() {
        }

        public void setEnvironmentVariable(String key, String value) {
            this.environmentVariables.put(key, value);
        }

        public Map<String, String> getEnvironmentVariables() {
            return this.environmentVariables;
        }

        public static MavenOptions empty() {
            return new MavenOptions();
        }
    }
}

