/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.compiler;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import spoon.compiler.ModelBuildingException;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtCodeSnippetExpression;
import spoon.reflect.code.CtCodeSnippetStatement;
import spoon.reflect.code.CtComment;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtStatement;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtCodeSnippet;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.factory.Factory;
import spoon.reflect.path.CtPath;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.filter.TypeFilter;
import spoon.support.compiler.SnippetCompilationError;
import spoon.support.compiler.jdt.JDTSnippetCompiler;
import spoon.support.compiler.jdt.PositionBuilder;
import spoon.support.reflect.declaration.CtElementImpl;

public class SnippetCompilationHelper {
    private static final String WRAPPER_CLASS_NAME = "Wrapper";
    private static final String WRAPPER_METHOD_NAME = "wrap";

    private SnippetCompilationHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compileAndReplaceSnippetsIn(CtType<?> initialClass) {
        HashMap<CtPath, CtElement> elements2before = new HashMap<CtPath, CtElement>();
        HashMap<CtPath, CtElement> elements2after = new HashMap<CtPath, CtElement>();
        for (Object o : initialClass.filterChildren(new TypeFilter<CtCodeSnippet>(CtCodeSnippet.class)).list()) {
            CtElement el = (CtElement)o;
            if (el instanceof CtCodeSnippetStatement && SnippetCompilationHelper.containsOnlyWhiteSpace(el)) {
                SnippetCompilationHelper.replaceComments((CtStatement)el);
                continue;
            }
            elements2before.put(el.getPath(), el);
        }
        Factory f = initialClass.getFactory();
        EnumSet<ModifierKind> backup = EnumSet.noneOf(ModifierKind.class);
        backup.addAll(initialClass.getModifiers());
        initialClass.removeModifier(ModifierKind.PUBLIC);
        initialClass.delete();
        CtNamedElement clonedInitialClass = initialClass.clone();
        SnippetCompilationHelper.addDummyStatements(clonedInitialClass);
        SnippetCompilationHelper.removeIllegalDummyStatements(clonedInitialClass);
        Object pkg = initialClass.getPackage().getQualifiedName();
        if (!((String)pkg).isEmpty()) {
            pkg = "package " + (String)pkg + ";";
        }
        try {
            SnippetCompilationHelper.build(f, (String)pkg + (CtType)clonedInitialClass);
        }
        finally {
            initialClass.setModifiers(backup);
        }
        CtType newClass = f.Type().get(initialClass.getQualifiedName());
        for (CtPath ctPath : elements2before.keySet()) {
            elements2after.put(ctPath, (CtElement)ctPath.evaluateOn(f.getModel().getRootPackage()).iterator().next());
        }
        newClass.replace(initialClass);
        for (Map.Entry entry : elements2before.entrySet()) {
            CtElement toReplace = (CtElement)entry.getValue();
            toReplace.replace((CtElement)elements2after.get(entry.getKey()));
        }
    }

    private static boolean containsOnlyWhiteSpace(CtElement element) {
        char[] snippet = (element.toString() + "\n").toCharArray();
        int next = PositionBuilder.findNextNonWhitespace(snippet, snippet.length - 1, 0);
        return next == -1;
    }

    private static void replaceComments(CtStatement element) {
        SnippetCompilationHelper.replaceComments(element, (element.toString() + "\n").toCharArray());
        element.delete();
    }

    private static void replaceComments(CtStatement element, char[] snippet) {
        Factory factory = element.getFactory();
        for (int i = 0; i < snippet.length; ++i) {
            if (Character.isWhitespace(snippet[i])) continue;
            int end = PositionBuilder.getEndOfComment(snippet, snippet.length - 1, i);
            CtComment comment = snippet[i + 1] == '*' ? factory.createComment(new String(Arrays.copyOfRange(snippet, i + 2, end - 1)), CtComment.CommentType.BLOCK) : factory.createComment(new String(Arrays.copyOfRange(snippet, i + 2, end)), CtComment.CommentType.INLINE);
            element.insertBefore(comment);
            if (end + 1 >= snippet.length) break;
            SnippetCompilationHelper.replaceComments(element, Arrays.copyOfRange(snippet, end + 1, snippet.length));
            break;
        }
    }

    private static void addDummyStatements(CtType<?> clonedInitialClass) {
        Factory factory = clonedInitialClass.getFactory();
        List list = clonedInitialClass.filterChildren(new TypeFilter<CtComment>(CtComment.class)).list();
        for (CtComment comment : list) {
            CtConstructorCall call = factory.createConstructorCall(factory.createCtTypeReference(Object.class), new CtExpression[0]);
            comment.insertBefore(call);
            comment.delete();
        }
    }

    private static void removeIllegalDummyStatements(CtType<?> clonedInitialClass) {
        for (Object o : clonedInitialClass.filterChildren(new TypeFilter<CtReturn>(CtReturn.class)).list()) {
            Object currentStatement;
            CtStatement returnStmt = (CtStatement)o;
            CtBlock block = (CtBlock)returnStmt.getParent();
            for (int i = block.getStatements().size() - 1; i > 0 && (currentStatement = block.getStatement(i)) != returnStmt; --i) {
                currentStatement.delete();
            }
        }
    }

    public static CtStatement compileStatement(CtCodeSnippetStatement st) throws SnippetCompilationError {
        return SnippetCompilationHelper.internalCompileStatement(st, st.getFactory().Type().voidPrimitiveType());
    }

    public static CtStatement compileStatement(CtCodeSnippetStatement st, CtTypeReference returnType) throws SnippetCompilationError {
        return SnippetCompilationHelper.internalCompileStatement(st, returnType);
    }

    private static CtStatement internalCompileStatement(CtElement st, CtTypeReference returnType) {
        Factory f = st.getFactory();
        String contents = SnippetCompilationHelper.createWrapperContent(st, f, returnType);
        SnippetCompilationHelper.build(f, contents);
        CtType c = f.Type().get(WRAPPER_CLASS_NAME);
        CtMethod wrapper = c.getMethod(WRAPPER_METHOD_NAME, new CtTypeReference[0]);
        List<CtStatement> statements = wrapper.getBody().getStatements();
        CtStatement ret = statements.get(statements.size() - 1);
        c.getPackage().removeType(c);
        ret.delete();
        ret.setParent(null);
        if (ret instanceof CtClass) {
            CtClass klass = (CtClass)ret;
            ret.getFactory().Package().getRootPackage().addType(klass);
            klass.setSimpleName(klass.getSimpleName().replaceAll("^[0-9]*", ""));
        }
        return ret;
    }

    public static <T> CtExpression<T> compileExpression(CtCodeSnippetExpression<T> expr) throws SnippetCompilationError {
        CtReturn ret = (CtReturn)SnippetCompilationHelper.internalCompileStatement(expr, expr.getFactory().Type().objectType());
        CtExpression returnedExpression = ret.getReturnedExpression();
        returnedExpression.delete();
        returnedExpression.setParent(null);
        return returnedExpression;
    }

    private static void build(Factory f, String contents) {
        JDTSnippetCompiler builder = new JDTSnippetCompiler(f, contents);
        try {
            builder.build();
        }
        catch (Exception e) {
            throw new ModelBuildingException("snippet compilation error while compiling: " + contents, e);
        }
    }

    private static String createWrapperContent(CtElement element, Factory f, CtTypeReference returnType) {
        CtClass w = f.Class().create(WRAPPER_CLASS_NAME);
        CtBlock body = f.Core().createBlock();
        if (element instanceof CtStatement) {
            body.addStatement((CtStatement)element);
        } else if (element instanceof CtExpression) {
            CtReturn ret = f.Core().createReturn();
            ret.setReturnedExpression((CtExpression)element);
            body.addStatement(ret);
        }
        EnumSet<ModifierKind> modifiers = EnumSet.of(ModifierKind.STATIC);
        HashSet<CtTypeReference<? extends Throwable>> thrownTypes = new HashSet<CtTypeReference<? extends Throwable>>();
        thrownTypes.add((CtTypeReference<? extends Throwable>)f.Class().get((Class)Throwable.class).getReference());
        f.Method().create(w, modifiers, returnType, WRAPPER_METHOD_NAME, CtElementImpl.emptyList(), thrownTypes, body);
        String contents = w.toString();
        w.getPackage().removeType(w);
        return contents;
    }
}

