/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.adaption;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import spoon.SpoonException;
import spoon.processing.FactoryAccessor;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtFormalTypeDeclarer;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeParameter;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.support.adaption.AdaptionVisitor;
import spoon.support.adaption.DeclarationNode;
import spoon.support.adaption.GlueNode;
import spoon.support.visitor.ClassTypingContext;
import spoon.support.visitor.MethodTypingContext;

public class TypeAdaptor {
    private final CtType<?> hierarchyStart;
    private final CtTypeReference<?> hierarchyStartReference;
    private final boolean initializedWithReference;
    private CtMethod<?> startMethod;
    private CtConstructor<?> startConstructor;
    private ClassTypingContext oldClassTypingContext;

    public TypeAdaptor(CtType<?> hierarchyStart) {
        this.hierarchyStart = hierarchyStart;
        this.hierarchyStartReference = hierarchyStart.getReference();
        this.initializedWithReference = false;
    }

    public TypeAdaptor(CtTypeReference<?> hierarchyStart) {
        this.hierarchyStartReference = hierarchyStart;
        this.hierarchyStart = this.hierarchyStartReference.getTypeDeclaration();
        this.initializedWithReference = true;
    }

    public TypeAdaptor(CtMethod<?> hierarchyStart) {
        this(hierarchyStart.getDeclaringType());
        this.startMethod = hierarchyStart;
    }

    public TypeAdaptor(CtConstructor<?> hierarchyStart) {
        this(hierarchyStart.getDeclaringType());
        this.startConstructor = hierarchyStart;
    }

    public boolean isSubtypeOf(CtTypeReference<?> superRef) {
        if (TypeAdaptor.useLegacyTypeAdaption(superRef)) {
            return this.getOldClassTypingContext().isSubtypeOf(superRef);
        }
        if (this.hierarchyStartReference instanceof CtArrayTypeReference) {
            return TypeAdaptor.handleArraySubtyping((CtArrayTypeReference)this.hierarchyStartReference, superRef);
        }
        if (this.hierarchyStart == null) {
            return false;
        }
        boolean subtype = TypeAdaptor.isSubtype(this.hierarchyStart, superRef);
        if (!subtype) {
            return false;
        }
        if (this.hierarchyStartReference.getActualTypeArguments().isEmpty() && superRef.getActualTypeArguments().isEmpty()) {
            return true;
        }
        return new ClassTypingContext(this.hierarchyStartReference).isSubtypeOf(superRef);
    }

    private static boolean handleArraySubtyping(CtArrayTypeReference<?> start, CtTypeReference<?> superRef) {
        if (superRef instanceof CtArrayTypeReference) {
            CtTypeReference<?> superInner = ((CtArrayTypeReference)superRef).getComponentType();
            return new TypeAdaptor(start.getComponentType()).isSubtypeOf(superInner);
        }
        String superRefQualName = superRef.getQualifiedName();
        return superRefQualName.equals("java.lang.Object") || superRefQualName.equals("java.io.Serializable") || superRefQualName.equals("java.lang.Cloneable");
    }

    public CtType<?> getHierarchyStart() {
        return this.hierarchyStart;
    }

    private static boolean useLegacyTypeAdaption(FactoryAccessor element) {
        return element.getFactory().getEnvironment().useLegacyTypeAdaption();
    }

    public static boolean isSubtype(CtType<?> base, CtTypeReference<?> superRef) {
        if (TypeAdaptor.useLegacyTypeAdaption(base)) {
            return new TypeAdaptor(base).isSubtypeOf(superRef);
        }
        if (base.isArray() && superRef instanceof CtArrayTypeReference) {
            if (!base.isShadow()) {
                throw new SpoonException("There are no source level array type declarations");
            }
            Class<?> actualClass = base.getActualClass();
            return TypeAdaptor.isSubtype(base.getFactory().Type().get(actualClass.getComponentType()), ((CtArrayTypeReference)superRef).getComponentType());
        }
        String superRefFqn = superRef.getTypeErasure().getQualifiedName();
        if (superRef.getQualifiedName().equals("java.lang.Object") || base.getQualifiedName().equals(superRefFqn)) {
            return true;
        }
        return TypeAdaptor.supertypeReachableInInheritanceTree(base, superRefFqn);
    }

    private static boolean supertypeReachableInInheritanceTree(CtType<?> base, String qualifiedSupertypeName) {
        ArrayDeque<CtReference> workQueue = new ArrayDeque<CtReference>();
        workQueue.add(base.getReference());
        while (!workQueue.isEmpty()) {
            CtTypeReference next = (CtTypeReference)workQueue.poll();
            if (next.getQualifiedName().equals(qualifiedSupertypeName)) {
                return true;
            }
            if (next.getSuperclass() != null) {
                workQueue.add(next.getSuperclass());
            }
            workQueue.addAll(next.getSuperInterfaces());
        }
        return false;
    }

    public CtMethod<?> adaptMethod(CtMethod<?> inputMethod) {
        return this.adaptMethod(inputMethod, true);
    }

    /*
     * WARNING - void declaration
     */
    private CtMethod<?> adaptMethod(CtMethod<?> inputMethod, boolean cloneBody) {
        void var5_13;
        CtExecutable clonedMethod;
        if (TypeAdaptor.useLegacyTypeAdaption(inputMethod)) {
            return this.legacyAdaptMethod(inputMethod);
        }
        if (cloneBody) {
            clonedMethod = inputMethod.clone();
        } else {
            clonedMethod = (CtMethod)inputMethod.getFactory().createMethod().setSimpleName(inputMethod.getSimpleName());
            for (CtParameter<?> ctParameter : inputMethod.getParameters()) {
                clonedMethod.addParameter((CtParameter<?>)ctParameter.clone());
            }
            for (CtTypeParameter ctTypeParameter : inputMethod.getFormalCtTypeParameters()) {
                clonedMethod.addFormalCtTypeParameter(ctTypeParameter.clone());
            }
        }
        for (int i = 0; i < clonedMethod.getFormalCtTypeParameters().size(); ++i) {
            CtTypeParameter ctTypeParameter = clonedMethod.getFormalCtTypeParameters().get(i);
            CtTypeParameter realParameter = inputMethod.getFormalCtTypeParameters().get(i);
            if (realParameter.getSuperclass() != null) {
                ctTypeParameter.setSuperclass(this.adaptType(realParameter.getSuperclass()));
            }
            ctTypeParameter.setSuperInterfaces(realParameter.getSuperInterfaces().stream().map(this::adaptType).collect(Collectors.toSet()));
        }
        CtTypeReference<?> newReturnType = this.adaptType(inputMethod.getType());
        clonedMethod.setType(newReturnType);
        boolean bl = false;
        while (var5_13 < clonedMethod.getParameters().size()) {
            CtParameter<?> newParameter = clonedMethod.getParameters().get((int)var5_13);
            newParameter.setType(this.adaptType(inputMethod.getParameters().get((int)var5_13).getType()));
            ++var5_13;
        }
        Set<CtTypeReference<? extends Throwable>> set = inputMethod.getThrownTypes().stream().map(this::adaptType).map(it -> it).collect(Collectors.toSet());
        clonedMethod.setThrownTypes(set);
        return (CtMethod)clonedMethod.setParent(this.hierarchyStart);
    }

    private CtMethod<?> legacyAdaptMethod(CtMethod<?> inputMethod) {
        return (CtMethod)new MethodTypingContext().setClassTypingContext(this.getOldClassTypingContext()).setMethod(inputMethod).getAdaptationScope();
    }

    private ClassTypingContext getOldClassTypingContext() {
        if (this.oldClassTypingContext == null) {
            this.oldClassTypingContext = this.initializedWithReference ? new ClassTypingContext(this.hierarchyStartReference) : new ClassTypingContext(this.hierarchyStart);
        }
        return this.oldClassTypingContext;
    }

    public boolean isConflicting(CtMethod<?> first, CtMethod<?> second) {
        if (TypeAdaptor.useLegacyTypeAdaption(first)) {
            return this.getOldClassTypingContext().isSameSignature(first, second);
        }
        if (first.getParameters().size() != second.getParameters().size()) {
            return false;
        }
        if (!first.getSimpleName().equals(second.getSimpleName())) {
            return false;
        }
        for (int i = 0; i < first.getParameters().size(); ++i) {
            CtTypeReference<?> secondType;
            CtParameter<?> firstParameter = first.getParameters().get(i);
            CtParameter<?> secondParameter = second.getParameters().get(i);
            CtTypeReference<?> firstType = firstParameter.getType().getTypeErasure();
            if (firstType.equals(secondType = secondParameter.getType().getTypeErasure())) continue;
            return this.isOverriding(first, second) || this.isOverriding(second, first);
        }
        return true;
    }

    public boolean isSameSignature(CtMethod<?> first, CtMethod<?> second) {
        if (TypeAdaptor.useLegacyTypeAdaption(first)) {
            return this.getOldClassTypingContext().isSubSignature(first, second);
        }
        if (first.getParameters().size() != second.getParameters().size()) {
            return false;
        }
        if (!first.getSimpleName().equals(second.getSimpleName())) {
            return false;
        }
        CtMethod<?> adaptedFirst = this.adaptMethod(first);
        CtMethod<?> adaptedSecond = this.adaptMethod(second);
        return this.isConflicting(adaptedFirst, adaptedSecond);
    }

    public boolean isOverriding(CtMethod<?> subMethod, CtMethod<?> superMethod) {
        CtType<?> superDeclaringType;
        if (TypeAdaptor.useLegacyTypeAdaption(subMethod)) {
            return this.getOldClassTypingContext().isOverriding(subMethod, superMethod);
        }
        if (subMethod.getParameters().size() != superMethod.getParameters().size()) {
            return false;
        }
        if (!subMethod.getSimpleName().equals(superMethod.getSimpleName())) {
            return false;
        }
        if (subMethod.isStatic() || superMethod.isStatic()) {
            return false;
        }
        CtType<?> subDeclaringType = subMethod.getDeclaringType();
        if (!TypeAdaptor.isSubtype(subDeclaringType, (superDeclaringType = superMethod.getDeclaringType()).getReference())) {
            return false;
        }
        CtMethod<?> adapted = new TypeAdaptor(subMethod.getDeclaringType()).adaptMethod(superMethod, false);
        for (int i = 0; i < subMethod.getParameters().size(); ++i) {
            CtParameter<?> subParam = subMethod.getParameters().get(i);
            CtParameter<?> superParam = adapted.getParameters().get(i);
            if (subParam.getType().getTypeErasure().equals(superParam.getType().getTypeErasure())) continue;
            return false;
        }
        return true;
    }

    public CtTypeReference<?> adaptType(CtTypeReference<?> superRef) {
        if (TypeAdaptor.useLegacyTypeAdaption(superRef)) {
            return this.legacyAdaptType(superRef);
        }
        if (this.hierarchyStart.getQualifiedName().equals(superRef.getQualifiedName())) {
            return (CtTypeReference)superRef.clone().setParent(superRef.isParentInitialized() ? superRef.getParent() : null);
        }
        Optional<CtTypeReference<?>> adaptedBetweenMethods = this.adaptBetweenMethods(superRef);
        if (adaptedBetweenMethods.isPresent()) {
            return adaptedBetweenMethods.get();
        }
        DeclarationNode hierarchy = this.buildHierarchyFrom(this.hierarchyStartReference, this.hierarchyStart, superRef);
        if (hierarchy == null) {
            hierarchy = this.buildHierarchyFrom(this.hierarchyStartReference, this.findDeclaringType(this.hierarchyStartReference), superRef);
        }
        if (hierarchy == null) {
            return (CtTypeReference)superRef.clone().setParent(superRef.isParentInitialized() ? superRef.getParent() : null);
        }
        return AdaptionVisitor.adapt(superRef, hierarchy);
    }

    private CtTypeReference<?> legacyAdaptType(CtTypeReference<?> superRef) {
        if (this.startMethod != null) {
            return new MethodTypingContext().setClassTypingContext(this.getOldClassTypingContext()).setMethod(this.startMethod).adaptType(superRef);
        }
        if (this.startConstructor != null) {
            return new MethodTypingContext().setClassTypingContext(this.getOldClassTypingContext()).setConstructor(this.startConstructor).adaptType(superRef);
        }
        return this.getOldClassTypingContext().adaptType(superRef);
    }

    public CtTypeReference<?> adaptType(CtType<?> superType) {
        return this.adaptType((CtTypeReference<?>)superType.getReference());
    }

    private Optional<CtTypeReference<?>> adaptBetweenMethods(CtTypeReference<?> superRef) {
        if (this.startMethod == null && this.startConstructor == null) {
            return Optional.empty();
        }
        CtExecutable<?> startExecutable = this.startMethod != null ? this.startMethod : this.startConstructor;
        Optional<CtExecutable<?>> superExecutableOpt = this.getDeclaringMethodOrConstructor(superRef);
        if (superExecutableOpt.isEmpty()) {
            return Optional.empty();
        }
        CtExecutable<?> superMethod = superExecutableOpt.get();
        if (superMethod.getType().equals(superRef)) {
            return Optional.of(startExecutable.getType());
        }
        for (int i = 0; i < superMethod.getParameters().size(); ++i) {
            CtParameter<?> parameter = superMethod.getParameters().get(i);
            if (!parameter.getType().equals(superRef)) continue;
            return Optional.of(startExecutable.getParameters().get(i).getType());
        }
        throw new SpoonException("Did not find a type :(");
    }

    private Optional<CtExecutable<?>> getDeclaringMethodOrConstructor(CtTypeReference<?> reference) {
        if (!(reference instanceof CtTypeParameterReference)) {
            return Optional.empty();
        }
        CtElement typeParam = reference.getDeclaration();
        if (!typeParam.isParentInitialized()) {
            return Optional.empty();
        }
        CtElement parent = typeParam.getParent();
        if (!(parent instanceof CtMethod) && !(parent instanceof CtConstructor)) {
            return Optional.empty();
        }
        return Optional.of((CtExecutable)parent);
    }

    private DeclarationNode buildHierarchyFrom(CtTypeReference<?> startReference, CtType<?> startType, CtTypeReference<?> end) {
        CtType<?> endType = this.findDeclaringType(end);
        HashMap declarationNodes = new HashMap();
        if (this.needToMoveStartTypeToEnclosingClass(end, endType)) {
            startType = this.moveStartTypeToEnclosingClass(this.hierarchyStart, (CtTypeReference<?>)endType.getReference());
            startReference = startType.getReference();
        }
        DeclarationNode root = this.buildDeclarationHierarchyFrom((CtTypeReference<?>)startType.getReference(), endType, new HashMap(), declarationNodes);
        if (!startReference.getActualTypeArguments().isEmpty()) {
            root.addChild(new GlueNode((CtTypeReference<?>)startReference));
        }
        return declarationNodes.values().stream().filter(it -> it.inducedBy(endType)).findFirst().orElse(null);
    }

    private boolean needToMoveStartTypeToEnclosingClass(CtTypeReference<?> end, CtType<?> endType) {
        if (!(end instanceof CtTypeParameterReference)) {
            return false;
        }
        CtType<?> parentType = end.getParent(CtType.class);
        return !(parentType = TypeAdaptor.resolveTypeParameterToDeclarer(parentType)).getQualifiedName().equals(endType.getQualifiedName());
    }

    private CtType<?> moveStartTypeToEnclosingClass(CtType<?> start, CtTypeReference<?> endRef) {
        for (CtType<?> current = start; current != null; current = current.getDeclaringType()) {
            if (!TypeAdaptor.isSubtype(current, endRef)) continue;
            return current;
        }
        throw new SpoonException("Did not find a suitable enclosing type to start parameter type adaption from");
    }

    private CtType<?> findDeclaringType(CtTypeReference<?> reference) {
        CtType type = null;
        if (reference instanceof CtTypeParameterReference) {
            type = reference.getTypeDeclaration();
        }
        if (type == null && reference.isParentInitialized()) {
            type = reference.getParent(CtType.class);
        }
        if (type == null) {
            type = reference.getTypeDeclaration();
        }
        return TypeAdaptor.resolveTypeParameterToDeclarer(type);
    }

    private static CtType<?> resolveTypeParameterToDeclarer(CtType<?> parentType) {
        if (parentType instanceof CtTypeParameter) {
            CtFormalTypeDeclarer declarer = ((CtTypeParameter)parentType).getTypeParameterDeclarer();
            if (declarer instanceof CtType) {
                return (CtType)declarer;
            }
            return declarer.getDeclaringType();
        }
        return parentType;
    }

    private DeclarationNode buildDeclarationHierarchyFrom(CtTypeReference<?> start, CtType<?> end, Map<CtTypeReference<?>, GlueNode> glueNodes, Map<CtTypeReference<?>, DeclarationNode> declarationNodes) {
        DeclarationNode node = declarationNodes.computeIfAbsent(start, DeclarationNode::new);
        if (!start.getActualTypeArguments().isEmpty()) {
            throw new RuntimeException("Wat? Why declaration then?");
        }
        if (end.getQualifiedName().equals(start.getQualifiedName())) {
            return node;
        }
        if (start.getSuperclass() != null) {
            this.buildGlueHierarchyFrom(start.getSuperclass(), end, glueNodes, declarationNodes).addChild(node);
        }
        for (CtTypeReference<?> superInterface : start.getSuperInterfaces()) {
            this.buildGlueHierarchyFrom(superInterface, end, glueNodes, declarationNodes).addChild(node);
        }
        return node;
    }

    private GlueNode buildGlueHierarchyFrom(CtTypeReference<?> start, CtType<?> end, Map<CtTypeReference<?>, GlueNode> glueNodes, Map<CtTypeReference<?>, DeclarationNode> declarationNodes) {
        GlueNode node = glueNodes.computeIfAbsent(start, GlueNode::new);
        CtType<?> typeDeclaration = start.getTypeDeclaration();
        if (typeDeclaration != null) {
            this.buildDeclarationHierarchyFrom((CtTypeReference<?>)typeDeclaration.getReference(), end, glueNodes, declarationNodes).addChild(node);
        }
        return node;
    }
}

