/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.adaption;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeParameter;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.support.adaption.AdaptionVisitor;
import spoon.support.adaption.DeclarationNode;
import spoon.support.adaption.NodePrintHelper;

class GlueNode {
    private final List<CtTypeReference<?>> actualArguments;
    private final CtTypeReference<?> inducedBy;
    private final Collection<DeclarationNode> children;

    GlueNode(CtTypeReference<?> inducedBy) {
        this.inducedBy = inducedBy;
        this.actualArguments = inducedBy.getActualTypeArguments();
        this.children = new ArrayList<DeclarationNode>();
    }

    public void addChild(DeclarationNode child) {
        this.children.add(child);
    }

    public boolean isInducedBy(CtTypeReference<?> reference) {
        return reference.getQualifiedName().equals(this.inducedBy.getQualifiedName());
    }

    public Optional<CtTypeReference<?>> resolveTypeParameter(CtTypeParameterReference reference) {
        String name = reference.getSimpleName();
        CtType<?> typeDeclaration = this.inducedBy.getTypeDeclaration();
        for (int i = 0; i < typeDeclaration.getFormalCtTypeParameters().size(); ++i) {
            CtTypeParameter parameter = typeDeclaration.getFormalCtTypeParameters().get(i);
            if (!parameter.getSimpleName().equals(name)) continue;
            if (this.actualArguments.isEmpty()) {
                return Optional.of(reference.getFactory().Class().get((Class)Object.class).getReference());
            }
            CtTypeReference<?> actualArgument = this.actualArguments.get(i);
            if (!actualArgument.isGenerics()) {
                return Optional.of(actualArgument.clone());
            }
            return Optional.of(AdaptionVisitor.adapt(actualArgument, this.children.iterator().next()));
        }
        return Optional.empty();
    }

    public String toString() {
        Object result = "{\n";
        result = (String)result + "  " + NodePrintHelper.quote("String") + ": " + NodePrintHelper.quote(this.inducedBy.getQualifiedName()) + ",\n";
        result = (String)result + "  " + NodePrintHelper.quote("Actual") + ": " + NodePrintHelper.toJsonLikeArray(this.actualArguments);
        if (!this.children.isEmpty()) {
            result = (String)result + ",\n  [\n";
            StringJoiner children = new StringJoiner(",\n");
            for (DeclarationNode node : this.children) {
                children.add(node.toString());
            }
            result = (String)result + children.toString().lines().map(it -> "    " + it).collect(Collectors.joining("\n")) + "\n";
            result = (String)result + "  ]\n";
        } else {
            result = (String)result + "\n";
        }
        result = (String)result + "}";
        return result;
    }
}

