/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.adaption;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import spoon.SpoonException;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeParameter;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.support.adaption.GlueNode;
import spoon.support.adaption.NodePrintHelper;

class DeclarationNode {
    private final List<CtTypeParameter> formalArguments;
    private final CtTypeReference<?> inducedBy;
    private final Collection<GlueNode> children;

    protected DeclarationNode(CtTypeReference<?> inducedBy) {
        this.inducedBy = inducedBy;
        this.formalArguments = inducedBy.getTypeDeclaration().getFormalCtTypeParameters();
        this.children = new ArrayList<GlueNode>();
    }

    public void addChild(GlueNode child) {
        this.children.add(child);
    }

    public boolean inducedBy(CtType<?> type) {
        return this.inducedBy.getQualifiedName().equals(type.getQualifiedName());
    }

    public Optional<CtTypeReference<?>> resolveTypeParameter(CtTypeParameterReference reference) {
        String name = reference.getSimpleName();
        if (!this.children.isEmpty()) {
            return this.children.iterator().next().resolveTypeParameter(reference);
        }
        Optional<CtTypeReference<?>> foo = this.formalArguments.stream().filter(it -> it.getSimpleName().equals(name)).findFirst().map(CtTypeParameter::getReference).or(() -> this.findTypeParameterByName(name)).map(it -> it);
        if (foo.isPresent()) {
            return foo;
        }
        throw new SpoonException("Could not find declaration of formal type parameter" + name + " in " + this.formalArguments + " for " + this.inducedBy);
    }

    private Optional<CtTypeParameterReference> findTypeParameterByName(String name) {
        for (CtType<?> currentType = this.inducedBy.getTypeDeclaration(); currentType != null; currentType = currentType.getDeclaringType()) {
            Optional<CtTypeParameterReference> parameter = currentType.getFormalCtTypeParameters().stream().filter(it -> it.getSimpleName().equals(name)).map(CtTypeParameter::getReference).findFirst();
            if (!parameter.isPresent()) continue;
            return parameter;
        }
        return Optional.empty();
    }

    public String toString() {
        Object result = "{\n";
        result = (String)result + "  " + NodePrintHelper.quote("String") + ": " + NodePrintHelper.quote(this.inducedBy.getQualifiedName()) + ",\n";
        result = (String)result + "  " + NodePrintHelper.quote("Formal") + ": " + NodePrintHelper.toJsonLikeArray(this.formalArguments);
        if (!this.children.isEmpty()) {
            result = (String)result + ",\n  [\n";
            StringJoiner children = new StringJoiner("\n");
            for (GlueNode node : this.children) {
                children.add(node.toString());
            }
            result = (String)result + children.toString().lines().map(it -> "    " + it).collect(Collectors.joining("\n")) + "\n";
            result = (String)result + "  ]\n";
        } else {
            result = (String)result + "\n";
        }
        result = (String)result + "}";
        return result;
    }
}

