/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.adaption;

import java.util.List;
import java.util.stream.Collectors;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtIntersectionTypeReference;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtWildcardReference;
import spoon.reflect.visitor.CtAbstractVisitor;
import spoon.support.adaption.DeclarationNode;

class AdaptionVisitor
extends CtAbstractVisitor {
    private final DeclarationNode hierarchy;
    private CtTypeReference<?> result;

    private AdaptionVisitor(DeclarationNode hierarchy) {
        this.hierarchy = hierarchy;
    }

    @Override
    public void visitCtWildcardReference(CtWildcardReference wildcardReference) {
        CtTypeReference<?> newBounding = AdaptionVisitor.adapt(wildcardReference.getBoundingType(), this.hierarchy);
        this.result = wildcardReference.clone().setBoundingType(newBounding);
    }

    @Override
    public void visitCtTypeParameterReference(CtTypeParameterReference reference) {
        if (AdaptionVisitor.isDeclaredOnExecutable(reference)) {
            this.result = reference.clone();
            return;
        }
        this.result = this.hierarchy.resolveTypeParameter(reference).orElse(reference.clone());
    }

    @Override
    public <T> void visitCtArrayTypeReference(CtArrayTypeReference<T> reference) {
        CtTypeReference<?> newArrayType = AdaptionVisitor.adapt(reference.getArrayType(), this.hierarchy);
        CtArrayTypeReference<?[]> newReference = reference.getFactory().createArrayReference(newArrayType);
        for (int i = 1; i < reference.getDimensionCount(); ++i) {
            newReference = reference.getFactory().createArrayReference(newReference);
        }
        this.result = newReference;
    }

    @Override
    public <T> void visitCtIntersectionTypeReference(CtIntersectionTypeReference<T> reference) {
        List<CtTypeReference<?>> newBounds = reference.getBounds().stream().map(it -> AdaptionVisitor.adapt(it, this.hierarchy)).collect(Collectors.toList());
        this.result = reference.clone().setBounds(newBounds);
    }

    public static CtTypeReference<?> adapt(CtTypeReference<?> reference, DeclarationNode hierarchy) {
        if (!reference.isGenerics()) {
            return reference.clone();
        }
        AdaptionVisitor visitor = new AdaptionVisitor(hierarchy);
        reference.accept(visitor);
        if (visitor.result != null) {
            return visitor.result;
        }
        List newActualArguments = reference.getActualTypeArguments().stream().map(it -> AdaptionVisitor.adapt(it, hierarchy)).collect(Collectors.toList());
        return (CtTypeReference)reference.clone().setActualTypeArguments(newActualArguments);
    }

    private static boolean isDeclaredOnExecutable(CtTypeParameterReference reference) {
        return reference.getDeclaration().getTypeParameterDeclarer() instanceof CtExecutable;
    }
}

