/*
 * Decompiled with CFR 0.152.
 */
package spoon.support;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import org.slf4j.Logger;
import spoon.Launcher;
import spoon.OutputType;
import spoon.SpoonException;
import spoon.compiler.Environment;
import spoon.compiler.InvalidClassPathException;
import spoon.compiler.SpoonFile;
import spoon.compiler.builder.EncodingProvider;
import spoon.processing.FileGenerator;
import spoon.processing.ProcessingManager;
import spoon.processing.Processor;
import spoon.processing.ProcessorProperties;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtType;
import spoon.reflect.visitor.DefaultImportComparator;
import spoon.reflect.visitor.DefaultJavaPrettyPrinter;
import spoon.reflect.visitor.ForceFullyQualifiedProcessor;
import spoon.reflect.visitor.ForceImportProcessor;
import spoon.reflect.visitor.ImportCleaner;
import spoon.reflect.visitor.ImportConflictDetector;
import spoon.reflect.visitor.PrettyPrinter;
import spoon.support.CompressionType;
import spoon.support.DefaultOutputDestinationHandler;
import spoon.support.Level;
import spoon.support.OutputDestinationHandler;
import spoon.support.compiler.FileSystemFolder;
import spoon.support.compiler.SpoonProgress;
import spoon.support.modelobs.EmptyModelChangeListener;
import spoon.support.modelobs.FineModelChangeListener;

public class StandardEnvironment
implements Serializable,
Environment {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_CODE_COMPLIANCE_LEVEL = StandardEnvironment.getCurrentJvmVersion();
    private transient FileGenerator<? extends CtElement> defaultFileGenerator;
    private int errorCount = 0;
    transient ProcessingManager manager;
    private boolean processingStopped = false;
    private Environment.PRETTY_PRINTING_MODE prettyPrintingMode = Environment.PRETTY_PRINTING_MODE.FULLYQUALIFIED;
    private int warningCount = 0;
    private String[] sourceClasspath = null;
    private List<String> sourceModulePath = List.of();
    private boolean preserveLineNumbers = false;
    private boolean copyResources = true;
    private boolean enableComments = true;
    private transient Logger logger = Launcher.LOGGER;
    private Level level = Level.ERROR;
    private boolean shouldCompile = false;
    private boolean skipSelfChecks = false;
    private transient FineModelChangeListener modelChangeListener = new EmptyModelChangeListener();
    private transient Charset encoding = Charset.defaultCharset();
    private transient EncodingProvider encodingProvider;
    private int complianceLevel = DEFAULT_CODE_COMPLIANCE_LEVEL;
    private boolean previewFeaturesEnabled = false;
    private transient OutputDestinationHandler outputDestinationHandler = new DefaultOutputDestinationHandler(new File("spooned"), this);
    private OutputType outputType = OutputType.CLASSES;
    private Boolean noclasspath = null;
    private Boolean ignoreSyntaxErrors = false;
    private transient SpoonProgress spoonProgress = new SpoonProgress(){};
    private CompressionType compressionType = CompressionType.GZIP;
    private boolean useLegacyTypeAdaption;
    private boolean ignoreDuplicateDeclarations = false;
    private Supplier<PrettyPrinter> prettyPrinterCreator;
    transient Map<String, ProcessorProperties> processorProperties = new TreeMap<String, ProcessorProperties>();
    boolean useTabulations = false;
    int tabulationSize = 4;
    private transient ClassLoader classloader;
    private transient ClassLoader inputClassloader;
    private String binaryOutputDirectory = "spooned-classes";

    @Override
    public Environment.PRETTY_PRINTING_MODE getPrettyPrintingMode() {
        return this.prettyPrintingMode;
    }

    @Override
    public void setPrettyPrintingMode(Environment.PRETTY_PRINTING_MODE prettyPrintingMode) {
        this.prettyPrintingMode = prettyPrintingMode;
    }

    private static int getCurrentJvmVersion() {
        try {
            return Runtime.version().feature();
        }
        catch (Exception e) {
            System.err.println("Error getting the jvm  version: " + e.getMessage());
            return 8;
        }
    }

    @Override
    public void debugMessage(String message) {
        this.print(message, Level.DEBUG);
    }

    @Override
    public boolean isAutoImports() {
        return Environment.PRETTY_PRINTING_MODE.AUTOIMPORT.equals((Object)this.prettyPrintingMode);
    }

    @Override
    public void setAutoImports(boolean autoImports) {
        this.prettyPrintingMode = autoImports ? Environment.PRETTY_PRINTING_MODE.AUTOIMPORT : Environment.PRETTY_PRINTING_MODE.FULLYQUALIFIED;
    }

    @Override
    public FileGenerator<? extends CtElement> getDefaultFileGenerator() {
        return this.defaultFileGenerator;
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(String level) {
        this.level = this.toLevel(level);
    }

    @Override
    public boolean shouldCompile() {
        return this.shouldCompile;
    }

    @Override
    public void setShouldCompile(boolean shouldCompile) {
        this.shouldCompile = shouldCompile;
    }

    @Override
    public boolean checksAreSkipped() {
        return this.skipSelfChecks;
    }

    @Override
    public void disableConsistencyChecks() {
        this.skipSelfChecks = true;
    }

    private Level toLevel(String level) {
        Level levelEnum;
        if (level == null || level.isEmpty()) {
            throw new SpoonException("Wrong level given at Spoon.");
        }
        try {
            levelEnum = Level.valueOf(level);
        }
        catch (IllegalArgumentException e) {
            return Level.TRACE;
        }
        return levelEnum;
    }

    @Override
    public ProcessingManager getManager() {
        return this.manager;
    }

    @Override
    public ProcessorProperties getProcessorProperties(String processorName) {
        if (this.processorProperties.containsKey(processorName)) {
            return this.processorProperties.get(processorName);
        }
        return null;
    }

    @Override
    public boolean isProcessingStopped() {
        return this.processingStopped;
    }

    private void prefix(StringBuilder buffer, Level level) {
        if (level == Level.ERROR) {
            buffer.append("error: ");
            ++this.errorCount;
        } else if (level == Level.WARN) {
            buffer.append("warning: ");
            ++this.warningCount;
        }
    }

    @Override
    public void report(Processor<?> processor, Level level, CtElement element, String message) {
        StringBuilder buffer = new StringBuilder();
        this.prefix(buffer, level);
        buffer.append(message);
        CtType type = element instanceof CtType ? (CtType)element : element.getParent(CtType.class);
        SourcePosition sp = element.getPosition();
        if (sp == null) {
            buffer.append(" (Unknown Source)");
        } else {
            CtExecutable exe;
            if (type != null) {
                buffer.append(" at ").append(type.getQualifiedName()).append(".");
            } else {
                buffer.append("at (?).");
            }
            CtExecutable ctExecutable = exe = element instanceof CtExecutable ? (CtExecutable)element : element.getParent(CtExecutable.class);
            if (exe != null) {
                buffer.append(exe.getSimpleName());
            }
            if (sp.getFile() != null) {
                buffer.append("(").append(sp.getFile().getName()).append(":").append(sp.getLine()).append(")");
            } else {
                buffer.append("(?:?)");
            }
        }
        this.print(buffer.toString(), level);
    }

    @Override
    public void report(Processor<?> processor, Level level, String message) {
        StringBuilder buffer = new StringBuilder();
        this.prefix(buffer, level);
        buffer.append(message);
        this.print(buffer.toString(), level);
    }

    private void print(String message, Level messageLevel) {
        if (this.level != Level.OFF && messageLevel.toInt() <= this.level.toInt()) {
            switch (messageLevel) {
                case ERROR: {
                    this.logger.error(message);
                    break;
                }
                case WARN: {
                    this.logger.warn(message);
                    break;
                }
                case INFO: {
                    this.logger.info(message);
                    break;
                }
                case DEBUG: {
                    this.logger.debug(message);
                    break;
                }
                case TRACE: {
                    this.logger.trace(message);
                }
            }
        }
    }

    @Override
    public void reportEnd() {
        this.print("End of processing: ", Level.DEBUG);
        if (this.warningCount > 0) {
            this.print(this.warningCount + " warning", Level.INFO);
            if (this.warningCount > 1) {
                this.print("s", Level.INFO);
            }
            if (this.errorCount > 0) {
                this.print(", ", Level.INFO);
            }
        }
        if (this.errorCount > 0) {
            this.print(this.errorCount + " error", Level.INFO);
            if (this.errorCount > 1) {
                this.print("s", Level.INFO);
            }
        }
        if (this.errorCount + this.warningCount > 0) {
            this.print("\n", Level.INFO);
        } else {
            this.print("No errors, no warnings", Level.DEBUG);
        }
    }

    @Override
    public void reportProgressMessage(String message) {
        this.print(message, Level.INFO);
    }

    public void setDebug(boolean debug) {
    }

    @Override
    public void setDefaultFileGenerator(FileGenerator<? extends CtElement> defaultFileGenerator) {
        this.defaultFileGenerator = defaultFileGenerator;
    }

    @Override
    public void setManager(ProcessingManager manager) {
        this.manager = manager;
    }

    @Override
    public void setProcessingStopped(boolean processingStopped) {
        this.processingStopped = processingStopped;
    }

    public void setVerbose(boolean verbose) {
    }

    @Override
    public int getComplianceLevel() {
        return this.complianceLevel;
    }

    @Override
    public void setComplianceLevel(int level) {
        this.complianceLevel = level;
    }

    @Override
    public boolean isPreviewFeaturesEnabled() {
        return this.previewFeaturesEnabled;
    }

    @Override
    public void setPreviewFeaturesEnabled(boolean previewFeaturesEnabled) {
        this.previewFeaturesEnabled = previewFeaturesEnabled;
    }

    @Override
    public void setProcessorProperties(String processorName, ProcessorProperties prop) {
        this.processorProperties.put(processorName, prop);
    }

    @Override
    public boolean isUsingTabulations() {
        return this.useTabulations;
    }

    @Override
    public void useTabulations(boolean tabulation) {
        this.useTabulations = tabulation;
    }

    @Override
    public int getTabulationSize() {
        return this.tabulationSize;
    }

    @Override
    public void setTabulationSize(int tabulationSize) {
        this.tabulationSize = tabulationSize;
    }

    @Override
    public void setInputClassLoader(ClassLoader aClassLoader) {
        URL[] urls;
        if (aClassLoader instanceof URLClassLoader && (urls = ((URLClassLoader)aClassLoader).getURLs()) != null && urls.length > 0) {
            for (URL url : urls) {
                if ("file".equals(url.getProtocol())) continue;
                throw new SpoonException("Spoon does not support a URLClassLoader containing other resources than local file.");
            }
            ArrayList<String> classpath = new ArrayList<String>();
            for (URL url : urls) {
                try {
                    classpath.add(Path.of(url.toURI()).toAbsolutePath().toString());
                }
                catch (IllegalArgumentException | URISyntaxException | FileSystemNotFoundException ignored) {
                    classpath.add(URLDecoder.decode(url.getPath(), StandardCharsets.UTF_8));
                }
            }
            this.setSourceClasspath(classpath.toArray(new String[0]));
        }
        this.classloader = aClassLoader;
    }

    @Override
    public ClassLoader getInputClassLoader() {
        if (this.classloader != null) {
            return this.classloader;
        }
        if (this.inputClassloader == null) {
            this.inputClassloader = new URLClassLoader(this.urlClasspath(), Thread.currentThread().getContextClassLoader());
        }
        return this.inputClassloader;
    }

    public URL[] urlClasspath() {
        Object[] classpath = this.getSourceClasspath();
        int length = classpath == null ? 0 : classpath.length;
        URL[] urls = new URL[length];
        for (int i = 0; i < length; ++i) {
            try {
                urls[i] = new File((String)classpath[i]).toURI().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException("Invalid classpath: " + Arrays.toString(classpath), e);
            }
        }
        return urls;
    }

    @Override
    public String[] getSourceClasspath() {
        return this.sourceClasspath;
    }

    @Override
    public void setSourceClasspath(String[] sourceClasspath) {
        this.verifySourceClasspath(sourceClasspath);
        this.sourceClasspath = sourceClasspath;
        this.inputClassloader = null;
    }

    @Override
    public List<String> getSourceModulePath() {
        return this.sourceModulePath;
    }

    @Override
    public void setSourceModulePath(List<String> sourceModulePath) {
        this.sourceModulePath = List.copyOf(sourceModulePath);
    }

    private void verifySourceClasspath(String[] sourceClasspath) throws InvalidClassPathException {
        for (String classPathElem : sourceClasspath) {
            File classOrJarFolder = new File(classPathElem);
            if (!classOrJarFolder.exists()) {
                throw new InvalidClassPathException(classPathElem + " does not exist, it is not a valid folder");
            }
            if (classOrJarFolder.isDirectory()) {
                FileSystemFolder tmp = new FileSystemFolder(classOrJarFolder);
                List<SpoonFile> javaFiles = tmp.getAllJavaFiles();
                if (!javaFiles.isEmpty()) {
                    this.print("You're trying to give source code in the classpath, this should be given to addInputSource " + javaFiles, Level.WARN);
                }
                this.print("You specified the directory " + classOrJarFolder.getPath() + " in source classpath, please note that only class files will be considered. Jars and subdirectories will be ignored.", Level.WARN);
                continue;
            }
            if (!classOrJarFolder.getName().endsWith(".class")) continue;
            throw new InvalidClassPathException(".class files are not accepted in source classpath.");
        }
    }

    @Override
    public int getErrorCount() {
        return this.errorCount;
    }

    @Override
    public int getWarningCount() {
        return this.warningCount;
    }

    @Override
    public boolean isPreserveLineNumbers() {
        return this.preserveLineNumbers;
    }

    @Override
    public void setPreserveLineNumbers(boolean preserveLineNumbers) {
        this.preserveLineNumbers = preserveLineNumbers;
    }

    @Override
    public void setNoClasspath(boolean option) {
        this.noclasspath = option;
    }

    @Override
    public boolean getNoClasspath() {
        if (this.noclasspath == null) {
            this.print("Spoon is used with the default noClasspath option set as true. See: http://spoon.gforge.inria.fr/launcher.html#about-the-classpath", Level.INFO);
            this.noclasspath = true;
        }
        return this.noclasspath;
    }

    @Override
    public void setIgnoreSyntaxErrors(boolean ignoreSyntaxErrors) {
        this.ignoreSyntaxErrors = ignoreSyntaxErrors;
    }

    @Override
    public boolean getIgnoreSyntaxErrors() {
        return this.ignoreSyntaxErrors;
    }

    @Override
    public boolean isCopyResources() {
        return this.copyResources;
    }

    @Override
    public void setCopyResources(boolean copyResources) {
        this.copyResources = copyResources;
    }

    @Override
    public boolean isCommentsEnabled() {
        return this.enableComments;
    }

    @Override
    public void setCommentEnabled(boolean commentEnabled) {
        this.enableComments = commentEnabled;
    }

    @Override
    public void setBinaryOutputDirectory(String s) {
        this.binaryOutputDirectory = s;
    }

    @Override
    public String getBinaryOutputDirectory() {
        return this.binaryOutputDirectory;
    }

    @Override
    public void setSourceOutputDirectory(File directory) {
        if (directory == null) {
            throw new SpoonException("You must specify a directory.");
        }
        if (directory.isFile()) {
            throw new SpoonException("Output must be a directory");
        }
        try {
            this.outputDestinationHandler = new DefaultOutputDestinationHandler(directory.getCanonicalFile(), this);
        }
        catch (IOException e) {
            this.print(e.getMessage(), Level.WARN);
            throw new SpoonException(e);
        }
    }

    @Override
    public File getSourceOutputDirectory() {
        return this.outputDestinationHandler.getDefaultOutputDirectory();
    }

    @Override
    public void setOutputDestinationHandler(OutputDestinationHandler outputDestinationHandler) {
        this.outputDestinationHandler = outputDestinationHandler;
    }

    @Override
    public OutputDestinationHandler getOutputDestinationHandler() {
        return this.outputDestinationHandler;
    }

    @Override
    public FineModelChangeListener getModelChangeListener() {
        return this.modelChangeListener;
    }

    @Override
    public void setModelChangeListener(FineModelChangeListener modelChangeListener) {
        this.modelChangeListener = modelChangeListener;
    }

    @Override
    public Charset getEncoding() {
        return this.encoding;
    }

    @Override
    public EncodingProvider getEncodingProvider() {
        return this.encodingProvider;
    }

    @Override
    public void setEncoding(Charset encoding) {
        this.encoding = encoding;
    }

    @Override
    public void setEncodingProvider(EncodingProvider encodingProvider) {
        this.encodingProvider = encodingProvider;
    }

    @Override
    public void setOutputType(OutputType outputType) {
        this.outputType = outputType;
    }

    @Override
    public OutputType getOutputType() {
        return this.outputType;
    }

    @Override
    public SpoonProgress getSpoonProgress() {
        return this.spoonProgress;
    }

    @Override
    public void setSpoonProgress(SpoonProgress spoonProgress) {
        this.spoonProgress = spoonProgress;
    }

    @Override
    public CompressionType getCompressionType() {
        return this.compressionType;
    }

    @Override
    public void setCompressionType(CompressionType serializationType) {
        this.compressionType = serializationType;
    }

    @Override
    public PrettyPrinter createPrettyPrinterAutoImport() {
        DefaultJavaPrettyPrinter printer = new DefaultJavaPrettyPrinter(this);
        List<Processor<CtElement>> preprocessors = List.of(new ForceImportProcessor(), new ImportCleaner().setCanAddImports(false), new ImportConflictDetector(), new ImportCleaner().setImportComparator(new DefaultImportComparator()));
        printer.setIgnoreImplicit(false);
        printer.setPreprocessors(preprocessors);
        return printer;
    }

    @Override
    public PrettyPrinter createPrettyPrinter() {
        if (this.prettyPrinterCreator == null) {
            if (Environment.PRETTY_PRINTING_MODE.AUTOIMPORT.equals((Object)this.prettyPrintingMode)) {
                return this.createPrettyPrinterAutoImport();
            }
            if (Environment.PRETTY_PRINTING_MODE.DEBUG.equals((Object)this.prettyPrintingMode)) {
                return new DefaultJavaPrettyPrinter(this);
            }
            if (Environment.PRETTY_PRINTING_MODE.FULLYQUALIFIED.equals((Object)this.prettyPrintingMode)) {
                DefaultJavaPrettyPrinter printer = new DefaultJavaPrettyPrinter(this);
                List<Processor<CtElement>> preprocessors = List.of(new ForceFullyQualifiedProcessor(), new ImportConflictDetector(), new ImportCleaner().setImportComparator(new DefaultImportComparator()));
                printer.setIgnoreImplicit(false);
                printer.setPreprocessors(preprocessors);
                return printer;
            }
            throw new UnsupportedOperationException();
        }
        return this.prettyPrinterCreator.get();
    }

    @Override
    public void setPrettyPrinterCreator(Supplier<PrettyPrinter> creator) {
        this.prettyPrinterCreator = creator;
    }

    @Override
    public boolean useLegacyTypeAdaption() {
        return this.useLegacyTypeAdaption;
    }

    @Override
    public void setUseLegacyTypeAdaption(boolean useLegacyTypeAdaption) {
        this.useLegacyTypeAdaption = useLegacyTypeAdaption;
    }

    @Override
    public boolean isIgnoreDuplicateDeclarations() {
        return this.ignoreDuplicateDeclarations;
    }

    @Override
    public void setIgnoreDuplicateDeclarations(boolean ignoreDuplicateDeclarations) {
        this.ignoreDuplicateDeclarations = ignoreDuplicateDeclarations;
    }
}

