/*
 * Decompiled with CFR 0.152.
 */
package spoon.support;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.compress.compressors.lzma.LZMACompressorInputStream;
import org.apache.commons.compress.compressors.lzma.LZMACompressorOutputStream;
import spoon.Launcher;
import spoon.reflect.ModelStreamer;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.factory.Factory;
import spoon.reflect.visitor.Filter;
import spoon.support.CompressionType;

public class SerializationModelStreamer
implements ModelStreamer {
    @Override
    public void save(Factory f, OutputStream out) throws IOException {
        if (f.getEnvironment().getCompressionType() == CompressionType.GZIP) {
            out = new GZIPOutputStream(out);
        } else if (f.getEnvironment().getCompressionType() == CompressionType.LZMA) {
            out = new LZMACompressorOutputStream(out);
        } else if (f.getEnvironment().getCompressionType() == CompressionType.BZIP2) {
            out = new BZip2CompressorOutputStream(out);
        }
        try (ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(out));){
            oos.writeObject(f);
            oos.flush();
        }
    }

    @Override
    public Factory load(InputStream in) throws IOException {
        try {
            BufferedInputStream buffered = new BufferedInputStream(in);
            try {
                String s = CompressorStreamFactory.detect((InputStream)buffered);
                if (s.equals("gz")) {
                    in = new GZIPInputStream(buffered);
                } else if (s.equals("lzma")) {
                    in = new LZMACompressorInputStream((InputStream)buffered);
                } else if (s.equals("bzip2")) {
                    in = new BZip2CompressorInputStream((InputStream)buffered);
                }
            }
            catch (CompressorException e) {
                in = buffered;
            }
            ObjectInputStream ois = new ObjectInputStream(in);
            final Factory f = (Factory)ois.readObject();
            f.createQuery(f.Module().getAllModules().toArray()).filterChildren(new Filter<CtElement>(){

                @Override
                public boolean matches(CtElement e) {
                    e.setFactory(f);
                    e.getPosition().getCompilationUnit().setFactory(f);
                    return false;
                }
            }).list();
            return f;
        }
        catch (ClassNotFoundException e) {
            Launcher.LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IOException(e.getMessage());
        }
    }
}

