/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor.filter;

import spoon.SpoonException;
import spoon.reflect.code.CtCatchVariable;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.chain.CtConsumableFunction;
import spoon.reflect.visitor.chain.CtConsumer;
import spoon.reflect.visitor.filter.CatchVariableReferenceFunction;
import spoon.reflect.visitor.filter.FieldReferenceFunction;
import spoon.reflect.visitor.filter.LocalVariableReferenceFunction;
import spoon.reflect.visitor.filter.ParameterReferenceFunction;

public class VariableReferenceFunction
implements CtConsumableFunction<CtElement> {
    protected final Visitor visitor = new Visitor();
    private final CtVariable<?> variable;
    protected CtConsumer<Object> outputConsumer;
    protected CtElement scope;

    public VariableReferenceFunction() {
        this.variable = null;
    }

    public VariableReferenceFunction(CtVariable<?> variable) {
        this.variable = variable;
    }

    @Override
    public void apply(CtElement variableOrScope, CtConsumer<Object> outputConsumer) {
        this.scope = variableOrScope;
        CtVariable var = this.variable;
        if (var == null) {
            if (variableOrScope instanceof CtVariable) {
                var = (CtVariable)variableOrScope;
            } else {
                throw new SpoonException("The input of VariableReferenceFunction must be a CtVariable but is a " + variableOrScope.getClass().getSimpleName());
            }
        }
        this.outputConsumer = outputConsumer;
        var.accept(this.visitor);
    }

    protected class Visitor
    extends CtScanner {
        protected Visitor() {
        }

        @Override
        protected void enter(CtElement e) {
            throw new SpoonException("Unsupported variable of type " + e.getClass().getName());
        }

        @Override
        public <T> void visitCtField(CtField<T> field) {
            new FieldReferenceFunction((CtField)VariableReferenceFunction.this.variable).apply(VariableReferenceFunction.this.scope, VariableReferenceFunction.this.outputConsumer);
        }

        @Override
        public <T> void visitCtLocalVariable(CtLocalVariable<T> localVariable) {
            new LocalVariableReferenceFunction((CtLocalVariable)VariableReferenceFunction.this.variable).apply(VariableReferenceFunction.this.scope, VariableReferenceFunction.this.outputConsumer);
        }

        @Override
        public <T> void visitCtParameter(CtParameter<T> parameter) {
            new ParameterReferenceFunction((CtParameter)VariableReferenceFunction.this.variable).apply(VariableReferenceFunction.this.scope, VariableReferenceFunction.this.outputConsumer);
        }

        @Override
        public <T> void visitCtCatchVariable(CtCatchVariable<T> catchVariable) {
            new CatchVariableReferenceFunction((CtCatchVariable)VariableReferenceFunction.this.variable).apply(VariableReferenceFunction.this.scope, VariableReferenceFunction.this.outputConsumer);
        }
    }
}

