/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor.filter;

import java.util.Set;
import spoon.Launcher;
import spoon.SpoonException;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeInformation;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.chain.CtConsumableFunction;
import spoon.reflect.visitor.chain.CtConsumer;
import spoon.reflect.visitor.chain.CtQuery;
import spoon.reflect.visitor.chain.CtQueryAware;
import spoon.reflect.visitor.chain.CtScannerListener;
import spoon.reflect.visitor.chain.ScanningMode;
import spoon.support.SpoonClassNotFoundException;

public class SuperInheritanceHierarchyFunction
implements CtConsumableFunction<CtTypeInformation>,
CtQueryAware {
    private boolean includingSelf = false;
    private boolean includingInterfaces = true;
    private CtQuery query;
    private boolean failOnClassNotFound = false;
    private CtScannerListener listener;
    private boolean returnTypeReferences = false;
    private boolean interfacesExtendObject = false;

    public SuperInheritanceHierarchyFunction() {
    }

    public SuperInheritanceHierarchyFunction(Set<String> visitedSet) {
        this.listener = new DistinctTypeListener(visitedSet);
    }

    public SuperInheritanceHierarchyFunction includingSelf(boolean includingSelf) {
        this.includingSelf = includingSelf;
        return this;
    }

    public SuperInheritanceHierarchyFunction includingInterfaces(boolean includingInterfaces) {
        this.includingInterfaces = includingInterfaces;
        return this;
    }

    public SuperInheritanceHierarchyFunction returnTypeReferences(boolean returnTypeReferences) {
        this.returnTypeReferences = returnTypeReferences;
        return this;
    }

    public SuperInheritanceHierarchyFunction interfacesExtendObject(boolean interfacesExtendObject) {
        this.interfacesExtendObject = interfacesExtendObject;
        return this;
    }

    public SuperInheritanceHierarchyFunction setListener(CtScannerListener listener) {
        if (this.listener != null) {
            throw new SpoonException("Cannot register listener on instance created with constructor which accepts the Set<String>. Use the no parameter constructor if listener has to be registered");
        }
        this.listener = listener;
        return this;
    }

    public SuperInheritanceHierarchyFunction failOnClassNotFound(boolean failOnClassNotFound) {
        this.failOnClassNotFound = failOnClassNotFound;
        return this;
    }

    @Override
    public void apply(CtTypeInformation input, CtConsumer<Object> outputConsumer) {
        CtReference typeRef;
        CtType type;
        if (input instanceof CtType) {
            type = (CtType)input;
            typeRef = type.getReference();
        } else {
            typeRef = (CtTypeReference)input;
            try {
                type = typeRef.getTypeDeclaration();
            }
            catch (SpoonClassNotFoundException e) {
                if (!typeRef.getFactory().getEnvironment().getNoClasspath()) {
                    throw e;
                }
                type = null;
            }
        }
        boolean isClass = type instanceof CtClass;
        if (!isClass && !this.includingInterfaces) {
            return;
        }
        ScanningMode mode = this.enter((CtTypeReference<?>)typeRef, isClass);
        if (mode == ScanningMode.SKIP_ALL) {
            return;
        }
        if (this.includingSelf) {
            this.sendResult((CtTypeReference<?>)typeRef, outputConsumer);
            if (this.query.isTerminated()) {
                mode = ScanningMode.SKIP_CHILDREN;
            }
        }
        if (mode == ScanningMode.NORMAL) {
            if (!isClass) {
                this.visitSuperInterfaces((CtTypeReference<?>)typeRef, outputConsumer);
                if (this.interfacesExtendObject) {
                    this.sendResultWithListener(typeRef.getFactory().Type().objectType(), isClass, outputConsumer, ref -> {});
                }
            } else {
                this.visitSuperClasses((CtTypeReference<?>)typeRef, outputConsumer, this.includingInterfaces);
            }
        }
        this.exit((CtTypeReference<?>)typeRef, isClass);
    }

    protected void visitSuperClasses(CtTypeReference<?> superTypeRef, CtConsumer<Object> outputConsumer, boolean includingInterfaces) {
        CtTypeReference<Object> superClassRef;
        if (Object.class.getName().equals(superTypeRef.getQualifiedName())) {
            return;
        }
        if (includingInterfaces) {
            this.visitSuperInterfaces(superTypeRef, outputConsumer);
            if (this.query.isTerminated()) {
                return;
            }
        }
        if ((superClassRef = superTypeRef.getSuperclass()) == null) {
            superClassRef = superTypeRef.getFactory().Type().objectType();
        }
        this.sendResultWithListener(superClassRef, true, outputConsumer, classRef -> this.visitSuperClasses((CtTypeReference<?>)classRef, outputConsumer, includingInterfaces));
    }

    protected void visitSuperInterfaces(CtTypeReference<?> type, CtConsumer<Object> outputConsumer) {
        Set<CtTypeReference<?>> superInterfaces;
        try {
            superInterfaces = type.getSuperInterfaces();
        }
        catch (SpoonClassNotFoundException e) {
            if (this.failOnClassNotFound) {
                throw e;
            }
            Launcher.LOGGER.warn("Cannot load class: " + type.getQualifiedName() + " with class loader " + Thread.currentThread().getContextClassLoader());
            return;
        }
        for (CtTypeReference<?> ifaceRef : superInterfaces) {
            this.sendResultWithListener(ifaceRef, false, outputConsumer, ref -> this.visitSuperInterfaces((CtTypeReference<?>)ref, outputConsumer));
            if (!this.query.isTerminated()) continue;
            return;
        }
    }

    private void sendResultWithListener(CtTypeReference<?> classRef, boolean isClass, CtConsumer<Object> outputConsumer, CtConsumer<CtTypeReference<?>> runNext) {
        ScanningMode mode = this.enter(classRef, isClass);
        if (mode == ScanningMode.SKIP_ALL) {
            return;
        }
        this.sendResult(classRef, outputConsumer);
        if (mode == ScanningMode.NORMAL && !this.query.isTerminated()) {
            runNext.accept(classRef);
        }
        this.exit(classRef, isClass);
    }

    @Override
    public void setQuery(CtQuery query) {
        this.query = query;
    }

    private ScanningMode enter(CtTypeReference<?> type, boolean isClass) {
        if (this.listener == null) {
            return ScanningMode.NORMAL;
        }
        if (this.listener instanceof Listener) {
            Listener typeListener = (Listener)this.listener;
            return typeListener.enter(type, isClass);
        }
        return this.listener.enter(type);
    }

    private void exit(CtTypeReference<?> type, boolean isClass) {
        if (this.listener != null) {
            if (this.listener instanceof Listener) {
                ((Listener)this.listener).exit(type, isClass);
            } else {
                this.listener.exit(type);
            }
        }
    }

    protected void sendResult(CtTypeReference<?> typeRef, CtConsumer<Object> outputConsumer) {
        if (this.returnTypeReferences) {
            outputConsumer.accept(typeRef);
        } else {
            CtType<?> type;
            try {
                type = typeRef.getTypeDeclaration();
            }
            catch (SpoonClassNotFoundException e) {
                if (this.failOnClassNotFound) {
                    throw e;
                }
                Launcher.LOGGER.warn("Cannot load class: " + typeRef.getQualifiedName() + " with class loader " + Thread.currentThread().getContextClassLoader());
                return;
            }
            outputConsumer.accept(type);
        }
    }

    public static class DistinctTypeListener
    extends Listener {
        Set<String> visitedSet;

        public DistinctTypeListener(Set<String> visitedSet) {
            this.visitedSet = visitedSet;
        }

        @Override
        public ScanningMode enter(CtElement element) {
            if (this.visitedSet.add(((CtTypeInformation)((Object)element)).getQualifiedName())) {
                return ScanningMode.NORMAL;
            }
            return ScanningMode.SKIP_ALL;
        }

        @Override
        public void exit(CtElement element) {
        }
    }

    private static class Listener
    implements CtScannerListener {
        private Listener() {
        }

        public ScanningMode enter(CtTypeReference<?> typeRef, boolean isClass) {
            return this.enter(typeRef);
        }

        public void exit(CtTypeReference<?> typeRef, boolean isClass) {
            this.exit(typeRef);
        }

        @Override
        public ScanningMode enter(CtElement element) {
            return ScanningMode.NORMAL;
        }

        @Override
        public void exit(CtElement element) {
        }
    }
}

