/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor.filter;

import spoon.reflect.declaration.CtMethod;
import spoon.reflect.visitor.Filter;
import spoon.support.adaption.TypeAdaptor;

public class OverriddenMethodFilter
implements Filter<CtMethod<?>> {
    private final CtMethod<?> method;
    private final TypeAdaptor context;
    private boolean includingSelf = false;

    public OverriddenMethodFilter(CtMethod<?> method) {
        this.method = method;
        this.context = new TypeAdaptor(method.getDeclaringType());
    }

    public OverriddenMethodFilter includingSelf(boolean includingSelf) {
        this.includingSelf = includingSelf;
        return this;
    }

    @Override
    public boolean matches(CtMethod<?> element) {
        if (this.method == element) {
            return this.includingSelf;
        }
        return this.context.isOverriding(this.method, element);
    }
}

