/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor.filter;

import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.visitor.Filter;

public class NamedElementFilter<T extends CtNamedElement>
implements Filter<T> {
    private final String name;
    private Class<T> acceptedClass;

    public NamedElementFilter(Class<T> acceptedClass, String name) {
        if (name == null || acceptedClass == null) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.acceptedClass = acceptedClass;
    }

    @Override
    public boolean matches(T element) {
        try {
            return this.acceptedClass.isAssignableFrom(element.getClass()) && this.name.equals(element.getSimpleName());
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
    }

    public Class<T> getType() {
        return this.acceptedClass;
    }
}

