/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor.filter;

import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.chain.CtConsumableFunction;
import spoon.reflect.visitor.chain.CtConsumer;
import spoon.reflect.visitor.filter.SubtypeFilter;

public class FieldScopeFunction
implements CtConsumableFunction<CtField<?>> {
    @Override
    public void apply(CtField<?> field, CtConsumer<Object> outputConsumer) {
        if (field.hasModifier(ModifierKind.PRIVATE)) {
            this.searchForPrivateField(field, outputConsumer);
        } else if (field.hasModifier(ModifierKind.PUBLIC)) {
            this.searchForPublicField(field, outputConsumer);
        } else if (field.hasModifier(ModifierKind.PROTECTED)) {
            this.searchForProtectedField(field, outputConsumer);
        } else {
            this.searchForPackageProtectedField(field, outputConsumer);
        }
    }

    protected void searchForPrivateField(CtField<?> field, CtConsumer<Object> outputConsumer) {
        field.getTopLevelType().filterChildren(null).forEach(outputConsumer);
    }

    protected void searchForProtectedField(CtField<?> field, CtConsumer<Object> outputConsumer) {
        field.getFactory().getModel().filterChildren(new SubtypeFilter((CtTypeReference<?>)field.getDeclaringType().getReference())).filterChildren(null).forEach(outputConsumer);
    }

    protected void searchForPublicField(CtField<?> field, CtConsumer<Object> outputConsumer) {
        field.getFactory().getModel().filterChildren(null).forEach(outputConsumer);
    }

    protected void searchForPackageProtectedField(CtField<?> field, CtConsumer<Object> outputConsumer) {
        field.getTopLevelType().getPackage().filterChildren(null).forEach(outputConsumer);
    }
}

