/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor.filter;

import java.util.HashSet;
import java.util.Set;
import spoon.SpoonException;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeInformation;
import spoon.reflect.declaration.CtTypeMember;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.visitor.chain.CtConsumableFunction;
import spoon.reflect.visitor.chain.CtConsumer;
import spoon.reflect.visitor.chain.CtQuery;
import spoon.reflect.visitor.chain.CtQueryAware;
import spoon.reflect.visitor.chain.CtQueryable;
import spoon.reflect.visitor.filter.SuperInheritanceHierarchyFunction;

public class AllTypeMembersFunction
implements CtConsumableFunction<CtTypeInformation>,
CtQueryAware {
    private CtQuery query;
    private final Class<?> memberClass;
    private Set<String> distinctSet;
    private Mode mode = Mode.ALL;

    public AllTypeMembersFunction() {
        this.memberClass = null;
    }

    public AllTypeMembersFunction(Class<?> memberClass) {
        this.memberClass = memberClass;
    }

    public AllTypeMembersFunction distinctSet(Set<String> distinctSet) {
        this.distinctSet = distinctSet;
        return this;
    }

    @Override
    public void apply(CtTypeInformation input, final CtConsumer<Object> outputConsumer) {
        final String inputQName = input.getQualifiedName();
        final CtQuery q = ((CtQueryable)((Object)input)).map(new SuperInheritanceHierarchyFunction(this.distinctSet == null ? new HashSet() : this.distinctSet).includingSelf(true));
        q.forEach(new CtConsumer<CtType<?>>(){

            @Override
            public void accept(CtType<?> type) {
                boolean isInputType = inputQName.equals(type.getQualifiedName());
                block4: for (CtTypeMember typeMember : type.getTypeMembers()) {
                    if (AllTypeMembersFunction.this.memberClass == null || AllTypeMembersFunction.this.memberClass.isInstance(typeMember)) {
                        switch (AllTypeMembersFunction.this.mode) {
                            case ALL: {
                                break;
                            }
                            case SKIP_PRIVATE: {
                                if (!typeMember.hasModifier(ModifierKind.PRIVATE) || isInputType) break;
                                continue block4;
                            }
                            default: {
                                throw new SpoonException("Unexpected mode " + AllTypeMembersFunction.this.mode);
                            }
                        }
                        outputConsumer.accept(typeMember);
                    }
                    if (!AllTypeMembersFunction.this.query.isTerminated()) continue;
                    q.terminate();
                }
            }
        });
    }

    @Override
    public void setQuery(CtQuery query) {
        this.query = query;
    }

    public AllTypeMembersFunction setMode(Mode mode) {
        this.mode = mode;
        return this;
    }

    public static enum Mode {
        ALL,
        SKIP_PRIVATE;

    }
}

