/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor.filter;

import java.lang.reflect.Method;
import spoon.SpoonException;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.visitor.Filter;
import spoon.support.util.RtHelper;

public abstract class AbstractFilter<T extends CtElement>
implements Filter<T> {
    private Class<T> type;

    public AbstractFilter(Class<? super T> type) {
        this.type = type;
    }

    public AbstractFilter() {
        Method method = RtHelper.getMethod(this.getClass(), "matches", 1);
        if (method == null) {
            throw new SpoonException("The method matches with one parameter was not found on the class " + this.getClass().getName());
        }
        this.type = method.getParameterTypes()[0];
    }

    public Class<T> getType() {
        return this.type;
    }

    @Override
    public boolean matches(T element) {
        return this.type.isAssignableFrom(element.getClass());
    }
}

