/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor.chain;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import spoon.Launcher;
import spoon.SpoonException;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtType;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.chain.CtConsumableFunction;
import spoon.reflect.visitor.chain.CtConsumer;
import spoon.reflect.visitor.chain.CtFunction;
import spoon.reflect.visitor.chain.CtQuery;
import spoon.reflect.visitor.chain.CtQueryAware;
import spoon.reflect.visitor.chain.QueryFailurePolicy;
import spoon.reflect.visitor.filter.CtScannerFunction;
import spoon.support.util.RtHelper;

public class CtQueryImpl
implements CtQuery {
    private static final String APPLY_METHOD_NAME = "apply";
    private static final String ACCEPT_METHOD_NAME = "_accept";
    private List<Object> inputs;
    private OutputFunctionWrapper outputStep = new OutputFunctionWrapper();
    private AbstractStep lastStep;
    private AbstractStep firstStep = this.lastStep = this.outputStep;
    private boolean terminated = false;
    private boolean logging = false;
    private QueryFailurePolicy failurePolicy = QueryFailurePolicy.FAIL;
    private static final String JDK9_BASE_PREFIX = "java.base/";
    private static final Pattern cceMessagePattern = Pattern.compile("(\\S+) cannot be cast to (\\S+)");
    private static final Pattern cceMessagePattern2 = Pattern.compile("class (\\S+) cannot be cast to class (\\S+)(.*)");
    private static final int INDEX_OF_CALLER_IN_STACK = CtQueryImpl.getIndexOfCallerInStackOfLambda();

    public CtQueryImpl(Object ... input) {
        this.setInput(input);
    }

    public List<Object> getInputs() {
        return this.inputs == null ? Collections.emptyList() : this.inputs;
    }

    public CtQueryImpl setInput(Object ... input) {
        if (this.inputs != null) {
            this.inputs.clear();
        }
        return this.addInput(input);
    }

    public CtQueryImpl addInput(Object ... input) {
        if (this.inputs == null) {
            this.inputs = new ArrayList<Object>();
        }
        if (input != null) {
            Collections.addAll(this.inputs, input);
        }
        return this;
    }

    public CtQueryImpl addInput(Iterable<?> input) {
        if (this.inputs == null) {
            this.inputs = new ArrayList<Object>();
        }
        if (input != null) {
            for (Object in : input) {
                this.inputs.add(in);
            }
        }
        return this;
    }

    @Override
    public <R> void forEach(CtConsumer<R> consumer) {
        this.outputStep.setNext(consumer);
        for (Object input : this.inputs) {
            this.firstStep.accept(input);
        }
    }

    @Override
    public <R> List<R> list() {
        return this.list(Object.class);
    }

    @Override
    public <R> List<R> list(Class<R> itemClass) {
        ArrayList list = new ArrayList();
        this.forEach(out -> {
            if (out != null && itemClass.isAssignableFrom(out.getClass())) {
                list.add(out);
            }
        });
        return list;
    }

    @Override
    public <R> R first() {
        return (R)this.first(Object.class);
    }

    @Override
    public <R> R first(Class<R> itemClass) {
        Object[] result = new Object[1];
        this.outputStep.setNext(out -> {
            if (out != null && itemClass.isAssignableFrom(out.getClass())) {
                result[0] = out;
                this.terminate();
            }
        });
        for (Object input : this.inputs) {
            this.firstStep.accept(input);
            if (!this.isTerminated()) continue;
            break;
        }
        return (R)result[0];
    }

    @Override
    public <I> CtQueryImpl map(CtConsumableFunction<I> code) {
        this.addStep(new LazyFunctionWrapper(code));
        return this;
    }

    @Override
    public <I, R> CtQueryImpl map(CtFunction<I, R> function) {
        this.addStep(new FunctionWrapper(function));
        return this;
    }

    @Override
    public <R extends CtElement> CtQueryImpl filterChildren(Filter<R> filter) {
        this.map((CtConsumableFunction)new CtScannerFunction());
        if (filter != null) {
            this.select((Filter)filter);
        }
        return this;
    }

    @Override
    public <R extends CtElement> CtQueryImpl select(final Filter<R> filter) {
        CtFunction fnc = new CtFunction<R, Boolean>(){

            @Override
            public Boolean apply(R input) {
                return filter.matches(input);
            }
        };
        FunctionWrapper fw = new FunctionWrapper(fnc);
        fw.onCallbackSet(fnc.getClass().getName(), APPLY_METHOD_NAME, filter.getClass(), "matches", 1, 0);
        this.addStep(fw);
        this.stepFailurePolicy(QueryFailurePolicy.IGNORE);
        return this;
    }

    @Override
    public boolean isTerminated() {
        return this.terminated;
    }

    @Override
    public void terminate() {
        this.terminated = true;
    }

    public <I, R> void evaluate(I input, CtConsumer<R> outputConsumer) {
        this.outputStep.setNext(outputConsumer);
        this.firstStep.accept(input);
    }

    @Override
    public CtQueryImpl name(String name) {
        this.lastStep.setName(name);
        return this;
    }

    @Override
    public CtQueryImpl failurePolicy(QueryFailurePolicy policy) {
        this.failurePolicy = policy;
        return this;
    }

    public CtQueryImpl stepFailurePolicy(QueryFailurePolicy policy) {
        this.lastStep.setLocalFailurePolicy(policy);
        return this;
    }

    public CtQueryImpl logging(boolean logging) {
        this.logging = logging;
        return this;
    }

    protected void handleListenerSetQuery(Object target) {
        if (target instanceof CtQueryAware) {
            ((CtQueryAware)target).setQuery(this);
        }
    }

    private void addStep(AbstractStep step) {
        step.nextStep = this.outputStep;
        this.lastStep.nextStep = step;
        this.lastStep = step;
        if (this.firstStep == this.outputStep) {
            this.firstStep = step;
        }
        step.setName(String.valueOf(this.getStepIndex(step) + 1));
    }

    private int getStepIndex(AbstractStep step) {
        int idx = 0;
        AbstractStep s = this.firstStep;
        while (s != this.outputStep) {
            if (s == step) {
                return idx;
            }
            s = (AbstractStep)s.nextStep;
            ++idx;
        }
        return -1;
    }

    private boolean isLogging() {
        return this.logging;
    }

    private void log(AbstractStep step, String message, Object ... parameters) {
        if (this.isLogging() && Launcher.LOGGER.isInfoEnabled()) {
            Launcher.LOGGER.info(this.getStepDescription(step, message, parameters));
        }
    }

    private String getStepDescription(AbstractStep step, String message, Object ... parameters) {
        StringBuilder sb = new StringBuilder("Step ");
        sb.append(step.getName()).append(") ");
        sb.append(message);
        for (int i = 0; i < parameters.length; ++i) {
            sb.append("\nParameter ").append(i + 1).append(") ");
            if (parameters[i] != null) {
                sb.append(parameters[i].getClass().getSimpleName());
                sb.append(": ");
            }
            sb.append(parameters[i]);
        }
        return sb.toString();
    }

    protected void reset() {
        this.terminated = false;
    }

    private static int getIndexOfCallerInStackOfLambda() {
        CtConsumer<CtType> f;
        CtConsumer<CtType> unchecked = f = t -> {};
        Object obj = new Object();
        try {
            unchecked.accept((CtType)obj);
            throw new SpoonException("The lambda expression with input type CtType must throw ClassCastException when input type is Integer. Basic CtQuery contract is violated by JVM!");
        }
        catch (ClassCastException e) {
            StackTraceElement[] stack = e.getStackTrace();
            for (int i = 0; i < stack.length; ++i) {
                if (!"getIndexOfCallerInStackOfLambda".equals(stack[i].getMethodName())) continue;
                Class<?> detectedClass = CtQueryImpl.detectTargetClassFromCCE(e, obj);
                if (detectedClass == null || !CtType.class.equals(detectedClass)) {
                    return -1;
                }
                return i;
            }
            throw new SpoonException("Spoon cannot detect index of caller of lambda expression in stack trace.", e);
        }
    }

    private static Class<?> processCCE(String objectClassName, String expectedClassName, Object input) {
        if (objectClassName.startsWith(JDK9_BASE_PREFIX)) {
            objectClassName = objectClassName.substring(JDK9_BASE_PREFIX.length());
        }
        if (objectClassName.equals(input.getClass().getName())) {
            try {
                return Class.forName(expectedClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Class<?> detectTargetClassFromCCE(ClassCastException e, Object input) {
        String message = e.getMessage();
        if (message != null) {
            Matcher m = cceMessagePattern.matcher(message);
            if (m.matches()) {
                return CtQueryImpl.processCCE(m.group(1), m.group(2), input);
            }
            Matcher m2 = cceMessagePattern2.matcher(message);
            if (m2.matches()) {
                return CtQueryImpl.processCCE(m2.group(1), m2.group(2), input);
            }
        }
        return null;
    }

    private class FunctionWrapper
    extends AbstractStep {
        private final CtFunction<Object, Object> fnc;

        FunctionWrapper(CtFunction<?, ?> code) {
            this.fnc = code;
            CtQueryImpl.this.handleListenerSetQuery(this.fnc);
            this.onCallbackSet(this.getClass().getName(), CtQueryImpl.ACCEPT_METHOD_NAME, this.fnc.getClass(), CtQueryImpl.APPLY_METHOD_NAME, 1, 0);
        }

        @Override
        protected Object _accept(Object input) {
            return this.fnc.apply(input);
        }

        @Override
        protected void handleResult(Object result, Object input) {
            if (result instanceof Boolean) {
                if (Boolean.TRUE.equals(result)) {
                    this.nextStep.accept(input);
                } else {
                    CtQueryImpl.this.log(this, "Skipped element, because CtFunction#accept(input) returned false", input);
                }
                return;
            }
            if (result instanceof Iterable) {
                for (Object out : (Iterable)result) {
                    this.nextStep.accept(out);
                    if (!CtQueryImpl.this.isTerminated()) continue;
                    return;
                }
                return;
            }
            if (result.getClass().isArray()) {
                for (int i = 0; i < Array.getLength(result); ++i) {
                    this.nextStep.accept(Array.get(result, i));
                    if (!CtQueryImpl.this.isTerminated()) continue;
                    return;
                }
                return;
            }
            this.nextStep.accept(result);
        }
    }

    private class LazyFunctionWrapper
    extends AbstractStep {
        private final CtConsumableFunction<Object> fnc;

        LazyFunctionWrapper(CtConsumableFunction<?> fnc) {
            this.fnc = fnc;
            CtQueryImpl.this.handleListenerSetQuery(this.fnc);
            this.onCallbackSet(this.getClass().getName(), CtQueryImpl.ACCEPT_METHOD_NAME, fnc.getClass(), CtQueryImpl.APPLY_METHOD_NAME, 2, 0);
        }

        @Override
        protected Object _accept(Object input) {
            this.fnc.apply(input, this.nextStep);
            return null;
        }
    }

    private class OutputFunctionWrapper
    extends AbstractStep {
        OutputFunctionWrapper() {
            this.localFailurePolicy = QueryFailurePolicy.IGNORE;
        }

        @Override
        protected Object _accept(Object element) {
            this.nextStep.accept(element);
            return null;
        }

        <R> void setNext(CtConsumer<R> out) {
            CtQueryImpl.this.reset();
            this.nextStep = out;
            CtQueryImpl.this.handleListenerSetQuery(this.nextStep);
            this.onCallbackSet(this.getClass().getName(), CtQueryImpl.ACCEPT_METHOD_NAME, this.nextStep.getClass(), "accept", 1, 0);
        }
    }

    private abstract class AbstractStep
    implements CtConsumer<Object> {
        String name;
        QueryFailurePolicy localFailurePolicy = null;
        CtConsumer<Object> nextStep;
        Class<?> expectedClass;
        String cceStacktraceClass;
        String cceStacktraceMethodName;

        private AbstractStep() {
        }

        @Override
        public final void accept(Object input) {
            Object result;
            if (input == null || CtQueryImpl.this.isTerminated()) {
                return;
            }
            if (!this.isAcceptableType(input)) {
                return;
            }
            try {
                result = this._accept(input);
            }
            catch (ClassCastException e) {
                this.onClassCastException(e, input);
                return;
            }
            if (result == null || CtQueryImpl.this.isTerminated()) {
                return;
            }
            this.handleResult(result, input);
        }

        protected abstract Object _accept(Object var1);

        protected void handleResult(Object result, Object input) {
        }

        private String getName() {
            return this.name;
        }

        private void setName(String name) {
            this.name = name;
        }

        private boolean isFailOnCCE() {
            if (this.localFailurePolicy != null) {
                return this.localFailurePolicy == QueryFailurePolicy.FAIL;
            }
            return CtQueryImpl.this.failurePolicy == QueryFailurePolicy.FAIL;
        }

        private void setLocalFailurePolicy(QueryFailurePolicy localFailurePolicy) {
            this.localFailurePolicy = localFailurePolicy;
        }

        protected boolean isAcceptableType(Object input) {
            if (this.isFailOnCCE()) {
                return true;
            }
            if (this.expectedClass != null && !this.expectedClass.isAssignableFrom(input.getClass())) {
                if (CtQueryImpl.this.isLogging()) {
                    CtQueryImpl.this.log(this, input.getClass().getName() + " cannot be cast to " + this.expectedClass.getName(), input);
                }
                return false;
            }
            return true;
        }

        protected void onCallbackSet(String stackClass, String stackMethodName, Class<?> callbackClass, String callbackMethod, int nrOfParams, int idxOfInputParam) {
            this.cceStacktraceClass = stackClass;
            this.cceStacktraceMethodName = stackMethodName;
            if (callbackClass.getName().contains("$$Lambda")) {
                this.expectedClass = null;
            } else {
                Method method = RtHelper.getMethod(callbackClass, callbackMethod, nrOfParams);
                if (method == null) {
                    throw new SpoonException("The method " + callbackMethod + " with one parameter was not found on the class " + callbackClass.getName());
                }
                this.expectedClass = method.getParameterTypes()[idxOfInputParam];
            }
        }

        protected void onClassCastException(ClassCastException e, Object input) {
            if (this.isFailOnCCE() || this.expectedClass != null) {
                throw e;
            }
            if (INDEX_OF_CALLER_IN_STACK < 0) {
                return;
            }
            StackTraceElement[] stackEles = e.getStackTrace();
            if (stackEles.length == 0) {
                return;
            }
            StackTraceElement stackEle = stackEles[INDEX_OF_CALLER_IN_STACK];
            if (stackEle.getMethodName().equals(this.cceStacktraceMethodName) && stackEle.getClassName().equals(this.cceStacktraceClass)) {
                this.expectedClass = CtQueryImpl.detectTargetClassFromCCE(e, input);
                if (this.expectedClass == null) {
                    // empty if block
                }
                CtQueryImpl.this.log(this, e.getMessage(), input);
                return;
            }
            throw e;
        }
    }
}

