/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import spoon.experimental.CtUnresolvedImport;
import spoon.reflect.cu.CompilationUnit;
import spoon.reflect.declaration.CtCompilationUnit;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtImport;
import spoon.reflect.declaration.CtImportKind;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeMember;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeMemberWildcardImportReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtImportVisitor;
import spoon.reflect.visitor.LexicalScope;
import spoon.reflect.visitor.NameScopeImpl;
import spoon.reflect.visitor.filter.AllTypeMembersFunction;

class TypeNameScope
extends NameScopeImpl {
    private Map<String, CtNamedElement> fieldsByName;
    private Map<String, CtNamedElement> typesByName;
    private Map<String, CtNamedElement> methodsByName;
    private static final Comparator<CtImport> importComparator = new Comparator<CtImport>(){

        @Override
        public int compare(CtImport o1, CtImport o2) {
            CtImportKind k1 = o1.getImportKind();
            CtImportKind k2 = o2.getImportKind();
            return this.getOrderOfImportKind(k1) - this.getOrderOfImportKind(k2);
        }

        private int getOrderOfImportKind(CtImportKind ik) {
            switch (ik) {
                case ALL_STATIC_MEMBERS: {
                    return 2;
                }
                case ALL_TYPES: {
                    return 1;
                }
            }
            return 0;
        }
    };

    TypeNameScope(LexicalScope conflictFinder, CtType<?> p_type) {
        super(conflictFinder, p_type);
    }

    @Override
    public <T> T forEachElementByName(String name, Function<? super CtNamedElement, T> consumer) {
        this.assureCacheInitialized();
        T r = TypeNameScope.forEachByName(this.fieldsByName, name, consumer);
        if (r != null) {
            return r;
        }
        r = TypeNameScope.forEachByName(this.typesByName, name, consumer);
        if (r != null) {
            return r;
        }
        r = TypeNameScope.forEachByName(this.methodsByName, name, consumer);
        if (r != null) {
            return r;
        }
        r = super.forEachElementByName(name, consumer);
        if (r != null) {
            return r;
        }
        return null;
    }

    private void putType(CtType<?> t) {
        this.putIfNotExists(this.typesByName, t);
    }

    private void assureCacheInitialized() {
        if (this.fieldsByName == null) {
            CompilationUnit cu;
            this.fieldsByName = new HashMap<String, CtNamedElement>();
            this.typesByName = new HashMap<String, CtNamedElement>();
            this.methodsByName = new HashMap<String, CtNamedElement>();
            CtType type = (CtType)this.getScopeElement();
            type.map(new AllTypeMembersFunction().setMode(AllTypeMembersFunction.Mode.SKIP_PRIVATE)).forEach(typeMember -> {
                if (typeMember instanceof CtField) {
                    this.putIfNotExists(this.fieldsByName, (CtField)typeMember);
                } else if (typeMember instanceof CtType) {
                    this.putType((CtType)typeMember);
                } else if (typeMember instanceof CtMethod) {
                    this.putIfNotExists(this.methodsByName, (CtMethod)typeMember);
                }
            });
            if (type.isTopLevel() && (cu = type.getPosition().getCompilationUnit()) != null) {
                this.addCompilationUnitNames(cu);
            }
        }
    }

    private void addCompilationUnitNames(CtCompilationUnit compilationUnit) {
        CtType type = (CtType)this.getScopeElement();
        CtReference typeRef = type.getReference();
        compilationUnit.getImports().stream().sorted(importComparator).forEach(arg_0 -> this.lambda$addCompilationUnitNames$1((CtTypeReference)typeRef, arg_0));
        CtPackage pack = compilationUnit.getDeclaredPackage();
        if (pack != null) {
            for (CtType<?> packageType : pack.getTypes()) {
                if (packageType == this.getScopeElement()) continue;
                this.typesByName.putIfAbsent(packageType.getSimpleName(), packageType);
            }
        }
    }

    private <T extends CtNamedElement> void putIfNotExists(Map<String, T> map, T element) {
        if (element == null) {
            return;
        }
        String name = element.getSimpleName();
        map.putIfAbsent(name, element);
    }

    private /* synthetic */ void lambda$addCompilationUnitNames$1(final CtTypeReference typeRef, CtImport aImport) {
        aImport.accept(new CtImportVisitor(){

            @Override
            public <T> void visitTypeImport(CtTypeReference<T> typeReference) {
                TypeNameScope.this.putType(typeReference.getTypeDeclaration());
            }

            @Override
            public <T> void visitMethodImport(CtExecutableReference<T> executableReference) {
                TypeNameScope.this.putIfNotExists(TypeNameScope.this.methodsByName, executableReference.getExecutableDeclaration());
            }

            @Override
            public <T> void visitFieldImport(CtFieldReference<T> fieldReference) {
                TypeNameScope.this.putIfNotExists(TypeNameScope.this.fieldsByName, fieldReference.getFieldDeclaration());
            }

            @Override
            public void visitAllTypesImport(CtPackageReference packageReference) {
                CtPackage pack = packageReference.getDeclaration();
                if (pack != null) {
                    for (CtType<?> type : pack.getTypes()) {
                        TypeNameScope.this.putType(type);
                    }
                }
            }

            @Override
            public <T> void visitAllStaticMembersImport(CtTypeMemberWildcardImportReference typeReference) {
                CtElement type = typeReference.getDeclaration();
                type.map(new AllTypeMembersFunction().setMode(AllTypeMembersFunction.Mode.SKIP_PRIVATE)).forEach(typeMember -> {
                    if (typeMember.isStatic() && typeRef.canAccess((CtTypeMember)typeMember)) {
                        if (typeMember instanceof CtField) {
                            TypeNameScope.this.putIfNotExists(TypeNameScope.this.fieldsByName, typeMember);
                        } else if (typeMember instanceof CtMethod) {
                            TypeNameScope.this.putIfNotExists(TypeNameScope.this.methodsByName, typeMember);
                        }
                    }
                });
            }

            @Override
            public <T> void visitUnresolvedImport(CtUnresolvedImport ctUnresolvedImport) {
            }
        });
    }
}

