/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor;

import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.visitor.OperatorHelper;

class RoundBracketAnalyzer {
    private RoundBracketAnalyzer() {
    }

    static EncloseInRoundBrackets requiresRoundBrackets(CtExpression<?> expr) {
        return RoundBracketAnalyzer.isNestedOperator(expr) ? RoundBracketAnalyzer.nestedOperatorRequiresRoundBrackets(expr) : EncloseInRoundBrackets.UNKNOWN;
    }

    private static EncloseInRoundBrackets nestedOperatorRequiresRoundBrackets(CtExpression<?> nestedOperator) {
        if (nestedOperator.getParent() instanceof CtUnaryOperator) {
            return EncloseInRoundBrackets.YES;
        }
        OperatorHelper.OperatorAssociativity associativity = RoundBracketAnalyzer.getOperatorAssociativity(nestedOperator);
        OperatorHelper.OperatorAssociativity positionInParent = RoundBracketAnalyzer.getPositionInParent(nestedOperator);
        int parentPrecedence = RoundBracketAnalyzer.getOperatorPrecedence(nestedOperator.getParent());
        int precedence = RoundBracketAnalyzer.getOperatorPrecedence(nestedOperator);
        return precedence < parentPrecedence || precedence == parentPrecedence && associativity != positionInParent ? EncloseInRoundBrackets.YES : EncloseInRoundBrackets.NO;
    }

    private static boolean isNestedOperator(CtElement e) {
        return e.isParentInitialized() && RoundBracketAnalyzer.isOperator(e) && RoundBracketAnalyzer.isOperator(e.getParent());
    }

    private static boolean isOperator(CtElement e) {
        return e instanceof CtBinaryOperator || e instanceof CtUnaryOperator;
    }

    private static int getOperatorPrecedence(CtElement e) {
        if (e instanceof CtBinaryOperator) {
            return OperatorHelper.getOperatorPrecedence(((CtBinaryOperator)e).getKind());
        }
        if (e instanceof CtUnaryOperator) {
            return OperatorHelper.getOperatorPrecedence(((CtUnaryOperator)e).getKind());
        }
        return 0;
    }

    private static OperatorHelper.OperatorAssociativity getOperatorAssociativity(CtElement e) {
        if (e instanceof CtBinaryOperator) {
            return OperatorHelper.getOperatorAssociativity(((CtBinaryOperator)e).getKind());
        }
        if (e instanceof CtUnaryOperator) {
            return OperatorHelper.getOperatorAssociativity(((CtUnaryOperator)e).getKind());
        }
        return OperatorHelper.OperatorAssociativity.NONE;
    }

    private static OperatorHelper.OperatorAssociativity getPositionInParent(CtElement e) {
        CtElement parent = e.getParent();
        if (parent instanceof CtBinaryOperator) {
            return ((CtBinaryOperator)parent).getLeftHandOperand() == e ? OperatorHelper.OperatorAssociativity.LEFT : OperatorHelper.OperatorAssociativity.RIGHT;
        }
        return OperatorHelper.OperatorAssociativity.NONE;
    }

    static enum EncloseInRoundBrackets {
        YES,
        NO,
        UNKNOWN;

    }
}

