/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.EnumSet;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtStatement;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtType;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CacheBasedConflictFinder;

public class PrintingContext {
    private CtStatement statement;
    private EnumSet<PrintingOptions> states = EnumSet.noneOf(PrintingOptions.class);
    Deque<CacheBasedConflictFinder> currentThis = new ArrayDeque<CacheBasedConflictFinder>();
    Deque<CtElement> elementStack = new ArrayDeque<CtElement>();
    Deque<CtExpression<?>> parenthesedExpression = new ArrayDeque();
    CtType<?> currentTopLevel;

    public boolean isFirstForVariable() {
        return this.states.contains((Object)PrintingOptions.FIRST_FOR_VARIABLE);
    }

    public boolean isNextForVariable() {
        return this.states.contains((Object)PrintingOptions.NEXT_FOR_VARIABLE);
    }

    public boolean ignoreGenerics() {
        return this.states.contains((Object)PrintingOptions.IGNORE_GENERICS);
    }

    public boolean skipArray() {
        return this.states.contains((Object)PrintingOptions.SKIP_ARRAY);
    }

    public boolean ignoreStaticAccess() {
        return this.states.contains((Object)PrintingOptions.IGNORE_STATIC_ACCESS);
    }

    public boolean ignoreEnclosingClass() {
        return this.states.contains((Object)PrintingOptions.IGNORE_ENCLOSING_CLASS);
    }

    public boolean forceWildcardGenerics() {
        return this.states.contains((Object)PrintingOptions.FORCE_WILDCARD_GENERICS);
    }

    public boolean isStatement(CtStatement stmt) {
        return this.statement == stmt;
    }

    public CtTypeReference<?> getCurrentTypeReference() {
        if (this.currentTopLevel != null) {
            CacheBasedConflictFinder tc = this.getCurrentTypeContext();
            if (tc != null) {
                return tc.typeRef;
            }
            return this.currentTopLevel.getReference();
        }
        return null;
    }

    private CacheBasedConflictFinder getCurrentTypeContext() {
        if (this.currentThis != null && !this.currentThis.isEmpty()) {
            return this.currentThis.peek();
        }
        return null;
    }

    public void pushCurrentThis(CtType<?> type) {
        this.currentThis.push(new CacheBasedConflictFinder(type));
    }

    public void popCurrentThis() {
        this.currentThis.pop();
    }

    public String toString() {
        return "PrintingContext [currentTopLevel=" + this.currentTopLevel.getQualifiedName() + ", statement=" + this.statement.getShortRepresentation() + ", states=" + this.states + "]";
    }

    public boolean isInCurrentScope(CtTypeReference<?> typeRef) {
        CtTypeReference<?> currentTypeRef = this.getCurrentTypeReference();
        return typeRef.equals(currentTypeRef);
    }

    public Writable modify() {
        return new Writable();
    }

    private static enum PrintingOptions {
        NEXT_FOR_VARIABLE,
        IGNORE_GENERICS,
        SKIP_ARRAY,
        IGNORE_STATIC_ACCESS,
        IGNORE_ENCLOSING_CLASS,
        FORCE_WILDCARD_GENERICS,
        FIRST_FOR_VARIABLE;

    }

    public class Writable
    implements AutoCloseable {
        private EnumSet<PrintingOptions> oldStates;
        private CtStatement oldStatement;

        protected Writable() {
            this.oldStatement = PrintingContext.this.statement;
            this.oldStates = EnumSet.copyOf(PrintingContext.this.states);
        }

        @Override
        public void close() {
            PrintingContext.this.states = EnumSet.copyOf(this.oldStates);
            PrintingContext.this.statement = this.oldStatement;
        }

        public <T extends Writable> T isFirstForVariable(boolean add) {
            this.modifyState(PrintingOptions.FIRST_FOR_VARIABLE, add);
            return (T)this;
        }

        public <T extends Writable> T isNextForVariable(boolean add) {
            this.modifyState(PrintingOptions.NEXT_FOR_VARIABLE, add);
            return (T)this;
        }

        public <T extends Writable> T ignoreGenerics(boolean add) {
            this.modifyState(PrintingOptions.IGNORE_GENERICS, add);
            return (T)this;
        }

        public <T extends Writable> T skipArray(boolean add) {
            this.modifyState(PrintingOptions.SKIP_ARRAY, add);
            return (T)this;
        }

        public <T extends Writable> T ignoreStaticAccess(boolean add) {
            this.modifyState(PrintingOptions.IGNORE_STATIC_ACCESS, add);
            return (T)this;
        }

        public <T extends Writable> T ignoreEnclosingClass(boolean add) {
            this.modifyState(PrintingOptions.IGNORE_ENCLOSING_CLASS, add);
            return (T)this;
        }

        public <T extends Writable> T forceWildcardGenerics(boolean add) {
            this.modifyState(PrintingOptions.FORCE_WILDCARD_GENERICS, add);
            return (T)this;
        }

        private void modifyState(PrintingOptions option, boolean add) {
            if (add) {
                PrintingContext.this.states.add(option);
            } else {
                PrintingContext.this.states.remove((Object)option);
            }
        }

        public <T extends Writable> T setStatement(CtStatement stmt) {
            PrintingContext.this.statement = stmt;
            return (T)this;
        }
    }
}

