/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor;

import java.util.Optional;
import java.util.Set;
import spoon.SpoonException;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.code.UnaryOperatorKind;
import spoon.reflect.factory.TypeFactory;
import spoon.reflect.reference.CtTypeReference;
import spoon.support.Internal;

@Internal
public final class OperatorHelper {
    private static final Set<Class<?>> WHOLE_NUMBERS = Set.of(Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE);
    private static final Set<Class<?>> NUMBERS_PROMOTED_TO_INT = Set.of(Byte.TYPE, Short.TYPE, Character.TYPE);

    private OperatorHelper() {
    }

    public static boolean isPrefixOperator(UnaryOperatorKind o) {
        return !OperatorHelper.isSufixOperator(o);
    }

    public static boolean isSufixOperator(UnaryOperatorKind o) {
        return o.name().startsWith("POST");
    }

    public static String getOperatorText(UnaryOperatorKind o) {
        switch (o) {
            case POS: {
                return "+";
            }
            case NEG: {
                return "-";
            }
            case NOT: {
                return "!";
            }
            case COMPL: {
                return "~";
            }
            case PREINC: {
                return "++";
            }
            case PREDEC: {
                return "--";
            }
            case POSTINC: {
                return "++";
            }
            case POSTDEC: {
                return "--";
            }
        }
        throw new SpoonException("Unsupported operator " + o.name());
    }

    public static String getOperatorText(BinaryOperatorKind o) {
        switch (o) {
            case OR: {
                return "||";
            }
            case AND: {
                return "&&";
            }
            case BITOR: {
                return "|";
            }
            case BITXOR: {
                return "^";
            }
            case BITAND: {
                return "&";
            }
            case EQ: {
                return "==";
            }
            case NE: {
                return "!=";
            }
            case LT: {
                return "<";
            }
            case GT: {
                return ">";
            }
            case LE: {
                return "<=";
            }
            case GE: {
                return ">=";
            }
            case SL: {
                return "<<";
            }
            case SR: {
                return ">>";
            }
            case USR: {
                return ">>>";
            }
            case PLUS: {
                return "+";
            }
            case MINUS: {
                return "-";
            }
            case MUL: {
                return "*";
            }
            case DIV: {
                return "/";
            }
            case MOD: {
                return "%";
            }
            case INSTANCEOF: {
                return "instanceof";
            }
        }
        throw new SpoonException("Unsupported operator " + o.name());
    }

    public static int getOperatorPrecedence(BinaryOperatorKind o) {
        switch (o) {
            case OR: {
                return 3;
            }
            case AND: {
                return 4;
            }
            case BITOR: {
                return 5;
            }
            case BITXOR: {
                return 6;
            }
            case BITAND: {
                return 7;
            }
            case EQ: 
            case NE: {
                return 8;
            }
            case LT: 
            case GT: 
            case LE: 
            case GE: 
            case INSTANCEOF: {
                return 9;
            }
            case SL: 
            case SR: 
            case USR: {
                return 10;
            }
            case PLUS: 
            case MINUS: {
                return 11;
            }
            case MUL: 
            case DIV: 
            case MOD: {
                return 12;
            }
        }
        throw new SpoonException("Unsupported operator " + o.name());
    }

    public static int getOperatorPrecedence(UnaryOperatorKind o) {
        switch (o) {
            case POS: 
            case NEG: 
            case NOT: 
            case COMPL: 
            case PREINC: 
            case PREDEC: {
                return 14;
            }
            case POSTINC: 
            case POSTDEC: {
                return 15;
            }
        }
        throw new SpoonException("Unsupported operator " + o.name());
    }

    public static OperatorAssociativity getOperatorAssociativity(BinaryOperatorKind o) {
        switch (o) {
            case LT: 
            case GT: 
            case LE: 
            case GE: 
            case INSTANCEOF: {
                return OperatorAssociativity.NONE;
            }
        }
        return OperatorAssociativity.LEFT;
    }

    public static OperatorAssociativity getOperatorAssociativity(UnaryOperatorKind o) {
        switch (o) {
            case POSTINC: 
            case POSTDEC: {
                return OperatorAssociativity.NONE;
            }
        }
        return OperatorAssociativity.RIGHT;
    }

    private static boolean isIntegralType(CtTypeReference<?> ctTypeReference) {
        return ctTypeReference.isPrimitive() && (WHOLE_NUMBERS.contains(ctTypeReference.getActualClass()) || ctTypeReference.getActualClass().equals(Character.TYPE));
    }

    private static boolean isNumericType(CtTypeReference<?> ctTypeReference) {
        return ctTypeReference.isPrimitive() && !ctTypeReference.getActualClass().equals(Boolean.TYPE);
    }

    private static Optional<CtTypeReference<?>> unaryNumericPromotion(CtExpression<?> operand) {
        CtTypeReference<?> operandType = operand.getType().unbox();
        if (!OperatorHelper.isNumericType(operandType)) {
            return Optional.empty();
        }
        if (NUMBERS_PROMOTED_TO_INT.contains(operandType.getActualClass())) {
            return Optional.of(operandType.getFactory().Type().integerPrimitiveType());
        }
        return Optional.of(operandType);
    }

    private static Optional<CtTypeReference<?>> binaryNumericPromotion(CtExpression<?> left, CtExpression<?> right) {
        CtTypeReference<?> leftType = left.getType().unbox();
        CtTypeReference<?> rightType = right.getType().unbox();
        TypeFactory typeFactory = leftType.getFactory().Type();
        if (!OperatorHelper.isNumericType(leftType) || !OperatorHelper.isNumericType(rightType)) {
            return Optional.empty();
        }
        CtTypeReference<Double> doubleType = typeFactory.doublePrimitiveType();
        if (leftType.equals(doubleType) || rightType.equals(doubleType)) {
            return Optional.of(doubleType);
        }
        CtTypeReference<Float> floatType = typeFactory.floatPrimitiveType();
        if (leftType.equals(floatType) || rightType.equals(floatType)) {
            return Optional.of(floatType);
        }
        CtTypeReference<Long> longType = typeFactory.longPrimitiveType();
        if (leftType.equals(longType) || rightType.equals(longType)) {
            return Optional.of(longType);
        }
        return Optional.of(typeFactory.integerPrimitiveType());
    }

    public static Optional<CtTypeReference<?>> getPromotedType(BinaryOperatorKind operator, CtExpression<?> left, CtExpression<?> right) {
        TypeFactory typeFactory = left.getFactory().Type();
        switch (operator) {
            case OR: 
            case AND: {
                CtTypeReference<Boolean> booleanType = typeFactory.booleanPrimitiveType();
                if (!left.getType().equals(booleanType) || !right.getType().equals(booleanType)) {
                    return Optional.empty();
                }
                return Optional.of(booleanType);
            }
            case SL: 
            case SR: 
            case USR: {
                CtTypeReference promotedLeft = OperatorHelper.unaryNumericPromotion(left).orElse(null);
                CtTypeReference promotedRight = OperatorHelper.unaryNumericPromotion(right).orElse(null);
                if (promotedLeft == null || promotedRight == null) {
                    return Optional.empty();
                }
                if (!OperatorHelper.isIntegralType(promotedLeft) || !OperatorHelper.isIntegralType(promotedRight)) {
                    return Optional.empty();
                }
                return Optional.of(promotedLeft);
            }
            case INSTANCEOF: {
                throw new UnsupportedOperationException("instanceof is not yet implemented");
            }
            case EQ: 
            case NE: {
                CtTypeReference<?> leftType = left.getType().unbox();
                CtTypeReference<?> rightType = right.getType().unbox();
                CtTypeReference<Boolean> booleanType = typeFactory.booleanPrimitiveType();
                return OperatorHelper.binaryNumericPromotion(left, right).or(() -> {
                    if (leftType.equals(rightType) && leftType.equals(booleanType)) {
                        return Optional.of(booleanType);
                    }
                    if (!leftType.isPrimitive() && !rightType.isPrimitive()) {
                        CtTypeReference<?> nullType = typeFactory.nullType();
                        if (leftType.equals(nullType)) {
                            return Optional.of(rightType);
                        }
                        if (rightType.equals(nullType)) {
                            return Optional.of(leftType);
                        }
                        if (leftType.isSubtypeOf(rightType)) {
                            return Optional.of(rightType);
                        }
                        if (rightType.isSubtypeOf(leftType)) {
                            return Optional.of(rightType);
                        }
                        return Optional.empty();
                    }
                    return Optional.empty();
                });
            }
            case LT: 
            case GT: 
            case LE: 
            case GE: 
            case MINUS: 
            case MUL: 
            case DIV: 
            case MOD: {
                return OperatorHelper.binaryNumericPromotion(left, right);
            }
            case PLUS: {
                return OperatorHelper.binaryNumericPromotion(left, right).or(() -> {
                    CtTypeReference<String> stringType = typeFactory.stringType();
                    if (left.getType().equals(stringType) || right.getType().equals(stringType)) {
                        return Optional.of(stringType);
                    }
                    return Optional.empty();
                });
            }
            case BITOR: 
            case BITXOR: 
            case BITAND: {
                CtTypeReference<?> leftType = left.getType().unbox();
                CtTypeReference<?> rightType = right.getType().unbox();
                Set<CtTypeReference<Double>> floatingPointNumbers = Set.of(typeFactory.floatPrimitiveType(), typeFactory.doublePrimitiveType());
                if (floatingPointNumbers.contains(leftType) || floatingPointNumbers.contains(rightType)) {
                    return Optional.empty();
                }
                if (leftType.equals(rightType) && leftType.equals(typeFactory.booleanPrimitiveType())) {
                    return Optional.of(leftType);
                }
                return OperatorHelper.binaryNumericPromotion(left, right);
            }
        }
        throw new UnsupportedOperationException("Unknown operator: " + operator);
    }

    public static Optional<CtTypeReference<?>> getPromotedType(UnaryOperatorKind operator, CtExpression<?> operand) {
        TypeFactory typeFactory = operand.getFactory().Type();
        CtTypeReference operandType = operand.getType();
        switch (operator) {
            case COMPL: {
                if (OperatorHelper.isIntegralType(operandType.unbox())) {
                    return OperatorHelper.unaryNumericPromotion(operand);
                }
                return Optional.empty();
            }
            case POS: 
            case NEG: {
                return OperatorHelper.unaryNumericPromotion(operand);
            }
            case NOT: {
                if (operand.getType().unbox().equals(typeFactory.booleanPrimitiveType())) {
                    return Optional.of(typeFactory.booleanPrimitiveType());
                }
                return Optional.empty();
            }
            case PREINC: 
            case PREDEC: 
            case POSTINC: 
            case POSTDEC: {
                if (!(operand instanceof CtVariableRead) || !OperatorHelper.isNumericType(operandType.unbox())) {
                    return Optional.empty();
                }
                return Optional.of(operandType);
            }
        }
        throw new UnsupportedOperationException("Unknown operator: " + operator);
    }

    public static enum OperatorAssociativity {
        LEFT,
        RIGHT,
        NONE;

    }
}

