/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.visitor.LexicalScope;

class NameScopeImpl
implements LexicalScope {
    private final LexicalScope parent;
    private final CtElement scopeElement;
    private final Map<String, CtNamedElement> elementsByName = new HashMap<String, CtNamedElement>();

    public Map<String, CtNamedElement> getElementsByName() {
        return this.elementsByName;
    }

    NameScopeImpl(LexicalScope parent, CtElement scopeElement, List<CtParameter<?>> parameters) {
        this(parent, scopeElement);
        for (CtParameter<?> parameter : parameters) {
            this.addNamedElement(parameter);
        }
    }

    protected NameScopeImpl(LexicalScope parent, CtElement scopeElement) {
        this.parent = parent;
        this.scopeElement = scopeElement;
    }

    @Override
    public NameScopeImpl addNamedElement(CtNamedElement element) {
        this.elementsByName.put(element.getSimpleName(), element);
        return this;
    }

    @Override
    public final CtElement getScopeElement() {
        return this.scopeElement;
    }

    public final Optional<LexicalScope> getParent() {
        return Optional.ofNullable(this.parent);
    }

    @Override
    public <T> T forEachElementByName(String name, Function<? super CtNamedElement, T> consumer) {
        CtNamedElement named;
        T r = NameScopeImpl.forEachByName(this.elementsByName, name, consumer);
        if (r != null) {
            return r;
        }
        if (this.scopeElement instanceof CtNamedElement && name.equals((named = (CtNamedElement)this.scopeElement).getSimpleName()) && (r = consumer.apply(named)) != null) {
            return r;
        }
        if (this.parent != null) {
            return this.parent.forEachElementByName(name, consumer);
        }
        return null;
    }

    protected static <T> T forEachByName(Map<String, CtNamedElement> map, String name, Function<? super CtNamedElement, T> consumer) {
        CtNamedElement named = map.get(name);
        if (named != null) {
            return consumer.apply(named);
        }
        return null;
    }
}

