/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.stream.Collectors;
import spoon.compiler.Environment;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.visitor.CtScanner;
import spoon.support.Internal;
import spoon.support.Level;

public class ModelConsistencyChecker
extends CtScanner {
    boolean fixInconsistencies;
    boolean fixNullParents;
    Environment environment;
    Deque<CtElement> stack = new ArrayDeque<CtElement>();
    private final List<InconsistentElements> inconsistentElements = new ArrayList<InconsistentElements>();

    public ModelConsistencyChecker(Environment environment, boolean fixInconsistencies, boolean fixNullParents) {
        this.environment = environment;
        this.fixInconsistencies = fixInconsistencies;
        this.fixNullParents = fixNullParents;
    }

    @Internal
    public static List<InconsistentElements> listInconsistencies(CtElement ctElement) {
        ModelConsistencyChecker checker = new ModelConsistencyChecker(null, false, false);
        checker.scan(ctElement);
        return checker.inconsistentElements();
    }

    @Override
    public void enter(CtElement element) {
        if (!(this.stack.isEmpty() || element.isParentInitialized() && element.getParent() == this.stack.peek())) {
            InconsistentElements inconsistentElements = new InconsistentElements(element, List.copyOf(this.stack));
            this.inconsistentElements.add(inconsistentElements);
            if (!element.isParentInitialized() && this.fixNullParents || element.getParent() != this.stack.peek() && this.fixInconsistencies) {
                element.setParent(this.stack.peek());
            } else if (this.environment != null) {
                this.environment.report(null, Level.WARN, inconsistentElements.reason());
                this.dumpStack();
            }
        }
        this.stack.push(element);
    }

    @Override
    protected void exit(CtElement e) {
        this.stack.pop();
    }

    private List<InconsistentElements> inconsistentElements() {
        return List.copyOf(this.inconsistentElements);
    }

    private void dumpStack() {
        this.environment.debugMessage("model consistency checker expectedParents:");
        for (CtElement e : this.stack) {
            this.environment.debugMessage("    " + e.getClass().getSimpleName() + " " + (e.getPosition().isValidPosition() ? String.valueOf(e.getPosition()) : "(?)"));
        }
    }

    @Internal
    public final class InconsistentElements {
        private final CtElement element;
        private final List<CtElement> expectedParents;

        public InconsistentElements(CtElement element, List<CtElement> expectedParents) {
            expectedParents = List.copyOf(expectedParents);
            this.element = element;
            this.expectedParents = expectedParents;
        }

        private String reason() {
            CtElement expectedParent = this.expectedParents.isEmpty() ? null : this.expectedParents.get(0);
            return String.format("The element %s has the parent %s, but expected the parent %s", this.formatElement(this.element), this.element.isParentInitialized() ? this.formatElement(this.element.getParent()) : "null", expectedParent != null ? this.formatElement(expectedParent) : "null");
        }

        private String formatElement(CtElement ctElement) {
            String name = ctElement instanceof CtNamedElement ? " " + ((CtNamedElement)ctElement).getSimpleName() : "";
            return String.format("%s%s", ctElement.getClass().getSimpleName(), name);
        }

        private String dumpExpectedParents() {
            return this.expectedParents.stream().map(ctElement -> String.format("    %s %s", ctElement.getClass().getSimpleName(), ctElement.getPosition().isValidPosition() ? String.valueOf(ctElement.getPosition()) : "(?)")).collect(Collectors.joining(System.lineSeparator()));
        }

        public String toString() {
            return String.format("%s%s", this.reason(), this.dumpExpectedParents());
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof InconsistentElements)) {
                return false;
            }
            InconsistentElements that = (InconsistentElements)object;
            return this.element == that.element();
        }

        public int hashCode() {
            return System.identityHashCode(this.element);
        }

        public CtElement element() {
            return this.element;
        }

        public List<CtElement> expectedParents() {
            return this.expectedParents;
        }
    }
}

