/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor;

import spoon.SpoonException;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtTextBlock;
import spoon.reflect.code.LiteralBase;
import spoon.reflect.cu.SourcePosition;

abstract class LiteralHelper {
    private LiteralHelper() {
    }

    private static String getBasedString(Integer value, LiteralBase base) {
        if (base == LiteralBase.BINARY) {
            return "0b" + Integer.toBinaryString(value);
        }
        if (base == LiteralBase.OCTAL) {
            return "0" + Integer.toOctalString(value);
        }
        if (base == LiteralBase.HEXADECIMAL) {
            return "0x" + Integer.toHexString(value);
        }
        return Integer.toString(value);
    }

    private static String getBasedString(Long value, LiteralBase base) {
        if (base == LiteralBase.BINARY) {
            return "0b" + Long.toBinaryString(value) + "L";
        }
        if (base == LiteralBase.OCTAL) {
            return "0" + Long.toOctalString(value) + "L";
        }
        if (base == LiteralBase.HEXADECIMAL) {
            return "0x" + Long.toHexString(value) + "L";
        }
        return Long.toString(value) + "L";
    }

    private static String getBasedString(Float value, LiteralBase base) {
        if (value.isInfinite() || value.isNaN()) {
            throw new SpoonException("Can not convert " + value + " to a float literal.");
        }
        if (base == LiteralBase.HEXADECIMAL) {
            return Float.toHexString(value.floatValue()) + "F";
        }
        return value + "F";
    }

    private static String getBasedString(Double value, LiteralBase base) {
        if (value.isInfinite() || value.isNaN()) {
            throw new SpoonException("Can not convert " + value + " to a double literal.");
        }
        if (base == LiteralBase.HEXADECIMAL) {
            return Double.toHexString(value);
        }
        return Double.toString(value);
    }

    public static String getTextBlockToken(CtTextBlock literal) {
        return "\"\"\"\n" + ((String)literal.getValue()).replace("\\", "\\\\") + "\"\"\"";
    }

    public static <T> String getLiteralToken(CtLiteral<T> literal) {
        if (literal.getValue() == null) {
            return "null";
        }
        if (literal.getValue() instanceof Integer) {
            return LiteralHelper.getBasedString((Integer)literal.getValue(), literal.getBase());
        }
        if (literal.getValue() instanceof Long) {
            return LiteralHelper.getBasedString((Long)literal.getValue(), literal.getBase());
        }
        if (literal.getValue() instanceof Float) {
            return LiteralHelper.getBasedString((Float)literal.getValue(), literal.getBase());
        }
        if (literal.getValue() instanceof Double) {
            return LiteralHelper.getBasedString((Double)literal.getValue(), literal.getBase());
        }
        if (literal.getValue() instanceof Character) {
            boolean mayContainsSpecialCharacter = true;
            SourcePosition position = literal.getPosition();
            if (position.isValidPosition()) {
                int stringLength = position.getSourceEnd() - position.getSourceStart() - 1;
                mayContainsSpecialCharacter = stringLength != 1;
            }
            StringBuilder sb = new StringBuilder(10);
            sb.append('\'');
            LiteralHelper.appendCharLiteral(sb, (Character)literal.getValue(), mayContainsSpecialCharacter, false);
            sb.append('\'');
            return sb.toString();
        }
        if (literal.getValue() instanceof String) {
            boolean mayContainsSpecialCharacters = true;
            SourcePosition position = literal.getPosition();
            if (position.isValidPosition()) {
                int stringLength = position.getSourceEnd() - position.getSourceStart() - 1;
                mayContainsSpecialCharacters = ((String)literal.getValue()).length() != stringLength;
            }
            return "\"" + LiteralHelper.getStringLiteral((String)literal.getValue(), mayContainsSpecialCharacters) + "\"";
        }
        if (literal.getValue() instanceof Class) {
            return ((Class)literal.getValue()).getName();
        }
        return literal.getValue().toString();
    }

    static void appendCharLiteral(StringBuilder sb, Character c, boolean mayContainsSpecialCharacter, boolean isInsideString) {
        if (!mayContainsSpecialCharacter) {
            sb.append(c);
        } else {
            switch (c.charValue()) {
                case '\b': {
                    sb.append("\\b");
                    break;
                }
                case '\t': {
                    sb.append("\\t");
                    break;
                }
                case '\n': {
                    sb.append("\\n");
                    break;
                }
                case '\f': {
                    sb.append("\\f");
                    break;
                }
                case '\r': {
                    sb.append("\\r");
                    break;
                }
                case '\"': {
                    sb.append("\\\"");
                    break;
                }
                case '\'': {
                    if (isInsideString) {
                        sb.append("'");
                        break;
                    }
                    sb.append("\\'");
                    break;
                }
                case '\\': {
                    sb.append("\\\\");
                    break;
                }
                default: {
                    sb.append(Character.isISOControl(c.charValue()) ? String.format("\\u%04x", c.charValue()) : Character.toString(c.charValue()));
                }
            }
        }
    }

    static String getStringLiteral(String value, boolean mayContainsSpecialCharacter) {
        if (!mayContainsSpecialCharacter) {
            return value;
        }
        StringBuilder sb = new StringBuilder(value.length() * 2);
        for (int i = 0; i < value.length(); ++i) {
            LiteralHelper.appendCharLiteral(sb, Character.valueOf(value.charAt(i)), true, true);
        }
        return sb.toString();
    }
}

