/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor;

import java.lang.annotation.Annotation;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtCatch;
import spoon.reflect.code.CtLambda;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.declaration.CtAnnotationType;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtCompilationUnit;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtEnum;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.visitor.CtAbstractVisitor;
import spoon.reflect.visitor.EarlyTerminatingScanner;
import spoon.reflect.visitor.LexicalScope;
import spoon.reflect.visitor.NameScopeImpl;
import spoon.reflect.visitor.TypeNameScope;

public class LexicalScopeScanner
extends EarlyTerminatingScanner<Object> {
    private final Deque<LexicalScope> scopes = new ArrayDeque<LexicalScope>();
    private final Map<String, String> encounteredImportedQualifiedNames = new HashMap<String, String>();
    private static NameScopeImpl EMPTY = new NameScopeImpl(null, null);

    @Override
    protected void enter(CtElement e) {
        NameScopeImpl newFinder = this.onElement(this.scopes.peek(), e);
        if (newFinder != null) {
            this.scopes.push(newFinder);
        }
    }

    @Override
    protected void exit(CtElement e) {
        LexicalScope topFinder = this.scopes.peek();
        if (topFinder != null && topFinder.getScopeElement() == e) {
            this.scopes.pop();
        }
    }

    public LexicalScope getCurrentLexicalScope() {
        LexicalScope ns = this.scopes.peek();
        return ns == null ? EMPTY : ns;
    }

    Map<String, String> getEncounteredImportedQualifiedNames() {
        return this.encounteredImportedQualifiedNames;
    }

    private NameScopeImpl onElement(final LexicalScope parent, CtElement target) {
        class Visitor
        extends CtAbstractVisitor {
            NameScopeImpl finder = null;

            Visitor() {
            }

            @Override
            public void visitCtCompilationUnit(CtCompilationUnit compilationUnit) {
            }

            @Override
            public <T> void visitCtClass(CtClass<T> ctClass) {
                this.finder = new TypeNameScope(parent, ctClass);
            }

            @Override
            public <T> void visitCtInterface(CtInterface<T> intrface) {
                this.finder = new TypeNameScope(parent, intrface);
            }

            @Override
            public <T extends Enum<?>> void visitCtEnum(CtEnum<T> ctEnum) {
                this.finder = new TypeNameScope(parent, ctEnum);
            }

            @Override
            public <A extends Annotation> void visitCtAnnotationType(CtAnnotationType<A> annotationType) {
                this.finder = new TypeNameScope(parent, annotationType);
            }

            @Override
            public <T> void visitCtMethod(CtMethod<T> m) {
                this.finder = new NameScopeImpl(parent, m, m.getParameters());
            }

            @Override
            public <T> void visitCtConstructor(CtConstructor<T> c) {
                this.finder = new NameScopeImpl(parent, c, c.getParameters());
            }

            @Override
            public <T> void visitCtLambda(CtLambda<T> lambda) {
                this.finder = new NameScopeImpl(parent, lambda, lambda.getParameters());
            }

            @Override
            public void visitCtCatch(CtCatch catchBlock) {
                this.finder = new NameScopeImpl(parent, catchBlock).addNamedElement(catchBlock.getParameter());
            }

            @Override
            public <R> void visitCtBlock(CtBlock<R> block) {
                this.finder = new NameScopeImpl(parent, block);
            }

            @Override
            public <T> void visitCtLocalVariable(CtLocalVariable<T> localVariable) {
                if (parent == null) {
                    return;
                }
                parent.addNamedElement(localVariable);
            }
        }
        Visitor scanner = new Visitor();
        target.accept(scanner);
        return scanner.finder;
    }
}

