/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import spoon.experimental.CtUnresolvedImport;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtCatchVariable;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtJavaDoc;
import spoon.reflect.code.CtJavaDocTag;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.declaration.CtAnnotationType;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtEnum;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtImport;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeMember;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.declaration.ParentNotInitializedException;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtVariableReference;
import spoon.reflect.visitor.AccessibleVariablesFinder;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.ImportScanner;
import spoon.support.SpoonClassNotFoundException;
import spoon.support.reflect.reference.CtTypeMemberWildcardImportReferenceImpl;

public class ImportScannerImpl
extends CtScanner
implements ImportScanner {
    private static final Collection<String> namesPresentInJavaLang8 = Collections.singletonList("FunctionalInterface");
    private static final Collection<String> namesPresentInJavaLang9 = Arrays.asList("ProcessHandle", "StackWalker", "StackFramePermission");
    protected Map<String, CtTypeReference<?>> classImports = new TreeMap();
    protected Map<String, CtFieldReference<?>> fieldImports = new TreeMap();
    protected Map<String, CtExecutableReference<?>> methodImports = new TreeMap();
    protected CtTypeReference<?> targetType;
    private Map<String, Boolean> namesPresentInJavaLang = new HashMap<String, Boolean>();
    private Set<String> fieldAndMethodsNames = new HashSet<String>();
    private Set<CtTypeReference> exploredReferences = new HashSet<CtTypeReference>();
    private Map<CtImport, Boolean> usedImport = new HashMap<CtImport, Boolean>();
    private static Set<String> mainTags = new HashSet<String>(Arrays.asList("see", "throws", "exception"));
    private static Set<String> inlineTags = new HashSet<String>(Arrays.asList("link", "linkplain", "value"));
    private static Pattern tagRE = Pattern.compile("(\\{)?@(\\w+)\\s+([\\w\\.\\$]+)(?:#(\\w+)(?:\\(([^\\)]*)\\)))?");

    @Override
    public <T> void visitCtFieldRead(CtFieldRead<T> fieldRead) {
        this.enter(fieldRead);
        this.scan(fieldRead.getAnnotations());
        this.scan(fieldRead.getTypeCasts());
        this.scan(fieldRead.getVariable());
        this.scan((CtElement)fieldRead.getTarget());
        this.exit(fieldRead);
    }

    @Override
    public <T> void visitCtFieldReference(CtFieldReference<T> reference) {
        this.enter(reference);
        this.scan(reference.getDeclaringType());
        if (reference.isStatic()) {
            this.addFieldImport(reference);
        } else {
            this.scan(reference.getDeclaringType());
        }
        this.exit(reference);
    }

    @Override
    public <T> void visitCtExecutableReference(CtExecutableReference<T> reference) {
        this.enter(reference);
        if (reference.isStatic()) {
            this.addMethodImport(reference);
        } else if (reference.isConstructor()) {
            this.scan(reference.getDeclaringType());
        }
        this.scan(reference.getActualTypeArguments());
        this.exit(reference);
    }

    @Override
    public <T> void visitCtTypeReference(CtTypeReference<T> reference) {
        if (!(reference instanceof CtArrayTypeReference)) {
            CtTypeReference<Object> typeReference = reference.getDeclaringType() == null ? reference : reference.getAccessType();
            if (!typeReference.equals(reference) && this.isAlreadyInUsedImport(reference)) {
                super.visitCtTypeReference(reference);
                return;
            }
            if (!this.isTypeInCollision(typeReference, false)) {
                this.addClassImport(typeReference);
            }
        }
        super.visitCtTypeReference(reference);
    }

    @Override
    public void scan(CtElement element) {
        if (element != null) {
            element.accept(this);
        }
    }

    @Override
    public void visitCtJavaDoc(CtJavaDoc ctJavaDoc) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ctJavaDoc.getContent());
        for (CtJavaDocTag ctJavaDocTag : ctJavaDoc.getTags()) {
            stringBuilder.append("\n").append((Object)ctJavaDocTag.getType()).append(" ").append(ctJavaDocTag.getContent());
        }
        String javadoc = stringBuilder.toString();
        for (CtImport ctImport : this.usedImport.keySet()) {
            switch (ctImport.getImportKind()) {
                case TYPE: {
                    if (!javadoc.contains(ctImport.getReference().getSimpleName()) || !(ctImport.getReference() instanceof CtTypeReference) || !this.matchesTypeName(javadoc, (CtTypeReference)ctImport.getReference())) break;
                    this.setImportUsed(ctImport);
                }
            }
        }
    }

    private boolean matchesTypeName(String javadoc, CtTypeReference<?> typeRef) {
        Matcher m = tagRE.matcher(javadoc);
        while (m.find()) {
            String[] paramTypes;
            String bracket = m.group(1);
            String tag = m.group(2);
            if ("{".equals(bracket) ? !inlineTags.contains(tag) : !mainTags.contains(tag)) continue;
            String type = m.group(3);
            String params = m.group(5);
            if (this.isTypeMatching(type, typeRef)) {
                return true;
            }
            if (params == null) continue;
            for (String paramType : paramTypes = params.split("\\s*,\\s*")) {
                if (!this.isTypeMatching(paramType, typeRef)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isTypeMatching(String typeName, CtTypeReference<?> typeRef) {
        if (typeName != null) {
            if (typeName.equals(typeRef.getQualifiedName())) {
                return true;
            }
            if (typeName.equals(typeRef.getSimpleName())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public <A extends Annotation> void visitCtAnnotationType(CtAnnotationType<A> annotationType) {
        this.addClassImport((CtTypeReference<?>)annotationType.getReference());
        super.visitCtAnnotationType(annotationType);
    }

    @Override
    public <T extends Enum<?>> void visitCtEnum(CtEnum<T> ctEnum) {
        this.addClassImport((CtTypeReference<?>)ctEnum.getReference());
        super.visitCtEnum(ctEnum);
    }

    @Override
    public <T> void visitCtInterface(CtInterface<T> intrface) {
        this.addClassImport((CtTypeReference<?>)intrface.getReference());
        for (CtTypeMember t : intrface.getTypeMembers()) {
            if (!(t instanceof CtType)) continue;
            this.addClassImport((CtTypeReference<?>)((CtType)t).getReference());
        }
        super.visitCtInterface(intrface);
    }

    @Override
    public <T> void visitCtClass(CtClass<T> ctClass) {
        this.addClassImport((CtTypeReference<?>)ctClass.getReference());
        for (CtTypeMember t : ctClass.getTypeMembers()) {
            if (!(t instanceof CtType)) continue;
            this.addClassImport((CtTypeReference<?>)((CtType)t).getReference());
        }
        super.visitCtClass(ctClass);
    }

    @Override
    public <T> void visitCtCatchVariable(CtCatchVariable<T> catchVariable) {
        for (CtTypeReference<?> type : catchVariable.getMultiTypes()) {
            this.addClassImport(type);
        }
        super.visitCtCatchVariable(catchVariable);
    }

    public void visitCtInvocation(CtInvocation invocation) {
        this.scan(invocation.getTypeCasts());
        this.scan(invocation.getExecutable());
        if (!this.isImportedInMethodImports(invocation.getExecutable())) {
            this.scan((CtElement)invocation.getTarget());
        }
        this.scan(invocation.getArguments());
    }

    @Override
    public Set<CtImport> getAllImports() {
        HashSet<CtImport> listallImports = new HashSet<CtImport>();
        for (Map.Entry<CtImport, Boolean> entry : this.usedImport.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            listallImports.add(entry.getKey());
        }
        for (CtReference ctReference : this.classImports.values()) {
            listallImports.add(ctReference.getFactory().Type().createImport(ctReference));
        }
        for (CtReference ctReference : this.fieldImports.values()) {
            listallImports.add(ctReference.getFactory().Type().createImport(ctReference));
        }
        for (CtReference ctReference : this.methodImports.values()) {
            listallImports.add(ctReference.getFactory().Type().createImport(ctReference));
        }
        return listallImports;
    }

    @Override
    public void computeImports(CtElement element) {
        if (element instanceof CtType) {
            CtType simpleType = (CtType)element;
            this.targetType = simpleType.getReference().getTopLevelType();
            this.addClassImport((CtTypeReference<?>)simpleType.getReference());
            this.scan(simpleType);
        } else {
            CtType type = element.getParent(CtType.class);
            this.targetType = type == null ? null : type.getReference().getTopLevelType();
            this.scan(element);
        }
    }

    @Override
    public boolean isImported(CtReference ref) {
        if (ref instanceof CtFieldReference) {
            return this.isImportedInFieldImports((CtFieldReference)ref);
        }
        if (ref instanceof CtExecutableReference) {
            return this.isImportedInMethodImports((CtExecutableReference)ref);
        }
        if (ref instanceof CtTypeReference) {
            return this.isImportedInClassImports((CtTypeReference)ref);
        }
        return false;
    }

    @Override
    public void initWithImports(Iterable<CtImport> importCollection) {
        for (CtImport ctImport : importCollection) {
            this.usedImport.put(ctImport, ctImport instanceof CtUnresolvedImport ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    private boolean isThereAnotherClassWithSameNameInAnotherPackage(CtTypeReference<?> ref) {
        for (CtTypeReference typeref : this.exploredReferences) {
            if (!typeref.getSimpleName().equals(ref.getSimpleName()) || typeref.getQualifiedName().equals(ref.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    protected boolean addClassImport(CtTypeReference<?> ref) {
        this.exploredReferences.add(ref);
        if (ref == null) {
            return false;
        }
        if (this.targetType != null && this.targetType.getSimpleName().equals(ref.getSimpleName()) && !this.targetType.equals(ref)) {
            return false;
        }
        if (this.classImports.containsKey(ref.getSimpleName())) {
            return this.isImportedInClassImports(ref);
        }
        if (ref.getPackage() == null || ref.getPackage().isUnnamedPackage()) {
            return false;
        }
        if (this.targetType != null && !this.targetType.canAccess(ref)) {
            return false;
        }
        if (this.isThereAnotherClassWithSameNameInAnotherPackage(ref)) {
            return false;
        }
        if (this.targetType != null) {
            try {
                CtElement parent = ref.getParent();
                if (parent != null && (parent = parent.getParent()) != null && (parent instanceof CtFieldAccess || parent instanceof CtExecutable || parent instanceof CtInvocation)) {
                    CtReference reference;
                    CtTypeReference<?> declaringType;
                    CtPackageReference pack = this.targetType.getPackage();
                    if (parent instanceof CtFieldAccess) {
                        CtFieldAccess field = (CtFieldAccess)parent;
                        CtVariableReference localReference = field.getVariable();
                        declaringType = localReference.getDeclaringType();
                        reference = localReference;
                    } else if (parent instanceof CtExecutable) {
                        CtExecutable exec = (CtExecutable)parent;
                        CtReference localReference = exec.getReference();
                        declaringType = localReference.getDeclaringType();
                        reference = localReference;
                    } else if (parent instanceof CtInvocation) {
                        CtInvocation invo = (CtInvocation)parent;
                        CtExecutableReference localReference = invo.getExecutable();
                        declaringType = localReference.getDeclaringType();
                        reference = localReference;
                    } else {
                        declaringType = null;
                        reference = null;
                    }
                    if (reference != null && this.isImported(reference)) {
                        if (declaringType != null && declaringType.getPackage() != null && !declaringType.getPackage().isUnnamedPackage() && !"java.lang".equals(declaringType.getPackage().getSimpleName()) && declaringType.getPackage().getSimpleName().equals(pack.getSimpleName())) {
                            this.classImports.put(ref.getSimpleName(), ref);
                            return true;
                        }
                        return false;
                    }
                }
            }
            catch (ParentNotInitializedException parent) {
                // empty catch block
            }
            CtPackageReference pack = this.targetType.getPackage();
            if (pack != null && ref.getPackage() != null && !ref.getPackage().isUnnamedPackage()) {
                if ("java.lang".equals(ref.getPackage().getSimpleName())) {
                    return false;
                }
                if (ref.getPackage().getSimpleName().equals(pack.getSimpleName())) {
                    return false;
                }
            }
        }
        if (!this.isAlreadyInUsedImport(ref)) {
            this.classImports.put(ref.getSimpleName(), ref);
            return true;
        }
        return false;
    }

    private boolean setImportUsed(CtImport ctImport) {
        this.usedImport.put(ctImport, true);
        return true;
    }

    private boolean isAlreadyInUsedImport(CtReference ref) {
        Object refQualifiedName = "";
        CtTypeReference<?> refDeclaringType = null;
        boolean isTypeRef = false;
        boolean isExecRef = false;
        boolean isFieldRef = false;
        if (ref instanceof CtTypeReference) {
            refQualifiedName = ((CtTypeReference)ref).getQualifiedName();
            isTypeRef = true;
        } else if (ref instanceof CtExecutableReference) {
            refDeclaringType = ((CtExecutableReference)ref).getDeclaringType();
            isExecRef = true;
        } else if (ref instanceof CtFieldReference) {
            refDeclaringType = ((CtFieldReference)ref).getDeclaringType();
            refQualifiedName = ((CtFieldReference)ref).getQualifiedName();
            isFieldRef = true;
        }
        block8: for (CtImport ctImport : this.usedImport.keySet()) {
            switch (ctImport.getImportKind()) {
                case METHOD: {
                    if (!isExecRef) break;
                    CtExecutableReference execRef = (CtExecutableReference)ctImport.getReference();
                    CtTypeReference<?> declaringType = execRef.getDeclaringType();
                    if (!execRef.getSimpleName().equals(ref.getSimpleName()) || declaringType == null || !declaringType.equals(refDeclaringType)) continue block8;
                    return this.setImportUsed(ctImport);
                }
                case FIELD: {
                    if (!isFieldRef) break;
                    CtFieldReference importFieldRef = (CtFieldReference)ctImport.getReference();
                    if (!importFieldRef.getQualifiedName().equals(refQualifiedName)) continue block8;
                    return this.setImportUsed(ctImport);
                }
                case ALL_STATIC_MEMBERS: {
                    Object importRef;
                    String importRefStr;
                    if (!isExecRef && !isFieldRef || refDeclaringType == null) break;
                    String qualifiedName = refDeclaringType.getQualifiedName();
                    if (!qualifiedName.equals(importRefStr = ((CtTypeMemberWildcardImportReferenceImpl)(importRef = (CtTypeMemberWildcardImportReferenceImpl)ctImport.getReference())).getTypeReference().getQualifiedName())) continue block8;
                    return this.setImportUsed(ctImport);
                }
                case TYPE: {
                    if (!isTypeRef) break;
                    CtTypeReference typeReference = (CtTypeReference)ctImport.getReference();
                    if (!typeReference.getQualifiedName().equals(refQualifiedName)) continue block8;
                    return this.setImportUsed(ctImport);
                }
                case ALL_TYPES: {
                    if (!isTypeRef) break;
                    String typeImportQualifiedName = ctImport.getReference().getSimpleName();
                    if (!((String)refQualifiedName).equals(typeImportQualifiedName)) continue block8;
                    return this.setImportUsed(ctImport);
                }
                case UNRESOLVED: {
                    CtUnresolvedImport unresolvedImport = (CtUnresolvedImport)ctImport;
                    Object importRef = unresolvedImport.getUnresolvedReference();
                    String importRefPrefix = null;
                    if (((String)importRef).contains("*")) {
                        importRefPrefix = ((String)importRef).substring(0, ((String)importRef).length() - 1);
                    }
                    if (isTypeRef && !unresolvedImport.isStatic()) {
                        return ((String)importRef).equals(refQualifiedName) || importRefPrefix != null && ((String)refQualifiedName).startsWith(importRefPrefix) && !((String)refQualifiedName).substring(importRefPrefix.length()).contains(".");
                    }
                    if (!isExecRef && !isFieldRef || refDeclaringType == null || !unresolvedImport.isStatic()) break;
                    if (isExecRef) {
                        refQualifiedName = refDeclaringType + "." + ref.getSimpleName();
                    }
                    return ((String)importRef).equals(refQualifiedName) || importRefPrefix != null && ((String)refQualifiedName).startsWith(importRefPrefix) && !((String)refQualifiedName).substring(importRefPrefix.length()).contains(".");
                }
            }
        }
        return false;
    }

    protected boolean isImportedInClassImports(CtTypeReference<?> ref) {
        CtPackageReference pack;
        if (this.isAlreadyInUsedImport(ref)) {
            return true;
        }
        if (this.targetType != null && (pack = this.targetType.getPackage()) != null && ref.getPackage() != null && !ref.getPackage().isUnnamedPackage() && !"java.lang".equals(ref.getPackage().getSimpleName()) && ref.getPackage().getSimpleName().equals(pack.getSimpleName())) {
            return true;
        }
        if (ref.equals(this.targetType)) {
            return true;
        }
        if (!ref.isImplicit() && this.classImports.containsKey(ref.getSimpleName())) {
            CtTypeReference<?> exist = this.classImports.get(ref.getSimpleName());
            return exist.getQualifiedName().equals(ref.getQualifiedName());
        }
        return false;
    }

    private boolean declaringTypeIsLocalOrImported(CtTypeReference declaringType) {
        if (declaringType != null) {
            boolean importSuccess;
            boolean isInCollision = this.isTypeInCollision(declaringType, false);
            if (!isInCollision && (importSuccess = this.addClassImport(declaringType))) {
                return true;
            }
            boolean importedInClassImports = this.isImportedInClassImports(declaringType);
            boolean inJavaLang = this.classNamePresentInJavaLang(declaringType);
            if (importedInClassImports || inJavaLang) {
                return true;
            }
            while (declaringType != null) {
                if (declaringType.equals(this.targetType)) {
                    return true;
                }
                declaringType = declaringType.getDeclaringType();
            }
        }
        return false;
    }

    private boolean isInCollisionWithLocalMethod(CtExecutableReference ref) {
        CtType typeDecl = ref.getParent(CtType.class);
        if (typeDecl != null) {
            String methodName = ref.getSimpleName();
            for (CtMethod<?> method : typeDecl.getAllMethods()) {
                if (!method.getSimpleName().equals(methodName)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean addMethodImport(CtExecutableReference ref) {
        if (ref.getFactory().getEnvironment().getComplianceLevel() < 5) {
            return false;
        }
        if (this.isImportedInMethodImports(ref)) {
            return true;
        }
        if (this.declaringTypeIsLocalOrImported(ref.getDeclaringType())) {
            return false;
        }
        if (this.isInCollisionWithLocalMethod(ref)) {
            return false;
        }
        this.methodImports.put(ref.getSimpleName(), ref);
        if (ref.getDeclaringType() != null && ref.getDeclaringType().getPackage() != null && this.targetType != null && ref.getDeclaringType().getPackage().equals(this.targetType.getPackage())) {
            this.addClassImport(ref.getDeclaringType());
        }
        return true;
    }

    protected boolean isImportedInMethodImports(CtExecutableReference<?> ref) {
        if (this.isAlreadyInUsedImport(ref)) {
            return true;
        }
        if (!ref.isImplicit() && this.methodImports.containsKey(ref.getSimpleName())) {
            CtExecutableReference<?> exist = this.methodImports.get(ref.getSimpleName());
            return this.getSignature(exist).equals(this.getSignature(ref));
        }
        return false;
    }

    private String getSignature(CtExecutableReference<?> exist) {
        return (exist.getDeclaringType() != null ? exist.getDeclaringType().getQualifiedName() : "") + "." + exist.getSignature();
    }

    protected boolean addFieldImport(CtFieldReference ref) {
        if (ref.getFactory().getEnvironment().getComplianceLevel() < 5) {
            return false;
        }
        if (this.fieldImports.containsKey(ref.getSimpleName())) {
            return this.isImportedInFieldImports(ref);
        }
        if (this.declaringTypeIsLocalOrImported(ref.getDeclaringType())) {
            return false;
        }
        this.fieldImports.put(ref.getSimpleName(), ref);
        return true;
    }

    protected boolean isImportedInFieldImports(CtFieldReference<?> ref) {
        if (this.isAlreadyInUsedImport(ref)) {
            return true;
        }
        if (!ref.isImplicit() && this.fieldImports.containsKey(ref.getSimpleName())) {
            CtFieldReference<?> exist = this.fieldImports.get(ref.getSimpleName());
            try {
                if (exist.getFieldDeclaration() != null && exist.getFieldDeclaration().equals(ref.getFieldDeclaration())) {
                    return true;
                }
            }
            catch (SpoonClassNotFoundException notfound) {
                return false;
            }
        }
        return false;
    }

    protected boolean classNamePresentInJavaLang(CtTypeReference<?> ref) {
        Boolean presentInJavaLang = this.namesPresentInJavaLang.get(ref.getSimpleName());
        if (presentInJavaLang == null) {
            if (namesPresentInJavaLang8.contains(ref.getSimpleName()) || namesPresentInJavaLang9.contains(ref.getSimpleName())) {
                presentInJavaLang = true;
            } else {
                try {
                    Class.forName("java.lang." + ref.getSimpleName());
                    presentInJavaLang = true;
                }
                catch (ClassNotFoundException | NoClassDefFoundError e) {
                    presentInJavaLang = false;
                }
            }
            this.namesPresentInJavaLang.put(ref.getSimpleName(), presentInJavaLang);
        }
        return presentInJavaLang;
    }

    protected Set<String> lookForLocalVariables(CtElement parent) {
        HashSet<String> result = new HashSet<String>();
        while (parent != null && !(parent instanceof CtBlock)) {
            if (parent instanceof CtClass) {
                return result;
            }
            parent = parent.getParent();
        }
        if (parent != null) {
            CtBlock block = (CtBlock)parent;
            while (parent != null && !(parent instanceof CtClass)) {
                parent = parent.getParent();
            }
            if (parent != null && !(parent.getParent() instanceof CtPackage)) {
                while (parent != null && !(parent instanceof CtBlock)) {
                    parent = parent.getParent();
                }
                if (parent != null) {
                    block = (CtBlock)parent;
                }
            }
            AccessibleVariablesFinder avf = new AccessibleVariablesFinder(block);
            List<CtVariable> variables = avf.find();
            for (CtVariable variable : variables) {
                result.add(variable.getSimpleName());
            }
        }
        return result;
    }

    protected boolean isTypeInCollision(CtReference ref, boolean fqnMode) {
        if (this.targetType != null && this.targetType.getSimpleName().equals(ref.getSimpleName()) && !this.targetType.equals(ref)) {
            return true;
        }
        try {
            CtElement parent = ref instanceof CtTypeReference ? ref.getParent() : ref;
            if (parent instanceof CtLiteral) {
                return false;
            }
            Set<Object> localVariablesOfBlock = new HashSet();
            if (parent instanceof CtField) {
                this.fieldAndMethodsNames.add(((CtField)parent).getSimpleName());
            } else if (parent instanceof CtMethod) {
                this.fieldAndMethodsNames.add(((CtMethod)parent).getSimpleName());
            } else {
                localVariablesOfBlock = this.lookForLocalVariables(parent);
            }
            while (!(parent instanceof CtPackage)) {
                if (parent instanceof CtFieldReference || parent instanceof CtExecutableReference || parent instanceof CtInvocation) {
                    CtTypeReference<?> typeReference;
                    CtElement parentType = parent instanceof CtInvocation ? ((CtInvocation)parent).getExecutable() : parent;
                    LinkedList<String> qualifiedNameTokens = new LinkedList<String>();
                    if (parentType != parent) {
                        qualifiedNameTokens.add(parentType.getSimpleName());
                    }
                    if ((typeReference = parent instanceof CtFieldReference ? ((CtFieldReference)parent).getDeclaringType() : (parent instanceof CtExecutableReference ? ((CtExecutableReference)parent).getDeclaringType() : ((CtInvocation)parent).getExecutable().getDeclaringType())) != null) {
                        qualifiedNameTokens.addFirst(typeReference.getSimpleName());
                        if (typeReference.getPackage() != null) {
                            StringTokenizer token = new StringTokenizer(typeReference.getPackage().getSimpleName(), ".");
                            int index = 0;
                            while (token.hasMoreElements()) {
                                qualifiedNameTokens.add(index, token.nextToken());
                                ++index;
                            }
                        }
                    }
                    if (!qualifiedNameTokens.isEmpty() && (this.fieldAndMethodsNames.contains(qualifiedNameTokens.getFirst()) || localVariablesOfBlock.contains(qualifiedNameTokens.getFirst()))) {
                        qualifiedNameTokens.removeFirst();
                        if (fqnMode) {
                            if (ref instanceof CtTypeReference) {
                                if (qualifiedNameTokens.isEmpty()) {
                                    return true;
                                }
                                for (String testedToken : qualifiedNameTokens) {
                                    if (this.fieldAndMethodsNames.contains(testedToken) || localVariablesOfBlock.contains(testedToken)) continue;
                                    return true;
                                }
                                return false;
                            }
                            return true;
                        }
                        for (String testedToken : qualifiedNameTokens) {
                            if (this.fieldAndMethodsNames.contains(testedToken) || localVariablesOfBlock.contains(testedToken)) continue;
                            return false;
                        }
                        return true;
                    }
                }
                parent = parent.getParent();
            }
        }
        catch (ParentNotInitializedException e) {
            return false;
        }
        return false;
    }
}

