/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor;

import java.util.Map;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtTargetedExpression;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeMember;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtVariableReference;
import spoon.reflect.visitor.ImportAnalyzer;
import spoon.reflect.visitor.LexicalScope;
import spoon.reflect.visitor.LexicalScopeScanner;
import spoon.support.Experimental;

@Experimental
public class ImportConflictDetector
extends ImportAnalyzer<LexicalScope> {
    @Override
    protected LexicalScopeScanner createScanner() {
        return new LexicalScopeScanner();
    }

    @Override
    protected LexicalScope getScannerContextInformation() {
        return ((LexicalScopeScanner)this.scanner).getCurrentLexicalScope();
    }

    @Override
    protected void handleTargetedExpression(CtTargetedExpression<?, ?> targetedExpression, LexicalScope nameScope) {
        Object target = targetedExpression.getTarget();
        if (target == null) {
            return;
        }
        if (targetedExpression instanceof CtFieldAccess) {
            CtField field;
            CtFieldAccess fieldAccess = (CtFieldAccess)targetedExpression;
            if (target.isImplicit() && (field = fieldAccess.getVariable().getFieldDeclaration()) != null) {
                String fieldName = field.getSimpleName();
                nameScope.forEachElementByName(fieldName, named -> {
                    if (named instanceof CtMethod) {
                        return null;
                    }
                    if (named == field) {
                        return true;
                    }
                    target.setImplicit(false);
                    return false;
                });
            }
            if (!target.isImplicit() && target instanceof CtTypeAccess) {
                CtTypeAccess typeAccess = (CtTypeAccess)target;
                CtTypeReference accessedTypeRef = typeAccess.getAccessedType();
                this.checkConflictOfTypeReference(nameScope, accessedTypeRef);
            }
        }
    }

    @Override
    protected void handleTypeReference(CtTypeReference<?> ref, LexicalScope nameScope, CtRole role) {
        if (ref.isImplicit()) {
            CtTargetedExpression targetedExpr = ImportConflictDetector.getParentIfType(ImportConflictDetector.getParentIfType(ref, CtTypeAccess.class), CtTargetedExpression.class);
            if (targetedExpr instanceof CtInvocation) {
                CtInvocation invocation = (CtInvocation)targetedExpr;
                CtExecutableReference importedReference = invocation.getExecutable();
                CtExecutable importedElement = importedReference.getExecutableDeclaration();
                if (importedElement == null) {
                    return;
                }
                if (importedElement instanceof CtMethod) {
                    nameScope.forEachElementByName(importedReference.getSimpleName(), named -> {
                        if (named instanceof CtMethod) {
                            if (ImportConflictDetector.isSameStaticImport(named, importedElement)) {
                                return true;
                            }
                            ref.setImplicit(false);
                            ref.setSimplyQualified(true);
                            return false;
                        }
                        return null;
                    });
                }
            } else if (targetedExpr instanceof CtFieldAccess) {
                CtFieldAccess fieldAccess = (CtFieldAccess)targetedExpr;
                CtVariableReference importedReference = fieldAccess.getVariable();
                CtField importedElement = importedReference.getFieldDeclaration();
                if (importedElement == null) {
                    return;
                }
                nameScope.forEachElementByName(importedReference.getSimpleName(), named -> {
                    if (named instanceof CtMethod) {
                        return null;
                    }
                    if (named == importedElement) {
                        return true;
                    }
                    ref.setImplicit(false);
                    ref.setSimplyQualified(true);
                    return false;
                });
            }
        }
        if (!ref.isImplicit() && ref.isSimplyQualified()) {
            String refQName = ref.getQualifiedName();
            nameScope.forEachElementByName(ref.getSimpleName(), named -> {
                CtType type;
                if (named instanceof CtMethod) {
                    return null;
                }
                if (named instanceof CtType && refQName.equals((type = (CtType)named).getQualifiedName())) {
                    return true;
                }
                ref.setImplicit(false);
                ref.setSimplyQualified(false);
                return false;
            });
            if (!ref.isImplicit() && ref.isSimplyQualified()) {
                Map<String, String> encounteredNames = ((LexicalScopeScanner)this.scanner).getEncounteredImportedQualifiedNames();
                encounteredNames.putIfAbsent(ref.getSimpleName(), ref.getQualifiedName());
                if (!encounteredNames.get(ref.getSimpleName()).equals(ref.getQualifiedName())) {
                    ref.setImplicit(false);
                    ref.setSimplyQualified(false);
                }
            }
        }
        this.checkConflictOfTypeReference(nameScope, ref);
    }

    private void checkConflictOfTypeReference(LexicalScope nameScope, CtTypeReference<?> typeRef) {
        if (typeRef == null) {
            return;
        }
        if (!typeRef.isSimplyQualified()) {
            if (this.isPackageNameConflict(nameScope, typeRef)) {
                typeRef.setSimplyQualified(true);
                if (this.isSimpleNameConflict(nameScope, typeRef)) {
                    typeRef.setImplicit(true);
                }
            }
        } else if (!typeRef.isImplicit() && this.isSimpleNameConflict(nameScope, typeRef)) {
            typeRef.setSimplyQualified(false);
        }
    }

    private boolean isPackageNameConflict(LexicalScope nameScope, CtTypeReference<?> typeRef) {
        String fistPackageName = this.getFirstPackageQName(typeRef);
        if (fistPackageName != null) {
            return Boolean.TRUE == nameScope.forEachElementByName(fistPackageName, named -> {
                if (named instanceof CtMethod) {
                    return null;
                }
                return Boolean.TRUE;
            });
        }
        return false;
    }

    private boolean isSimpleNameConflict(LexicalScope nameScope, CtTypeReference<?> typeRef) {
        String typeQName = typeRef.getQualifiedName();
        return Boolean.TRUE == nameScope.forEachElementByName(typeRef.getSimpleName(), named -> {
            CtType type;
            if (named instanceof CtMethod) {
                return null;
            }
            if (named instanceof CtType && typeQName.equals((type = (CtType)named).getQualifiedName())) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        });
    }

    private String getFirstPackageQName(CtTypeReference<?> typeRef) {
        String qname;
        CtPackageReference packRef;
        if (typeRef != null && (packRef = typeRef.getPackage()) != null && (qname = packRef.getQualifiedName()) != null && qname.length() > 0) {
            int idx = qname.indexOf(46);
            if (idx < 0) {
                idx = qname.length();
            }
            return qname.substring(0, idx);
        }
        return null;
    }

    private static boolean isSameStaticImport(CtNamedElement m1, CtNamedElement m2) {
        if (m1 instanceof CtTypeMember && m2 instanceof CtTypeMember && m1.getSimpleName().equals(m2.getSimpleName())) {
            CtType<?> declType2;
            CtType<?> declType1 = ((CtTypeMember)m1).getDeclaringType();
            return declType1 == (declType2 = ((CtTypeMember)m2).getDeclaringType());
        }
        return false;
    }
}

