/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor;

import java.util.EnumSet;
import java.util.Set;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtTargetedExpression;
import spoon.reflect.declaration.CtCompilationUnit;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtVariableReference;
import spoon.reflect.visitor.CtAbstractVisitor;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.EarlyTerminatingScanner;
import spoon.reflect.visitor.chain.CtScannerListener;
import spoon.reflect.visitor.chain.ScanningMode;
import spoon.support.Experimental;

@Experimental
abstract class ImportAnalyzer<U>
extends AbstractProcessor<CtElement> {
    protected EarlyTerminatingScanner scanner;
    protected static Set<CtRole> IGNORED_ROLES_WHEN_IMPLICIT = EnumSet.of(CtRole.TYPE_ARGUMENT, CtRole.BOUNDING_TYPE, CtRole.TYPE);

    ImportAnalyzer() {
    }

    @Override
    public void process(CtElement el) {
        this.scanner = this.createScanner();
        CtScannerListener listener = this.createScannerListener();
        this.scanner.setListener(listener);
        if (el instanceof CtCompilationUnit) {
            ImportAnalyzer.process(this.scanner, (CtCompilationUnit)el);
        } else {
            this.scanner.scan(el);
        }
    }

    protected static void process(CtScanner scanner, CtCompilationUnit cu) {
        scanner.enter(cu);
        switch (cu.getUnitType()) {
            case MODULE_DECLARATION: 
            case UNKNOWN: {
                break;
            }
            case PACKAGE_DECLARATION: {
                CtPackage pack = cu.getDeclaredPackage();
                scanner.scan(pack.getAnnotations());
                break;
            }
            case TYPE_DECLARATION: {
                for (CtTypeReference<?> typeRef : cu.getDeclaredTypeReferences()) {
                    scanner.scan(typeRef.getTypeDeclaration());
                }
                break;
            }
        }
        scanner.exit(cu);
    }

    protected CtScannerListener createScannerListener() {
        return new ScannerListener();
    }

    protected void onEnter(final U context, final CtRole role, final CtElement element) {
        if (element instanceof CtTargetedExpression) {
            CtTargetedExpression targetedExpression = (CtTargetedExpression)element;
            this.handleTargetedExpression(targetedExpression, context);
        } else if (element instanceof CtTypeReference) {
            element.accept(new CtAbstractVisitor(){

                @Override
                public <T> void visitCtTypeReference(CtTypeReference<T> reference) {
                    ImportAnalyzer.this.handleTypeReference((CtTypeReference)element, context, role);
                }
            });
        }
    }

    protected abstract U getScannerContextInformation();

    protected abstract EarlyTerminatingScanner createScanner();

    protected abstract void handleTypeReference(CtTypeReference<?> var1, U var2, CtRole var3);

    protected abstract void handleTargetedExpression(CtTargetedExpression<?, ?> var1, U var2);

    protected static <T extends CtElement> T getParentIfType(CtElement element, Class<T> type) {
        if (element == null || !element.isParentInitialized()) {
            return null;
        }
        CtElement parent = element.getParent();
        if (type.isInstance(parent)) {
            return (T)((CtElement)type.cast(parent));
        }
        return null;
    }

    protected class ScannerListener
    implements CtScannerListener {
        protected Set<CtRole> ignoredRoles = IGNORED_ROLES_WHEN_IMPLICIT;

        ScannerListener() {
        }

        @Override
        public ScanningMode enter(CtRole role, CtElement element) {
            if (element == null) {
                return ScanningMode.SKIP_ALL;
            }
            if (role == CtRole.VARIABLE && element instanceof CtVariableReference) {
                return ScanningMode.SKIP_ALL;
            }
            if (element.isParentInitialized()) {
                CtElement parent = element.getParent();
                if (role == CtRole.DECLARING_TYPE && element instanceof CtTypeReference) {
                    if (parent instanceof CtFieldReference) {
                        return ScanningMode.SKIP_ALL;
                    }
                    if (parent instanceof CtExecutableReference) {
                        return ScanningMode.SKIP_ALL;
                    }
                    if (parent instanceof CtTypeReference && !((CtTypeReference)parent).getAccessType().equals(element)) {
                        return ScanningMode.SKIP_ALL;
                    }
                }
                if (role == CtRole.TYPE && element instanceof CtTypeReference) {
                    if (parent instanceof CtFieldReference) {
                        return ScanningMode.SKIP_ALL;
                    }
                    if (parent instanceof CtExecutableReference) {
                        CtElement parent2 = null;
                        if (parent.isParentInitialized()) {
                            parent2 = parent.getParent();
                        }
                        if (!(parent2 instanceof CtConstructorCall)) {
                            return ScanningMode.SKIP_ALL;
                        }
                    }
                }
                if (role == CtRole.ARGUMENT_TYPE) {
                    return ScanningMode.SKIP_ALL;
                }
            }
            if (element.isImplicit() && this.ignoredRoles.contains((Object)role)) {
                return ScanningMode.SKIP_ALL;
            }
            ImportAnalyzer.this.onEnter(ImportAnalyzer.this.getScannerContextInformation(), role, element);
            return ScanningMode.NORMAL;
        }
    }
}

