/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor;

import spoon.reflect.code.CtNewClass;
import spoon.reflect.code.CtSuperAccess;
import spoon.reflect.code.CtTargetedExpression;
import spoon.reflect.code.CtThisAccess;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.declaration.CtAnonymousExecutable;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtType;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.ImportAnalyzer;
import spoon.reflect.visitor.LexicalScope;
import spoon.reflect.visitor.LexicalScopeScanner;
import spoon.support.Experimental;

@Experimental
public class ForceFullyQualifiedProcessor
extends ImportAnalyzer<LexicalScope> {
    @Override
    protected LexicalScopeScanner createScanner() {
        return new LexicalScopeScanner();
    }

    @Override
    protected LexicalScope getScannerContextInformation() {
        return ((LexicalScopeScanner)this.scanner).getCurrentLexicalScope();
    }

    @Override
    protected void handleTypeReference(CtTypeReference<?> reference, LexicalScope nameScope, CtRole role) {
        if (reference.isSimplyQualified() || reference.isImplicit()) {
            if (this.isThisAccess(reference)) {
                return;
            }
            if (this.isTypeReferenceToEnclosingType(nameScope, reference) && reference.getParent(CtAnonymousExecutable.class) != null) {
                return;
            }
            if (this.isSupertypeOfNewClass(reference)) {
                return;
            }
            if (role == CtRole.PERMITTED_TYPE) {
                return;
            }
            reference.setImplicit(false);
            reference.setSimplyQualified(false);
        }
    }

    protected boolean isTypeReferenceToEnclosingType(LexicalScope nameScope, CtTypeReference<?> reference) {
        CtType enclosingType = reference.getParent(CtType.class);
        if (enclosingType == null) {
            return false;
        }
        return reference.getQualifiedName().equals(enclosingType.getQualifiedName());
    }

    private boolean isSupertypeOfNewClass(CtTypeReference<?> typeRef) {
        CtElement parent2;
        if (!typeRef.isParentInitialized()) {
            return false;
        }
        CtElement parent = typeRef.getParent();
        return parent instanceof CtClass && ((CtClass)parent).getSuperclass() == typeRef && (parent2 = parent.getParent()) instanceof CtNewClass;
    }

    @Override
    protected void handleTargetedExpression(CtTargetedExpression<?, ?> targetedExpression, LexicalScope nameScope) {
        Object target = targetedExpression.getTarget();
        if (target == null) {
            return;
        }
        if (!target.isImplicit()) {
            return;
        }
        if (target instanceof CtThisAccess || target instanceof CtSuperAccess) {
            return;
        }
        if (target instanceof CtTypeAccess) {
            CtTypeAccess typeAccess = (CtTypeAccess)target;
            if (this.isThisAccess(typeAccess)) {
                return;
            }
            if (this.isTypeReferenceToEnclosingType(nameScope, typeAccess.getAccessedType())) {
                return;
            }
        }
        target.setImplicit(false);
    }

    private boolean isThisAccess(CtTypeReference<?> typeRef) {
        return ForceFullyQualifiedProcessor.getParentIfType(ForceFullyQualifiedProcessor.getParentIfType(typeRef, CtTypeAccess.class), CtThisAccess.class) != null;
    }

    private boolean isThisAccess(CtTypeAccess<?> typeAccess) {
        return ForceFullyQualifiedProcessor.getParentIfType(typeAccess, CtThisAccess.class) != null;
    }
}

