/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.function.Consumer;
import spoon.compiler.Environment;
import spoon.experimental.CtUnresolvedImport;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtComment;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtForEach;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtCompilationUnit;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtFormalTypeDeclarer;
import spoon.reflect.declaration.CtImport;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtModifiable;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.CtSealable;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeMember;
import spoon.reflect.declaration.CtTypeParameter;
import spoon.reflect.declaration.CtTypedElement;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.factory.Factory;
import spoon.reflect.reference.CtActualTypeContainer;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtTypeMemberWildcardImportReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.DefaultJavaPrettyPrinter;
import spoon.reflect.visitor.ListPrinter;
import spoon.reflect.visitor.LiteralHelper;
import spoon.reflect.visitor.PrinterHelper;
import spoon.reflect.visitor.TokenWriter;
import spoon.reflect.visitor.printer.CommentOffset;
import spoon.support.reflect.CtExtendedModifier;

public class ElementPrinterHelper {
    private final DefaultJavaPrettyPrinter prettyPrinter;
    private final Environment env;
    private TokenWriter printer;
    private static final String QUALIFIED_NAME_SEPARATORS = ".$";

    public ElementPrinterHelper(TokenWriter printerTokenWriter, DefaultJavaPrettyPrinter prettyPrinter, Environment env) {
        this.printer = printerTokenWriter;
        this.prettyPrinter = prettyPrinter;
        this.env = env;
    }

    public void writeAnnotations(CtElement element) {
        for (CtAnnotation<? extends Annotation> annotation : element.getAnnotations()) {
            if (element.isParentInitialized() && element instanceof CtTypeReference && element.getParent() instanceof CtTypedElement && element.getParent().getAnnotations().contains(annotation)) continue;
            this.prettyPrinter.scan(annotation);
            this.printer.writeln();
        }
    }

    public void writeModifiers(CtModifiable modifiable) {
        CtMethod m;
        ArrayList<String> firstPosition = new ArrayList<String>();
        ArrayList<String> secondPosition = new ArrayList<String>();
        ArrayList<String> thirdPosition = new ArrayList<String>();
        for (CtExtendedModifier extendedModifier : modifiable.getExtendedModifiers()) {
            if (extendedModifier.isImplicit()) continue;
            ModifierKind modifierKind = extendedModifier.getKind();
            if (modifierKind == ModifierKind.PUBLIC || modifierKind == ModifierKind.PRIVATE || modifierKind == ModifierKind.PROTECTED) {
                firstPosition.add(modifierKind.toString());
                continue;
            }
            if (modifierKind == ModifierKind.ABSTRACT || modifierKind == ModifierKind.STATIC) {
                secondPosition.add(modifierKind.toString());
                continue;
            }
            thirdPosition.add(modifierKind.toString());
        }
        for (String s : firstPosition) {
            this.printer.writeKeyword(s).writeSpace();
        }
        for (String s : secondPosition) {
            this.printer.writeKeyword(s).writeSpace();
        }
        for (String s : thirdPosition) {
            this.printer.writeKeyword(s).writeSpace();
        }
        if (modifiable instanceof CtMethod && (m = (CtMethod)modifiable).isDefaultMethod()) {
            this.printer.writeKeyword("default").writeSpace();
        }
    }

    public void visitCtNamedElement(CtNamedElement namedElement, CtCompilationUnit sourceCompilationUnit) {
        this.writeAnnotations(namedElement);
        if (this.env.isPreserveLineNumbers()) {
            this.getPrinterHelper().adjustStartPosition(namedElement);
        }
    }

    public void writeExtendsClause(CtType<?> type) {
        if (type.getSuperclass() != null) {
            this.printer.writeSpace().writeKeyword("extends").writeSpace();
            this.prettyPrinter.scan(type.getSuperclass());
        }
    }

    public void writeImplementsClause(CtType<?> type) {
        if (!type.getSuperInterfaces().isEmpty()) {
            this.printList(type.getSuperInterfaces(), "implements", false, null, false, true, ",", true, false, null, ref -> this.prettyPrinter.scan((CtElement)ref));
        }
    }

    public void writeExecutableParameters(CtExecutable<?> executable) {
        ArrayList<CtTypedElement<Object>> parameters = new ArrayList<CtTypedElement<Object>>();
        if (executable.getReceiverParameter() != null) {
            parameters.add(executable.getReceiverParameter());
        }
        parameters.addAll(executable.getParameters());
        this.printList(parameters, null, false, "(", false, false, ",", true, false, ")", this.prettyPrinter::scan);
    }

    public void writeThrowsClause(CtExecutable<?> executable) {
        if (!executable.getThrownTypes().isEmpty()) {
            this.printList(executable.getThrownTypes(), "throws", false, null, false, false, ",", true, false, null, ref -> this.prettyPrinter.scan((CtElement)ref));
        }
    }

    public void writeStatement(CtStatement statement) {
        try (Object _context = this.prettyPrinter.getContext().modify().setStatement(statement);){
            this.prettyPrinter.scan(statement);
        }
    }

    public void writeElementList(List<CtTypeMember> elements) {
        for (CtTypeMember element : elements) {
            if (element.isImplicit()) continue;
            this.printer.writeln();
            this.prettyPrinter.scan(element);
            if (this.env.isPreserveLineNumbers()) continue;
            this.printer.writeln();
        }
    }

    public void writeAnnotationElement(Factory factory, Object value) {
        if (value instanceof CtTypeAccess) {
            this.prettyPrinter.scan((CtTypeAccess)value);
            this.printer.writeSeparator(".").writeKeyword("class");
        } else if (value instanceof CtFieldReference) {
            this.prettyPrinter.scan(((CtFieldReference)value).getDeclaringType());
            this.printer.writeSeparator(".").writeIdentifier(((CtFieldReference)value).getSimpleName());
        } else if (value instanceof CtElement) {
            this.prettyPrinter.scan((CtElement)value);
        } else if (value instanceof String) {
            this.printer.writeLiteral("\"" + LiteralHelper.getStringLiteral((String)value, true) + "\"");
        } else if (value instanceof Collection) {
            this.printList((Collection)value, null, false, "{", false, true, ",", false, false, "}", obj -> this.writeAnnotationElement(factory, obj));
        } else if (value instanceof Object[]) {
            this.printList(Arrays.asList((Object[])value), null, false, "{", false, true, ",", false, false, "}", obj -> this.writeAnnotationElement(factory, obj));
        } else if (value instanceof Enum) {
            try (Object c = this.prettyPrinter.getContext().modify().ignoreGenerics(true);){
                this.prettyPrinter.scan(factory.Type().createReference(((Enum)value).getDeclaringClass()));
            }
            this.printer.writeSeparator(".");
            this.printer.writeIdentifier(value.toString());
        } else {
            this.printer.writeLiteral(value.toString());
        }
    }

    public void writeFormalTypeParameters(CtFormalTypeDeclarer ctFormalTypeDeclarer) {
        List<CtTypeParameter> parameters = ctFormalTypeDeclarer.getFormalCtTypeParameters();
        if (parameters == null) {
            return;
        }
        if (!parameters.isEmpty()) {
            this.printList(parameters, null, false, "<", false, false, ",", true, false, ">", parameter -> this.prettyPrinter.scan((CtElement)parameter));
        }
    }

    @Deprecated
    public void writeActualTypeArguments(CtActualTypeContainer ctGenericElementReference) {
        this.writeActualTypeArguments(ctGenericElementReference, PrintTypeArguments.ONLY_PRINT_EXPLICIT_TYPES);
    }

    public void writeActualTypeArguments(CtActualTypeContainer ctGenericElementReference, PrintTypeArguments handleImplicit) {
        List<CtTypeReference<?>> arguments = ctGenericElementReference.getActualTypeArguments();
        if (arguments == null || arguments.isEmpty()) {
            return;
        }
        boolean allImplicit = arguments.stream().allMatch(CtElement::isImplicit);
        if (allImplicit && handleImplicit == PrintTypeArguments.ONLY_PRINT_EXPLICIT_TYPES) {
            return;
        }
        this.printList(arguments.stream().filter(a -> !a.isImplicit())::iterator, null, false, "<", false, false, ",", true, false, ">", argument -> {
            if (this.prettyPrinter.getContext().forceWildcardGenerics()) {
                this.printer.writeSeparator("?");
            } else {
                this.prettyPrinter.scan((CtElement)argument);
            }
        });
    }

    private boolean isJavaLangClasses(String importType) {
        return importType.matches("^(java\\.lang\\.)[^.]*$");
    }

    public void writeImports(Collection<CtImport> imports) {
        HashSet<Object> setImports = new HashSet<Object>();
        HashSet<Object> setStaticImports = new HashSet<Object>();
        for (CtImport ctImport : imports) {
            switch (ctImport.getImportKind()) {
                case TYPE: {
                    CtTypeReference typeRef = (CtTypeReference)ctImport.getReference();
                    Object importTypeStr = typeRef.getQualifiedName();
                    if (this.isJavaLangClasses((String)importTypeStr)) break;
                    setImports.add(this.removeInnerTypeSeparator((String)importTypeStr));
                    break;
                }
                case ALL_TYPES: {
                    CtPackageReference packageRef = (CtPackageReference)ctImport.getReference();
                    Object importTypeStr = packageRef.getQualifiedName() + ".*";
                    if (this.isJavaLangClasses((String)importTypeStr)) break;
                    setImports.add(this.removeInnerTypeSeparator((String)importTypeStr));
                    break;
                }
                case METHOD: {
                    CtExecutableReference execRef = (CtExecutableReference)ctImport.getReference();
                    if (execRef.getDeclaringType() == null) break;
                    setStaticImports.add(this.removeInnerTypeSeparator(execRef.getDeclaringType().getQualifiedName()) + "." + execRef.getSimpleName());
                    break;
                }
                case FIELD: {
                    CtFieldReference fieldRef = (CtFieldReference)ctImport.getReference();
                    setStaticImports.add(this.removeInnerTypeSeparator(fieldRef.getDeclaringType().getQualifiedName()) + "." + fieldRef.getSimpleName());
                    break;
                }
                case ALL_STATIC_MEMBERS: {
                    CtTypeMemberWildcardImportReference typeStarRef = (CtTypeMemberWildcardImportReference)ctImport.getReference();
                    Object importTypeStr = typeStarRef.getTypeReference().getQualifiedName();
                    if (this.isJavaLangClasses((String)importTypeStr)) break;
                    setStaticImports.add(this.removeInnerTypeSeparator((String)importTypeStr) + ".*");
                    break;
                }
                case UNRESOLVED: {
                    CtUnresolvedImport unresolvedImport = (CtUnresolvedImport)ctImport;
                    Object importTypeStr = unresolvedImport.getUnresolvedReference();
                    if (this.isJavaLangClasses((String)importTypeStr)) break;
                    if (unresolvedImport.isStatic()) {
                        setStaticImports.add(importTypeStr);
                        break;
                    }
                    setImports.add(importTypeStr);
                }
            }
        }
        ArrayList sortedImports = new ArrayList(setImports);
        Collections.sort(sortedImports);
        boolean isFirst = true;
        for (String importLine : sortedImports) {
            if (isFirst) {
                this.printer.writeln();
                this.printer.writeln();
                isFirst = false;
            }
            this.printer.writeKeyword("import").writeSpace();
            this.writeQualifiedName(importLine).writeSeparator(";").writeln();
        }
        if (!setStaticImports.isEmpty()) {
            if (isFirst) {
                this.printer.writeln();
            }
            this.printer.writeln();
            ArrayList sortedStaticImports = new ArrayList(setStaticImports);
            Collections.sort(sortedStaticImports);
            for (String importLine : sortedStaticImports) {
                this.printer.writeKeyword("import").writeSpace().writeKeyword("static").writeSpace();
                this.writeQualifiedName(importLine).writeSeparator(";").writeln();
            }
        }
    }

    public void writePackageLine(String packageQualifiedName) {
        this.writePackageStatement(packageQualifiedName);
        this.printer.writeln();
    }

    public void writePackageStatement(String packageQualifiedName) {
        this.printer.writeKeyword("package").writeSpace();
        this.writeQualifiedName(packageQualifiedName).writeSeparator(";");
    }

    private String removeInnerTypeSeparator(String fqn) {
        return fqn.replace("$", ".");
    }

    public void writeComment(CtComment comment) {
        if (!this.env.isCommentsEnabled() || comment == null) {
            return;
        }
        this.prettyPrinter.scan(comment);
        this.printer.writeln();
    }

    private void writeComment(List<CtComment> comments) {
        if (!this.env.isCommentsEnabled() || comments == null) {
            return;
        }
        for (CtComment comment : comments) {
            this.writeComment(comment);
        }
    }

    public void writeComment(CtElement element) {
        if (element == null) {
            return;
        }
        this.writeComment(element.getComments());
    }

    public void writeComment(CtElement element, CommentOffset offset) {
        this.writeComment(this.getComments(element, offset));
    }

    public List<CtComment> getComments(CtElement element, CommentOffset offset) {
        ArrayList<CtComment> commentsToPrint = new ArrayList<CtComment>();
        if (!this.env.isCommentsEnabled() || element == null) {
            return commentsToPrint;
        }
        for (CtComment comment : element.getComments()) {
            boolean commentStartsBeforeUs;
            if (comment.getCommentType() == CtComment.CommentType.FILE && offset == CommentOffset.TOP_FILE && element.getPosition().getSourceEnd() > comment.getPosition().getSourceStart()) {
                commentsToPrint.add(comment);
                continue;
            }
            if (comment.getCommentType() == CtComment.CommentType.FILE && offset == CommentOffset.BOTTOM_FILE && element.getPosition().getSourceEnd() < comment.getPosition().getSourceStart()) {
                commentsToPrint.add(comment);
                continue;
            }
            if (comment.getCommentType() == CtComment.CommentType.FILE) continue;
            if (!comment.getPosition().isValidPosition() || !element.getPosition().isValidPosition()) {
                if (offset != CommentOffset.BEFORE) continue;
                commentsToPrint.add(comment);
                continue;
            }
            int line = element.getPosition().getLine();
            int sourceEnd = element.getPosition().getSourceEnd();
            int sourceStart = element.getPosition().getSourceStart();
            boolean commentStartsInLineBefore = comment.getPosition().getLine() < line;
            boolean commentStartsInsideUs = sourceStart <= comment.getPosition().getSourceStart() && sourceEnd > comment.getPosition().getSourceEnd();
            boolean bl = commentStartsBeforeUs = sourceStart >= comment.getPosition().getSourceStart() && sourceEnd > comment.getPosition().getSourceEnd();
            if (offset == CommentOffset.BEFORE && (commentStartsInLineBefore || commentStartsInsideUs || commentStartsBeforeUs)) {
                commentsToPrint.add(comment);
                continue;
            }
            if (offset == CommentOffset.AFTER && (comment.getPosition().getSourceStart() > sourceEnd || comment.getPosition().getSourceEnd() == sourceEnd)) {
                commentsToPrint.add(comment);
                continue;
            }
            int endLine = element.getPosition().getEndLine();
            if (offset != CommentOffset.INSIDE || comment.getPosition().getLine() < line || comment.getPosition().getEndLine() > endLine) continue;
            commentsToPrint.add(comment);
        }
        return commentsToPrint;
    }

    public boolean isElseIf(CtIf ifStmt) {
        if (ifStmt.getElseStatement() == null) {
            return false;
        }
        if (ifStmt.getElseStatement() instanceof CtIf) {
            return true;
        }
        if (ifStmt.getElseStatement() instanceof CtBlock) {
            CtBlock block = (CtBlock)ifStmt.getElseStatement();
            return block.getStatements().size() == 1 && block.getStatement(0) instanceof CtIf;
        }
        return false;
    }

    public void writeIfOrLoopBlock(CtStatement block) {
        if (block != null) {
            if (!block.isImplicit() && (block instanceof CtBlock || block instanceof CtIf)) {
                this.printer.writeSpace();
            }
            if (!(block instanceof CtBlock) && !(block instanceof CtIf)) {
                this.printer.incTab();
                this.printer.writeln();
            }
            this.writeStatement(block);
            if (!(block instanceof CtBlock) && !(block instanceof CtIf)) {
                this.printer.decTab().writeln();
            }
            if (!(block.isImplicit() || block.isParentInitialized() && (block.getParent() instanceof CtFor || block.getParent() instanceof CtForEach || block.getParent() instanceof CtIf))) {
                this.printer.writeSpace();
            }
        } else {
            this.printer.writeSeparator(";");
        }
    }

    private ListPrinter createListPrinter(boolean startPrefixSpace, String start, boolean startSufficSpace, boolean nextPrefixSpace, String next, boolean nextSuffixSpace, boolean endPrefixSpace, String end) {
        return new ListPrinter(this.printer, startPrefixSpace, start, startSufficSpace, nextPrefixSpace, next, nextSuffixSpace, endPrefixSpace, end);
    }

    public TokenWriter writeQualifiedName(String qualifiedName) {
        StringTokenizer st = new StringTokenizer(qualifiedName, QUALIFIED_NAME_SEPARATORS, true);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.length() == 1 && QUALIFIED_NAME_SEPARATORS.indexOf(token.charAt(0)) >= 0) {
                this.printer.writeSeparator(token);
                continue;
            }
            this.printer.writeIdentifier(token);
        }
        return this.printer;
    }

    private PrinterHelper getPrinterHelper() {
        return this.printer.getPrinterHelper();
    }

    public <T> void printList(Iterable<T> iterable, String startKeyword, boolean startPrefixSpace, String start, boolean startSuffixSpace, boolean nextPrefixSpace, String next, boolean nextSuffixSpace, boolean endPrefixSpace, String end, Consumer<T> elementPrinter) {
        if (startKeyword != null) {
            this.printer.writeSpace().writeKeyword(startKeyword).writeSpace();
        }
        try (ListPrinter lp = this.createListPrinter(startPrefixSpace, start, startSuffixSpace, nextPrefixSpace, next, nextSuffixSpace, endPrefixSpace, end);){
            for (T item : iterable) {
                lp.printSeparatorIfAppropriate();
                elementPrinter.accept(item);
            }
        }
    }

    protected void printPermits(CtSealable sealable) {
        if (sealable.getPermittedTypes().isEmpty() || sealable.getPermittedTypes().stream().allMatch(CtElement::isImplicit)) {
            return;
        }
        this.printer.writeln().incTab().writeKeyword("permits").writeSpace();
        this.printList(sealable.getPermittedTypes(), null, false, null, false, false, ",", true, false, null, this.prettyPrinter::scan);
        this.printer.decTab();
    }

    public static enum PrintTypeArguments {
        ONLY_PRINT_EXPLICIT_TYPES,
        ALSO_PRINT_DIAMOND_OPERATOR;

    }
}

